/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractNonThreadSafeRefCounted;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefLookup;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.OrdinalBytesRefBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

public final class OrdinalBytesRefVector
extends AbstractNonThreadSafeRefCounted
implements BytesRefVector {
    private final IntVector ordinals;
    private final BytesRefVector bytes;

    public OrdinalBytesRefVector(IntVector ordinals, BytesRefVector bytes) {
        this.ordinals = ordinals;
        this.bytes = bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static OrdinalBytesRefVector readOrdinalVector(BlockFactory blockFactory, StreamInput in) throws IOException {
        IntVector ordinals = IntVector.readFrom(blockFactory, in);
        BytesRefVector bytes = null;
        OrdinalBytesRefVector result = null;
        try {
            bytes = BytesRefVector.readFrom(blockFactory, in);
            result = new OrdinalBytesRefVector(ordinals, bytes);
            if (result != null) return result;
        }
        catch (Throwable throwable) {
            if (result != null) throw throwable;
            Releasables.close((Releasable[])new Releasable[]{ordinals, bytes});
            throw throwable;
        }
        Releasables.close((Releasable[])new Releasable[]{ordinals, bytes});
        return result;
    }

    void writeOrdinalVector(StreamOutput out) throws IOException {
        this.ordinals.writeTo(out);
        this.bytes.writeTo(out);
    }

    public boolean isDense() {
        return this.ordinals.getPositionCount() * 2 / 3 >= this.bytes.getPositionCount();
    }

    @Override
    public int getPositionCount() {
        return this.ordinals.getPositionCount();
    }

    @Override
    public BlockFactory blockFactory() {
        return this.ordinals.blockFactory();
    }

    @Override
    public void allowPassingToDifferentDriver() {
        this.ordinals.allowPassingToDifferentDriver();
        this.bytes.allowPassingToDifferentDriver();
    }

    @Override
    public BytesRef getBytesRef(int position, BytesRef dest) {
        return this.bytes.getBytesRef(this.ordinals.getInt(position), dest);
    }

    @Override
    public OrdinalBytesRefBlock asBlock() {
        return new OrdinalBytesRefBlock(this.ordinals.asBlock(), this.bytes);
    }

    @Override
    public OrdinalBytesRefVector asOrdinals() {
        return this;
    }

    public IntVector getOrdinalsVector() {
        return this.ordinals;
    }

    public BytesRefVector getDictionaryVector() {
        return this.bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BytesRefVector filter(int ... positions) {
        if (positions.length >= this.ordinals.getPositionCount()) {
            OrdinalBytesRefVector result = null;
            IntVector filteredOrdinals = this.ordinals.filter(positions);
            try {
                result = new OrdinalBytesRefVector(filteredOrdinals, this.bytes);
                this.bytes.incRef();
            }
            finally {
                if (result == null) {
                    filteredOrdinals.close();
                }
            }
            return result;
        }
        BytesRef scratch = new BytesRef();
        try (BytesRefVector.Builder builder = this.blockFactory().newBytesRefVectorBuilder(positions.length);){
            for (int p : positions) {
                builder.appendBytesRef(this.getBytesRef(p, scratch));
            }
            BytesRefVector bytesRefVector = builder.build();
            return bytesRefVector;
        }
    }

    @Override
    public BytesRefBlock keepMask(BooleanVector mask) {
        return this.asBlock().keepMask(mask);
    }

    @Override
    public ReleasableIterator<? extends BytesRefBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        return new BytesRefLookup(this.asBlock(), positions, targetBlockSize);
    }

    @Override
    public ElementType elementType() {
        return this.bytes.elementType();
    }

    @Override
    public boolean isConstant() {
        return this.bytes.isConstant() || this.ordinals.isConstant();
    }

    public long ramBytesUsed() {
        return this.ordinals.ramBytesUsed() + this.bytes.ramBytesUsed();
    }

    @Override
    protected void closeInternal() {
        Releasables.close((Releasable[])new Releasable[]{this.ordinals, this.bytes});
    }
}

