/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.lucene.LuceneQueryEvaluator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.ScoreOperator;

public class LuceneQueryScoreEvaluator
extends LuceneQueryEvaluator<DoubleVector.Builder>
implements ScoreOperator.ExpressionScorer {
    public static final double NO_MATCH_SCORE = 0.0;

    LuceneQueryScoreEvaluator(BlockFactory blockFactory, LuceneQueryEvaluator.ShardConfig[] shards) {
        super(blockFactory, shards);
    }

    @Override
    public DoubleBlock score(Page page) {
        return (DoubleBlock)this.executeQuery(page);
    }

    @Override
    protected ScoreMode scoreMode() {
        return ScoreMode.COMPLETE;
    }

    @Override
    protected Vector createNoMatchVector(BlockFactory blockFactory, int size) {
        return blockFactory.newConstantDoubleVector(0.0, size);
    }

    @Override
    protected DoubleVector.Builder createVectorBuilder(BlockFactory blockFactory, int size) {
        return blockFactory.newDoubleVectorFixedBuilder(size);
    }

    @Override
    protected void appendNoMatch(DoubleVector.Builder builder) {
        builder.appendDouble(0.0);
    }

    @Override
    protected void appendMatch(DoubleVector.Builder builder, Scorable scorer) throws IOException {
        builder.appendDouble(scorer.score());
    }

    public record Factory(LuceneQueryEvaluator.ShardConfig[] shardConfigs) implements ScoreOperator.ExpressionScorer.Factory
    {
        @Override
        public ScoreOperator.ExpressionScorer get(DriverContext context) {
            return new LuceneQueryScoreEvaluator(context.blockFactory(), this.shardConfigs);
        }
    }
}

