/*
 * Decompiled with CFR 0.152.
 */
package si.uom;

import java.util.Set;
import javax.measure.MetricPrefix;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.AmountOfSubstance;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.ElectricCharge;
import javax.measure.quantity.Energy;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Length;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Pressure;
import javax.measure.quantity.RadiationDoseEffective;
import javax.measure.quantity.Radioactivity;
import javax.measure.quantity.SolidAngle;
import javax.measure.quantity.Speed;
import javax.measure.quantity.Time;
import si.uom.quantity.DynamicViscosity;
import si.uom.quantity.IonizingRadiation;
import si.uom.quantity.KinematicViscosity;
import si.uom.quantity.Level;
import tech.units.indriya.AbstractSystemOfUnits;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.EBNFUnitFormat;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.function.LogConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.unit.TransformedUnit;
import tech.units.indriya.unit.Units;

public final class NonSI
extends AbstractSystemOfUnits {
    private static final String SYSTEM_NAME = "Non-SI Units";
    private static final NonSI INSTANCE = new NonSI();
    public static final Unit<Dimensionless> PI = NonSI.addUnit(AbstractUnit.ONE.multiply(Math.PI), "Pi", "pi");
    public static final Unit<Angle> DEGREE_ANGLE = NonSI.addUnit(new TransformedUnit(Units.RADIAN, MultiplyConverter.ofPiExponent((int)1).concatenate((UnitConverter)MultiplyConverter.ofRational((long)1L, (long)180L))), "Degree Angle", "deg");
    public static final Unit<Angle> MINUTE_ANGLE = NonSI.addUnit(new TransformedUnit(Units.RADIAN, MultiplyConverter.ofPiExponent((int)1).concatenate((UnitConverter)MultiplyConverter.ofRational((long)1L, (long)10800L))), "Minute Angle", "'");
    public static final Unit<Angle> SECOND_ANGLE = NonSI.addUnit(new TransformedUnit(Units.RADIAN, MultiplyConverter.ofPiExponent((int)1).concatenate((UnitConverter)MultiplyConverter.ofRational((long)1L, (long)648000L))), "Second Angle", "''");
    public static final Unit<Energy> ELECTRON_VOLT = NonSI.addUnit(new TransformedUnit(Units.JOULE, (UnitConverter)MultiplyConverter.of((double)1.602176487E-19)), "Electron Volt", "eV");
    public static final Unit<Mass> UNIFIED_ATOMIC_MASS = NonSI.addUnit(new TransformedUnit(Units.KILOGRAM, (UnitConverter)MultiplyConverter.of((double)1.660538782E-27)), "Unified atomic mass", "u", true);
    public static final Unit<Mass> DALTON = NonSI.addUnit(new TransformedUnit(UNIFIED_ATOMIC_MASS, (UnitConverter)AbstractConverter.IDENTITY), "Dalton", "Da");
    public static final Unit<Length> ASTRONOMICAL_UNIT = NonSI.addUnit(new TransformedUnit(Units.METRE, (UnitConverter)MultiplyConverter.of((double)1.49597871E11)), "Astronomical Unit", "UA");
    public static final Unit<Area> HECTARE = NonSI.addUnit(new TransformedUnit(Units.SQUARE_METRE, (UnitConverter)MultiplyConverter.ofRational((long)10000L, (long)1L)), "Hectare", "ha");
    public static final Unit<AmountOfSubstance> ATOM = NonSI.addUnit(Units.MOLE.divide(6.02214199E23), "Atom", "atom");
    public static final Unit<Length> ANGSTROM = NonSI.addUnit(Units.METRE.divide(1.0E10), "\u00c5ngstr\u00f6m", "\u00c5");
    public static final Unit<Length> LIGHT_YEAR = NonSI.addUnit(Units.METRE.multiply(9.460528405E15), "Light year", "ly");
    public static final Unit<Length> PARSEC = NonSI.addUnit(Units.METRE.multiply(3.085677E16), "Parsec", "pc");
    public static final Unit<Length> NAUTICAL_MILE = NonSI.addUnit(Units.METRE.multiply(1852.0), "Nautical mile", "nmi");
    public static final Unit<Length> BOHR_RADIUS = NonSI.addUnit(Units.METRE.multiply(5.291772106712E-11), "Bohr Radius", "a0");
    public static final Unit<Time> DAY_SIDEREAL = NonSI.addUnit(Units.SECOND.multiply(86164.09), "Day Sidereal", "day_sidereal");
    public static final Unit<Time> YEAR_CALENDAR = NonSI.addUnit(Units.DAY.multiply(365.0), "Calendar Year", "year");
    public static final Unit<Time> YEAR_SIDEREAL = NonSI.addUnit(Units.SECOND.multiply(3.155814954E7), "Year Sidereal", "year_sidereal");
    public static final Unit<Time> YEAR_JULIEN = NonSI.addUnit(Units.SECOND.multiply(3.15576E7), "Year Julien", "year_julien");
    public static final Unit<Mass> ATOMIC_MASS = NonSI.addUnit(Units.KILOGRAM.multiply(1.6605387280149467E-27), "Atomic Mass", "u");
    public static final Unit<Mass> ELECTRON_MASS = NonSI.addUnit(Units.KILOGRAM.multiply(9.10938188E-31), "Electron Mass", "me");
    public static final Unit<Mass> TONNE = NonSI.addUnit(new TransformedUnit(Units.KILOGRAM, (UnitConverter)MultiplyConverter.ofRational((long)1000L, (long)1L)), "Tonne", "t");
    public static final Unit<ElectricCharge> FARADAY = NonSI.addUnit(Units.COULOMB.multiply(96485.3414719984), "Faraday", "Fd");
    public static final Unit<ElectricCharge> FRANKLIN = NonSI.addUnit(Units.COULOMB.multiply(3.3356E-10), "Franklin", "Fr");
    public static final Unit<Speed> C = NonSI.addUnit(Units.METRE_PER_SECOND.multiply(2.99792458E8), "Speed of Light", "c");
    public static final Unit<Pressure> MILLIMETRE_OF_MERCURY = NonSI.addUnit(Units.PASCAL.multiply(133.322387415), "Millimetre of Mercury", "mmHg");
    public static final Unit<Pressure> INCH_OF_MERCURY = NonSI.addUnit(Units.PASCAL.multiply(3386.388), "Inch of Mercury", "inHg");
    public static final Unit<Radioactivity> RUTHERFORD = NonSI.addUnit(Units.BECQUEREL.multiply(1000000.0), "Rutherford", "Rd");
    public static final Unit<RadiationDoseEffective> REM = NonSI.addUnit(Units.SIEVERT.divide(100.0), "Rem", "rem");
    public static final Unit<Radioactivity> CURIE = NonSI.addUnit(Units.BECQUEREL.multiply(3.7E10), "Curie", "Ci");
    protected static final Unit<SolidAngle> SPHERE = NonSI.addUnit(Units.STERADIAN.multiply(4.0).multiply(PI).asType(SolidAngle.class), "Sphere", "sphere");
    public static final Unit<DynamicViscosity> POISE = NonSI.addUnit(Units.GRAM.divide(MetricPrefix.CENTI((Unit)Units.METRE).multiply(Units.SECOND))).asType(DynamicViscosity.class);
    public static final Unit<KinematicViscosity> STOKES = NonSI.addUnit(MetricPrefix.CENTI((Unit)Units.METRE).pow(2).divide(Units.SECOND)).asType(KinematicViscosity.class);
    protected static final Unit<Frequency> FRAMES_PER_SECOND = NonSI.addUnit(AbstractUnit.ONE.divide(Units.SECOND)).asType(Frequency.class);
    public static final Unit<IonizingRadiation> ROENTGEN = NonSI.addUnit(Units.COULOMB.divide(Units.KILOGRAM).multiply(2.58E-4).asType(IonizingRadiation.class), "Roentgen", "R", true);
    public static final Unit<Level<Dimensionless>> BEL = NonSI.addUnit(AbstractUnit.ONE.transform((UnitConverter)new LogConverter(10.0)), "Bel", "B", true);
    public static final Unit<Level<Dimensionless>> NEPER = NonSI.addUnit(AbstractUnit.ONE.transform((UnitConverter)new LogConverter(Math.E)), "Neper", "Np", true);

    private NonSI() {
    }

    public static NonSI getInstance() {
        return INSTANCE;
    }

    public String getName() {
        return SYSTEM_NAME;
    }

    private static <U extends Unit<?>> U addUnit(U unit) {
        NonSI.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text, boolean isLabel) {
        if (isLabel && text != null) {
            SimpleUnitFormat.getInstance().label(unit, text);
            EBNFUnitFormat.getInstance().label(unit, text);
        }
        if (name != null && unit instanceof AbstractUnit) {
            return (U)AbstractSystemOfUnits.Helper.addUnit((Set)NonSI.INSTANCE.units, unit, (String)name);
        }
        NonSI.INSTANCE.units.add(unit);
        return unit;
    }

    private static <U extends Unit<?>> U addUnit(U unit, String name, String text) {
        return NonSI.addUnit(unit, name, text, true);
    }

    static {
        SimpleUnitFormat.getInstance().label(TONNE, "t");
        SimpleUnitFormat.getInstance().label(MetricPrefix.MEGA(TONNE), "Mt");
        EBNFUnitFormat.getInstance().label(TONNE, "t");
        EBNFUnitFormat.getInstance().label(MetricPrefix.MEGA(TONNE), "Mt");
    }
}

