/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.extractors.BinaryDisplayType;
import com.intellij.database.extractors.DisplayType;
import com.intellij.database.run.actions.ChangeColumnDisplayTypeAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.table.GridTableModel;
import com.intellij.database.run.ui.table.TableResultViewColumn;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.Range;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegularGridTableModel
extends GridTableModel {
    public RegularGridTableModel(@NotNull DataGrid grid) {
        if (grid == null) {
            RegularGridTableModel.$$$reportNull$$$0(0);
        }
        super(grid);
    }

    @Override
    protected int row(int rowIndex, int columnIndex) {
        return rowIndex;
    }

    @Override
    protected int col(int rowIndex, int columnIndex) {
        return columnIndex;
    }

    @Override
    @NotNull
    public TableResultViewColumn createColumn(int columnDataIdx) {
        ModelIndex columnIdx = ModelIndex.forColumn((CoreGrid)this.myGrid, (int)columnDataIdx);
        GridColumn c = Objects.requireNonNull((GridColumn)this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx));
        return new RegularTableColumn(c, columnDataIdx);
    }

    @Override
    protected Range<Integer> rowRange(ModelIndexSet<GridRow> rows, ModelIndexSet<GridColumn> columns) {
        return RegularGridTableModel.getSmallestCoveringRange(rows);
    }

    @Override
    public int getRowCount() {
        return this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumnCount();
    }

    public void columnsAdded(ModelIndexSet<GridColumn> columns) {
        this.fireTableStructureChanged();
    }

    public void columnsRemoved(ModelIndexSet<GridColumn> columns) {
        this.fireTableStructureChanged();
    }

    public void rowsAdded(ModelIndexSet<GridRow> rows) {
        Range<Integer> rowRange = RegularGridTableModel.getSmallestCoveringRange(rows);
        this.fireTableRowsInserted((Integer)rowRange.getFrom(), (Integer)rowRange.getTo());
    }

    public void rowsRemoved(ModelIndexSet<GridRow> rows) {
        Range<Integer> rowRange = RegularGridTableModel.getSmallestCoveringRange(rows);
        this.fireTableRowsDeleted((Integer)rowRange.getFrom(), (Integer)rowRange.getTo());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/table/RegularGridTableModel", "<init>"));
    }

    protected class RegularTableColumn
    extends TableResultViewColumn {
        private static final int HIERARCHICAL_COLUMN_ADDITIONAL_WIDTH = 40;
        private final GridColumn myColumn;
        private Icon myIconCache;

        private RegularTableColumn(GridColumn column, int modelIndex) {
            if (column == null) {
                RegularTableColumn.$$$reportNull$$$0(0);
            }
            super(modelIndex);
            this.myColumn = column;
        }

        @Override
        public Icon getIcon(boolean forDisplay) {
            if (this.myIconCache != null) {
                return this.myIconCache;
            }
            Icon icon = GridHelper.get(RegularGridTableModel.this.myGrid).getColumnIcon(RegularGridTableModel.this.myGrid, this.myColumn, forDisplay);
            if (forDisplay) {
                this.myIconCache = icon;
            }
            return icon;
        }

        @Override
        @NlsContexts.ColumnName
        @NotNull
        public String getHeaderValue() {
            Object displayTypeName;
            String result = RegularGridTableModel.this.myGrid.getName(this.myColumn);
            ModelIndex columnIdx = ModelIndex.forColumn((CoreGrid)RegularGridTableModel.this.myGrid, (int)this.myColumn.getColumnNumber());
            if (ChangeColumnDisplayTypeAction.isBinary((ModelIndex<GridColumn>)columnIdx, RegularGridTableModel.this.myGrid)) {
                DisplayType displayType = RegularGridTableModel.this.myGrid.getDisplayType((ModelIndex<GridColumn>)columnIdx);
                DisplayType pureDisplayType = RegularGridTableModel.this.myGrid.getPureDisplayType((ModelIndex<GridColumn>)columnIdx);
                displayTypeName = pureDisplayType == BinaryDisplayType.DETECT && displayType == BinaryDisplayType.HEX ? "" : " (" + displayType.getName() + ")";
            } else {
                displayTypeName = "";
            }
            String string = result + (String)displayTypeName;
            if (string == null) {
                RegularTableColumn.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int getAdditionalWidth() {
            HierarchicalColumnsDataGridModel.HierarchicalGridColumn hierarchicalColumn;
            GridColumn gridColumn = this.myColumn;
            if (gridColumn instanceof HierarchicalColumnsDataGridModel.HierarchicalGridColumn && (hierarchicalColumn = (HierarchicalColumnsDataGridModel.HierarchicalGridColumn)gridColumn).isLeftMostChildOfDirectAncestor()) {
                return 40;
            }
            return 8;
        }

        @Override
        @NlsContexts.ColumnName
        @NotNull
        public List<String> getMultilineHeaderValues() {
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.getHeaderValue());
            GridColumn gridColumn = this.myColumn;
            if (gridColumn instanceof HierarchicalColumnsDataGridModel.HierarchicalGridColumn) {
                HierarchicalColumnsDataGridModel.HierarchicalGridColumn hierarchicalColumn = (HierarchicalColumnsDataGridModel.HierarchicalGridColumn)gridColumn;
                boolean wasPreviousNodeLeftMost = hierarchicalColumn.isLeftMostChildOfDirectAncestor();
                for (HierarchicalColumnsDataGridModel.HierarchicalGridColumn current = hierarchicalColumn.getParent(); current != null; current = current.getParent()) {
                    result.add(wasPreviousNodeLeftMost ? current.getName() : "    ");
                    wasPreviousNodeLeftMost &= current.isLeftMostChildOfDirectAncestor();
                }
            }
            List list = ContainerUtil.reverse(result);
            if (list == null) {
                RegularTableColumn.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        @NlsContexts.Tooltip
        @Nullable
        public String getTooltipText() {
            return GridHelper.get(RegularGridTableModel.this.myGrid).getColumnTooltipHtml(RegularGridTableModel.this.myGrid, (ModelIndex<GridColumn>)ModelIndex.forColumn((CoreGrid)RegularGridTableModel.this.myGrid, (int)this.myColumn.getColumnNumber()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/table/RegularGridTableModel$RegularTableColumn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/table/RegularGridTableModel$RegularTableColumn";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHeaderValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMultilineHeaderValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

