/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.feedback;

import com.intellij.openapi.project.Project;
import com.intellij.platform.feedback.InIdeFeedbackSurveyConfig;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.SystemDataJsonSerializable;
import com.intellij.platform.feedback.impl.notification.RequestFeedbackNotification;
import com.intellij.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.block.TerminalUsageLocalStorage;
import org.jetbrains.plugins.terminal.block.feedback.BlockTerminalFeedbackDialog;
import org.jetbrains.plugins.terminal.block.feedback.BlockTerminalFeedbackSurveyKt;
import org.jetbrains.plugins.terminal.fus.TerminalFeedbackEvent;
import org.jetbrains.plugins.terminal.fus.TerminalFeedbackMoment;
import org.jetbrains.plugins.terminal.fus.TerminalUsageTriggerCollector;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/terminal/block/feedback/BlockTerminalSurveyConfig;", "Lcom/intellij/platform/feedback/InIdeFeedbackSurveyConfig;", "<init>", "()V", "surveyId", "", "getSurveyId", "()Ljava/lang/String;", "createFeedbackDialog", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "Lcom/intellij/platform/feedback/dialog/SystemDataJsonSerializable;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "", "updateStateAfterDialogClosedOk", "", "lastDayOfFeedbackCollection", "Lkotlinx/datetime/LocalDate;", "getLastDayOfFeedbackCollection", "()Lkotlinx/datetime/LocalDate;", "requireIdeEAP", "getRequireIdeEAP", "()Z", "checkIdeIsSuitable", "checkExtraConditionSatisfied", "createNotification", "Lcom/intellij/platform/feedback/impl/notification/RequestFeedbackNotification;", "updateStateAfterNotificationShowed", "intellij.terminal"})
public final class BlockTerminalSurveyConfig
implements InIdeFeedbackSurveyConfig {
    @NotNull
    private final String surveyId;
    @NotNull
    private final LocalDate lastDayOfFeedbackCollection = new LocalDate(2025, 2, 1);
    private final boolean requireIdeEAP;

    public BlockTerminalSurveyConfig() {
        this.surveyId = "new_terminal";
    }

    @NotNull
    public String getSurveyId() {
        return this.surveyId;
    }

    @NotNull
    public BlockBasedFeedbackDialog<? extends SystemDataJsonSerializable> createFeedbackDialog(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!forTest) {
            TerminalUsageTriggerCollector.INSTANCE.triggerFeedbackSurveyEvent$intellij_terminal(project, TerminalFeedbackEvent.DIALOG_SHOWN, BlockTerminalFeedbackSurveyKt.getFeedbackMoment(project));
        }
        return new BlockTerminalFeedbackDialog(project, forTest);
    }

    public void updateStateAfterDialogClosedOk(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TerminalUsageTriggerCollector.INSTANCE.triggerFeedbackSurveyEvent$intellij_terminal(project, TerminalFeedbackEvent.FEEDBACK_SENT, BlockTerminalFeedbackSurveyKt.getFeedbackMoment(project));
    }

    @NotNull
    public LocalDate getLastDayOfFeedbackCollection() {
        return this.lastDayOfFeedbackCollection;
    }

    public boolean getRequireIdeEAP() {
        return this.requireIdeEAP;
    }

    public boolean checkIdeIsSuitable() {
        return PlatformUtils.isJetBrainsProduct();
    }

    public boolean checkExtraConditionSatisfied(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TerminalUsageLocalStorage usageStorage = TerminalUsageLocalStorage.Companion.getInstance();
        return !usageStorage.getState().getFeedbackNotificationShown() && (usageStorage.getExecutedCommandsNumber() >= 15 || usageStorage.getExecutedCommandsNumber() > 0 && BlockTerminalFeedbackSurveyKt.getFeedbackMoment(project) == TerminalFeedbackMoment.ON_DISABLING);
    }

    @NotNull
    public RequestFeedbackNotification createNotification(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = TerminalBundle.message("feedback.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = TerminalBundle.message("feedback.notification.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return new RequestFeedbackNotification("Feedback In IDE", string, string2);
    }

    public void updateStateAfterNotificationShowed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TerminalUsageLocalStorage.Companion.getInstance().getState().setFeedbackNotificationShown(true);
        TerminalUsageTriggerCollector.INSTANCE.triggerFeedbackSurveyEvent$intellij_terminal(project, TerminalFeedbackEvent.NOTIFICATION_SHOWN, BlockTerminalFeedbackSurveyKt.getFeedbackMoment(project));
    }
}

