/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.backend;

import com.intellij.ide.ui.colors.ColorIdKt;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.ide.vfs.VirtualFileId;
import com.intellij.ide.vfs.VirtualFileIdKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.platform.recentFiles.shared.SwitcherRpcDto;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IconUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.awt.Color;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a4\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001H\u0001\u001a/\u0010\n\u001a\u00020\u0006\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\b\u0010\u000f\u001a\u0004\u0018\u0001H\u000bH\u0002\u00a2\u0006\u0002\u0010\u0010\u001a\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\"\u000e\u0010\u0015\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"getFilesToShow", "", "Lcom/intellij/platform/recentFiles/shared/SwitcherRpcDto$File;", "project", "Lcom/intellij/openapi/project/Project;", "onlyEdited", "", "pinned", "filesFromFrontendEditorSelectionHistory", "Lcom/intellij/ide/vfs/VirtualFileId;", "addIfNotNull", "T", "", "targetCollection", "", "item", "(Ljava/util/Collection;Ljava/lang/Object;)Z", "getRecentFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "createRecentFileViewModel", "virtualFile", "SWITCHER_ELEMENTS_LIMIT", "", "intellij.platform.recentFiles.backend"})
@SourceDebugExtension(value={"SMAP\nrecentFilesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 recentFilesCollector.kt\ncom/intellij/platform/recentFiles/backend/RecentFilesCollectorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n774#2:150\n865#2,2:151\n3829#3:153\n4344#3,2:154\n1#4:156\n*S KotlinDebug\n*F\n+ 1 recentFilesCollector.kt\ncom/intellij/platform/recentFiles/backend/RecentFilesCollectorKt\n*L\n62#1:150\n62#1:151,2\n109#1:153\n109#1:154,2\n*E\n"})
public final class RecentFilesCollectorKt {
    private static final int SWITCHER_ELEMENTS_LIMIT = 30;

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @NotNull
    public static final List<SwitcherRpcDto.File> getFilesToShow(@NotNull Project project, boolean onlyEdited, boolean pinned, @NotNull List<VirtualFileId> filesFromFrontendEditorSelectionHistory) {
        List filesForInit;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(filesFromFrontendEditorSelectionHistory, (String)"filesFromFrontendEditorSelectionHistory");
        ArrayList<Object> filesData = new ArrayList<Object>();
        ArrayList<SwitcherRpcDto.File> editors = new ArrayList<SwitcherRpcDto.File>();
        LinkedHashSet addedFiles = new LinkedHashSet();
        if (!pinned) {
            for (VirtualFileId hint : filesFromFrontendEditorSelectionHistory) {
                VirtualFile virtualFile;
                if (VirtualFileIdKt.virtualFile((VirtualFileId)hint) == null) continue;
                editors.add(RecentFilesCollectorKt.createRecentFileViewModel(virtualFile, project));
            }
            Iterator iterator = editors.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<Object> iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object object = iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
                SwitcherRpcDto.File editor = (SwitcherRpcDto.File)object;
                RecentFilesCollectorKt.addIfNotNull(addedFiles, VirtualFileIdKt.virtualFile((VirtualFileId)editor.getVirtualFileId()));
                filesData.add(editor);
                if (filesData.size() < 30) continue;
            }
        }
        if (filesData.size() > 1) {
            return filesData;
        }
        if (onlyEdited) {
            List list = IdeDocumentHistory.getInstance((Project)project).getChangedFiles();
            v3 = list;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChangedFiles(...)");
        } else {
            v3 = filesForInit = RecentFilesCollectorKt.getRecentFiles(project);
        }
        if (!filesForInit.isEmpty()) {
            int i;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            int editorFileCount = SequencesKt.count((Sequence)SequencesKt.distinct((Sequence)CollectionsKt.asSequence((Iterable)editors)));
            int maxFiles = Math.max(editorFileCount, filesForInit.size());
            Iterable iterable = ToolWindowManagerEx.Companion.getInstanceEx(project).getToolWindows();
            boolean $i$f$filter = false;
            void var13_15 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ToolWindow it = (ToolWindow)element$iv$iv;
                boolean bl = false;
                if (!(it.isAvailable() && it.isShowStripeButton())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            int activeToolWindowsLimit = ((List)destination$iv$iv).size();
            int minIndex = pinned ? 0 : filesForInit.size() - RangesKt.coerceAtMost((int)activeToolWindowsLimit, (int)maxFiles);
            if (minIndex <= (i = filesForInit.size() - 1)) {
                while (true) {
                    Iterator iterator;
                    Object e = filesForInit.get(i);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    SwitcherRpcDto.File info = RecentFilesCollectorKt.createRecentFileViewModel((VirtualFile)e, project);
                    boolean add = true;
                    Intrinsics.checkNotNullExpressionValue(filesData.iterator(), (String)"iterator(...)");
                    while (iterator.hasNext()) {
                        Object e2 = iterator.next();
                        Intrinsics.checkNotNullExpressionValue(e2, (String)"next(...)");
                        SwitcherRpcDto.File fileInfo = (SwitcherRpcDto.File)e2;
                        if (!Intrinsics.areEqual((Object)fileInfo, (Object)info)) continue;
                        add = false;
                        break;
                    }
                    if (add && RecentFilesCollectorKt.addIfNotNull(addedFiles, VirtualFileIdKt.virtualFile((VirtualFileId)info.getVirtualFileId()))) {
                        filesData.add(info);
                    }
                    if (i == minIndex) break;
                    --i;
                }
            }
        }
        if (editors.size() == 1 && (filesData.isEmpty() || !Intrinsics.areEqual(editors.get(0), filesData.get(0))) && RecentFilesCollectorKt.addIfNotNull(addedFiles, VirtualFileIdKt.virtualFile((VirtualFileId)((SwitcherRpcDto.File)editors.get(0)).getVirtualFileId()))) {
            filesData.add(0, editors.get(0));
        }
        return filesData;
    }

    private static final <T> boolean addIfNotNull(Collection<T> targetCollection, T item) {
        if (item == null) {
            return false;
        }
        return targetCollection.add(item);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<VirtualFile> getRecentFiles(Project project) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        List recentFiles = EditorHistoryManager.Companion.getInstance(project).getFileList();
        Object[] objectArray = FileEditorManager.getInstance((Project)project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getOpenFiles(...)");
        Object[] openFiles = objectArray;
        HashSet recentFilesSet = new HashSet(recentFiles);
        HashSet openFilesSet = ArraysKt.toHashSet((Object[])openFiles);
        int index = 0;
        int n = ((Collection)recentFiles).size();
        for (int i = 0; i < n; ++i) {
            if (!openFilesSet.contains(recentFiles.get(i))) continue;
            index = i;
            break;
        }
        ArrayList result = new ArrayList(recentFiles);
        Object[] objectArray2 = openFiles;
        int n2 = index;
        ArrayList arrayList = result;
        boolean $i$f$filter = false;
        void var9_13 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n3 = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n3; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(!recentFilesSet.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        arrayList.addAll(n2, list);
        return result;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final SwitcherRpcDto.File createRecentFileViewModel(VirtualFile virtualFile, Project project) {
        block9: {
            block10: {
                block8: {
                    v0 /* !! */  = virtualFile.getParent();
                    parentPath = v0 /* !! */  != null && (v0 /* !! */  = v0 /* !! */ .getPath()) != null ? NioPathUtil.toNioPathOrNull((String)v0 /* !! */ ) : null;
                    v1 = FilenameIndex.getVirtualFilesByName((String)virtualFile.getName(), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getVirtualFilesByName(...)");
                    sameNameFiles = v1;
                    if (parentPath != null && parentPath.getNameCount() != 0 && sameNameFiles.size() > 1) break block8;
                    v2 = "";
                    break block9;
                }
                filePath = parentPath.toString();
                v3 = project.getBasePath();
                if (v3 != null) {
                    it = v3;
                    $i$a$-let-RecentFilesCollectorKt$createRecentFileViewModel$result$projectPath$1 = false;
                    v4 = FileUtil.toSystemDependentName((String)it);
                } else {
                    v4 = projectPath = null;
                }
                if (projectPath == null || !FileUtil.isAncestor((String)projectPath, (String)filePath, (boolean)true)) break block10;
                locationRelativeToProjectDir = FileUtil.getRelativePath((String)projectPath, (String)filePath, (char)File.separatorChar);
                if (locationRelativeToProjectDir == null) ** GOTO lbl-1000
                v5 = Paths.get(locationRelativeToProjectDir, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"get(...)");
                if (v5.getNameCount() != 0) {
                    v2 = locationRelativeToProjectDir;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = filePath;
                }
                break block9;
            }
            if (FileUtil.isAncestor((String)SystemProperties.getUserHome(), (String)filePath, (boolean)true)) {
                locationRelativeToUserHome = FileUtil.getLocationRelativeToUserHome((String)filePath);
                Intrinsics.checkNotNull((Object)locationRelativeToUserHome);
                v6 = Paths.get(locationRelativeToUserHome, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"get(...)");
                v2 = v6.getNameCount() != 0 ? locationRelativeToUserHome : filePath;
            } else {
                v2 = result = filePath;
            }
        }
        if ((v7 = EditorTabPresentationUtil.getCustomEditorTabTitle((Project)project, (VirtualFile)virtualFile)) == null) {
            v8 = virtualFile.getPresentableName();
            v7 = v8;
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getPresentableName(...)");
        }
        var5_4 = v7;
        v9 /* !! */  = virtualFile.getParent();
        if (v9 /* !! */  == null || (v9 /* !! */  = v9 /* !! */ .getPresentableUrl()) == null) {
            v10 = virtualFile.getPresentableUrl();
            v9 /* !! */  = v10;
            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"getPresentableUrl(...)");
        }
        v11 = FileUtil.getLocationRelativeToUserHome((String)v9 /* !! */ );
        Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"getLocationRelativeToUserHome(...)");
        var6_8 = v11;
        Intrinsics.checkNotNull((Object)result);
        var7_9 = result;
        var8_11 = WolfTheProblemSolver.getInstance((Project)project).isProblemFile(virtualFile);
        var9_5 = VirtualFileIdKt.rpcId((VirtualFile)virtualFile);
        var10_7 = IconIdKt.rpcId((Icon)IconUtil.getIcon((VirtualFile)virtualFile, (int)0, (Project)project));
        v12 = VfsPresentationUtil.getFileBackgroundColor((Project)project, (VirtualFile)virtualFile);
        var11_12 = v12 != null ? ColorIdKt.rpcId((Color)v12) : null;
        v13 = FileStatusManager.getInstance((Project)project).getStatus(virtualFile).getColor();
        var12_13 = v13 != null ? ColorIdKt.rpcId((Color)v13) : null;
        return new SwitcherRpcDto.File(var5_4, var6_8, var7_9, var8_11, var10_7, var12_13, var11_12, var9_5);
    }
}

