/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.tooltip.data;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.data.DataFrameUtil;
import org.jetbrains.letsPlot.core.plot.base.tooltip.LineSpec;
import org.jetbrains.letsPlot.core.plot.base.tooltip.MappedDataAccess;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.TooltipFormatting;
import org.jetbrains.letsPlot.core.plot.builder.tooltip.data.ValueSource;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0000H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0003J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u001c\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010 \u001a\u00020!H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\t\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/data/DataFrameField;", "Lorg/jetbrains/letsPlot/core/plot/builder/tooltip/data/ValueSource;", "name", "", "format", "(Ljava/lang/String;Ljava/lang/String;)V", "isAxis", "", "()Z", "isSide", "myDataAccess", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/MappedDataAccess;", "myDataFrame", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "myFormatter", "Lkotlin/Function1;", "", "myVariable", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "copy", "getDataPoint", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/LineSpec$DataPoint;", "index", "", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "getVariableName", "initDataContext", "", "data", "mappedDataAccess", "initFormatter", "expFormat", "Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat$ExponentFormat;", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nDataFrameField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataFrameField.kt\norg/jetbrains/letsPlot/core/plot/builder/tooltip/data/DataFrameField\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class DataFrameField
implements ValueSource {
    @NotNull
    private final String name;
    @Nullable
    private final String format;
    private MappedDataAccess myDataAccess;
    private DataFrame myDataFrame;
    private DataFrame.Variable myVariable;
    @Nullable
    private Function1<Object, String> myFormatter;
    private final boolean isSide;
    private final boolean isAxis;

    public DataFrameField(@NotNull String name, @Nullable String format2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.format = format2;
    }

    public /* synthetic */ DataFrameField(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    private final Function1<Object, String> initFormatter(StringFormat.ExponentFormat expFormat) {
        Function1 function1;
        if (!(this.myFormatter == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.format == null) {
            MappedDataAccess mappedDataAccess;
            DataFrame.Variable variable = this.myVariable;
            if (variable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myVariable");
                variable = null;
            }
            if ((mappedDataAccess = this.myDataAccess) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myDataAccess");
                mappedDataAccess = null;
            }
            function1 = TooltipFormatting.INSTANCE.createFormatter(variable, mappedDataAccess.getDefaultFormatters(), expFormat);
        } else {
            function1 = (Function1)new Function1<Object, String>((Object)StringFormat.Companion.forOneArg$default(StringFormat.Companion, this.format, null, this.name, expFormat, 2, null)){

                @NotNull
                public final String invoke(@NotNull Object p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((StringFormat)this.receiver).format(p0);
                }
            };
        }
        Function1<Object, String> function12 = this.myFormatter = function1;
        Intrinsics.checkNotNull(function12);
        return function12;
    }

    @Override
    public boolean isSide() {
        return this.isSide;
    }

    @Override
    public boolean isAxis() {
        return this.isAxis;
    }

    @Override
    public void initDataContext(@NotNull DataFrame data, @NotNull MappedDataAccess mappedDataAccess) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)mappedDataAccess, (String)"mappedDataAccess");
        if (!(this.myDataAccess == null)) {
            boolean $i$a$-require-DataFrameField$initDataContext$32 = false;
            String $i$a$-require-DataFrameField$initDataContext$32 = "Data context can be initialized only once";
            throw new IllegalArgumentException($i$a$-require-DataFrameField$initDataContext$32.toString());
        }
        this.myDataAccess = mappedDataAccess;
        if (!(this.myDataFrame == null)) {
            boolean bl = false;
            String string = "Data context can be initialized only once";
            throw new IllegalArgumentException(string.toString());
        }
        this.myDataFrame = data;
        DataFrame dataFrame = this.myDataFrame;
        if (dataFrame == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDataFrame");
            dataFrame = null;
        }
        this.myVariable = DataFrameUtil.INSTANCE.findVariableOrFail(dataFrame, this.name);
    }

    @Override
    @Nullable
    public LineSpec.DataPoint getDataPoint(int index, @NotNull PlotContext ctx2) {
        DataFrame.Variable variable;
        DataFrame dataFrame;
        Function1<Object, String> formatter2;
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Function1<Object, String> function1 = this.myFormatter;
        if (function1 == null) {
            function1 = formatter2 = this.initFormatter(ctx2.getExpFormat());
        }
        if ((dataFrame = this.myDataFrame) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myDataFrame");
            dataFrame = null;
        }
        if ((variable = this.myVariable) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myVariable");
            variable = null;
        }
        Object obj = dataFrame.get(variable).get(index);
        if (obj == null) {
            return null;
        }
        Object originalValue = obj;
        return new LineSpec.DataPoint(this.name, (String)formatter2.invoke(originalValue), null, false, false);
    }

    @Override
    @NotNull
    public DataFrameField copy() {
        return new DataFrameField(this.name, this.format);
    }

    @NotNull
    public final String getVariableName() {
        return this.name;
    }
}

