/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchPair;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitNewBranchDialog;
import git4idea.branch.GitNewBranchOptions;
import git4idea.config.GitVcsSettings;
import git4idea.config.UpdateMethod;
import git4idea.fetch.GitFetchResult;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchCheckoutOperation;
import git4idea.update.GitUpdateExecutionProcess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a<\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00012\b\b\u0003\u0010\n\u001a\u00020\u00012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0001\u001a,\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eH\u0000\u001a$\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a$\u0010\u0013\u001a\u00020\u00102\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0001H\u0000\"\u0010\u0010\u0000\u001a\u00020\u00018\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"GIT_SINGLE_REF_ACTION_GROUP", "", "createOrCheckoutNewBranch", "", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "startPoint", "title", "initialName", "updateBranches", "localBranchNames", "", "isTrackingInfosExist", "", "branchNames", "hasRemotes", "hasTrackingConflicts", "conflictingLocalBranches", "", "Lgit4idea/GitLocalBranch;", "remoteBranchName", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitBranchActionsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchActionsUtil.kt\ngit4idea/ui/branch/GitBranchActionsUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,132:1\n1279#2,2:133\n1293#2,2:135\n774#2:137\n865#2,2:138\n1296#2:140\n1368#2:141\n1454#2,5:142\n1755#2,3:147\n1755#2,3:150\n188#3,3:153\n*S KotlinDebug\n*F\n+ 1 GitBranchActionsUtil.kt\ngit4idea/ui/branch/GitBranchActionsUtilKt\n*L\n48#1:133,2\n48#1:135,2\n48#1:137\n48#1:138,2\n48#1:140\n104#1:141\n104#1:142,5\n105#1:147,3\n108#1:150,3\n113#1:153,3\n*E\n"})
public final class GitBranchActionsUtilKt {
    @Language(value="devkit-action-id")
    @NotNull
    public static final String GIT_SINGLE_REF_ACTION_GROUP = "Git.Branch";

    @JvmOverloads
    public static final void createOrCheckoutNewBranch(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NotNull String startPoint, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, @Nullable String initialName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)startPoint, (String)"startPoint");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        GitNewBranchOptions gitNewBranchOptions = new GitNewBranchDialog(project, repositories, title, initialName, true, true, false, true, null, 256, null).showAndGetOptions();
        if (gitNewBranchOptions == null) {
            return;
        }
        GitNewBranchOptions options = gitNewBranchOptions;
        new GitBranchCheckoutOperation(project, options.repositories()).perform(startPoint, options);
    }

    public static /* synthetic */ void createOrCheckoutNewBranch$default(Project project, Collection collection, String string, String string2, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = GitBundle.message("branches.create.new.branch.dialog.title", new Object[0]);
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        GitBranchActionsUtilKt.createOrCheckoutNewBranch(project, collection, string, string2, string3);
    }

    /*
     * WARNING - void declaration
     */
    public static final void updateBranches(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NotNull List<String> localBranchNames) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter(localBranchNames, (String)"localBranchNames");
        Iterable $this$associateWith$iv = repositories;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv;
            void it;
            GitRepository gitRepository = (GitRepository)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Collection<GitBranchTrackInfo> collection = it.getBranchTrackInfos();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getBranchTrackInfos(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                GitBranchTrackInfo info = (GitBranchTrackInfo)element$iv$iv2;
                boolean bl2 = false;
                if (!localBranchNames.contains(info.getLocalBranch().getName())) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List list = (List)destination$iv$iv;
            map2.put(t, list);
        }
        Map repoToTrackingInfos = result$iv;
        if (repoToTrackingInfos.isEmpty()) {
            return;
        }
        String string = GitBundle.message("branches.updating.process", new Object[0]);
        GitVcs.runInBackground(new Task.Backgroundable(project, repoToTrackingInfos, repositories, string){
            private final ArrayList<String> successfullyUpdated;
            final /* synthetic */ Project $project;
            final /* synthetic */ Map<GitRepository, List<GitBranchTrackInfo>> $repoToTrackingInfos;
            final /* synthetic */ Collection<GitRepository> $repositories;
            {
                this.$project = $project;
                this.$repoToTrackingInfos = $repoToTrackingInfos;
                this.$repositories = $repositories;
                super($project, $super_call_param$1, true);
                this.successfullyUpdated = new ArrayList<E>();
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GitFetchSupport gitFetchSupport = GitFetchSupport.fetchSupport(this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)gitFetchSupport, (String)"fetchSupport(...)");
                GitFetchSupport fetchSupport = gitFetchSupport;
                Map currentBranchesMap = new HashMap<K, V>();
                for (Map.Entry<GitRepository, List<GitBranchTrackInfo>> entry : this.$repoToTrackingInfos.entrySet()) {
                    GitRepository repo2 = entry.getKey();
                    List<GitBranchTrackInfo> trackingInfos = entry.getValue();
                    GitLocalBranch currentBranch = repo2.getCurrentBranch();
                    for (GitBranchTrackInfo trackingInfo : trackingInfos) {
                        boolean bl;
                        GitFetchResult fetchResult2;
                        String localBranchName;
                        String remoteBranchName;
                        GitRemoteBranch remoteBranch;
                        GitLocalBranch localBranch;
                        Intrinsics.checkNotNullExpressionValue((Object)trackingInfo.getLocalBranch(), (String)"getLocalBranch(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)trackingInfo.getRemoteBranch(), (String)"getRemoteBranch(...)");
                        if (Intrinsics.areEqual((Object)localBranch, (Object)currentBranch)) {
                            currentBranchesMap.put(repo2, new GitBranchPair(currentBranch, remoteBranch));
                            continue;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)localBranch.getName(), (String)"getName(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)remoteBranch.getNameForRemoteOperations(), (String)"getNameForRemoteOperations(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)fetchSupport.fetch(repo2, trackingInfo.getRemote(), remoteBranchName + ":" + localBranchName), (String)"fetch(...)");
                        try {
                            fetchResult2.throwExceptionIfFailed();
                            bl = this.successfullyUpdated.add(localBranchName);
                        }
                        catch (VcsException ignored) {
                            bl = fetchResult2.showNotificationIfFailed(GitBundle.message("branches.update.failed", new Object[0]));
                        }
                    }
                }
                if (!currentBranchesMap.isEmpty()) {
                    UpdateMethod updateMethod = GitVcsSettings.getInstance(this.$project).getUpdateMethod();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)updateMethod), (String)"getUpdateMethod(...)");
                    new GitUpdateExecutionProcess(this.$project, this.$repositories, currentBranchesMap, updateMethod, false).execute();
                }
            }

            public void onSuccess() {
                if (!((Collection)this.successfullyUpdated).isEmpty()) {
                    Object[] objectArray = new Object[]{this.successfullyUpdated.size(), CollectionsKt.joinToString$default((Iterable)this.successfullyUpdated, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)};
                    VcsNotifier.getInstance((Project)this.$project).notifySuccess("git.branches.update.successful", "", GitBundle.message("branches.selected.branches.updated.title", objectArray));
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isTrackingInfosExist(@NotNull List<String> branchNames, @NotNull Collection<? extends GitRepository> repositories) {
        boolean bl;
        block8: {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(branchNames, (String)"branchNames");
            Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
            Iterable $this$flatMap$iv = repositories;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                GitRepository p0 = (GitRepository)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = p0.getBranchTrackInfos();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl3;
                    block7: {
                        GitBranchTrackInfo trackingBranchInfo = (GitBranchTrackInfo)element$iv;
                        boolean bl4 = false;
                        Iterable $this$any$iv2 = branchNames;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String branchName = (String)element$iv2;
                                boolean bl5 = false;
                                if (!Intrinsics.areEqual((Object)branchName, (Object)trackingBranchInfo.getLocalBranch().getName())) continue;
                                bl3 = true;
                                break block7;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasRemotes(@NotNull Project project) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Collection<GitRepository> collection = GitUtil.getRepositories(project);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getRepositories(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitRepository repository = (GitRepository)element$iv;
                    boolean bl2 = false;
                    if (!(!repository.getRemotes().isEmpty())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasTrackingConflicts(@NotNull Map<GitRepository, GitLocalBranch> conflictingLocalBranches, @NotNull String remoteBranchName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(conflictingLocalBranches, (String)"conflictingLocalBranches");
            Intrinsics.checkNotNullParameter((Object)remoteBranchName, (String)"remoteBranchName");
            Map<GitRepository, GitLocalBranch> $this$any$iv = conflictingLocalBranches;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<GitRepository, GitLocalBranch>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    GitLocalBranch branch;
                    Map.Entry<GitRepository, GitLocalBranch> element$iv;
                    Map.Entry<GitRepository, GitLocalBranch> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    GitRepository repo2 = entry.getKey();
                    GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repo2, branch = entry.getValue());
                    if (!(trackInfo != null && !GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)remoteBranchName, (Object)trackInfo.getRemoteBranch().getName()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmOverloads
    public static final void createOrCheckoutNewBranch(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NotNull String startPoint, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)startPoint, (String)"startPoint");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        GitBranchActionsUtilKt.createOrCheckoutNewBranch$default(project, repositories, startPoint, title, null, 16, null);
    }

    @JvmOverloads
    public static final void createOrCheckoutNewBranch(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NotNull String startPoint) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)startPoint, (String)"startPoint");
        GitBranchActionsUtilKt.createOrCheckoutNewBranch$default(project, repositories, startPoint, null, null, 24, null);
    }
}

