/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl.engineV2;

import com.intellij.httpClient.converters.RequestBuilder;
import io.netty.channel.ChannelOption;
import io.netty.channel.FixedRecvByteBufAllocator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.netty.http.Http11SslContextSpec;
import reactor.netty.http.Http2SettingsSpec;
import reactor.netty.http.Http2SslContextSpec;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.AbstractProtocolSslContextSpec;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\f\u0010\u0010\u001a\u00020\n*\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/httpClient/execution/impl/engineV2/NettyProtocolConfigurator;", "", "isSecure", "", "explicitProtocol", "Lcom/intellij/httpClient/converters/RequestBuilder$HttpProtocol;", "<init>", "(ZLcom/intellij/httpClient/converters/RequestBuilder$HttpProtocol;)V", "()Z", "configureProtocols", "Lreactor/netty/http/client/HttpClient;", "client", "sslContextSpec", "Lreactor/netty/tcp/AbstractProtocolSslContextSpec;", "getSslContextSpec", "()Lreactor/netty/tcp/AbstractProtocolSslContextSpec;", "customizedHttp2Settings", "intellij.httpClient.executor"})
public final class NettyProtocolConfigurator {
    private final boolean isSecure;
    @Nullable
    private final RequestBuilder.HttpProtocol explicitProtocol;

    public NettyProtocolConfigurator(boolean isSecure, @Nullable RequestBuilder.HttpProtocol explicitProtocol) {
        this.isSecure = isSecure;
        this.explicitProtocol = explicitProtocol;
    }

    public final boolean isSecure() {
        return this.isSecure;
    }

    @NotNull
    public final HttpClient configureProtocols(@NotNull HttpClient client) {
        HttpClient httpClient;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        RequestBuilder.HttpProtocol httpProtocol = this.explicitProtocol;
        switch (httpProtocol == null ? -1 : WhenMappings.$EnumSwitchMapping$0[httpProtocol.ordinal()]) {
            case 1: {
                HttpProtocol[] httpProtocolArray = new HttpProtocol[]{HttpProtocol.HTTP11};
                HttpClient httpClient2 = client.protocol(httpProtocolArray);
                httpClient = httpClient2;
                Intrinsics.checkNotNullExpressionValue((Object)httpClient2, (String)"protocol(...)");
                break;
            }
            case 2: {
                if (this.isSecure) {
                    HttpProtocol[] httpProtocolArray = new HttpProtocol[]{HttpProtocol.H2, HttpProtocol.HTTP11};
                    HttpClient httpClient3 = client.protocol(httpProtocolArray);
                    Intrinsics.checkNotNullExpressionValue((Object)httpClient3, (String)"protocol(...)");
                    httpClient = this.customizedHttp2Settings(httpClient3);
                    break;
                }
                HttpProtocol[] httpProtocolArray = new HttpProtocol[]{HttpProtocol.H2C, HttpProtocol.HTTP11};
                HttpClient httpClient4 = client.protocol(httpProtocolArray);
                Intrinsics.checkNotNullExpressionValue((Object)httpClient4, (String)"protocol(...)");
                httpClient = this.customizedHttp2Settings(httpClient4);
                break;
            }
            case 3: {
                if (this.isSecure) {
                    HttpProtocol[] httpProtocolArray = new HttpProtocol[]{HttpProtocol.H2};
                    HttpClient httpClient5 = client.protocol(httpProtocolArray);
                    Intrinsics.checkNotNullExpressionValue((Object)httpClient5, (String)"protocol(...)");
                    httpClient = this.customizedHttp2Settings(httpClient5);
                    break;
                }
                HttpProtocol[] httpProtocolArray = new HttpProtocol[]{HttpProtocol.H2C};
                HttpClient httpClient6 = client.protocol(httpProtocolArray);
                Intrinsics.checkNotNullExpressionValue((Object)httpClient6, (String)"protocol(...)");
                httpClient = this.customizedHttp2Settings(httpClient6);
                break;
            }
            case -1: {
                if (this.isSecure) {
                    HttpProtocol[] httpProtocolArray = new HttpProtocol[]{HttpProtocol.H2, HttpProtocol.HTTP11};
                    HttpClient httpClient7 = client.protocol(httpProtocolArray);
                    Intrinsics.checkNotNullExpressionValue((Object)httpClient7, (String)"protocol(...)");
                    httpClient = this.customizedHttp2Settings(httpClient7);
                    break;
                }
                HttpProtocol[] httpProtocolArray = new HttpProtocol[]{HttpProtocol.HTTP11};
                HttpClient httpClient8 = client.protocol(httpProtocolArray);
                Intrinsics.checkNotNull((Object)httpClient8);
                httpClient = httpClient8;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return httpClient;
    }

    @NotNull
    public final AbstractProtocolSslContextSpec<?> getSslContextSpec() {
        AbstractProtocolSslContextSpec abstractProtocolSslContextSpec;
        if (!this.isSecure) {
            throw new IllegalStateException("Check failed.");
        }
        if (this.explicitProtocol == RequestBuilder.HttpProtocol.HTTP_11) {
            Http11SslContextSpec http11SslContextSpec = Http11SslContextSpec.forClient();
            Intrinsics.checkNotNull((Object)http11SslContextSpec);
            abstractProtocolSslContextSpec = http11SslContextSpec;
        } else {
            Http2SslContextSpec http2SslContextSpec = Http2SslContextSpec.forClient();
            Intrinsics.checkNotNull((Object)http2SslContextSpec);
            abstractProtocolSslContextSpec = http2SslContextSpec;
        }
        return abstractProtocolSslContextSpec;
    }

    private final HttpClient customizedHttp2Settings(HttpClient $this$customizedHttp2Settings) {
        Object t = $this$customizedHttp2Settings.http2Settings(NettyProtocolConfigurator::customizedHttp2Settings$lambda$0).option(ChannelOption.RCVBUF_ALLOCATOR, new FixedRecvByteBufAllocator(0x100000));
        Intrinsics.checkNotNullExpressionValue(t, (String)"option(...)");
        return (HttpClient)t;
    }

    private static final void customizedHttp2Settings$lambda$0(Http2SettingsSpec.Builder it) {
        it.maxConcurrentStreams(1L).maxFrameSize(0x100000).initialWindowSize(0x100000);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestBuilder.HttpProtocol.values().length];
            try {
                nArray[RequestBuilder.HttpProtocol.HTTP_11.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestBuilder.HttpProtocol.HTTP_2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestBuilder.HttpProtocol.HTTP_2_PRIOR_KNOWLEDGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

