/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.execution.FailureReason;
import com.jetbrains.python.execution.PyExecutionFailure;
import com.jetbrains.python.execution.PyExecutionFailureKt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a3\u0010\u0006\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"showProcessExecutionErrorDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "exception", "Lcom/jetbrains/python/execution/PyExecutionFailure;", "appendProcessOutput", "Ljavax/swing/JTextPane;", "command", "", "stdout", "stderr", "exitCode", "", "(Ljavax/swing/JTextPane;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)V", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nProcessExecutionErrorDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessExecutionErrorDialog.kt\ncom/jetbrains/python/ProcessExecutionErrorDialogKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,94:1\n13402#2,2:95\n*S KotlinDebug\n*F\n+ 1 ProcessExecutionErrorDialog.kt\ncom/jetbrains/python/ProcessExecutionErrorDialogKt\n*L\n87#1:95,2\n*E\n"})
public final class ProcessExecutionErrorDialogKt {
    public static final void showProcessExecutionErrorDialog(@Nullable Project project, @NotNull PyExecutionFailure exception) {
        JTextPane jTextPane;
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (!(project == null || !project.isDisposed())) {
            throw new IllegalStateException("Check failed.");
        }
        String string = PyBundle.message("dialog.message.command.could.not.complete", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String errorMessageText = string;
        JBLabel errorMessageLabel = new JBLabel(UIUtil.toHtml((String)errorMessageText), Messages.getErrorIcon(), 2);
        JTextPane $this$showProcessExecutionErrorDialog_u24lambda_u240 = jTextPane = new JTextPane();
        boolean bl = false;
        String command = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)exception.getCommand()), (Iterable)exception.getArgs()), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        FailureReason err = exception.getFailureReason();
        if (Intrinsics.areEqual((Object)err, (Object)FailureReason.CantStart.INSTANCE)) {
            ProcessExecutionErrorDialogKt.appendProcessOutput($this$showProcessExecutionErrorDialog_u24lambda_u240, command, "\n", PyExecutionFailureKt.getUserMessage(exception), null);
        } else if (err instanceof FailureReason.ExecutionFailed) {
            ProcessOutput output2 = ((FailureReason.ExecutionFailed)err).getOutput();
            String string2 = output2.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStdout(...)");
            String string3 = output2.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStderr(...)");
            ProcessExecutionErrorDialogKt.appendProcessOutput($this$showProcessExecutionErrorDialog_u24lambda_u240, command, string2, string3, output2.getExitCode());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$showProcessExecutionErrorDialog_u24lambda_u240.setBackground((Color)JBColor.WHITE);
        $this$showProcessExecutionErrorDialog_u24lambda_u240.setEditable(false);
        JTextPane commandOutputTextPane = jTextPane;
        JTextPane $this$showProcessExecutionErrorDialog_u24lambda_u241 = $this$showProcessExecutionErrorDialog_u24lambda_u240 = new BorderLayoutPanel();
        boolean bl2 = false;
        $this$showProcessExecutionErrorDialog_u24lambda_u241.setBorder((Border)IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"border.title.command.output", (Object[])new Object[0]), (boolean)false));
        $this$showProcessExecutionErrorDialog_u24lambda_u241.addToCenter((Component)new JBScrollPane((Component)commandOutputTextPane, 20, 31));
        JTextPane commandOutputPanel = $this$showProcessExecutionErrorDialog_u24lambda_u240;
        FormBuilder formBuilder = new FormBuilder().addComponent((JComponent)errorMessageLabel).addComponentFillVertically((JComponent)commandOutputPanel, 4);
        Intrinsics.checkNotNullExpressionValue((Object)formBuilder, (String)"addComponentFillVertically(...)");
        FormBuilder formBuilder2 = formBuilder;
        new DialogWrapper(exception, errorMessageText, project, formBuilder2){
            final /* synthetic */ FormBuilder $formBuilder;
            {
                this.$formBuilder = $formBuilder;
                super($project);
                this.init();
                String string = $exception.getAdditionalMessage();
                if (string == null) {
                    string = $errorMessageText;
                }
                this.setTitle(string);
            }

            protected Action[] createActions() {
                Action[] actionArray = new Action[]{this.getOKAction()};
                return actionArray;
            }

            protected JComponent createCenterPanel() {
                JPanel jPanel;
                JPanel $this$createCenterPanel_u24lambda_u240 = jPanel = this.$formBuilder.getPanel();
                boolean bl = false;
                $this$createCenterPanel_u24lambda_u240.setPreferredSize(new Dimension(600, 300));
                JPanel jPanel2 = jPanel;
                Intrinsics.checkNotNullExpressionValue((Object)jPanel2, (String)"apply(...)");
                return jPanel2;
            }
        }.showAndGet();
    }

    private static final void appendProcessOutput(JTextPane $this$appendProcessOutput, String command, String stdout, String stderr, Integer exitCode) {
        Document document;
        Style stdoutStyle = $this$appendProcessOutput.addStyle(null, null);
        StyleConstants.setFontFamily(stdoutStyle, "Monospaced");
        Style stderrStyle = $this$appendProcessOutput.addStyle(null, stdoutStyle);
        StyleConstants.setForeground(stderrStyle, (Color)JBColor.RED);
        Document $this$appendProcessOutput_u24lambda_u243 = document = $this$appendProcessOutput.getDocument();
        boolean bl = false;
        $this$appendProcessOutput_u24lambda_u243.insertString(0, command + "\n", stdoutStyle);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)stdout, (Object)stdoutStyle), TuplesKt.to((Object)stderr, (Object)stderrStyle)};
        Pair[] $this$forEach$iv = pairArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Pair element$iv;
            Pair pair = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            String std = (String)pair.component1();
            Style style = (Style)pair.component2();
            if (!(((CharSequence)std).length() > 0)) continue;
            $this$appendProcessOutput_u24lambda_u243.insertString($this$appendProcessOutput_u24lambda_u243.getLength(), std + "\n", style);
        }
        if (exitCode != null) {
            $this$appendProcessOutput_u24lambda_u243.insertString($this$appendProcessOutput_u24lambda_u243.getLength(), "Process finished with exit code " + exitCode, stdoutStyle);
        }
    }
}

