/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.controlflow.CallInstruction;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.PyWithContextExitInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyInspectionsUtil {
    @ApiStatus.Internal
    public static boolean hasAnyInterruptedControlFlowPaths(@NotNull PsiElement element, @NotNull TypeEvalContext context) {
        ScopeOwner owner;
        if (element == null) {
            PyInspectionsUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyInspectionsUtil.$$$reportNull$$$0(1);
        }
        if ((owner = ScopeUtil.getScopeOwner(element)) != null) {
            return !PyInspectionsUtil.collectUnreachable(owner, element, context).isEmpty();
        }
        return false;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<PsiElement> collectUnreachable(@NotNull ScopeOwner owner, @Nullable PsiElement anchor, @NotNull TypeEvalContext context) {
        int start;
        if (owner == null) {
            PyInspectionsUtil.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PyInspectionsUtil.$$$reportNull$$$0(3);
        }
        ControlFlow flow = ControlFlowCache.getControlFlow(owner);
        Instruction[] instructions = flow.getInstructions();
        ArrayList<PsiElement> unreachable = new ArrayList<PsiElement>();
        int n = start = anchor != null ? ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)anchor) : instructions.length - 1;
        if (start >= 0) {
            ControlFlowUtil.iteratePrev((int)start, (Instruction[])instructions, instruction -> {
                if (PyInspectionsUtil.getReachablePredecessors(instruction, context).isEmpty() && instruction.num() != 0) {
                    ContainerUtil.addIfNotNull((Collection)unreachable, (Object)PyInspectionsUtil.getRelevantElement(instruction));
                }
                return ControlFlowUtil.Operation.NEXT;
            });
        }
        ArrayList<PsiElement> arrayList = unreachable;
        if (arrayList == null) {
            PyInspectionsUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private static List<Instruction> getReachablePredecessors(@NotNull Instruction instruction, @NotNull TypeEvalContext context) {
        if (instruction == null) {
            PyInspectionsUtil.$$$reportNull$$$0(5);
        }
        if (context == null) {
            PyInspectionsUtil.$$$reportNull$$$0(6);
        }
        List list = ContainerUtil.filter((Collection)instruction.allPred(), it -> {
            PyWithContextExitInstruction wi;
            CallInstruction ci;
            if (it instanceof CallInstruction && (ci = (CallInstruction)((Object)it)).isNoReturnCall(context)) {
                return false;
            }
            return !(it instanceof PyWithContextExitInstruction) || (wi = (PyWithContextExitInstruction)((Object)it)).isSuppressingExceptions(context);
        });
        if (list == null) {
            PyInspectionsUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    private static PsiElement getRelevantElement(@NotNull Instruction instruction) {
        if (instruction == null) {
            PyInspectionsUtil.$$$reportNull$$$0(8);
        }
        if (instruction instanceof PyWithContextExitInstruction) {
            return null;
        }
        PsiElement element = instruction.getElement();
        if (element instanceof PyStatementListContainer) {
            return ((PyStatementListContainer)element).getStatementList();
        }
        return element;
    }

    private PyInspectionsUtil() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyInspectionsUtil";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyInspectionsUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUnreachable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReachablePredecessors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasAnyInterruptedControlFlowPaths";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectUnreachable";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReachablePredecessors";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRelevantElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7 -> new IllegalStateException(string);
        };
    }
}

