/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.repository;

import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SegmentedButton;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.repository.PyPackageRepository;
import com.jetbrains.python.packaging.repository.PyPackageRepositoryAuthenticationType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\tH\u0016J\b\u0010\u001a\u001a\u00020\u0002H\u0016J\b\u0010\u001b\u001a\u00020\tH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/python/packaging/repository/PyRepositoryListItem;", "Lcom/intellij/openapi/ui/NamedConfigurable;", "Lcom/jetbrains/python/packaging/repository/PyPackageRepository;", "repository", "<init>", "(Lcom/jetbrains/python/packaging/repository/PyPackageRepository;)V", "getRepository", "()Lcom/jetbrains/python/packaging/repository/PyPackageRepository;", "currentName", "", "password", "propertyGraph", "Lcom/intellij/openapi/observable/properties/PropertyGraph;", "urlProperty", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "loginProperty", "passwordProperty", "authorizationTypeProperty", "Lcom/jetbrains/python/packaging/repository/PyPackageRepositoryAuthenticationType;", "getDisplayName", "isModified", "", "apply", "", "setDisplayName", "name", "getEditableObject", "getBannerSlogan", "createOptionsPanel", "Ljavax/swing/JComponent;", "intellij.python.community.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPyRepositoryListItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyRepositoryListItem.kt\ncom/jetbrains/python/packaging/repository/PyRepositoryListItem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class PyRepositoryListItem
extends NamedConfigurable<PyPackageRepository> {
    @NotNull
    private final PyPackageRepository repository;
    @NlsSafe
    @NotNull
    private String currentName;
    @Nullable
    private String password;
    @NotNull
    private final PropertyGraph propertyGraph;
    @NotNull
    private final GraphProperty<String> urlProperty;
    @NotNull
    private final GraphProperty<String> loginProperty;
    @NotNull
    private final GraphProperty<String> passwordProperty;
    @NotNull
    private final GraphProperty<PyPackageRepositoryAuthenticationType> authorizationTypeProperty;

    public PyRepositoryListItem(@NotNull PyPackageRepository repository) {
        Intrinsics.checkNotNullParameter((Object)((Object)repository), (String)"repository");
        super(true, null);
        this.repository = repository;
        String string = this.repository.getName();
        Intrinsics.checkNotNull((Object)string);
        this.currentName = string;
        this.password = this.repository.getPassword();
        this.propertyGraph = new PropertyGraph(null, false, 3, null);
        this.urlProperty = this.propertyGraph.lazyProperty(() -> PyRepositoryListItem.urlProperty$lambda$0(this));
        this.loginProperty = this.propertyGraph.lazyProperty(() -> PyRepositoryListItem.loginProperty$lambda$1(this));
        this.passwordProperty = this.propertyGraph.lazyProperty(() -> PyRepositoryListItem.passwordProperty$lambda$2(this));
        this.authorizationTypeProperty = this.propertyGraph.lazyProperty(() -> PyRepositoryListItem.authorizationTypeProperty$lambda$3(this));
    }

    @NotNull
    public final PyPackageRepository getRepository() {
        return this.repository;
    }

    @NotNull
    public String getDisplayName() {
        return this.currentName;
    }

    public boolean isModified() {
        return !Intrinsics.areEqual((Object)this.currentName, (Object)this.repository.getName()) || !Intrinsics.areEqual((Object)this.repository.getRepositoryUrl(), (Object)this.urlProperty.get()) || this.repository.getAuthorizationType() != this.authorizationTypeProperty.get() || !Intrinsics.areEqual((Object)this.repository.getLogin(), (Object)this.loginProperty.get()) || !Intrinsics.areEqual((Object)this.password, (Object)this.passwordProperty.get());
    }

    public void apply() {
        if (!Intrinsics.areEqual((Object)this.currentName, (Object)this.repository.getName())) {
            this.repository.clearCredentials();
        }
        this.repository.setName(this.currentName);
        String newUrl = ((Object)StringsKt.trim((CharSequence)((String)this.urlProperty.get()))).toString();
        this.repository.setRepositoryUrl((String)(StringsKt.endsWith$default((String)newUrl, (String)"/", (boolean)false, (int)2, null) ? newUrl : newUrl + "/"));
        this.repository.setAuthorizationType((PyPackageRepositoryAuthenticationType)((Object)this.authorizationTypeProperty.get()));
        if (this.repository.getAuthorizationType() == PyPackageRepositoryAuthenticationType.HTTP) {
            this.repository.setLogin((String)this.loginProperty.get());
            this.repository.setPassword((String)this.passwordProperty.get());
        } else {
            this.repository.setLogin("");
            this.repository.clearCredentials();
        }
    }

    public void setDisplayName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.currentName = name2;
    }

    @NotNull
    public PyPackageRepository getEditableObject() {
        return this.repository;
    }

    @NotNull
    public String getBannerSlogan() {
        return this.getDisplayName();
    }

    @NotNull
    public JComponent createOptionsPanel() {
        JPanel jPanel;
        JPanel $this$createOptionsPanel_u24lambda_u244 = jPanel = new JPanel();
        boolean bl = false;
        $this$createOptionsPanel_u24lambda_u244.setBorder(JBUI.Borders.empty((int)10));
        $this$createOptionsPanel_u24lambda_u244.setLayout(new BorderLayout());
        JPanel mainPanel2 = jPanel;
        DialogPanel repositoryForm = BuilderKt.panel(arg_0 -> PyRepositoryListItem.createOptionsPanel$lambda$14(this, arg_0));
        mainPanel2.add((Component)repositoryForm, "Center");
        return mainPanel2;
    }

    private static final String urlProperty$lambda$0(PyRepositoryListItem this$0) {
        String string = this$0.repository.getRepositoryUrl();
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static final String loginProperty$lambda$1(PyRepositoryListItem this$0) {
        String string = this$0.repository.getLogin();
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static final String passwordProperty$lambda$2(PyRepositoryListItem this$0) {
        String string = this$0.repository.getPassword();
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static final PyPackageRepositoryAuthenticationType authorizationTypeProperty$lambda$3(PyRepositoryListItem this$0) {
        return this$0.repository.getAuthorizationType();
    }

    private static final Unit createOptionsPanel$lambda$14$lambda$5(PyRepositoryListItem this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldKt.bindText((Cell)$this$row.cell((JComponent)new JBTextField(this$0.repository.getRepositoryUrl())).align((Align)AlignX.FILL.INSTANCE), (ObservableMutableProperty)((ObservableMutableProperty)this$0.urlProperty));
        return Unit.INSTANCE;
    }

    private static final Unit createOptionsPanel$lambda$14$lambda$7$lambda$6(SegmentedButton.ItemPresentation $this$segmentedButton, PyPackageRepositoryAuthenticationType it) {
        Intrinsics.checkNotNullParameter((Object)$this$segmentedButton, (String)"$this$segmentedButton");
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        $this$segmentedButton.setText(it.getText());
        return Unit.INSTANCE;
    }

    private static final Unit createOptionsPanel$lambda$14$lambda$7(PyRepositoryListItem this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.segmentedButton((Collection)ArraysKt.toList((Object[])PyPackageRepositoryAuthenticationType.values()), PyRepositoryListItem::createOptionsPanel$lambda$14$lambda$7$lambda$6).bind((ObservableMutableProperty)this$0.authorizationTypeProperty);
        return Unit.INSTANCE;
    }

    private static final Unit createOptionsPanel$lambda$14$lambda$9(PyRepositoryListItem this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell $this$createOptionsPanel_u24lambda_u2414_u24lambda_u249_u24lambda_u248 = cell = $this$row.cell((JComponent)new JBTextField(this$0.repository.getLogin()));
        boolean bl = false;
        ((JBTextField)$this$createOptionsPanel_u24lambda_u2414_u24lambda_u249_u24lambda_u248.getComponent()).setPreferredSize(new Dimension(250, ((JBTextField)$this$createOptionsPanel_u24lambda_u2414_u24lambda_u249_u24lambda_u248.getComponent()).getPreferredSize().height));
        TextFieldKt.bindText((Cell)cell, (ObservableMutableProperty)((ObservableMutableProperty)this$0.loginProperty));
        return Unit.INSTANCE;
    }

    private static final Unit createOptionsPanel$lambda$14$lambda$12$lambda$10(PyRepositoryListItem this$0, JBPasswordField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setText(this$0.repository.getPassword());
        return Unit.INSTANCE;
    }

    private static final Unit createOptionsPanel$lambda$14$lambda$12(PyRepositoryListItem this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell $this$createOptionsPanel_u24lambda_u2414_u24lambda_u2412_u24lambda_u2411 = cell = $this$row.passwordField().applyToComponent(arg_0 -> PyRepositoryListItem.createOptionsPanel$lambda$14$lambda$12$lambda$10(this$0, arg_0));
        boolean bl = false;
        ((JBPasswordField)$this$createOptionsPanel_u24lambda_u2414_u24lambda_u2412_u24lambda_u2411.getComponent()).setPreferredSize(new Dimension(250, ((JBPasswordField)$this$createOptionsPanel_u24lambda_u2414_u24lambda_u2412_u24lambda_u2411.getComponent()).getPreferredSize().height));
        TextFieldKt.bindText((Cell)cell, (ObservableMutableProperty)((ObservableMutableProperty)this$0.passwordProperty));
        return Unit.INSTANCE;
    }

    private static final Unit createOptionsPanel$lambda$14$lambda$13(PyRepositoryListItem this$0, Row $row1, Row $row2, PyPackageRepositoryAuthenticationType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        PyPackageRepositoryAuthenticationType state = (PyPackageRepositoryAuthenticationType)((Object)this$0.authorizationTypeProperty.get());
        $row1.visible(state != PyPackageRepositoryAuthenticationType.NONE);
        $row2.visible(state != PyPackageRepositoryAuthenticationType.NONE);
        return Unit.INSTANCE;
    }

    private static final Unit createOptionsPanel$lambda$14(PyRepositoryListItem this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = PyBundle.message("python.packaging.repository.form.url", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> PyRepositoryListItem.createOptionsPanel$lambda$14$lambda$5(this$0, arg_0));
        String string2 = PyBundle.message("python.packaging.repository.form.authorization", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> PyRepositoryListItem.createOptionsPanel$lambda$14$lambda$7(this$0, arg_0));
        String string3 = PyBundle.message("python.packaging.repository.form.login", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        Row row1 = $this$panel.row(string3, arg_0 -> PyRepositoryListItem.createOptionsPanel$lambda$14$lambda$9(this$0, arg_0)).visible(this$0.repository.getAuthorizationType() != PyPackageRepositoryAuthenticationType.NONE);
        String string4 = PyBundle.message("python.packaging.repository.form.password", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        Row row2 = $this$panel.row(string4, arg_0 -> PyRepositoryListItem.createOptionsPanel$lambda$14$lambda$12(this$0, arg_0)).visible(this$0.repository.getAuthorizationType() != PyPackageRepositoryAuthenticationType.NONE);
        this$0.authorizationTypeProperty.afterChange(arg_0 -> PyRepositoryListItem.createOptionsPanel$lambda$14$lambda$13(this$0, row1, row2, arg_0));
        return Unit.INSTANCE;
    }
}

