/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.psi.resolve.RootVisitor;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class RootVisitorHost {
    public static void visitRoots(@NotNull PsiElement elt, @NotNull RootVisitor visitor2) {
        Module module;
        if (elt == null) {
            RootVisitorHost.$$$reportNull$$$0(0);
        }
        if (visitor2 == null) {
            RootVisitorHost.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)elt)) != null) {
            RootVisitorHost.visitRoots(module, false, visitor2);
        } else {
            PsiFile containingFile;
            if (PythonRuntimeService.getInstance().isInScratchFile(elt)) {
                RootVisitorHost.visitRootsInAllModules(elt.getProject(), visitor2);
            }
            if ((containingFile = elt.getContainingFile()) != null) {
                RootVisitorHost.visitSdkRoots(containingFile, visitor2);
            }
        }
    }

    public static void visitRootsInAllModules(@NotNull Project project, @NotNull RootVisitor visitor2) {
        if (project == null) {
            RootVisitorHost.$$$reportNull$$$0(2);
        }
        if (visitor2 == null) {
            RootVisitorHost.$$$reportNull$$$0(3);
        }
        for (Module mod : ModuleManager.getInstance((Project)project).getModules()) {
            RootVisitorHost.visitRoots(mod, true, false, visitor2);
        }
    }

    public static void visitRoots(@NotNull Module module, boolean skipSdk, RootVisitor visitor2) {
        if (module == null) {
            RootVisitorHost.$$$reportNull$$$0(4);
        }
        RootVisitorHost.visitRoots(module, skipSdk, true, visitor2);
    }

    private static void visitRoots(@NotNull Module module, boolean skipSdk, boolean processModuleDeps, RootVisitor visitor2) {
        if (module == null) {
            RootVisitorHost.$$$reportNull$$$0(5);
        }
        OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)module);
        if (processModuleDeps) {
            enumerator = enumerator.recursively();
        }
        if (skipSdk) {
            enumerator = enumerator.withoutSdk();
        }
        enumerator.forEach(orderEntry -> {
            if (orderEntry instanceof ModuleSourceOrderEntry) {
                return RootVisitorHost.visitModuleContentEntries(((ModuleSourceOrderEntry)orderEntry).getRootModel(), visitor2);
            }
            return RootVisitorHost.visitOrderEntryRoots(visitor2, orderEntry);
        });
    }

    static void visitSdkRoots(PsiFile file, RootVisitor visitor2) {
        Sdk sdk2;
        VirtualFile elt_vfile = file.getOriginalFile().getVirtualFile();
        List orderEntries = null;
        if (elt_vfile != null) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)file.getProject()).getFileIndex();
            orderEntries = fileIndex.getOrderEntriesForFile(elt_vfile);
            if (!orderEntries.isEmpty()) {
                OrderEntry entry;
                Iterator iterator = orderEntries.iterator();
                while (iterator.hasNext() && RootVisitorHost.visitOrderEntryRoots(visitor2, entry = (OrderEntry)iterator.next())) {
                }
            } else {
                orderEntries = null;
            }
        }
        if (orderEntries == null && (sdk2 = ProjectRootManager.getInstance((Project)file.getProject()).getProjectSdk()) != null) {
            RootVisitorHost.visitSdkRoots(sdk2, visitor2);
        }
    }

    public static boolean visitSdkRoots(@NotNull Sdk sdk2, @NotNull RootVisitor visitor2) {
        VirtualFile[] roots;
        if (sdk2 == null) {
            RootVisitorHost.$$$reportNull$$$0(6);
        }
        if (visitor2 == null) {
            RootVisitorHost.$$$reportNull$$$0(7);
        }
        for (VirtualFile root : roots = sdk2.getRootProvider().getFiles(OrderRootType.CLASSES)) {
            if (visitor2.visitRoot(root, null, sdk2, false)) continue;
            return true;
        }
        return false;
    }

    private static boolean visitModuleContentEntries(ModuleRootModel rootModel, RootVisitor visitor2) {
        for (ContentEntry entry : rootModel.getContentEntries()) {
            VirtualFile rootFile = entry.getFile();
            if (rootFile != null && !visitor2.visitRoot(rootFile, null, null, true)) {
                return false;
            }
            for (VirtualFile folder : entry.getSourceFolderFiles()) {
                if (visitor2.visitRoot(folder, rootModel.getModule(), null, true)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean visitOrderEntryRoots(RootVisitor visitor2, OrderEntry entry) {
        LinkedHashSet allRoots = new LinkedHashSet();
        Collections.addAll(allRoots, entry.getFiles(OrderRootType.SOURCES));
        Collections.addAll(allRoots, entry.getFiles(OrderRootType.CLASSES));
        Module module = entry instanceof ModuleOrderEntry ? ((ModuleOrderEntry)entry).getModule() : null;
        Sdk sdk2 = entry instanceof JdkOrderEntry ? ((JdkOrderEntry)entry).getJdk() : null;
        for (VirtualFile root : allRoots) {
            if (visitor2.visitRoot(root, module, sdk2, false)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/resolve/RootVisitorHost";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRoots";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRootsInAllModules";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSdkRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

