/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.toml;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.apache.tuweni.toml.AccumulatingErrorListener;
import org.apache.tuweni.toml.KeyVisitor;
import org.apache.tuweni.toml.LineVisitor;
import org.apache.tuweni.toml.TomlParseError;
import org.apache.tuweni.toml.TomlParseResult;
import org.apache.tuweni.toml.TomlPosition;
import org.apache.tuweni.toml.TomlTable;
import org.apache.tuweni.toml.TomlVersion;
import org.apache.tuweni.toml.internal.TomlLexer;
import org.apache.tuweni.toml.internal.TomlParser;

final class Parser {
    private Parser() {
    }

    static TomlParseResult parse(CharStream stream, TomlVersion version2) {
        TomlLexer lexer = new TomlLexer(stream);
        TomlParser parser = new TomlParser(new CommonTokenStream(lexer));
        parser.removeErrorListeners();
        final AccumulatingErrorListener errorListener = new AccumulatingErrorListener();
        parser.addErrorListener(errorListener);
        TomlParser.TomlContext tree = parser.toml();
        final TomlTable table = tree.accept(new LineVisitor(errorListener, version2));
        return new TomlParseResult(){

            @Override
            public int size() {
                return table.size();
            }

            @Override
            public boolean isEmpty() {
                return table.isEmpty();
            }

            @Override
            public Set<String> keySet() {
                return table.keySet();
            }

            @Override
            public Set<List<String>> keyPathSet(boolean includeTables) {
                return table.keyPathSet(includeTables);
            }

            @Override
            @Nullable
            public Object get(List<String> path2) {
                return table.get(path2);
            }

            @Override
            @Nullable
            public TomlPosition inputPositionOf(List<String> path2) {
                return table.inputPositionOf(path2);
            }

            @Override
            public Map<String, Object> toMap() {
                return table.toMap();
            }

            @Override
            public List<TomlParseError> errors() {
                return errorListener.errors();
            }
        };
    }

    static List<String> parseDottedKey(String dottedKey) {
        TomlLexer lexer = new TomlLexer(CharStreams.fromString(dottedKey));
        lexer.mode(1);
        TomlParser parser = new TomlParser(new CommonTokenStream(lexer));
        parser.removeErrorListeners();
        AccumulatingErrorListener errorListener = new AccumulatingErrorListener();
        parser.addErrorListener(errorListener);
        List<String> keyList = parser.tomlKey().accept(new KeyVisitor());
        List<TomlParseError> errors2 = errorListener.errors();
        if (!errors2.isEmpty()) {
            TomlParseError e = errors2.get(0);
            throw new IllegalArgumentException("Invalid key: " + e.getMessage(), e);
        }
        return keyList;
    }
}

