/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.frontend.split;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.station.comms.common.api.StationServicesClient;
import com.intellij.station.core.services.IdeStationServerService;
import com.intellij.station.core.services.IdeStationServicesClient;
import com.intellij.station.frontend.split.ToolboxConnectionFlowKt;
import com.intellij.station.frontend.split.ToolboxConnectionHolder;
import com.intellij.station.frontend.split.ToolboxLink;
import com.intellij.station.frontend.split.ToolboxLinkHandler;
import com.intellij.util.UriUtilKt;
import com.intellij.util.text.StringKt;
import com.jetbrains.thinclient.PlatformFrontendSplitBundle;
import com.jetbrains.thinclient.link.ConnectionFlowArguments;
import com.jetbrains.thinclient.link.LinkConnectionFlow;
import com.jetbrains.thinclient.link.LinkConnectionUtil;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/station/frontend/split/ToolboxConnectionFlow;", "Lcom/jetbrains/thinclient/link/LinkConnectionFlow;", "args", "Lcom/jetbrains/thinclient/link/ConnectionFlowArguments;", "<init>", "(Lcom/jetbrains/thinclient/link/ConnectionFlowArguments;)V", "name", "", "getName", "()Ljava/lang/String;", "connect", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.station.frontend.split"})
@SourceDebugExtension(value={"SMAP\nToolboxConnectionFlow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolboxConnectionFlow.kt\ncom/intellij/station/frontend/split/ToolboxConnectionFlow\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,73:1\n40#2,3:74\n15#3:77\n*S KotlinDebug\n*F\n+ 1 ToolboxConnectionFlow.kt\ncom/intellij/station/frontend/split/ToolboxConnectionFlow\n*L\n61#1:74,3\n30#1:77\n*E\n"})
public final class ToolboxConnectionFlow
implements LinkConnectionFlow {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectionFlowArguments args;
    @NotNull
    private final String name;
    @NotNull
    private static final Logger logger;

    public ToolboxConnectionFlow(@NotNull ConnectionFlowArguments args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.args = args;
        this.name = "Toolbox";
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Object connect(@NotNull Continuation<? super Unit> $completion) {
        URI url = this.args.getUrl();
        if (!ToolboxConnectionFlowKt.access$isToolboxLink(url)) {
            logger.warn("Toolbox connection requested with unsupported link " + url);
            Object object = LinkConnectionUtil.INSTANCE.reportUnexpectedError(PlatformFrontendSplitBundle.INSTANCE.message("connection.status.unsupported.scheme", new Object[0]), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        List list = StringUtil.split((String)url.getPath(), (String)"/");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"split(...)");
        List parts = list;
        String pluginId = StringKt.nullize$default((String)url.getHost(), (boolean)false, (int)1, null);
        String environmentId = (String)CollectionsKt.getOrNull((List)parts, (int)0);
        String targetIde = (String)CollectionsKt.getOrNull((List)parts, (int)1);
        String productCode = (String)UriUtilKt.getFragmentParameters((URI)url).get("p");
        if (pluginId == null || environmentId == null || targetIde == null) {
            logger.warn("Toolbox connection link is invalid " + url);
            Object object = LinkConnectionUtil.INSTANCE.reportUnexpectedError(PlatformFrontendSplitBundle.INSTANCE.message("connection.status.unsupported.scheme", new Object[0]), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        IdeStationServerService.Companion.getInstance();
        StationServicesClient servicesClient = (StationServicesClient)IdeStationServicesClient.Companion.getInstance();
        ToolboxLink link = new ToolboxLink(pluginId, environmentId, targetIde, productCode);
        ToolboxLinkHandler handler = ToolboxLinkHandler.Companion.create(servicesClient, link, this.args.getUserName());
        boolean $i$f$service = false;
        Class<ToolboxConnectionHolder> serviceClass$iv = ToolboxConnectionHolder.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((ToolboxConnectionHolder)object).setLinkHandler(handler);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ToolboxConnectionFlow.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ToolboxConnectionFlow.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/station/frontend/split/ToolboxConnectionFlow$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.station.frontend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

