/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections.quickfixes;

import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.javascript.web.js.WebJSResolveUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.angular2.entities.Angular2Directive;
import org.angular2.entities.Angular2DirectiveProperty;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.entities.source.Angular2SourceDirectiveProperty;
import org.angular2.inspections.quickfixes.Angular2FixesPsiUtil;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001eB'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u0006H\u0016J2\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J3\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0096\u0002J\"\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/angular2/inspections/quickfixes/AddInputTransformFunctionQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "Lcom/intellij/codeInsight/intention/PriorityAction;", "kind", "Lorg/angular2/inspections/quickfixes/AddInputTransformFunctionQuickFix$TransformKind;", "inputName", "", "expressionType", "clazz", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptClass;", "<init>", "(Lorg/angular2/inspections/quickfixes/AddInputTransformFunctionQuickFix$TransformKind;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptClass;)V", "getFamilyName", "getText", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "invoke", "", "invokeInner", "getPriority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "TransformKind", "intellij.angular"})
@SourceDebugExtension(value={"SMAP\nAddInputTransformFunctionQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddInputTransformFunctionQuickFix.kt\norg/angular2/inspections/quickfixes/AddInputTransformFunctionQuickFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,110:1\n1#2:111\n19#3:112\n*S KotlinDebug\n*F\n+ 1 AddInputTransformFunctionQuickFix.kt\norg/angular2/inspections/quickfixes/AddInputTransformFunctionQuickFix\n*L\n75#1:112\n*E\n"})
public final class AddInputTransformFunctionQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements PriorityAction {
    @NotNull
    private final TransformKind kind;
    @NotNull
    private final String inputName;
    @NotNull
    private final String expressionType;

    public AddInputTransformFunctionQuickFix(@NotNull TransformKind kind, @NotNull String inputName, @NotNull String expressionType, @NotNull TypeScriptClass clazz) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)inputName, (String)"inputName");
        Intrinsics.checkNotNullParameter((Object)expressionType, (String)"expressionType");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        super((PsiElement)clazz);
        this.kind = kind;
        this.inputName = inputName;
        this.expressionType = expressionType;
    }

    @NotNull
    public String getFamilyName() {
        return Angular2Bundle.Companion.message("angular.quickfix.template.create-input-transformer.family", new Object[0]);
    }

    @NotNull
    public String getText() {
        String string;
        if (this.kind == TransformKind.Custom) {
            string = this.getFamilyName();
        } else {
            Object[] objectArray = new Object[]{StringUtil.decapitalize((String)this.kind.name())};
            string = Angular2Bundle.Companion.message("angular.quickfix.template.create-input-transformer.std.name", objectArray);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        return !JSProjectUtil.isInLibrary((PsiElement)startElement);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)startElement, () -> AddInputTransformFunctionQuickFix.invoke$lambda$0(this, project, editor, startElement));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void invokeInner(Project project, Editor editor, PsiElement startElement) {
        PsiElement psiElement;
        Angular2SourceDirectiveProperty angular2SourceDirectiveProperty;
        Angular2DirectiveProperty property;
        Angular2Directive angular2Directive = Angular2EntitiesProvider.getDirective((PsiElement)(startElement instanceof TypeScriptClass ? (TypeScriptClass)startElement : null));
        if (angular2Directive == null) return;
        Collection<Angular2DirectiveProperty> collection = angular2Directive.getInputs();
        if (collection == null) return;
        OpenFileDescriptor openFileDescriptor = ((Iterable)collection).iterator();
        do {
            Angular2SourceDirectiveProperty angular2SourceDirectiveProperty2;
            if (!openFileDescriptor.hasNext()) return;
            property = (Angular2DirectiveProperty)openFileDescriptor.next();
            boolean bl = false;
            Angular2SourceDirectiveProperty angular2SourceDirectiveProperty3 = angular2SourceDirectiveProperty2 = property instanceof Angular2SourceDirectiveProperty ? (Angular2SourceDirectiveProperty)property : null;
            if (angular2SourceDirectiveProperty2 != null) {
                Angular2SourceDirectiveProperty angular2SourceDirectiveProperty4;
                Angular2SourceDirectiveProperty it = angular2SourceDirectiveProperty4 = angular2SourceDirectiveProperty2;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)it.getName(), (Object)this.inputName) && !it.getVirtualProperty() && it.getTransformParameterType() == null) {
                    angular2SourceDirectiveProperty = angular2SourceDirectiveProperty4;
                    continue;
                }
                angular2SourceDirectiveProperty = null;
                continue;
            }
            angular2SourceDirectiveProperty = null;
        } while ((property = angular2SourceDirectiveProperty) == null);
        Angular2DirectiveProperty angular2DirectiveProperty = property;
        Angular2SourceDirectiveProperty angular2SourceDirectiveProperty5 = angular2DirectiveProperty;
        if (angular2SourceDirectiveProperty5 == null) return;
        Angular2SourceDirectiveProperty input = angular2SourceDirectiveProperty5;
        PsiElement psiElement2 = input.getDeclarationSource();
        if (psiElement2 != null) {
            PsiFile psiFile = startElement.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            psiElement = Angular2FixesPsiUtil.INSTANCE.remapToCopyIfNeeded(psiElement2, psiFile);
        } else {
            psiElement = null;
        }
        JSObjectLiteralExpression jSObjectLiteralExpression = Angular2FixesPsiUtil.INSTANCE.getOrCreateInputObjectLiteral(psiElement);
        if (jSObjectLiteralExpression == null) {
            return;
        }
        JSObjectLiteralExpression objectLiteral = jSObjectLiteralExpression;
        if (this.kind == TransformKind.Custom) {
            TextEditor textEditor;
            void $this$asSafely$iv;
            JSType jSType;
            angular2SourceDirectiveProperty5 = input.getRawJsType();
            String inputType = angular2SourceDirectiveProperty5 != null && (jSType = angular2SourceDirectiveProperty5.substitute(startElement)) != null ? jSType.getTypeText(JSType.TypeTextFormat.CODE) : null;
            JSProperty property2 = Angular2FixesPsiUtil.insertJSObjectLiteralProperty$default(Angular2FixesPsiUtil.INSTANCE, objectLiteral, "transform", "(value: " + this.expressionType + "): " + inputType + " => ", false, false, 8, null);
            if (IntentionPreviewUtils.isIntentionPreviewActive()) {
                return;
            }
            OpenFileDescriptor it = openFileDescriptor = new OpenFileDescriptor(project, property2.getContainingFile().getVirtualFile(), property2.getTextRange().getEndOffset());
            boolean $i$a$-takeIf-AddInputTransformFunctionQuickFix$invokeInner$22 = false;
            Object object = jSType = it.canNavigateToSource() ? openFileDescriptor : null;
            if (jSType != null) {
                jSType.navigate(true);
            }
            if ((openFileDescriptor = FileEditorManager.getInstance((Project)project).getSelectedEditor(property2.getContainingFile().getVirtualFile())) == null) return;
            OpenFileDescriptor $i$a$-takeIf-AddInputTransformFunctionQuickFix$invokeInner$22 = openFileDescriptor;
            boolean $i$f$asSafely = false;
            Object v8 = $this$asSafely$iv;
            if (!(v8 instanceof TextEditor)) {
                v8 = null;
            }
            if ((textEditor = (TextEditor)v8) == null) return;
            Editor editor2 = textEditor.getEditor();
            Editor componentEditor = editor2;
            if (componentEditor == null) return;
            JSExpression jSExpression = property2.getValue();
            if (jSExpression != null) {
                jSExpression.delete();
            }
            Template template = TemplateManager.getInstance((Project)project).createTemplate("ng_insert_input_transform", "angular", "(value: $TYPE0$): $TYPE1$ => $END$");
            template.addVariable("TYPE0", (Expression)new TextExpression(this.expressionType), (Expression)new TextExpression(this.expressionType), true, true);
            template.addVariable("TYPE1", (Expression)new TextExpression(inputType), (Expression)new TextExpression(inputType), true, true);
            template.addVariable("END", (Expression)new EmptyExpression(), true);
            template.setToReformat(true);
            TemplateManager.getInstance((Project)project).startTemplate(componentEditor, template);
            return;
        } else {
            String string = StringUtil.decapitalize((String)this.kind.name());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decapitalize(...)");
            String functionName = string;
            PsiElement function = WebJSResolveUtil.INSTANCE.resolveSymbolFromNodeModule(startElement, "@angular/core", functionName, PsiElement.class);
            if (function == null) return;
            Angular2FixesPsiUtil.insertJSObjectLiteralProperty$default(Angular2FixesPsiUtil.INSTANCE, objectLiteral, "transform", functionName, false, false, 8, null);
            ES6ImportPsiUtil.insertJSImport((PsiElement)startElement, (String)functionName, (PsiElement)function, (Editor)editor);
        }
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return this.kind == TransformKind.Custom ? PriorityAction.Priority.NORMAL : PriorityAction.Priority.HIGH;
    }

    private static final Unit invoke$lambda$0(AddInputTransformFunctionQuickFix this$0, Project $project, Editor $editor, PsiElement $startElement) {
        this$0.invokeInner($project, $editor, $startElement);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/angular2/inspections/quickfixes/AddInputTransformFunctionQuickFix$TransformKind;", "", "<init>", "(Ljava/lang/String;I)V", "BooleanAttribute", "NumberAttribute", "Custom", "intellij.angular"})
    public static final class TransformKind
    extends Enum<TransformKind> {
        public static final /* enum */ TransformKind BooleanAttribute = new TransformKind();
        public static final /* enum */ TransformKind NumberAttribute = new TransformKind();
        public static final /* enum */ TransformKind Custom = new TransformKind();
        private static final /* synthetic */ TransformKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TransformKind[] values() {
            return (TransformKind[])$VALUES.clone();
        }

        public static TransformKind valueOf(String value) {
            return Enum.valueOf(TransformKind.class, value);
        }

        @NotNull
        public static EnumEntries<TransformKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = transformKindArray = new TransformKind[]{TransformKind.BooleanAttribute, TransformKind.NumberAttribute, TransformKind.Custom};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

