/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.requests;

import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.CoroutineHelpersKt;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.remoteDev.tracing.RequestTelemetryData;
import com.intellij.remoteDev.tracing.TelemetryDataUtilKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.document.DocumentSynchronizerListener;
import com.jetbrains.rd.ide.document.DocumentSynchronizerListeners;
import com.jetbrains.rd.ide.editor.CaretRestoreHelper;
import com.jetbrains.rd.ide.model.DocumentsOperationModel;
import com.jetbrains.rd.ide.model.DocumentsOperationModel_GeneratedKt;
import com.jetbrains.rd.ide.model.RdFailureResponse;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdRequestHolder;
import com.jetbrains.rd.ide.model.RdRequests;
import com.jetbrains.rd.ide.model.RdResponse;
import com.jetbrains.rd.ide.model.RdResponses;
import com.jetbrains.rd.ide.model.RdRetryResponse;
import com.jetbrains.rd.ide.model.RdSuccessResponse;
import com.jetbrains.rd.ide.model.RdTelemetryDataHolder;
import com.jetbrains.rd.ide.model.RequestResponseModel;
import com.jetbrains.rd.ide.model.RequestResponseModel_GeneratedKt;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.requests.RdPatchUtilsKt;
import com.jetbrains.rd.ide.requests.SpeculativelyEqualsResult;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.AppExtListener;
import com.jetbrains.rd.tracing.OpenTelemetryKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.FrontendBundle;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.FrontendDocumentHost;
import com.jetbrains.rdclient.editorActions.cwm.FrontendEditorActionRequest;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchItemHandlerKt;
import com.jetbrains.rdclient.patches.FrontendPatchEngineKt;
import com.jetbrains.rdclient.patches.FrontendRdPatchHandlerRegistry;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutor;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutorBehaviour;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutorKt;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestListener;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResult;
import com.jetbrains.rdclient.requests.FrontendRebaseSession;
import com.jetbrains.rdclient.requests.PatchItemOperationType;
import com.jetbrains.rdclient.requests.RequestStatus;
import com.jetbrains.rdclient.requests.recovering.RecoveringStrategyProvider;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelicateCoroutinesApi;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.YieldKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 x2\u00020\u0001:\u0004xyz{B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0007J,\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u001a\u0010.\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010)\u0012\u0004\u0012\u00020\u00160(H\u0007J7\u0010/\u001a\u00020+2'\u00100\u001a#\b\u0001\u0012\u0004\u0012\u000201\u0012\n\u0012\b\u0012\u0004\u0012\u00020+02\u0012\u0006\u0012\u0004\u0018\u0001030(\u00a2\u0006\u0002\b4H\u0087@\u00a2\u0006\u0002\u00105J\u0018\u00106\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u00107\u001a\u000208H\u0002J\b\u0010=\u001a\u00020\u0016H\u0007J\u0006\u0010>\u001a\u00020\u0016J\b\u0010?\u001a\u00020+H\u0007J\u000e\u0010E\u001a\u00020+H\u0086@\u00a2\u0006\u0002\u0010FJ\u0016\u0010G\u001a\u00020+2\u0006\u0010H\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u0010IJ\u000e\u0010J\u001a\u00020+2\u0006\u0010H\u001a\u00020\u0010J\u0016\u0010K\u001a\u00020+2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002J\u0016\u0010M\u001a\u00020+2\u0006\u0010N\u001a\u00020OH\u0082@\u00a2\u0006\u0002\u0010PJ&\u0010Q\u001a\u00020+2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020S0\u00122\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u000bH\u0002J\u0010\u0010W\u001a\u00020+2\u0006\u0010H\u001a\u00020\u0010H\u0002J\u0018\u0010X\u001a\u00020+2\u0006\u0010H\u001a\u00020\u00102\u0006\u0010Y\u001a\u00020SH\u0002J\u0016\u0010Z\u001a\u00020+2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020S0\u0012H\u0002J\u0010\u0010[\u001a\u00020+2\u0006\u0010\\\u001a\u00020]H\u0002J0\u0010^\u001a\u00020_2\u0006\u0010H\u001a\u00020\u00102\u0006\u0010Y\u001a\u00020`2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u000b2\u0006\u0010a\u001a\u00020\u0016H\u0002J,\u0010b\u001a\u00020c2\b\u0010d\u001a\u0004\u0018\u00010)2\b\u0010e\u001a\u0004\u0018\u00010)2\u0006\u0010H\u001a\u00020f2\u0006\u0010a\u001a\u00020\u0016H\u0002J(\u0010g\u001a\u00020+2\u0006\u0010Y\u001a\u00020h2\u0006\u0010H\u001a\u00020\u00102\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020\u000bH\u0002J\u0018\u0010i\u001a\u00020+2\u0006\u0010H\u001a\u00020\u00102\u0006\u0010Y\u001a\u00020jH\u0002J\b\u0010k\u001a\u00020+H\u0002J\u0016\u0010l\u001a\u00020+2\u0006\u0010m\u001a\u00020)H\u0082@\u00a2\u0006\u0002\u0010nJ\u001c\u0010o\u001a\u00020+2\f\u00100\u001a\b\u0012\u0004\u0012\u00020+0pH\u0082@\u00a2\u0006\u0002\u0010qJ\u0010\u0010r\u001a\u00020+2\u0006\u0010m\u001a\u00020)H\u0002J\u0018\u0010s\u001a\u00020_2\u0006\u0010m\u001a\u00020)2\u0006\u0010T\u001a\u00020UH\u0002J\u0018\u0010t\u001a\u00020\u00162\u0006\u0010H\u001a\u00020\u00102\u0006\u0010T\u001a\u00020UH\u0002J\u0010\u0010u\u001a\u00020_2\u0006\u0010T\u001a\u00020UH\u0002J\u001a\u0010v\u001a\u00020+2\u0006\u0010m\u001a\u00020)2\n\b\u0002\u0010H\u001a\u0004\u0018\u00010\u0010J\u000e\u0010w\u001a\u00020+H\u0082@\u00a2\u0006\u0002\u0010FR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010!\u001a\u0004\u0018\u00010\"8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R&\u0010'\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010)\u0012\u0004\u0012\u00020\u00160(8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010:\u001a\u0002088BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0014\u0010@\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u0019R\u001a\u0010B\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u0019\"\u0004\bD\u0010\u001b\u00a8\u0006|"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "_lastQueuedRequest", "Ljava/util/concurrent/atomic/AtomicLong;", "lastQueuedRequest", "", "getLastQueuedRequest", "()J", "requestsQueue", "Ljava/util/ArrayDeque;", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "requestQueueItems", "", "executionMutex", "Lkotlinx/coroutines/sync/Mutex;", "nestedExecutionGuard", "", "recoveringInProgress", "getRecoveringInProgress$intellij_rd_client", "()Z", "setRecoveringInProgress$intellij_rd_client", "(Z)V", "triggerRecoveryEditorStates", "getTriggerRecoveryEditorStates$intellij_rd_client", "setTriggerRecoveryEditorStates$intellij_rd_client", "patchHandlerRegistry", "Lcom/jetbrains/rdclient/patches/FrontendRdPatchHandlerRegistry;", "rebaseListener", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$RebaseListener;", "getRebaseListener", "()Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$RebaseListener;", "setRebaseListener", "(Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$RebaseListener;)V", "forceRebase", "Lkotlin/Function2;", "Lcom/jetbrains/rd/ide/model/RdPatch;", "withForceRebase", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "check", "synchronizeWithPatchEngine", "action", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "bindWithModel", "model", "Lcom/jetbrains/rd/ide/model/RequestResponseModel;", "isInitialized", "protocolModel", "getProtocolModel", "()Lcom/jetbrains/rd/ide/model/RequestResponseModel;", "isRequestQueueEmpty", "thereArePendingRequests", "ensureRequestQueueEmpty", "executionInProgress", "getExecutionInProgress", "speculativeExecutionEnabled", "getSpeculativeExecutionEnabled", "setSpeculativeExecutionEnabled", "awaitSpeculativeRequests", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "executeRequest", "request", "(Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "submitRequest", "doExecute", "requests", "requestsCompleted", "respList", "Lcom/jetbrains/rd/ide/model/RdResponses;", "(Lcom/jetbrains/rd/ide/model/RdResponses;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doRequestsCompleted", "responses", "Lcom/jetbrains/rd/ide/model/RdResponse;", "rebaseSession", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "delta", "fireRequestSent", "fireRequestCompleted", "response", "fireResponsesExecuted", "fireProblemOccurred", "throwable", "", "handleBackendResult", "", "Lcom/jetbrains/rd/ide/model/RdSuccessResponse;", "isBatchMode", "speculativelyEquals", "Lcom/jetbrains/rd/ide/requests/SpeculativelyEqualsResult;", "speculatedPatch", "backendPatch", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestWithImmediateResult;", "handleFailure", "Lcom/jetbrains/rd/ide/model/RdFailureResponse;", "handleRetry", "Lcom/jetbrains/rd/ide/model/RdRetryResponse;", "executeNextRequest", "backendChanged", "patch", "(Lcom/jetbrains/rd/ide/model/RdPatch;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runGuardedWithRecovery", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doBackendChanged", "rollbackConflictingRequests", "rollForwardRequest", "rollForwardRevertedRequests", "applyBackendPatch", "recoverState", "Companion", "MyModelListener", "RetryCustomizer", "RebaseListener", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendAsyncRequestExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendAsyncRequestExecutor.kt\ncom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 TelemetryDataUtil.kt\ncom/intellij/remoteDev/tracing/TelemetryDataUtilKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 8 FrontendRebaseSession.kt\ncom/jetbrains/rdclient/requests/FrontendRebaseSession$Companion\n*L\n1#1,712:1\n116#2,10:713\n69#3,4:723\n69#3,4:727\n69#3,4:731\n69#3,4:735\n69#3,4:739\n69#3,4:743\n69#3,4:748\n69#3,4:752\n69#3,4:756\n69#3,4:760\n69#3,4:764\n69#3,4:768\n69#3,4:782\n69#3,4:786\n69#3,4:800\n69#3,4:822\n69#3,4:828\n69#3,4:832\n69#3,4:840\n69#3,4:847\n69#3,4:851\n69#3,4:859\n69#3,4:866\n69#3,4:870\n69#3,4:874\n69#3,4:878\n69#3,4:882\n69#3,4:886\n69#3,4:890\n69#3,4:894\n69#3,4:898\n69#3,4:904\n1#4:747\n31#5,7:772\n15#5,2:779\n38#5:781\n19#5,4:804\n31#5,7:808\n15#5,2:815\n38#5:817\n19#5,4:818\n756#6,10:790\n1863#6,2:902\n31#7,2:826\n22#8,4:836\n28#8,3:844\n22#8,4:855\n28#8,3:863\n22#8,9:908\n*S KotlinDebug\n*F\n+ 1 FrontendAsyncRequestExecutor.kt\ncom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor\n*L\n122#1:713,10\n147#1:723,4\n194#1:727,4\n200#1:731,4\n202#1:735,4\n205#1:739,4\n231#1:743,4\n263#1:748,4\n301#1:752,4\n311#1:756,4\n314#1:760,4\n351#1:764,4\n356#1:768,4\n393#1:782,4\n399#1:786,4\n415#1:800,4\n466#1:822,4\n475#1:828,4\n479#1:832,4\n491#1:840,4\n564#1:847,4\n568#1:851,4\n576#1:859,4\n588#1:866,4\n595#1:870,4\n599#1:874,4\n603#1:878,4\n607#1:882,4\n613#1:886,4\n623#1:890,4\n627#1:894,4\n674#1:898,4\n277#1:904,4\n388#1:772,7\n388#1:779,2\n388#1:781\n388#1:804,4\n455#1:808,7\n455#1:815,2\n455#1:817\n455#1:818,4\n400#1:790,10\n685#1:902,2\n471#1:826,2\n486#1:836,4\n486#1:844,3\n571#1:855,4\n571#1:863,3\n293#1:908,9\n*E\n"})
public final class FrontendAsyncRequestExecutor
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final AtomicLong _lastQueuedRequest;
    @NotNull
    private final ArrayDeque<FrontendAsyncRequest> requestsQueue;
    @NotNull
    private final Mutex executionMutex;
    private volatile boolean nestedExecutionGuard;
    private boolean recoveringInProgress;
    private boolean triggerRecoveryEditorStates;
    @NotNull
    private final FrontendRdPatchHandlerRegistry patchHandlerRegistry;
    @TestOnly
    @Nullable
    private RebaseListener rebaseListener;
    @TestOnly
    @NotNull
    private Function2<? super FrontendAsyncRequest, ? super RdPatch, Boolean> forceRebase;
    private boolean isInitialized;
    private boolean speculativeExecutionEnabled;

    public FrontendAsyncRequestExecutor(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this._lastQueuedRequest = new AtomicLong(-1L);
        this.requestsQueue = new ArrayDeque();
        this.executionMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.patchHandlerRegistry = FrontendRdPatchHandlerRegistry.Companion.getInstance();
        this.forceRebase = FrontendAsyncRequestExecutor::forceRebase$lambda$0;
        this.speculativeExecutionEnabled = true;
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    public final long getLastQueuedRequest() {
        return this._lastQueuedRequest.get();
    }

    @RequiresEdt
    @NotNull
    public final List<FrontendAsyncRequest> requestQueueItems() {
        return CollectionsKt.toList((Iterable)this.requestsQueue);
    }

    public final boolean getRecoveringInProgress$intellij_rd_client() {
        return this.recoveringInProgress;
    }

    public final void setRecoveringInProgress$intellij_rd_client(boolean bl) {
        this.recoveringInProgress = bl;
    }

    public final boolean getTriggerRecoveryEditorStates$intellij_rd_client() {
        return this.triggerRecoveryEditorStates;
    }

    public final void setTriggerRecoveryEditorStates$intellij_rd_client(boolean bl) {
        this.triggerRecoveryEditorStates = bl;
    }

    @Nullable
    public final RebaseListener getRebaseListener() {
        return this.rebaseListener;
    }

    public final void setRebaseListener(@Nullable RebaseListener rebaseListener) {
        this.rebaseListener = rebaseListener;
    }

    @TestOnly
    public final void withForceRebase(@NotNull Lifetime lifetime, @NotNull Function2<? super FrontendAsyncRequest, ? super RdPatch, Boolean> check) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(check, (String)"check");
        Function2<? super FrontendAsyncRequest, ? super RdPatch, Boolean> old = this.forceRebase;
        lifetime.bracketOrThrow(() -> FrontendAsyncRequestExecutor.withForceRebase$lambda$1(this, check), () -> FrontendAsyncRequestExecutor.withForceRebase$lambda$3(this, check, old));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @ApiStatus.Internal
    @DelicateCoroutinesApi
    @Nullable
    public final Object synchronizeWithPatchEngine(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof synchronizeWithPatchEngine.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ FrontendAsyncRequestExecutor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.synchronizeWithPatchEngine(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.executionMutex;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = action;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl31
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                action = (Function2)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 3 sources

                $i$a$-withLock$default-FrontendAsyncRequestExecutor$synchronizeWithPatchEngine$2 = false;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v1 = CoroutineScopeKt.coroutineScope((Function2)action, (Continuation)$continuation);
                ** if (v1 != var10_5) goto lbl39
lbl38:
                // 1 sources

                return var10_5;
lbl39:
                // 1 sources

                ** GOTO lbl49
            }
            case 2: {
                $i$f$withLock = false;
                $i$a$-withLock$default-FrontendAsyncRequestExecutor$synchronizeWithPatchEngine$2 = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl49:
                    // 2 sources

                    var7_14 = Unit.INSTANCE;
                }
                catch (Throwable var6_13) {
                    throw var6_13;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void bindWithModel(Lifetime lifetime, RequestResponseModel model) {
        Logger $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("[service] FrontendAsyncRequestExecutor$init called");
        }
        FrontendDocumentHost.Companion.getInstance(this.session).ensureProtocolSubscriptionsReady();
        CoroutineHelpersKt.adviseSuspendPreserveClientId$default((ISource)((ISource)model.getResponsesWithTime()), (Lifetime)lifetime, null, null, (Function2)((Function2)new Function2<RdResponses, Continuation<? super Unit>, Object>((Object)this){

            public final Object invoke(RdResponses p0, Continuation<? super Unit> $completion) {
                return FrontendAsyncRequestExecutor.access$requestsCompleted((FrontendAsyncRequestExecutor)((Object)this.receiver), p0, $completion);
            }
        }), (int)6, null);
        CoroutineHelpersKt.adviseSuspendPreserveClientId$default((ISource)((ISource)model.getBackendPatches()), (Lifetime)lifetime, null, null, (Function2)((Function2)new Function2<RdPatch, Continuation<? super Unit>, Object>((Object)this){

            public final Object invoke(RdPatch p0, Continuation<? super Unit> $completion) {
                return FrontendAsyncRequestExecutor.access$backendChanged((FrontendAsyncRequestExecutor)((Object)this.receiver), p0, $completion);
            }
        }), (int)6, null);
        model.getBackendBound().advise(lifetime, arg_0 -> FrontendAsyncRequestExecutor.bindWithModel$lambda$6(this, arg_0));
    }

    private final RequestResponseModel getProtocolModel() {
        return RequestResponseModel_GeneratedKt.getRequestResponseModel((DocumentsOperationModel)DocumentsOperationModel_GeneratedKt.getDocumentsOperationModel((IProtocol)FrontendSessionsUtilKt.getProtocol(this.session)));
    }

    @TestOnly
    public final boolean isRequestQueueEmpty() {
        return this.requestsQueue.isEmpty();
    }

    public final boolean thereArePendingRequests() {
        int size = this.requestsQueue.size();
        FrontendAsyncRequest head = this.requestsQueue.peek();
        return size > 1 || head != null && !head.getStatus().isExecuting();
    }

    @TestOnly
    public final void ensureRequestQueueEmpty() {
        boolean bl = this.isRequestQueueEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Pending Requests in the queue: " + this.requestsQueue.size() + ".\n" + CollectionsKt.joinToString$default((Iterable)this.requestsQueue, (CharSequence)"\n", null, null, (int)0, null, FrontendAsyncRequestExecutor::ensureRequestQueueEmpty$lambda$8$lambda$7, (int)30, null);
            throw new AssertionError((Object)string);
        }
    }

    private final boolean getExecutionInProgress() {
        FrontendAsyncRequest frontendAsyncRequest = this.requestsQueue.peek();
        if (frontendAsyncRequest == null) {
            return false;
        }
        FrontendAsyncRequest request = frontendAsyncRequest;
        return request.getStatus().isExecuting();
    }

    public final boolean getSpeculativeExecutionEnabled() {
        return this.speculativeExecutionEnabled;
    }

    public final void setSpeculativeExecutionEnabled(boolean bl) {
        this.speculativeExecutionEnabled = bl;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object awaitSpeculativeRequests(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof awaitSpeculativeRequests.1)) ** GOTO lbl-1000
        var11_2 = $completion;
        if ((var11_2.label & -2147483648) != 0) {
            var11_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ FrontendAsyncRequestExecutor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.awaitSpeculativeRequests((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var9_8 = $this$trace$iv;
                    $i$a$-trace-FrontendAsyncRequestExecutor$awaitSpeculativeRequests$2 = false;
                    var9_8.trace("Start awaiting completion of speculative requests...");
                }
                requestsQueueCopy = CollectionsKt.toList((Iterable)this.requestsQueue);
                var3_7 = requestsQueueCopy.iterator();
lbl21:
                // 6 sources

                while (var3_7.hasNext()) {
                    request = (FrontendAsyncRequest)var3_7.next();
                    if (!(request instanceof FrontendAsyncRequestWithImmediateResult) || ((FrontendAsyncRequestWithImmediateResult)request).getPatch() == null || !((FrontendAsyncRequestWithImmediateResult)request).getStatus().isExecuting() && !((FrontendAsyncRequestWithImmediateResult)request).getStatus().isPending()) continue;
                    $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var9_8 = $this$trace$iv;
                        $i$a$-trace-FrontendAsyncRequestExecutor$awaitSpeculativeRequests$3 = false;
                        var9_8.trace("Awaiting " + request + "...");
                    }
                    $continuation.L$0 = var3_7;
                    $continuation.L$1 = request;
                    $continuation.label = 1;
                    v0 = ((FrontendAsyncRequestWithImmediateResult)request).await((Continuation<? super Unit>)$continuation);
                    ** if (v0 != var12_4) goto lbl39
lbl38:
                    // 1 sources

                    return var12_4;
lbl39:
                    // 1 sources

                    ** GOTO lbl48
                }
                break;
            }
            case 1: {
                request = (FrontendAsyncRequest)$continuation.L$1;
                var3_7 = (Iterator<E>)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl48:
                    // 2 sources

                    $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                    $i$f$trace = false;
                    if (!$this$trace$iv.isTraceEnabled()) ** GOTO lbl21
                    var9_8 = $this$trace$iv;
                    $i$a$-trace-FrontendAsyncRequestExecutor$awaitSpeculativeRequests$4 = false;
                    var9_8.trace("Request awaiting completed for " + request);
                }
                catch (CancellationException var5_12) {
                    $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                    $i$f$trace = false;
                    if (!$this$trace$iv.isTraceEnabled()) ** GOTO lbl21
                    var9_8 = $this$trace$iv;
                    $i$a$-trace-FrontendAsyncRequestExecutor$awaitSpeculativeRequests$5 = false;
                    var9_8.trace("Request " + request + " was cancelled");
                }
                ** GOTO lbl21
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object executeRequest(@NotNull FrontendAsyncRequest request, @NotNull Continuation<? super Unit> $completion) {
        this.submitRequest(request);
        Object object = request.await($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void submitRequest(@NotNull FrontendAsyncRequest request) {
        FrontendAsyncRequest merged;
        FrontendAsyncRequest last;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (FrontendPatchEngineKt.getEngine(this.session).getHasActivePatch()) {
            FrontendAsyncRequestExecutorKt.access$getLogger$p().error(request + " was triggered during another patch recording");
        }
        Logger $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Triggered " + request);
        }
        request.assertClientId();
        ThreadingAssertions.assertEventDispatchThread();
        if (!(!this.nestedExecutionGuard)) {
            boolean $i$a$-require-FrontendAsyncRequestExecutor$submitRequest$32 = false;
            String $i$a$-require-FrontendAsyncRequestExecutor$submitRequest$32 = request + " was triggered during another response";
            throw new IllegalArgumentException($i$a$-require-FrontendAsyncRequestExecutor$submitRequest$32.toString());
        }
        FrontendAsyncRequest requestToEnqueue = null;
        requestToEnqueue = request;
        while ((last = this.requestsQueue.peekLast()) != null && !Intrinsics.areEqual((Object)last, (Object)requestToEnqueue) && Intrinsics.areEqual((Object)last.getStatus(), (Object)RequestStatus.Companion.getPENDING()) && (merged = last.tryMergeWith(requestToEnqueue)) != null) {
            this.requestsQueue.removeLast();
            requestToEnqueue = merged;
            merged.alsoComplete$intellij_rd_client(last);
            merged.alsoComplete$intellij_rd_client(requestToEnqueue);
        }
        requestToEnqueue.setId$intellij_rd_client(this._lastQueuedRequest.incrementAndGet());
        this.requestsQueue.addLast(requestToEnqueue);
        this.fireRequestSent(requestToEnqueue);
        if (!this.getExecutionInProgress() && this.isInitialized) {
            this.doExecute((List)new SmartList((Object)requestToEnqueue));
        } else {
            Logger $this$trace$iv2 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            boolean $i$f$trace2 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                logger = $this$trace$iv2;
                boolean bl = false;
                logger.trace("Queue " + requestToEnqueue + " to execute");
            }
        }
    }

    private final void doExecute(List<? extends FrontendAsyncRequest> requests) {
        if (!(!this.getExecutionInProgress())) {
            boolean $i$a$-require-FrontendAsyncRequestExecutor$doExecute$22 = false;
            String $i$a$-require-FrontendAsyncRequestExecutor$doExecute$22 = "Can't execute next request before previous one is finished, previous: " + this.requestsQueue.peek();
            throw new IllegalArgumentException($i$a$-require-FrontendAsyncRequestExecutor$doExecute$22.toString());
        }
        if (requests.isEmpty()) {
            return;
        }
        ClientId clientId = ((FrontendAsyncRequest)CollectionsKt.first(requests)).getClientId();
        SmartList models = new SmartList();
        boolean isBatch = requests.size() > 1;
        ClientId.Companion.withExplicitClientId(clientId, () -> FrontendAsyncRequestExecutor.doExecute$lambda$19(requests, models, this, isBatch));
    }

    private final Object requestsCompleted(RdResponses respList, Continuation<? super Unit> $completion) {
        Object object = this.runGuardedWithRecovery((Function0<Unit>)((Function0)() -> FrontendAsyncRequestExecutor.requestsCompleted$lambda$21(this, respList)), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void doRequestsCompleted(List<? extends RdResponse> responses, FrontendRebaseSession rebaseSession, long delta) {
        boolean bl;
        Object object;
        ThreadingAssertions.assertEventDispatchThread();
        if (this.recoveringInProgress) {
            Logger $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl2 = false;
                logger.trace("Skipping backend responses during recovering, request ids: [" + CollectionsKt.joinToString$default((Iterable)responses, null, null, null, (int)0, null, FrontendAsyncRequestExecutor::doRequestsCompleted$lambda$23$lambda$22, (int)31, null) + "]");
            }
            return;
        }
        boolean isBatchMode = responses.size() > 1;
        Iterator<FrontendAsyncRequest> iterator2 = this.requestsQueue.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<FrontendAsyncRequest> reqIt = iterator2;
        long startTime = System.nanoTime();
        int undoneReqNum = 0;
        int redoneReqNum = 0;
        Object $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
        boolean bl3 = false;
        if ($this$trace$iv.isTraceEnabled()) {
            object = $this$trace$iv;
            bl = false;
            object.trace("Responses to process[" + responses.size() + "]: " + CollectionsKt.joinToString$default((Iterable)responses, (CharSequence)"\n", null, null, (int)0, null, FrontendAsyncRequestExecutor::doRequestsCompleted$lambda$25$lambda$24, (int)30, null));
        }
        for (RdResponse rdResponse : responses) {
            long requestId = rdResponse.getRequestId();
            Logger $this$trace$iv2 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            boolean $i$f$trace232 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                object = $this$trace$iv2;
                boolean bl4 = false;
                object.trace(">> response#" + requestId);
            }
            if (!reqIt.hasNext()) {
                throw new IllegalStateException("executing request is null".toString());
            }
            FrontendAsyncRequest request = reqIt.next();
            if (!(request.getId() == requestId)) {
                boolean $i$a$-require-FrontendAsyncRequestExecutor$doRequestsCompleted$632 = false;
                String $i$a$-require-FrontendAsyncRequestExecutor$doRequestsCompleted$632 = "Response is not corresponded to request: " + Reflection.getOrCreateKotlinClass(request.getClass()).getSimpleName() + ", expected id: " + request.getId() + ", actual id: " + requestId;
                throw new IllegalArgumentException($i$a$-require-FrontendAsyncRequestExecutor$doRequestsCompleted$632.toString());
            }
            ClientIdKt.assertClientIdConsistency$default((ClientId)request.getClientId(), (String)"doRequestsCompleted::request.clientId", (boolean)false, (int)2, null);
            if (undoneReqNum > 0 && Intrinsics.areEqual((Object)request.getStatus(), (Object)RequestStatus.Companion.getREVERTED_EXECUTING())) {
                Intrinsics.checkNotNull((Object)request);
                if (this.rollForwardRequest(request, rebaseSession)) {
                    ++redoneReqNum;
                }
            }
            if (!(Intrinsics.areEqual((Object)request.getStatus(), (Object)RequestStatus.Companion.getEXECUTING()) || Intrinsics.areEqual((Object)request.getStatus(), (Object)RequestStatus.Companion.getCANCELLED_EXECUTING()))) {
                boolean $i$a$-require-FrontendAsyncRequestExecutor$doRequestsCompleted$732 = false;
                String $i$a$-require-FrontendAsyncRequestExecutor$doRequestsCompleted$732 = "Unexpected request status on complete: " + request.getStatus();
                throw new IllegalArgumentException($i$a$-require-FrontendAsyncRequestExecutor$doRequestsCompleted$732.toString());
            }
            Intrinsics.checkNotNull((Object)request);
            this.fireRequestCompleted(request, rdResponse);
            RdResponse $i$f$trace232 = rdResponse;
            if ($i$f$trace232 instanceof RdSuccessResponse) {
                undoneReqNum += this.handleBackendResult(request, (RdSuccessResponse)rdResponse, rebaseSession, delta, isBatchMode);
            } else if ($i$f$trace232 instanceof RdRetryResponse) {
                if (isBatchMode) {
                    throw new IllegalStateException(("Retrying is not allowed during batch processing; current request: " + request + ". Requests in queue: " + CollectionsKt.joinToString$default((Iterable)this.requestsQueue, (CharSequence)", ", null, null, (int)0, null, FrontendAsyncRequestExecutor::doRequestsCompleted$lambda$29, (int)30, null)).toString());
                }
                this.handleRetry(request, (RdRetryResponse)rdResponse);
            } else if ($i$f$trace232 instanceof RdFailureResponse) {
                this.handleFailure((RdFailureResponse)rdResponse, request, rebaseSession, delta);
            } else {
                throw new IllegalStateException(("Unexpected response type: " + Reflection.getOrCreateKotlinClass(rdResponse.getClass()).getSimpleName()).toString());
            }
            if (isBatchMode && !request.getStatus().isCompleted()) {
                throw new IllegalStateException(("Retrying is not allowed during batch processing; request: " + request).toString());
            }
            Logger $this$trace$iv3 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            boolean $i$f$trace3 = false;
            if (!$this$trace$iv3.isTraceEnabled()) continue;
            object = $this$trace$iv3;
            boolean bl5 = false;
            object.trace("<< response#" + requestId);
        }
        redoneReqNum += undoneReqNum > 0 ? this.rollForwardRevertedRequests(rebaseSession) : 0;
        $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
        boolean bl6 = false;
        if ($this$trace$iv.isTraceEnabled()) {
            object = $this$trace$iv;
            bl = false;
            object.trace("Responses number: " + responses.size() + ", processing time: " + (double)(System.nanoTime() - startTime) / 1000000.0 + " ms, request queue size: " + this.requestsQueue.size() + ", undone requests: " + undoneReqNum + ", redone requests: " + redoneReqNum + ", cancelled requests: " + (undoneReqNum - redoneReqNum));
        }
        this.executeNextRequest();
        this.fireResponsesExecuted(responses);
    }

    private final void fireRequestSent(FrontendAsyncRequest request) {
        ((FrontendAsyncRequestListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendAsyncRequestListener.Companion.getTOPIC())).requestSent(this.session, request);
    }

    private final void fireRequestCompleted(FrontendAsyncRequest request, RdResponse response) {
        ((FrontendAsyncRequestListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendAsyncRequestListener.Companion.getTOPIC())).requestCompleted(this.session, request, response);
    }

    private final void fireResponsesExecuted(List<? extends RdResponse> responses) {
        ((FrontendAsyncRequestListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendAsyncRequestListener.Companion.getTOPIC())).responsesExecuted(this.session, responses);
    }

    private final void fireProblemOccurred(Throwable throwable) {
        ((FrontendAsyncRequestListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendAsyncRequestListener.Companion.getTOPIC())).problemOccurred(this.session, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final int handleBackendResult(FrontendAsyncRequest request, RdSuccessResponse response, FrontendRebaseSession rebaseSession, long delta, boolean isBatchMode) {
        if (!Intrinsics.areEqual((Object)request.getStatus(), (Object)RequestStatus.Companion.getEXECUTING())) {
            $i$a$-require-FrontendAsyncRequestExecutor$handleBackendResult$1 = false;
            $i$a$-require-FrontendAsyncRequestExecutor$handleBackendResult$1 = "Unexpected status: " + request.getStatus();
            throw new IllegalArgumentException($i$a$-require-FrontendAsyncRequestExecutor$handleBackendResult$1.toString());
        }
        backendPatch = response.getPatch();
        model = request.createModel();
        telemetryData = null;
        requestHolder = new RdRequestHolder(request.getId(), model, telemetryData);
        remoteContext = OpenTelemetryKt.getRemoteContext((RdTelemetryDataHolder)((RdTelemetryDataHolder)requestHolder));
        var12_13 = "client: backend activity finished";
        kind$iv = SpanKind.CLIENT;
        $i$f$withSpan = false;
        startTime$iv = TelemetryDataUtilKt.currentTimeWithAdjustment((long)delta);
        v0 = TelemetryDataUtilKt.rdctTracer().spanBuilder((String)message$iv).setSpanKind(kind$iv).setParent(remoteContext).setAttribute("start time", startTime$iv).setStartTimestamp(startTime$iv, TimeUnit.NANOSECONDS).startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"startSpan(...)");
        $this$use$iv$iv = v0;
        $i$f$use = false;
        try {
            block22: {
                block21: {
                    $this$withSpan_u24lambda_u240$iv = $this$use$iv$iv;
                    $i$a$-use-TelemetryDataUtilKt$withSpan$1$iv = false;
                    $this$handleBackendResult_u24lambda_u2438 = $this$withSpan_u24lambda_u240$iv;
                    $i$a$-withSpan-FrontendAsyncRequestExecutor$handleBackendResult$2 = false;
                    if (!(request instanceof FrontendAsyncRequestWithImmediateResult)) break block21;
                    speculatedPatch = ((FrontendAsyncRequestWithImmediateResult)request).getPatch();
                    speculativelyEqualsResult = this.speculativelyEquals(speculatedPatch, backendPatch, (FrontendAsyncRequestWithImmediateResult)request, isBatchMode);
                    if (!RdPatchUtilsKt.isEqualOrEquivalent((SpeculativelyEqualsResult)speculativelyEqualsResult)) ** GOTO lbl-1000
                    $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var27_33 = $this$trace$iv;
                        $i$a$-trace-FrontendAsyncRequestExecutor$handleBackendResult$2$1 = false;
                        var27_33.trace("Client and backend patches are " + speculativelyEqualsResult.name() + ". Skipping full rebase...");
                    }
                    if (backendPatch != null) {
                        if (speculatedPatch == null) {
                            $this$trace$iv = "Required value was null.";
                            throw new IllegalArgumentException($this$trace$iv.toString());
                        }
                        if (speculativelyEqualsResult == SpeculativelyEqualsResult.Equivalent) {
                            $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                            $i$f$trace = false;
                            if ($this$trace$iv.isTraceEnabled()) {
                                var27_33 = $this$trace$iv;
                                $i$a$-trace-FrontendAsyncRequestExecutor$handleBackendResult$2$2 = false;
                                var27_33.trace("Client and backend patches are Equivalent. Speculative:\n" + IPrintableKt.printToString((Object)speculatedPatch) + "\nBackend:\n" + IPrintableKt.printToString((Object)backendPatch) + "\n. Do virtual rebase");
                            }
                            $this$trace$iv = this.requestsQueue;
                            var29_35 = backendPatch;
                            var30_36 = (FrontendAsyncRequestWithImmediateResult)request;
                            var27_33 = this.patchHandlerRegistry;
                            $i$f$dropWhile = false;
                            yielding$iv = false;
                            list$iv = new ArrayList<T>();
                            for (T item$iv : $this$dropWhile$iv) {
                                if (yielding$iv) {
                                    list$iv.add(item$iv);
                                    continue;
                                }
                                it = (FrontendAsyncRequest)item$iv;
                                $i$a$-dropWhile-FrontendAsyncRequestExecutor$handleBackendResult$2$3 = false;
                                if (it != request) continue;
                                list$iv.add(item$iv);
                                yielding$iv = true;
                            }
                            var36_42 = list$iv;
                            var27_33.updatePendingRequestsVersions(var30_36, var29_35, var36_42);
                        }
                        ctx = new FrontendRdPatchHandlerContext(this.session, backendPatch, request, PatchItemOperationType.Perform.INSTANCE);
                        FrontendRdPatchItemHandlerKt.withHandlerContext(ctx, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, handleBackendResult$lambda$38$lambda$36(com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutor com.jetbrains.rd.ide.model.RdPatch com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext ), ()Lkotlin/Unit;)((FrontendAsyncRequestExecutor)this, (RdPatch)backendPatch, (FrontendRdPatchHandlerContext)ctx));
                    }
                    request.setStatus(RequestStatus.Companion.getCOMPLETED());
                    v1 = 0;
                    break block22;
                }
                if (backendPatch == null) {
                    $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var27_33 = $this$trace$iv;
                        $i$a$-trace-FrontendAsyncRequestExecutor$handleBackendResult$2$5 = false;
                        var27_33.trace("Empty patch. Skipping rebase...");
                    }
                    request.setStatus(RequestStatus.Companion.getCOMPLETED());
                    v1 = 0;
                } else lbl-1000:
                // 2 sources

                {
                    if (backendPatch == null) {
                        if (!(request instanceof FrontendAsyncRequestWithImmediateResult)) {
                            $i$a$-trace-FrontendAsyncRequestExecutor$handleBackendResult$2$5 = "Failed requirement.";
                            throw new IllegalArgumentException($i$a$-trace-FrontendAsyncRequestExecutor$handleBackendResult$2$5.toString());
                        }
                        v2 = ((FrontendAsyncRequestWithImmediateResult)request).getPatch();
                        v3 = v2;
                        Intrinsics.checkNotNull((Object)v2);
                    } else {
                        v3 = backendPatch;
                    }
                    conflictingPatch = v3;
                    caretRestoreHelper = CaretRestoreHelper.Companion.getInstance();
                    caretRestoreHelper.setLastCaretBeforeRollbackLeansForward(null);
                    undoneReqNum = this.rollbackConflictingRequests(conflictingPatch, rebaseSession);
                    request.setStatus(RequestStatus.Companion.getCOMPLETED());
                    if (backendPatch != null) {
                        v4 = request instanceof FrontendEditorActionRequest != false ? (FrontendEditorActionRequest)request : null;
                        v5 = editor = v4 != null && (v4 = v4.getEditorId()) != null ? FrontendTextControlHostKt.toEditorOrNull((TextControlId)v4) : null;
                        if (v5 != null) {
                            v5.putUserData(EditorImpl.DISABLE_CARET_POSITION_KEEPING, (Object)true);
                        }
                        this.applyBackendPatch(backendPatch, request);
                        v6 = editor;
                        if (v6 != null) {
                            v6.putUserData(EditorImpl.DISABLE_CARET_POSITION_KEEPING, null);
                        }
                    }
                    caretRestoreHelper.setLastCaretBeforeRollbackLeansForward(null);
                    v1 = undoneReqNum;
                }
            }
            var37_43 = v1;
        }
        finally {
            finishTime$iv$iv = TelemetryDataUtilKt.currentTimeWithAdjustment((long)delta);
            $this$use$iv$iv.setAttribute("finish time", finishTime$iv$iv);
            $this$use$iv$iv.setAttribute("delta", delta);
            $this$use$iv$iv.end(finishTime$iv$iv, TimeUnit.NANOSECONDS);
        }
        return var37_43;
    }

    private final SpeculativelyEqualsResult speculativelyEquals(RdPatch speculatedPatch, RdPatch backendPatch, FrontendAsyncRequestWithImmediateResult request, boolean isBatchMode) {
        if (((Boolean)this.forceRebase.invoke((Object)request, (Object)backendPatch)).booleanValue()) {
            return SpeculativelyEqualsResult.Different;
        }
        return RdPatchUtilsKt.speculativelyEquals((RdPatch)speculatedPatch, (RdPatch)backendPatch, (!isBatchMode ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void handleFailure(RdFailureResponse response, FrontendAsyncRequest request, FrontendRebaseSession rebaseSession, long delta) {
        void message$iv;
        List telemetryData = null;
        Context remoteContext2 = OpenTelemetryKt.getRemoteContext((RdTelemetryDataHolder)((RdTelemetryDataHolder)new RdRequestHolder(request.getId(), request.createModel(), telemetryData)));
        String string = "client: backend activity failed";
        SpanKind kind$iv = SpanKind.CLIENT;
        boolean $i$f$withSpan = false;
        long startTime$iv = TelemetryDataUtilKt.currentTimeWithAdjustment((long)delta);
        Span span = TelemetryDataUtilKt.rdctTracer().spanBuilder((String)message$iv).setSpanKind(kind$iv).setParent(remoteContext2).setAttribute("start time", startTime$iv).setStartTimestamp(startTime$iv, TimeUnit.NANOSECONDS).startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$use$iv$iv = span;
        boolean $i$f$use = false;
        try {
            Span $this$withSpan_u24lambda_u240$iv = $this$use$iv$iv;
            boolean bl = false;
            Span $this$handleFailure_u24lambda_u2439 = $this$withSpan_u24lambda_u240$iv;
            boolean bl2 = false;
            FrontendAsyncRequestExecutorKt.access$getLogger$p().error("Can't execute " + request + ", reason: " + response.getMessage());
            if (Intrinsics.areEqual((Object)request.getStatus(), (Object)RequestStatus.Companion.getEXECUTING())) {
                request.undo(rebaseSession);
            }
            request.setStatus(RequestStatus.Companion.getCANCELLED_COMPLETED());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            long finishTime$iv$iv = TelemetryDataUtilKt.currentTimeWithAdjustment((long)delta);
            $this$use$iv$iv.setAttribute("finish time", finishTime$iv$iv);
            $this$use$iv$iv.setAttribute("delta", delta);
            $this$use$iv$iv.end(finishTime$iv$iv, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void handleRetry(FrontendAsyncRequest request, RdRetryResponse response) {
        if (Intrinsics.areEqual((Object)request.getStatus(), (Object)RequestStatus.Companion.getCANCELLED_EXECUTING())) {
            Logger $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Cannot re-try " + request);
            }
            request.setStatus(RequestStatus.Companion.getCANCELLED_COMPLETED());
            return;
        }
        ComponentManager $this$service$iv22 = (ComponentManager)ApplicationKt.getApplication();
        boolean $i$f$service = false;
        Class<RetryCustomizer> serviceClass$iv = RetryCustomizer.class;
        Object object = $this$service$iv22.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv22, serviceClass$iv);
        }
        boolean forceRetry = ((RetryCustomizer)object).retry(request, response);
        int $this$service$iv22 = request.getRetryCounter();
        request.setRetryCounter($this$service$iv22 + 1);
        if (request.getRetryCounter() <= 1 || forceRetry) {
            Logger $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Re-trying " + request + " at " + request.getRetryCounter() + " time, reason: " + response.getMessage());
            }
            request.setStatus(RequestStatus.Companion.getPENDING());
        } else {
            void this_$iv;
            Object $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Retry trials exceeded max limit (1)");
            }
            if (!(request instanceof FrontendAsyncRequestWithImmediateResult) || ((FrontendAsyncRequestWithImmediateResult)request).getPatch() == null) {
                request.undo(FrontendRebaseSession.Companion.createEmpty());
                request.setStatus(RequestStatus.Companion.getCANCELLED_COMPLETED());
                return;
            }
            $this$trace$iv = FrontendRebaseSession.Companion;
            ClientAppSession clientAppSession$iv = this.session;
            boolean $i$f$using = false;
            FrontendRebaseSession rebaseSession$iv = this_$iv.createEmpty();
            try {
                DocumentSynchronizerListeners.Companion.getInstance(clientAppSession$iv).addListener((DocumentSynchronizerListener)rebaseSession$iv);
                FrontendRebaseSession it = rebaseSession$iv;
                boolean bl = false;
                RdPatch rdPatch = ((FrontendAsyncRequestWithImmediateResult)request).getPatch();
                Intrinsics.checkNotNull((Object)rdPatch);
                int undoneReqNum = this.rollbackConflictingRequests(rdPatch, it);
                request.setStatus(RequestStatus.Companion.getCANCELLED_COMPLETED());
                int redoneReqNum = this.rollForwardRevertedRequests(it);
                Logger $this$trace$iv2 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                boolean $i$f$trace = false;
                if ($this$trace$iv2.isTraceEnabled()) {
                    Logger logger = $this$trace$iv2;
                    boolean bl2 = false;
                    logger.trace("Cancelling request was done; request queue size: " + this.requestsQueue.size() + ", undone requests: " + undoneReqNum + ", redone requests: " + redoneReqNum + ", cancelled requests: " + (undoneReqNum - redoneReqNum) + ".");
                }
            }
            finally {
                DocumentSynchronizerListeners.Companion.getInstance(clientAppSession$iv).removeListener((DocumentSynchronizerListener)rebaseSession$iv);
            }
        }
    }

    private final void executeNextRequest() {
        Iterator<FrontendAsyncRequest> iterator2 = this.requestsQueue.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<FrontendAsyncRequest> it = iterator2;
        SmartList nextRequests = new SmartList();
        FrontendAsyncRequest prevRequest = null;
        while (it.hasNext()) {
            boolean batchingAllowed;
            FrontendAsyncRequest nextRequest = it.next();
            RequestStatus status = nextRequest.getStatus();
            if (status.isCompleted()) {
                it.remove();
                continue;
            }
            boolean bl = batchingAllowed = nextRequest.isBatchingAllowed() && FrontendAsyncRequestExecutorBehaviour.Companion.getInstance().supportBatching();
            if (!batchingAllowed && !nextRequests.isEmpty() || prevRequest != null && !Intrinsics.areEqual((Object)prevRequest.getClientId(), (Object)nextRequest.getClientId())) break;
            nextRequests.add((Object)nextRequest);
            prevRequest = nextRequest;
            if (batchingAllowed && nextRequests.size() != 10) continue;
        }
        if (nextRequests.isEmpty()) {
            return;
        }
        this.doExecute((List)nextRequests);
    }

    private final Object backendChanged(RdPatch patch, Continuation<? super Unit> $completion) {
        Object object = this.runGuardedWithRecovery((Function0<Unit>)((Function0)() -> FrontendAsyncRequestExecutor.backendChanged$lambda$45(this, patch)), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object runGuardedWithRecovery(Function0<Unit> var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof runGuardedWithRecovery.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ FrontendAsyncRequestExecutor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FrontendAsyncRequestExecutor.access$runGuardedWithRecovery(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.synchronizeWithPatchEngine((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (Function0<Unit>)action, null){
                    int label;
                    final /* synthetic */ FrontendAsyncRequestExecutor this$0;
                    final /* synthetic */ Function0<Unit> $action;
                    {
                        this.this$0 = $receiver;
                        this.$action = $action;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                if (!(!FrontendAsyncRequestExecutor.access$getNestedExecutionGuard$p(this.this$0))) {
                                    String string = "Failed requirement.";
                                    throw new IllegalArgumentException(string.toString());
                                }
                                FrontendAsyncRequestExecutor.access$setNestedExecutionGuard$p(this.this$0, true);
                                try {
                                    this.$action.invoke();
                                }
                                finally {
                                    FrontendAsyncRequestExecutor.access$setNestedExecutionGuard$p(this.this$0, false);
                                }
                                if (this.this$0.getTriggerRecoveryEditorStates$intellij_rd_client()) {
                                    this.this$0.setTriggerRecoveryEditorStates$intellij_rd_client(false);
                                    String msg = "Recovery Editor States is triggered manually";
                                    FrontendAsyncRequestExecutorKt.access$getLogger$p().warn(msg);
                                    throw new Throwable(msg);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super Unit>)$continuation);
                ** if (v0 != var6_5) goto lbl19
lbl18:
                // 1 sources

                return var6_5;
lbl19:
                // 1 sources

                ** GOTO lbl41
            }
            case 1: {
                this = (FrontendAsyncRequestExecutor)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                    ** GOTO lbl41
                }
                catch (Throwable t) {
                    if (t instanceof ProcessCanceledException || t instanceof CancellationException) {
                        throw t;
                    }
                    FrontendAsyncRequestExecutorKt.access$getLogger$p().error("Error occurred when handling request", t);
                    this.fireProblemOccurred(t);
                    $continuation.L$0 = null;
                    $continuation.label = 2;
                    v1 = this.recoverState((Continuation<? super Unit>)$continuation);
                    if (v1 == var6_5) {
                        return var6_5;
                    }
                    ** GOTO lbl41
                }
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl41:
                // 4 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void doBackendChanged(RdPatch patch) {
        void this_$iv;
        ThreadingAssertions.assertEventDispatchThread();
        if (this.recoveringInProgress) {
            Logger $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Skipping backend change during recovering, patch: " + IPrintableKt.printToString((Object)patch));
            }
            return;
        }
        Logger $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(">> applying backend changes, patch: " + IPrintableKt.printToString((Object)patch));
        }
        long startTime = System.nanoTime();
        FrontendRebaseSession.Companion bl = FrontendRebaseSession.Companion;
        ClientAppSession clientAppSession$iv = this.session;
        boolean $i$f$using = false;
        FrontendRebaseSession rebaseSession$iv = this_$iv.createEmpty();
        try {
            DocumentSynchronizerListeners.Companion.getInstance(clientAppSession$iv).addListener((DocumentSynchronizerListener)rebaseSession$iv);
            FrontendRebaseSession it = rebaseSession$iv;
            boolean bl2 = false;
            int undoneReqNum = this.rollbackConflictingRequests(patch, it);
            FrontendAsyncRequestExecutor.applyBackendPatch$default(this, patch, null, 2, null);
            int redoneReqNum = this.rollForwardRevertedRequests(it);
            Logger $this$trace$iv2 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            boolean $i$f$trace2 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                Logger logger = $this$trace$iv2;
                boolean bl3 = false;
                logger.trace("<< applying backend changes; time: " + (double)(System.nanoTime() - startTime) / 1000000.0 + ", request queue size: " + this.requestsQueue.size() + ", undone requests: " + undoneReqNum + ", redone requests: " + redoneReqNum + ", cancelled requests: " + (undoneReqNum - redoneReqNum) + ".");
            }
        }
        finally {
            DocumentSynchronizerListeners.Companion.getInstance(clientAppSession$iv).removeListener((DocumentSynchronizerListener)rebaseSession$iv);
        }
    }

    private final int rollbackConflictingRequests(RdPatch patch, FrontendRebaseSession rebaseSession) {
        Logger logger;
        Iterator<FrontendAsyncRequest> backIt = this.requestsQueue.descendingIterator();
        int undoneReqNum = 0;
        while (backIt.hasNext()) {
            boolean $i$f$trace;
            Logger $this$trace$iv;
            FrontendAsyncRequest request = backIt.next();
            if (Intrinsics.areEqual((Object)request.getStatus(), (Object)RequestStatus.Companion.getCANCELLED_EXECUTING()) || request.getStatus().isReverted() || request.getStatus().isCompleted()) {
                $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                $i$f$trace = false;
                if (!$this$trace$iv.isTraceEnabled()) continue;
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("skip request with status=" + request.getStatus() + " request.status.isReverted()=" + request.getStatus().isReverted() + " request.status.isCompleted()=" + request.getStatus().isCompleted() + " " + request);
                continue;
            }
            if (!(Intrinsics.areEqual((Object)request.getStatus(), (Object)RequestStatus.Companion.getPENDING()) || Intrinsics.areEqual((Object)request.getStatus(), (Object)RequestStatus.Companion.getEXECUTING()))) {
                boolean $i$a$-require-FrontendAsyncRequestExecutor$rollbackConflictingRequests$32 = false;
                String $i$a$-require-FrontendAsyncRequestExecutor$rollbackConflictingRequests$32 = "Unexpected status: " + request.getStatus();
                throw new IllegalArgumentException($i$a$-require-FrontendAsyncRequestExecutor$rollbackConflictingRequests$32.toString());
            }
            if (request.conflictWith(patch)) {
                $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("undoing " + request);
                }
                request.setStatus(request.getStatus().revert());
                RebaseListener rebaseListener = this.rebaseListener;
                if (rebaseListener != null) {
                    Intrinsics.checkNotNull((Object)request);
                    rebaseListener.undo(request);
                }
                request.undo(rebaseSession);
                $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace(request + " was undone");
                }
                int $this$trace$iv2 = undoneReqNum;
                undoneReqNum = $this$trace$iv2 + 1;
                continue;
            }
            $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            $i$f$trace = false;
            if (!$this$trace$iv.isTraceEnabled()) continue;
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("non-conflicting request: " + request);
        }
        Logger $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(undoneReqNum + " requests were undone. HasMore: " + backIt.hasNext());
        }
        return undoneReqNum;
    }

    private final boolean rollForwardRequest(FrontendAsyncRequest request, FrontendRebaseSession rebaseSession) {
        Logger logger;
        request.setStatus(request.getStatus().undoRevert());
        Logger $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("redoing " + request);
        }
        RebaseListener rebaseListener = this.rebaseListener;
        if (rebaseListener != null) {
            rebaseListener.redo();
        }
        try {
            $i$f$trace = request.redo(rebaseSession);
        }
        catch (Throwable t) {
            FrontendAsyncRequestExecutorKt.access$getLogger$p().error("Redoing of request " + request + " failed with exception", t);
            $i$f$trace = false;
        }
        boolean redoingResult = $i$f$trace;
        if (!redoingResult) {
            Logger $this$trace$iv2 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            boolean $i$f$trace2 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                logger = $this$trace$iv2;
                boolean bl = false;
                logger.trace(request + " was cancelled");
            }
            request.setStatus(request.getStatus().cancel());
            return false;
        }
        Logger $this$trace$iv3 = FrontendAsyncRequestExecutorKt.access$getLogger$p();
        boolean $i$f$trace3 = false;
        if ($this$trace$iv3.isTraceEnabled()) {
            logger = $this$trace$iv3;
            boolean bl = false;
            logger.trace(request + " was redone");
        }
        return true;
    }

    private final int rollForwardRevertedRequests(FrontendRebaseSession rebaseSession) {
        Iterator<FrontendAsyncRequest> iterator2 = this.requestsQueue.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<FrontendAsyncRequest> it = iterator2;
        int redoneReqNum = 0;
        while (it.hasNext()) {
            FrontendAsyncRequest request = it.next();
            if (!request.getStatus().isReverted()) continue;
            Intrinsics.checkNotNull((Object)request);
            if (this.rollForwardRequest(request, rebaseSession)) {
                ++redoneReqNum;
            }
            if (!Intrinsics.areEqual((Object)request.getStatus(), (Object)RequestStatus.Companion.getCANCELLED_PENDING())) continue;
            it.remove();
        }
        return redoneReqNum;
    }

    public final void applyBackendPatch(@NotNull RdPatch patch, @Nullable FrontendAsyncRequest request) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        FrontendRdPatchHandlerContext ctx = new FrontendRdPatchHandlerContext(this.session, patch, request, PatchItemOperationType.Perform.INSTANCE);
        if (!this.patchHandlerRegistry.validate(patch.getExpectedItemVersions(), ctx)) {
            throw new IllegalStateException("Not matched versions before applying patch".toString());
        }
        FrontendRdPatchItemHandlerKt.withHandlerContext(ctx, () -> FrontendAsyncRequestExecutor.applyBackendPatch$lambda$59(this, patch, ctx));
        if (!this.patchHandlerRegistry.validate(patch.getUpdatedItemVersions(), ctx)) {
            throw new IllegalStateException("Not matched versions after applying patch".toString());
        }
        this.patchHandlerRegistry.update(patch.getUpdatedItemVersions(), ctx);
        FrontendRdPatchItemHandlerKt.withHandlerContext(ctx, () -> FrontendAsyncRequestExecutor.applyBackendPatch$lambda$60(this, patch, ctx));
    }

    public static /* synthetic */ void applyBackendPatch$default(FrontendAsyncRequestExecutor frontendAsyncRequestExecutor, RdPatch rdPatch, FrontendAsyncRequest frontendAsyncRequest, int n, Object object) {
        if ((n & 2) != 0) {
            frontendAsyncRequest = null;
        }
        frontendAsyncRequestExecutor.applyBackendPatch(rdPatch, frontendAsyncRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object recoverState(Continuation<? super Unit> $completion) {
        if (!($completion instanceof recoverState.1)) ** GOTO lbl-1000
        var11_2 = $completion;
        if ((var11_2.label & -2147483648) != 0) {
            var11_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ FrontendAsyncRequestExecutor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FrontendAsyncRequestExecutor.access$recoverState(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var9_8 = $this$trace$iv;
                    $i$a$-trace-FrontendAsyncRequestExecutor$recoverState$2 = false;
                    var9_8.trace("recoverState called");
                }
                ThreadingAssertions.assertEventDispatchThread();
                this.recoveringInProgress = true;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = YieldKt.yield((Continuation)$continuation);
                if (v0 == var12_4) {
                    return var12_4;
                }
                ** GOTO lbl32
            }
            case 1: {
                this = (FrontendAsyncRequestExecutor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 3 sources

                FrontendAsyncRequestExecutorKt.access$getLogger$p().warn(">> Start recovering states after exception...");
                $this$forEach$iv = this.requestsQueue;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (FrontendAsyncRequest)element$iv;
                    $i$a$-forEach-FrontendAsyncRequestExecutor$recoverState$3 = false;
                    response = new RdFailureResponse("Version mismatch", it.getId(), null, 4, null);
                    if (!it.getStatus().isCompleted()) {
                        Intrinsics.checkNotNull((Object)it);
                        this.fireRequestCompleted(it, (RdResponse)response);
                    }
                    it.setStatus(RequestStatus.Companion.getCANCELLED_COMPLETED());
                    this.fireResponsesExecuted(CollectionsKt.listOf((Object)response));
                }
                this.requestsQueue.clear();
                v1 = ModalTaskOwner.guess();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"guess(...)");
                $continuation.L$0 = this;
                $continuation.label = 2;
                v2 = TasksKt.withModalProgress((ModalTaskOwner)v1, (String)FrontendBundle.INSTANCE.message("actions.recovering.editors", new Object[0]), (TaskCancellation)((TaskCancellation)TaskCancellation.Companion.nonCancellable()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ FrontendAsyncRequestExecutor this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                    int label;
                                    final /* synthetic */ FrontendAsyncRequestExecutor this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                IPermittedModalities.Companion.getInstance$default(IPermittedModalities.Companion, null, 1, null).allowPumpProtocolUnderCurrentModality();
                                                this.label = 1;
                                                Object object3 = RecoveringStrategyProvider.Companion.getInstance().createRecoveringStrategy(this.this$0.getSession()).recover((Continuation<? super Unit>)((Continuation)this));
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v2 != var12_4) goto lbl55
lbl54:
                // 1 sources

                return var12_4;
lbl55:
                // 1 sources

                ** GOTO lbl62
            }
            case 2: {
                this = (FrontendAsyncRequestExecutor)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl62:
                    // 2 sources

                    FrontendAsyncRequestExecutorKt.access$getLogger$p().warn("<< End recovering states");
                }
                catch (Throwable var2_6) {
                    throw var2_6;
                }
                finally {
                    this.recoveringInProgress = false;
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final boolean forceRebase$lambda$0(FrontendAsyncRequest request, RdPatch backendPatch) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return false;
    }

    private static final Unit withForceRebase$lambda$1(FrontendAsyncRequestExecutor this$0, Function2 $check) {
        this$0.forceRebase = $check;
        return Unit.INSTANCE;
    }

    private static final boolean withForceRebase$lambda$3$lambda$2(FrontendAsyncRequest request, RdPatch backendPatch) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return false;
    }

    private static final Unit withForceRebase$lambda$3(FrontendAsyncRequestExecutor this$0, Function2 $check, Function2 $old) {
        if (this$0.forceRebase == $check) {
            this$0.forceRebase = $old;
        } else {
            FrontendAsyncRequestExecutorKt.access$getLogger$p().error("forceRebase was changed. Incorrect scoping");
            this$0.forceRebase = FrontendAsyncRequestExecutor::withForceRebase$lambda$3$lambda$2;
        }
        return Unit.INSTANCE;
    }

    private static final Unit bindWithModel$lambda$6(FrontendAsyncRequestExecutor this$0, boolean it) {
        this$0.isInitialized = true;
        this$0.executeNextRequest();
        return Unit.INSTANCE;
    }

    private static final CharSequence ensureRequestQueueEmpty$lambda$8$lambda$7(FrontendAsyncRequest it) {
        return IPrintableKt.printToString((Object)it);
    }

    private static final Unit doExecute$lambda$19(List $requests, SmartList $models, FrontendAsyncRequestExecutor this$0, boolean $isBatch) {
        for (FrontendAsyncRequest request : $requests) {
            Logger $this$trace$iv = FrontendAsyncRequestExecutorKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Start executing " + request + " " + (String)($isBatch ? "[batch size: " + $requests.size() + "]" : ""));
            }
            if (!Intrinsics.areEqual((Object)request.getStatus(), (Object)RequestStatus.Companion.getPENDING())) {
                boolean bl = false;
                String string = "Unexpected status: " + request.getStatus();
                throw new IllegalArgumentException(string.toString());
            }
            request.assertClientId();
            request.setStatus(RequestStatus.Companion.getEXECUTING());
            List telemetryData = null;
            $models.add((Object)new RdRequestHolder(request.getId(), request.createModel(), telemetryData));
        }
        this$0.getProtocolModel().getRequestsWithTime().fire((Object)new RdRequests((List)$models, TelemetryDataUtilKt.getCurrentTime()));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit requestsCompleted$lambda$21(FrontendAsyncRequestExecutor this$0, RdResponses $respList) {
        void this_$iv;
        FrontendRebaseSession.Companion companion = FrontendRebaseSession.Companion;
        ClientAppSession clientAppSession$iv = this$0.session;
        boolean $i$f$using = false;
        FrontendRebaseSession rebaseSession$iv = this_$iv.createEmpty();
        try {
            DocumentSynchronizerListeners.Companion.getInstance(clientAppSession$iv).addListener((DocumentSynchronizerListener)rebaseSession$iv);
            FrontendRebaseSession it = rebaseSession$iv;
            boolean bl = false;
            this$0.doRequestsCompleted($respList.getResponses(), it, new RequestTelemetryData($respList.getTimestamp()).getDelta());
        }
        finally {
            DocumentSynchronizerListeners.Companion.getInstance(clientAppSession$iv).removeListener((DocumentSynchronizerListener)rebaseSession$iv);
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence doRequestsCompleted$lambda$23$lambda$22(RdResponse it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(it.getRequestId());
    }

    private static final CharSequence doRequestsCompleted$lambda$25$lambda$24(RdResponse it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return IPrintableKt.printToString((Object)it);
    }

    private static final CharSequence doRequestsCompleted$lambda$29(FrontendAsyncRequest it) {
        return IPrintableKt.printToString((Object)it);
    }

    private static final Unit handleBackendResult$lambda$38$lambda$36(FrontendAsyncRequestExecutor this$0, RdPatch $backendPatch, FrontendRdPatchHandlerContext $ctx) {
        this$0.patchHandlerRegistry.apply($backendPatch.getFeatures(), $ctx);
        this$0.patchHandlerRegistry.update($backendPatch.getUpdatedItemVersions(), $ctx);
        return Unit.INSTANCE;
    }

    private static final Unit backendChanged$lambda$45(FrontendAsyncRequestExecutor this$0, RdPatch $patch) {
        this$0.doBackendChanged($patch);
        return Unit.INSTANCE;
    }

    private static final Unit applyBackendPatch$lambda$59(FrontendAsyncRequestExecutor this$0, RdPatch $patch, FrontendRdPatchHandlerContext $ctx) {
        this$0.patchHandlerRegistry.apply($patch.getChanges(), $ctx);
        return Unit.INSTANCE;
    }

    private static final Unit applyBackendPatch$lambda$60(FrontendAsyncRequestExecutor this$0, RdPatch $patch, FrontendRdPatchHandlerContext $ctx) {
        this$0.patchHandlerRegistry.apply($patch.getFeatures(), $ctx);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$requestsCompleted(FrontendAsyncRequestExecutor $this, RdResponses respList, Continuation $completion) {
        return $this.requestsCompleted(respList, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$backendChanged(FrontendAsyncRequestExecutor $this, RdPatch patch, Continuation $completion) {
        return $this.backendChanged(patch, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$runGuardedWithRecovery(FrontendAsyncRequestExecutor $this, Function0 action, Continuation $completion) {
        return $this.runGuardedWithRecovery((Function0<Unit>)action, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ boolean access$getNestedExecutionGuard$p(FrontendAsyncRequestExecutor $this) {
        return $this.nestedExecutionGuard;
    }

    public static final /* synthetic */ void access$setNestedExecutionGuard$p(FrontendAsyncRequestExecutor $this, boolean bl) {
        $this.nestedExecutionGuard = bl;
    }

    public static final /* synthetic */ Object access$recoverState(FrontendAsyncRequestExecutor $this, Continuation $completion) {
        return $this.recoverState((Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendAsyncRequestExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendAsyncRequestExecutor.kt\ncom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,712:1\n31#2,2:713\n*S KotlinDebug\n*F\n+ 1 FrontendAsyncRequestExecutor.kt\ncom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$Companion\n*L\n62#1:713,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendAsyncRequestExecutor getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ComponentManager $this$service$iv = (ComponentManager)session;
            boolean $i$f$service = false;
            Class<FrontendAsyncRequestExecutor> serviceClass$iv = FrontendAsyncRequestExecutor.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (FrontendAsyncRequestExecutor)((Object)object);
        }

        @Deprecated(message="Use an overload with client app session")
        @ApiStatus.ScheduledForRemoval
        @ApiStatus.Internal
        @NotNull
        public final FrontendAsyncRequestExecutor getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project).getAppSession());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$MyModelListener;", "Lcom/jetbrains/rd/protocol/AppExtListener;", "Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "Lcom/jetbrains/rd/ide/model/RequestResponseModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "parent", "model", "intellij.rd.client"})
    public static final class MyModelListener
    implements AppExtListener<DocumentsOperationModel, RequestResponseModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull DocumentsOperationModel parent, @NotNull RequestResponseModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Companion.getInstance(session).bindWithModel(lifetime, model);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$RebaseListener;", "", "redo", "", "undo", "request", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "intellij.rd.client"})
    @TestOnly
    public static interface RebaseListener {
        public void redo();

        public void undo(@NotNull FrontendAsyncRequest var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestExecutor$RetryCustomizer;", "", "<init>", "()V", "retry", "", "request", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "response", "Lcom/jetbrains/rd/ide/model/RdRetryResponse;", "intellij.rd.client"})
    public static class RetryCustomizer {
        public boolean retry(@NotNull FrontendAsyncRequest request, @NotNull RdRetryResponse response) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            return false;
        }
    }
}

