/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.actions;

import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.JupyterRemoteBundle;
import com.intellij.jupyter.core.jupyter.connections.action.JupyterConnectionActionExtensionsKt;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterExecutionState;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookOfflineSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookRuntimeSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookSessionSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.ManagedJupyterServerNotebookSessionSettings;
import com.intellij.jupyter.core.jupyter.connections.managed.JupyterRuntimeManagedServerInfo;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerFinished;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerStarted;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerStarting;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerState;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerStopped;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionSettingsManager;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterConfiguredServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterManagedServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterAnActionEventExtensionsKt;
import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.jupyter.core.jupyter.server.JupyterManagedServerConfigurationProvider;
import com.intellij.jupyter.core.jupyter.server.JupyterManagedServerExecutionServiceProvider;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerExecution;
import com.intellij.jupyter.py.connections.managed.actions.JupyterManagedServerExtensionsKt;
import com.intellij.jupyter.py.helper.JupyterPyExtensionsKt;
import com.intellij.notebooks.jupyter.core.icons.JupyterCoreIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0003J \u0010\u0014\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u001a\u0010\u001c\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u0012H\u0003J\u0010\u0010\u001f\u001a\u0004\u0018\u00010 *\u0004\u0018\u00010!H\u0002\u00a8\u0006\""}, d2={"Lcom/intellij/jupyter/py/connections/actions/JupyterServerChooserAction;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$BackendOnly;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getConnectionPresentationText", "", "managedServerConfiguration", "Lcom/intellij/jupyter/core/jupyter/connections/managed/JupyterRuntimeManagedServerInfo;", "currentSessionConfig", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterServerConfig;", "savedConfig", "createPopupActionGroup", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "askUserConfirmation", "", "config", "getJupyterServerExecutionStatusText", "execution", "Lcom/intellij/jupyter/core/jupyter/server/common/JupyterServerExecution;", "getIconForKernelState", "Ljavax/swing/Icon;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterExecutionState;", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterServerChooserAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterServerChooserAction.kt\ncom/intellij/jupyter/py/connections/actions/JupyterServerChooserAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1#2:236\n25#3:237\n1557#4:238\n1628#4,3:239\n*S KotlinDebug\n*F\n+ 1 JupyterServerChooserAction.kt\ncom/intellij/jupyter/py/connections/actions/JupyterServerChooserAction\n*L\n115#1:237\n148#1:238\n148#1:239,3\n*E\n"})
public final class JupyterServerChooserAction
extends DefaultActionGroup
implements DumbAware,
ActionRemoteBehaviorSpecification.BackendOnly {
    public JupyterServerChooserAction() {
        Presentation presentation;
        Presentation $this$_init__u24lambda_u240 = presentation = this.getTemplatePresentation();
        boolean bl = false;
        $this$_init__u24lambda_u240.putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
        $this$_init__u24lambda_u240.putClientProperty(ActionUtil.USE_SMALL_FONT_IN_TOOLBAR, (Object)true);
        $this$_init__u24lambda_u240.setPerformGroup(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        InputEvent inputEvent = e.getInputEvent();
        Object object = inputEvent != null ? inputEvent.getSource() : null;
        Component component = object instanceof Component ? (Component)object : null;
        if (component == null) {
            return;
        }
        Component component2 = component;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)e);
        if (backedNotebookVirtualFile == null || (backedNotebookVirtualFile = backedNotebookVirtualFile.getFile()) == null) {
            return;
        }
        BackedNotebookVirtualFile virtualFile = backedNotebookVirtualFile;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)this.createPopupActionGroup(e, project2, (VirtualFile)virtualFile), e.getDataContext(), null, true, null).showUnderneathOf(component2);
    }

    public void update(@NotNull AnActionEvent e) {
        Module module;
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        if (!JupyterPyExtensionsKt.isPyNotebook(dataContext)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterAnActionEventExtensionsKt.getNotebookFile((AnActionEvent)e);
        VirtualFile virtualFile2 = virtualFile = backedNotebookVirtualFile != null ? backedNotebookVirtualFile.getFile() : null;
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            v4 = ModuleUtilCore.findModuleForFile((VirtualFile)it, (Project)project2);
        } else {
            v4 = module = null;
        }
        if (module == null) {
            e.getPresentation().setText(JupyterBundle.message((String)"jupyter.file.outside.module", (Object[])new Object[0]));
            e.getPresentation().setEnabled(false);
            return;
        }
        JupyterExecutionState kernelState = JupyterConnectionActionExtensionsKt.getKernelState((AnActionEvent)e);
        e.getPresentation().setIcon(this.getIconForKernelState(kernelState));
        JupyterConnectionSettingsManager settingsManager = JupyterConnectionSettingsManager.Companion.getInstance();
        try {
            String string;
            JupyterNotebookRuntimeSettings runtimeSettings = JupyterConnectionActionExtensionsKt.getJupyterNotebookRuntimeSettings((AnActionEvent)e);
            JupyterServerConfig savedSettings = settingsManager.getConfigForVirtualFileOrDefault(virtualFile, project2);
            JupyterRuntimeManagedServerInfo jupyterRuntimeManagedServerInfo = JupyterManagedServerExtensionsKt.getJupyterManagedServerInfo(e);
            if (jupyterRuntimeManagedServerInfo == null) {
                jupyterRuntimeManagedServerInfo = JupyterManagedServerConfigurationProvider.Companion.getJupyterManagedServerConfiguration$default((JupyterManagedServerConfigurationProvider.Companion)JupyterManagedServerConfigurationProvider.Companion, (Module)module, null, (int)2, null);
            }
            JupyterRuntimeManagedServerInfo managedServerConfiguration = jupyterRuntimeManagedServerInfo;
            Presentation presentation = e.getPresentation();
            if (runtimeSettings == null) {
                string = this.getConnectionPresentationText(managedServerConfiguration, savedSettings, savedSettings);
            } else {
                JupyterNotebookRuntimeSettings jupyterNotebookRuntimeSettings = runtimeSettings;
                if (jupyterNotebookRuntimeSettings instanceof JupyterNotebookOfflineSettings || jupyterNotebookRuntimeSettings instanceof JupyterNotebookSessionSettings) {
                    string = this.getConnectionPresentationText(managedServerConfiguration, runtimeSettings.getConnectionSettings(), savedSettings);
                } else if (jupyterNotebookRuntimeSettings instanceof ManagedJupyterServerNotebookSessionSettings) {
                    string = this.getJupyterServerExecutionStatusText(((ManagedJupyterServerNotebookSessionSettings)runtimeSettings).getJupyterServerExecution(), savedSettings);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            presentation.setText(string);
        }
        catch (Throwable t) {
            if (t instanceof ControlFlowException) {
                throw t;
            }
            JupyterServerChooserAction $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterServerChooserAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn(t);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @NlsSafe
    private final String getConnectionPresentationText(JupyterRuntimeManagedServerInfo managedServerConfiguration, JupyterServerConfig currentSessionConfig, JupyterServerConfig savedConfig) {
        String string;
        JupyterServerConfig jupyterServerConfig = currentSessionConfig;
        if (jupyterServerConfig instanceof JupyterManagedServerConfig) {
            JupyterServerExecution currentExecution = JupyterManagedServerExecutionServiceProvider.Companion.getInstance().getManaged(managedServerConfiguration);
            string = this.getJupyterServerExecutionStatusText(currentExecution, savedConfig);
        } else if (jupyterServerConfig instanceof JupyterConfiguredServerConfig) {
            string = ((JupyterConfiguredServerConfig)currentSessionConfig).getName().toString();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final DefaultActionGroup createPopupActionGroup(AnActionEvent e, Project project, VirtualFile virtualFile) {
        Object[] objectArray;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        JupyterConnectionSettingsManager settingsManager = JupyterConnectionSettingsManager.Companion.getInstance();
        List connections = !(virtualFile instanceof JupyterRemoteVirtualFile) ? settingsManager.getAll() : CollectionsKt.emptyList();
        JupyterServerConfig selectedConnection = settingsManager.getConfigForVirtualFileOrDefault(virtualFile, project);
        Iterable $this$map$iv = connections;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void config;
            objectArray = (Object[])item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Icon icon = Intrinsics.areEqual((Object)config, (Object)selectedConnection) ? AllIcons.Actions.Checked : null;
            collection.add(DumbAwareAction.create((String)config.getName(), (Icon)icon, arg_0 -> JupyterServerChooserAction.createPopupActionGroup$lambda$4$lambda$3(arg_0 -> JupyterServerChooserAction.createPopupActionGroup$lambda$4$lambda$2((JupyterServerConfig)config, selectedConnection, this, project, virtualFile, settingsManager, arg_0), arg_0)));
        }
        List selectConnectionActions2 = (List)destination$iv$iv;
        AnAction openSettingsAction = ActionManager.getInstance().getAction("OpenJupyterSettingsAction");
        AnAction shutdownNotebookAction = ActionManager.getInstance().getAction("JupyterShutdownNotebookAction");
        AnAction switchKernelAction = ActionManager.getInstance().getAction("JupyterKernelManagementAction");
        AnAction connectToServer = ActionManager.getInstance().getAction("JupyterConnectToServerAction");
        Object object = JupyterManagedServerExtensionsKt.getCurrentKernel(e);
        if (object == null || (object = object.getDisplayName()) == null) {
            object = JupyterRemoteBundle.message((String)"separator.server.actions", (Object[])new Object[0]);
        }
        Object kernelSectionTitle = object;
        item$iv$iv2 = new AnAction[]{Separator.create((String)kernelSectionTitle), connectToServer, switchKernelAction, shutdownNotebookAction};
        List kernelActions = CollectionsKt.listOfNotNull(item$iv$iv2);
        objectArray = new AnAction[]{Separator.create(), openSettingsAction};
        List actionList = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)kernelActions, (Object)Separator.create((String)JupyterRemoteBundle.message((String)"separator.config.actions", (Object[])new Object[0]))), (Iterable)selectConnectionActions2), (Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
        return new DefaultActionGroup(actionList);
    }

    private final boolean askUserConfirmation(Project project, VirtualFile virtualFile, JupyterServerConfig config) {
        JupyterRuntimeService runtimeService = JupyterRuntimeService.Companion.getInstance(project);
        JupyterNotebookRuntimeSettings jupyterNotebookRuntimeSettings = runtimeService.getRuntime(virtualFile);
        if (jupyterNotebookRuntimeSettings == null) {
            return true;
        }
        JupyterNotebookRuntimeSettings runtime = jupyterNotebookRuntimeSettings;
        JupyterServerConfig runtimeConnection = runtime.getConnectionSettings();
        if (Intrinsics.areEqual((Object)config, (Object)runtimeConnection)) {
            return true;
        }
        Object[] objectArray = new Object[]{runtimeConnection.getName()};
        boolean isOk = Messages.showOkCancelDialog((Project)project, (String)JupyterRemoteBundle.message((String)"change.jupyter.config.dialog.confirm.message", (Object[])objectArray), (String)JupyterRemoteBundle.message((String)"change.jupyter.config.dialog.confirm.title", (Object[])new Object[0]), (String)Messages.getOkButton(), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon()) == 0;
        return isOk;
    }

    @Nls
    private final String getJupyterServerExecutionStatusText(JupyterServerExecution execution, JupyterServerConfig config) {
        String string;
        JupyterServerState state;
        JupyterServerExecution jupyterServerExecution = execution;
        Object object = state = jupyterServerExecution != null ? jupyterServerExecution.getState() : null;
        if (state == null || state instanceof JupyterServerStopped || state instanceof JupyterServerFinished) {
            Object[] objectArray = new Object[]{config.getName()};
            string = JupyterBundle.message((String)"Jupyter.managed.server.auto.start", (Object[])objectArray);
        } else if (state instanceof JupyterServerStarting) {
            Object[] objectArray = new Object[]{config.getName()};
            string = JupyterBundle.message((String)"Jupyter.managed.server.starting", (Object[])objectArray);
        } else if (state instanceof JupyterServerStarted) {
            Object[] objectArray = new Object[]{config.getName(), ((JupyterServerStarted)state).getConnectionParameters().getUri().toString()};
            string = JupyterBundle.message((String)"Jupyter.managed.server.running", (Object[])objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final Icon getIconForKernelState(JupyterExecutionState $this$getIconForKernelState) {
        JupyterExecutionState jupyterExecutionState = $this$getIconForKernelState;
        return switch (jupyterExecutionState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jupyterExecutionState.ordinal()]) {
            case 1 -> JupyterCoreIcons.Server.Jupyter_waiting;
            case 2 -> JupyterCoreIcons.Server.Jupyter_waiting;
            case 3 -> JupyterCoreIcons.Server.Jupyter_busy;
            case 4 -> JupyterCoreIcons.Server.Jupyter_error;
            case -1 -> JupyterCoreIcons.Server.Jupyter_stopped;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Unit createPopupActionGroup$lambda$4$lambda$2(JupyterServerConfig $config, JupyterServerConfig $selectedConnection, JupyterServerChooserAction this$0, Project $project, VirtualFile $virtualFile, JupyterConnectionSettingsManager $settingsManager, AnActionEvent it) {
        if (Intrinsics.areEqual((Object)$config, (Object)$selectedConnection)) {
            return Unit.INSTANCE;
        }
        if (!this$0.askUserConfirmation($project, $virtualFile, $config)) {
            return Unit.INSTANCE;
        }
        $settingsManager.setConfigForFile($virtualFile, $config);
        JupyterCoroutineKt.launchBackground((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($project, $virtualFile, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.$project = $project;
                this.$virtualFile = $virtualFile;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        JupyterRuntimeService runtimeService = JupyterRuntimeService.Companion.getInstance(this.$project);
                        runtimeService.clearRuntime(this.$virtualFile);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final void createPopupActionGroup$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterExecutionState.values().length];
            try {
                nArray[JupyterExecutionState.STARTING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterExecutionState.BUSY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterExecutionState.IDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterExecutionState.ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

