/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.managed;

import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerState;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionSettingsManager;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.jupyter.core.jupyter.server.JupyterManagedServerExecutionServiceProvider;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerExecution;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.module.Module;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0012J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c2\u0003J3\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/managed/JupyterRuntimeManagedServerInfo;", "", "configId", "", "module", "Lcom/intellij/openapi/module/Module;", "workingDirectory", "presentableName", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/module/Module;Ljava/lang/String;Ljava/lang/String;)V", "getConfigId", "()Ljava/lang/String;", "getModule", "()Lcom/intellij/openapi/module/Module;", "getWorkingDirectory", "displayName", "getDisplayName", "isJupyterServerStarted", "", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "intellij.jupyter.core"})
public final class JupyterRuntimeManagedServerInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String configId;
    @NotNull
    private final Module module;
    @Nullable
    private final String workingDirectory;
    @NotNull
    private final String presentableName;
    @NotNull
    private static final DataKey<JupyterRuntimeManagedServerInfo> DATA_KEY = DataKey.Companion.create("JupyterRuntimeManagedServerInfo");

    public JupyterRuntimeManagedServerInfo(@NotNull String configId, @NotNull Module module, @Nullable String workingDirectory, @NotNull String presentableName) {
        Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)presentableName, (String)"presentableName");
        this.configId = configId;
        this.module = module;
        this.workingDirectory = workingDirectory;
        this.presentableName = presentableName;
    }

    @NotNull
    public final String getConfigId() {
        return this.configId;
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    @Nullable
    public final String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @NotNull
    public final String getDisplayName() {
        JupyterServerConfig jupyterServerConfig = JupyterConnectionSettingsManager.Companion.getInstance().getConfig(this.configId);
        if (jupyterServerConfig == null) {
            return this.presentableName;
        }
        JupyterServerConfig instance = jupyterServerConfig;
        return instance.getName() + ": " + this.presentableName;
    }

    public final boolean isJupyterServerStarted() {
        JupyterServerExecution currentExecution = JupyterManagedServerExecutionServiceProvider.Companion.getInstance().getManaged(this);
        Object object = currentExecution;
        return object != null && (object = object.getState()) != null ? ((JupyterServerState)object).isStarted() : false;
    }

    @NotNull
    public final String component1() {
        return this.configId;
    }

    @NotNull
    public final Module component2() {
        return this.module;
    }

    @Nullable
    public final String component3() {
        return this.workingDirectory;
    }

    private final String component4() {
        return this.presentableName;
    }

    @NotNull
    public final JupyterRuntimeManagedServerInfo copy(@NotNull String configId, @NotNull Module module, @Nullable String workingDirectory, @NotNull String presentableName) {
        Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)presentableName, (String)"presentableName");
        return new JupyterRuntimeManagedServerInfo(configId, module, workingDirectory, presentableName);
    }

    public static /* synthetic */ JupyterRuntimeManagedServerInfo copy$default(JupyterRuntimeManagedServerInfo jupyterRuntimeManagedServerInfo, String string, Module module, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = jupyterRuntimeManagedServerInfo.configId;
        }
        if ((n & 2) != 0) {
            module = jupyterRuntimeManagedServerInfo.module;
        }
        if ((n & 4) != 0) {
            string2 = jupyterRuntimeManagedServerInfo.workingDirectory;
        }
        if ((n & 8) != 0) {
            string3 = jupyterRuntimeManagedServerInfo.presentableName;
        }
        return jupyterRuntimeManagedServerInfo.copy(string, module, string2, string3);
    }

    @NotNull
    public String toString() {
        return "JupyterRuntimeManagedServerInfo(configId=" + this.configId + ", module=" + this.module + ", workingDirectory=" + this.workingDirectory + ", presentableName=" + this.presentableName + ")";
    }

    public int hashCode() {
        int result = this.configId.hashCode();
        result = result * 31 + this.module.hashCode();
        result = result * 31 + (this.workingDirectory == null ? 0 : this.workingDirectory.hashCode());
        result = result * 31 + this.presentableName.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JupyterRuntimeManagedServerInfo)) {
            return false;
        }
        JupyterRuntimeManagedServerInfo jupyterRuntimeManagedServerInfo = (JupyterRuntimeManagedServerInfo)other;
        if (!Intrinsics.areEqual((Object)this.configId, (Object)jupyterRuntimeManagedServerInfo.configId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.module, (Object)jupyterRuntimeManagedServerInfo.module)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.workingDirectory, (Object)jupyterRuntimeManagedServerInfo.workingDirectory)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.presentableName, (Object)jupyterRuntimeManagedServerInfo.presentableName);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/managed/JupyterRuntimeManagedServerInfo$Companion;", "", "<init>", "()V", "DATA_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/jupyter/core/jupyter/connections/managed/JupyterRuntimeManagedServerInfo;", "getDATA_KEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<JupyterRuntimeManagedServerInfo> getDATA_KEY() {
            return DATA_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

