/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.execution.message.BytesWebSocketMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.StringWebSocketMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.WebSocketMessage;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.CellOutputBounds;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.JupyterPreviewMessageListener;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.JupyterSocketValve;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.JupyterStopMessage;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.messages.BackToFrontMessage;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.messages.BackToFrontRepaintOutputsMessage;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.messages.BackToFrontScrollToOffsetMessage;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.messages.UpdateOutputs;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.messages.WidgetStateMessage;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.models.BackToFrontScriptMessage;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.models.ScriptLoaderMessageType;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.providers.local.ScriptUriConverter;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.webHandlers.JupyterCefWebSocketListener;
import com.intellij.jupyter.core.jupyter.messages.JupyterKernelToFrontEndApi;
import com.intellij.jupyter.core.jupyter.messages.JupyterMessageBuffer;
import com.intellij.jupyter.core.jupyter.messages.JupyterMessageWrapper;
import com.intellij.jupyter.core.jupyter.messages.MessageSink;
import com.intellij.jupyter.core.jupyter.messages.processors.JupyterMessageProcessor;
import com.intellij.jupyter.core.jupyter.messages.processors.JupyterMessageProcessorFacadeKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.webSocket.WebSocketClient;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001EB\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u001eH\u0016J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0016J\u0015\u0010)\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\b,J\u001f\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u000101H\u0000\u00a2\u0006\u0002\b2J\u0015\u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u000205H\u0000\u00a2\u0006\u0002\b6J\u001f\u00107\u001a\u00020\u001e2\u000e\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020(09H\u0000\u00a2\u0006\u0004\b:\u0010;J\u0015\u0010<\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020>H\u0000\u00a2\u0006\u0002\b?J\b\u0010@\u001a\u00020\u001eH\u0016J\u0010\u0010A\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020DH\u0002R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00120\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/JupyterPreviewApiSocket;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/webHandlers/JupyterCefWebSocketListener;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/jupyter/core/jupyter/messages/JupyterKernelToFrontEndApi;", "listener", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/JupyterPreviewMessageListener;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/JupyterPreviewMessageListener;Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "getVirtualFile", "()Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "messageSink", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/JupyterPreviewApiSocket$MessageSinkImpl;", "messageBuffer", "Lcom/intellij/jupyter/core/jupyter/messages/JupyterMessageBuffer;", "Lkotlin/Pair;", "", "", "timer", "Ljava/util/concurrent/ScheduledExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "valve", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/JupyterSocketValve;", "messageProcessors", "", "Lcom/intellij/jupyter/core/jupyter/messages/processors/JupyterMessageProcessor;", "clientConnected", "", "client", "Lorg/jetbrains/io/webSocket/WebSocketClient;", "clientDisconnected", "messageFromFrontEndArrived", "message", "", "resolveFilePath", "Ljava/nio/file/Path;", "path", "", "updateOutputs", "outputs", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/messages/UpdateOutputs;", "updateOutputs$intellij_jupyter_core", "setWidgetScriptResponse", "code", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/scriptLoader/models/ScriptLoaderMessageType;", "payload", "", "setWidgetScriptResponse$intellij_jupyter_core", "scrollToOffset", "offset", "", "scrollToOffset$intellij_jupyter_core", "repaintOutputs", "outputIds", "", "repaintOutputs$intellij_jupyter_core", "([Ljava/lang/String;)V", "setWidgetState", "state", "Lcom/fasterxml/jackson/databind/JsonNode;", "setWidgetState$intellij_jupyter_core", "dispose", "sendMessageToSink", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "sendIntellijMessage", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/messages/BackToFrontMessage;", "MessageSinkImpl", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterPreviewApiSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterPreviewApiSocket.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/JupyterPreviewApiSocket\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public final class JupyterPreviewApiSocket
implements JupyterCefWebSocketListener,
Disposable,
JupyterKernelToFrontEndApi {
    @NotNull
    private final BackedNotebookVirtualFile virtualFile;
    @Nullable
    private volatile MessageSinkImpl messageSink;
    @NotNull
    private final JupyterMessageBuffer<Pair<byte[], Boolean>> messageBuffer;
    @NotNull
    private final ScheduledExecutorService timer;
    @NotNull
    private final JupyterSocketValve<Pair<byte[], Boolean>> valve;
    @NotNull
    private final List<JupyterMessageProcessor<?>> messageProcessors;

    public JupyterPreviewApiSocket(@NotNull JupyterPreviewMessageListener listener, @NotNull Project project, @NotNull BackedNotebookVirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        this.virtualFile = virtualFile2;
        this.messageBuffer = new JupyterMessageBuffer(() -> JupyterPreviewApiSocket.messageBuffer$lambda$0(this));
        ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"Jupyter socket", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"createBoundedScheduledExecutorService(...)");
        this.timer = scheduledExecutorService;
        this.valve = new JupyterSocketValve(this.timer, () -> JupyterPreviewApiSocket.valve$lambda$1(this));
        this.messageProcessors = JupyterMessageProcessorFacadeKt.createStandardMessageProcessors(listener, (TypeReference<CellOutputBounds[]>)((TypeReference)new TypeReference<CellOutputBounds[]>(){}), project, this.getVirtualFile(), this);
        this.timer.scheduleWithFixedDelay(() -> JupyterPreviewApiSocket._init_$lambda$2(this), 10L, 10L, TimeUnit.SECONDS);
    }

    @Override
    @NotNull
    public BackedNotebookVirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clientConnected(@NotNull WebSocketClient client) {
        void it;
        MessageSinkImpl messageSinkImpl;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        MessageSinkImpl messageSinkImpl2 = messageSinkImpl = new MessageSinkImpl(client);
        JupyterPreviewApiSocket jupyterPreviewApiSocket = this;
        boolean bl = false;
        this.messageBuffer.purge((MessageSink)it);
        jupyterPreviewApiSocket.messageSink = messageSinkImpl;
    }

    @Override
    public void clientDisconnected() {
        this.messageSink = null;
    }

    @Override
    public void messageFromFrontEndArrived(@NotNull CharSequence message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        JupyterMessageWrapper messageWrapper = JupyterMessageWrapper.Companion.fromString(((Object)message).toString());
        messageWrapper.process((Iterable)this.messageProcessors);
    }

    @Override
    @Nullable
    public Path resolveFilePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        VirtualFile file = this.getVirtualFile().getFile();
        if (StringsKt.startsWith$default((String)path, (String)"BASE_EXTENSION_PATH", (boolean)false, (int)2, null)) {
            Path path2 = (Path)this.getVirtualFile().getFile().getUserData(ScriptUriConverter.Companion.getBASE_EXTENSION_PATH_KEY());
            if (path2 == null) {
                return null;
            }
            Path sourcePath = path2;
            String clearSubPath = StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)path, (CharSequence)"BASE_EXTENSION_PATH"), (CharSequence)"/"), (CharSequence)"\\");
            clearSubPath = StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)clearSubPath, (CharSequence)"BASE_EXTENSION_PATH"), (CharSequence)"/"), (CharSequence)"\\");
            Path resolve = sourcePath.resolve(clearSubPath);
            return resolve;
        }
        if (!file.isInLocalFileSystem()) {
            return null;
        }
        VirtualFile parent = file.getParent();
        if (!parent.isDirectory()) {
            return null;
        }
        return parent.toNioPath().toAbsolutePath().resolve(path);
    }

    public final void updateOutputs$intellij_jupyter_core(@NotNull UpdateOutputs outputs) {
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        this.sendIntellijMessage(outputs);
    }

    public final void setWidgetScriptResponse$intellij_jupyter_core(@NotNull ScriptLoaderMessageType code, @Nullable Object payload) {
        Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
        this.sendIntellijMessage(new BackToFrontScriptMessage(code.getCode(), payload));
    }

    public final void scrollToOffset$intellij_jupyter_core(int offset) {
        this.sendIntellijMessage(new BackToFrontScrollToOffsetMessage(offset));
    }

    public final void repaintOutputs$intellij_jupyter_core(@NotNull String[] outputIds) {
        Intrinsics.checkNotNullParameter((Object)outputIds, (String)"outputIds");
        this.sendIntellijMessage(new BackToFrontRepaintOutputsMessage(outputIds));
    }

    public final void setWidgetState$intellij_jupyter_core(@NotNull JsonNode state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.sendIntellijMessage(new WidgetStateMessage(state));
    }

    public void dispose() {
        MessageSinkImpl messageSinkImpl = this.messageSink;
        if (messageSinkImpl != null && (messageSinkImpl = messageSinkImpl.getClient()) != null) {
            messageSinkImpl.disconnect(new CloseWebSocketFrame());
        }
        this.messageSink = null;
        this.timer.shutdown();
    }

    @Override
    public void sendMessageToSink(@NotNull JupyterMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (message instanceof JupyterStopMessage) {
            this.valve.closeValve();
            return;
        }
        WebSocketMessage data = message.serialize();
        if (data instanceof BytesWebSocketMessage) {
            this.valve.sendMessageToSink((Pair<byte[], Boolean>)new Pair((Object)((BytesWebSocketMessage)data).getBytes().array(), (Object)true));
        } else if (data instanceof StringWebSocketMessage) {
            byte[] byArray = ((StringWebSocketMessage)data).getString().getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            this.valve.sendMessageToSink((Pair<byte[], Boolean>)new Pair((Object)byArray, (Object)false));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void sendIntellijMessage(BackToFrontMessage message) {
        this.messageBuffer.sendMessageToSink((Pair<byte[], Boolean>)new Pair((Object)JupyterJsonKt.getJackson().writeValueAsBytes((Object)message), (Object)false));
    }

    private static final MessageSink messageBuffer$lambda$0(JupyterPreviewApiSocket this$0) {
        return this$0.messageSink;
    }

    private static final JupyterMessageBuffer valve$lambda$1(JupyterPreviewApiSocket this$0) {
        return this$0.messageBuffer;
    }

    private static final void _init_$lambda$2(JupyterPreviewApiSocket this$0) {
        block0: {
            MessageSinkImpl messageSinkImpl = this$0.messageSink;
            if (messageSinkImpl == null || (messageSinkImpl = messageSinkImpl.getClient()) == null) break block0;
            messageSinkImpl.sendHeartbeat();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/JupyterPreviewApiSocket$MessageSinkImpl;", "Lcom/intellij/jupyter/core/jupyter/messages/MessageSink;", "Lkotlin/Pair;", "", "", "client", "Lorg/jetbrains/io/webSocket/WebSocketClient;", "<init>", "(Lorg/jetbrains/io/webSocket/WebSocketClient;)V", "getClient", "()Lorg/jetbrains/io/webSocket/WebSocketClient;", "sendMessageToSink", "", "message", "intellij.jupyter.core"})
    private static final class MessageSinkImpl
    implements MessageSink<Pair<? extends byte[], ? extends Boolean>> {
        @NotNull
        private final WebSocketClient client;

        public MessageSinkImpl(@NotNull WebSocketClient client) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            this.client = client;
        }

        @NotNull
        public final WebSocketClient getClient() {
            return this.client;
        }

        @Override
        public void sendMessageToSink(@NotNull Pair<byte[], Boolean> message) {
            Intrinsics.checkNotNullParameter(message, (String)"message");
            this.client.sendFrame(Unpooled.wrappedBuffer((byte[])((byte[])message.getFirst())), ((Boolean)message.getSecond()).booleanValue());
        }
    }
}

