/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.mssql.MsDialect;
import com.intellij.database.dialects.mssql.TsqlDmlHelper;
import com.intellij.database.model.DasTable;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/mssql/MsDmlHelper;", "Lcom/intellij/database/dialects/mssql/TsqlDmlHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "supportsInsertDefaultValues", "", "getSupportsInsertDefaultValues", "()Z", "hasRowId", "table", "Lcom/intellij/database/model/DasTable;", "version", "Lcom/intellij/database/util/Version;", "appendRowId", "Lcom/intellij/database/util/DdlBuilder;", "builder", "alias", "", "intellij.database.dialects.mssql"})
public final class MsDmlHelper
extends TsqlDmlHelper {
    public MsDmlHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Override
    public boolean getSupportsInsertDefaultValues() {
        return true;
    }

    @Override
    public boolean hasRowId(@NotNull DasTable table, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        return this.getDbms().eq(Dbms.AZURE) || this.getDbms().eq(Dbms.MSSQL) && MsDialect.isMsSql2008(version);
    }

    @Override
    @NotNull
    public DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        DdlBuilder ddlBuilder = builder.symbol(",").space().literal("%%physloc%% as \"%%physloc%%\"");
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"literal(...)");
        return ddlBuilder;
    }
}

