/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.DefiniteIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.MultiDatabaseIntrospectionTaskHelper;
import com.intellij.database.introspection.SingleDatabaseIntrospectionTaskHelper;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicMultiDatabaseRoot;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSingleDatabaseRoot;
import com.intellij.database.util.ObjectPath;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH&J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH&J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000fH&J(\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/introspection/IntrospectionTaskHelper;", "", "<init>", "()V", "root", "Lcom/intellij/database/model/basic/BasicRoot;", "getRoot", "()Lcom/intellij/database/model/basic/BasicRoot;", "specifiedDatabaseOf", "Lcom/intellij/database/model/basic/BasicDatabase;", "task", "Lcom/intellij/database/introspection/IntrospectionTask;", "databaseOf", "databaseIsKnown", "", "Lcom/intellij/database/introspection/DefiniteIntrospectionTask;", "distributeObjectPathsBetweenDatabases", "", "Lcom/intellij/database/model/basic/BasicNamespaceOwner;", "", "Lcom/intellij/database/util/ObjectPath;", "paths", "", "Companion", "Lcom/intellij/database/introspection/MultiDatabaseIntrospectionTaskHelper;", "Lcom/intellij/database/introspection/SingleDatabaseIntrospectionTaskHelper;", "intellij.database.core.impl"})
@ApiStatus.Internal
public abstract class IntrospectionTaskHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private IntrospectionTaskHelper() {
    }

    @NotNull
    public abstract BasicRoot getRoot();

    @Nullable
    public abstract BasicDatabase specifiedDatabaseOf(@NotNull IntrospectionTask var1);

    @Nullable
    public abstract BasicDatabase databaseOf(@NotNull IntrospectionTask var1);

    public abstract boolean databaseIsKnown(@NotNull DefiniteIntrospectionTask var1);

    @NotNull
    public abstract Map<BasicNamespaceOwner, Set<ObjectPath>> distributeObjectPathsBetweenDatabases(@NotNull Collection<? extends ObjectPath> var1);

    @JvmStatic
    @NotNull
    public static final IntrospectionTaskHelper prepareHelper(@NotNull BasicRoot root) {
        return Companion.prepareHelper(root);
    }

    public /* synthetic */ IntrospectionTaskHelper(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/introspection/IntrospectionTaskHelper$Companion;", "", "<init>", "()V", "prepareHelper", "Lcom/intellij/database/introspection/IntrospectionTaskHelper;", "root", "Lcom/intellij/database/model/basic/BasicRoot;", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IntrospectionTaskHelper prepareHelper(@NotNull BasicRoot root) {
            IntrospectionTaskHelper introspectionTaskHelper;
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            BasicRoot basicRoot = root;
            if (basicRoot instanceof BasicSingleDatabaseRoot) {
                introspectionTaskHelper = new SingleDatabaseIntrospectionTaskHelper((BasicSingleDatabaseRoot)root);
            } else if (basicRoot instanceof BasicMultiDatabaseRoot) {
                introspectionTaskHelper = new MultiDatabaseIntrospectionTaskHelper((BasicMultiDatabaseRoot)root);
            } else {
                throw new IllegalArgumentException("Bad root class: " + root.getClass().getName());
            }
            return introspectionTaskHelper;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

