/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.basic.ByteConverter;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.core.StringCodec;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class EncodedByteArrayConverter
implements Converter,
SingleValueConverter {
    private static final ByteConverter byteConverter = new ByteConverter();
    private final StringCodec codec;

    public EncodedByteArrayConverter() {
        this(JVM.getBase64Codec());
    }

    public EncodedByteArrayConverter(StringCodec stringCodec) {
        this.codec = stringCodec;
    }

    public boolean canConvert(Class type) {
        return type != null && type.isArray() && type.getComponentType().equals(Byte.TYPE);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.setValue(this.toString(source));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String data = reader.getValue();
        if (!reader.hasMoreChildren()) {
            return this.fromString(data);
        }
        return this.unmarshalIndividualByteElements(reader, context);
    }

    private Object unmarshalIndividualByteElements(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<Object> bytes2 = new ArrayList<Object>();
        boolean firstIteration = true;
        while (firstIteration || reader.hasMoreChildren()) {
            reader.moveDown();
            bytes2.add(byteConverter.fromString(reader.getValue()));
            reader.moveUp();
            firstIteration = false;
        }
        byte[] result2 = new byte[bytes2.size()];
        int i2 = 0;
        Iterator iterator = bytes2.iterator();
        while (iterator.hasNext()) {
            Byte b = (Byte)iterator.next();
            result2[i2] = b;
            ++i2;
        }
        return result2;
    }

    public String toString(Object obj2) {
        return this.codec.encode((byte[])obj2);
    }

    public Object fromString(String str) {
        return this.codec.decode(str);
    }
}

