/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.filter;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilter;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilterSource;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.DirectoryUtils;

public abstract class RemoteRepositoryFilterSourceSupport
implements RemoteRepositoryFilterSource {
    private static final String CONFIG_PROP_PREFIX = "aether.remoteRepositoryFilter.";
    private static final String CONF_NAME_BASEDIR = "basedir";
    static final String LOCAL_REPO_PREFIX_DIR = ".remoteRepositoryFilters";
    private final String name;

    protected RemoteRepositoryFilterSourceSupport(String name2) {
        this.name = Objects.requireNonNull(name2);
    }

    protected String configPropKey(String name2) {
        return CONFIG_PROP_PREFIX + this.name + "." + name2;
    }

    protected boolean isEnabled(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, false, CONFIG_PROP_PREFIX + this.name);
    }

    protected Path getBasedir(RepositorySystemSession session, boolean mayCreate) {
        try {
            return DirectoryUtils.resolveDirectory(session, LOCAL_REPO_PREFIX_DIR, this.configPropKey(CONF_NAME_BASEDIR), mayCreate);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected static class SimpleResult
    implements RemoteRepositoryFilter.Result {
        private final boolean accepted;
        private final String reasoning;

        public SimpleResult(boolean accepted, String reasoning) {
            this.accepted = accepted;
            this.reasoning = Objects.requireNonNull(reasoning);
        }

        @Override
        public boolean isAccepted() {
            return this.accepted;
        }

        @Override
        public String reasoning() {
            return this.reasoning;
        }
    }
}

