/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.qml.formatter;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.qml.QmlBundle;
import com.intellij.lang.qml.settings.QmlSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.IndentStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.psi.codeStyle.statusbar.CodeStyleStatusBarWidgetFactory;
import com.intellij.qt.common.settings.QtSettings;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QmlFormatStatusUIContributor
extends IndentStatusBarUIContributor {
    private final PsiFile myAnchorCodeFile;

    @Nullable
    private static PsiFile getAnchorFile(@NotNull PsiFile codeFile) {
        PsiElement context;
        if (codeFile == null) {
            QmlFormatStatusUIContributor.$$$reportNull$$$0(0);
        }
        if ((context = codeFile.getContext()) != null && context.getContainingFile() != codeFile) {
            return QmlFormatStatusUIContributor.getAnchorFile(context.getContainingFile());
        }
        VirtualFile vf = codeFile.getViewProvider().getVirtualFile();
        return vf.isInLocalFileSystem() && !ScratchUtil.isScratch((VirtualFile)vf) ? codeFile : null;
    }

    public QmlFormatStatusUIContributor(@NotNull TransientCodeStyleSettings transientSettings) {
        if (transientSettings == null) {
            QmlFormatStatusUIContributor.$$$reportNull$$$0(1);
        }
        super(CommonCodeStyleSettings.IndentOptions.DEFAULT_INDENT_OPTIONS);
        @Nullable PsiFile file = transientSettings.getPsiFile();
        this.myAnchorCodeFile = file == null ? null : QmlFormatStatusUIContributor.getAnchorFile(file);
    }

    public boolean areActionsAvailable(@NotNull VirtualFile file) {
        if (file == null) {
            QmlFormatStatusUIContributor.$$$reportNull$$$0(2);
        }
        return true;
    }

    public AnAction @Nullable [] getActions(@NotNull PsiFile file) {
        if (file == null) {
            QmlFormatStatusUIContributor.$$$reportNull$$$0(3);
        }
        if (this.myAnchorCodeFile == null) {
            return AnAction.EMPTY_ARRAY;
        }
        QmlSettings qmlSettings = QmlSettings.getInstance(this.myAnchorCodeFile.getProject());
        ArrayList<DumbAwareAction> actions = new ArrayList<DumbAwareAction>();
        QtSettings qtSettings = QtSettings.getInstance((Project)this.myAnchorCodeFile.getProject());
        if (qmlSettings.isQmlFormatEnabledAndExists(qtSettings.getCurrentProfile())) {
            actions.add(DumbAwareAction.create((String)QmlBundle.message("configurable.qml.disable.qmlformat", new Object[0]), e -> qmlSettings.setQmlFormatEnabled(qtSettings.getCurrentProfile(), false)));
        } else {
            actions.add(CodeStyleStatusBarWidgetFactory.createDefaultIndentConfigureAction((PsiFile)this.myAnchorCodeFile));
            if (!qmlSettings.findQmlFormatPath().isEmpty()) {
                actions.add(DumbAwareAction.create((String)QmlBundle.message("configurable.qml.enable.qmlformat", new Object[0]), e -> qmlSettings.setQmlFormatEnabled(qtSettings.getCurrentProfile(), true)));
            }
        }
        return actions.toArray(AnAction.EMPTY_ARRAY);
    }

    @Nullable
    public AnAction createDisableAction(@NotNull Project project) {
        if (project == null) {
            QmlFormatStatusUIContributor.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Nullable
    public String getHint() {
        QtSettings qtSettings;
        if (this.myAnchorCodeFile == null) {
            return null;
        }
        QmlSettings qmlSettings = QmlSettings.getInstance(this.myAnchorCodeFile.getProject());
        if (qmlSettings.isQmlFormatEnabledAndExists((qtSettings = QtSettings.getInstance((Project)this.myAnchorCodeFile.getProject())).getCurrentProfile())) {
            return "`qmlformat`";
        }
        return null;
    }

    @NotNull
    public String getStatusText(@NotNull PsiFile codeFile) {
        QtSettings qtSettings;
        QmlSettings qmlSettings;
        if (codeFile == null) {
            QmlFormatStatusUIContributor.$$$reportNull$$$0(5);
        }
        if ((qmlSettings = QmlSettings.getInstance(this.myAnchorCodeFile.getProject())).isQmlFormatEnabledAndExists((qtSettings = QtSettings.getInstance((Project)this.myAnchorCodeFile.getProject())).getCurrentProfile())) {
            return "`qmlformat`";
        }
        String string = super.getStatusText(codeFile);
        if (string == null) {
            QmlFormatStatusUIContributor.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isShowFileIndentOptionsEnabled() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transientSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/qml/formatter/QmlFormatStatusUIContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/qml/formatter/QmlFormatStatusUIContributor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "areActionsAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDisableAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStatusText";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

