/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import com.github.kittinunf.fuel.FuelKt;
import com.github.kittinunf.fuel.core.Response;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.api.ToDataFrameKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.ConstructorsKt;
import org.jetbrains.kotlinx.dataframe.io.JsonKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a4\u0010\u0004\u001a\n\u0012\u0002\b\u00030\u0005j\u0002`\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u001a\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0002\b\u00030\u0005j\u0002`\u00060\bH\u0000\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a.\u0010\u0011\u001a\n\u0012\u0002\b\u00030\u0005j\u0002`\u0006\"\u0004\b\u0000\u0010\u0012*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\u00130\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u000b\u00a8\u0006\u0015"}, d2={"asFileOrNull", "Ljava/io/File;", "url", "Ljava/net/URL;", "catchHttpResponse", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "body", "Lkotlin/Function1;", "Ljava/io/InputStream;", "isFile", "", "isProtocolSupported", "isURL", "path", "", "urlAsFile", "toDataFrame", "T", "", "containsColumns", "core"})
@SourceDebugExtension(value={"SMAP\ncommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 common.kt\norg/jetbrains/kotlinx/dataframe/io/CommonKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1603#2,9:62\n1855#2:71\n1856#2:73\n1612#2:74\n1549#2:75\n1620#2,3:76\n1559#2:79\n1590#2,3:80\n1549#2:83\n1620#2,3:84\n1593#2:87\n1747#2,3:88\n1#3:72\n*S KotlinDebug\n*F\n+ 1 common.kt\norg/jetbrains/kotlinx/dataframe/io/CommonKt\n*L\n31#1:62,9\n31#1:71\n31#1:73\n31#1:74\n40#1:75\n40#1:76,3\n42#1:79\n42#1:80,3\n43#1:83\n43#1:84,3\n42#1:87\n52#1:88,3\n31#1:72\n*E\n"})
public final class CommonKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> catchHttpResponse(@NotNull URL url, @NotNull Function1<? super InputStream, ? extends DataFrame<?>> body) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        try {
            Object object;
            Closeable closeable = url.openStream();
            Throwable throwable = null;
            try {
                object = body.invoke((Object)closeable);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return (DataFrame)object;
        }
        catch (IOException e) {
            String string = e.getMessage();
            boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"Server returned HTTP response code", (boolean)false, (int)2, null) : false;
            if (bl) {
                String string2 = url.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                Response response = (Response)FuelKt.httpGet$default((String)string2, null, (int)1, null).responseString().component2();
                try {
                    return JsonKt.readJsonStr$default(DataFrame.Companion, StringsKt.decodeToString((byte[])response.getData()), null, null, null, 14, null);
                }
                catch (Exception e2) {
                    throw e;
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> DataFrame<?> toDataFrame(@NotNull List<? extends List<? extends T>> $this$toDataFrame, boolean containsColumns) {
        DataFrame<?> dataFrame;
        Intrinsics.checkNotNullParameter($this$toDataFrame, (String)"<this>");
        if (containsColumns) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = $this$toDataFrame;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                DataColumn dataColumn;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                List it = (List)element$iv$iv;
                boolean bl2 = false;
                if (it.isEmpty()) {
                    dataColumn = null;
                } else {
                    String name = String.valueOf(it.get(0));
                    List values2 = CollectionsKt.drop((Iterable)it, (int)1);
                    dataColumn = ConstructorsKt.guessColumnType(name, values2);
                }
                if (dataColumn == null) continue;
                DataColumn it$iv$iv = dataColumn;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            dataFrame = ToDataFrameKt.toDataFrameAnyColumn((List)destination$iv$iv);
        } else if ($this$toDataFrame.isEmpty()) {
            dataFrame = DataFrame.Companion.getEmpty();
        } else {
            void $this$mapIndexedTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$toDataFrame.get(0);
            boolean $i$f$map = false;
            Iterable destination$iv$iv = $this$map$iv;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator $i$f$forEach = $this$mapTo$iv$iv.iterator();
            while ($i$f$forEach.hasNext()) {
                void it;
                Object item$iv$iv;
                Object element$iv$iv$iv = item$iv$iv = $i$f$forEach.next();
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(String.valueOf(it));
            }
            List header = (List)destination$iv$iv2;
            List data2 = CollectionsKt.drop((Iterable)$this$toDataFrame, (int)1);
            Iterable $this$mapIndexed$iv = header;
            boolean $i$f$mapIndexed = false;
            destination$iv$iv2 = $this$mapIndexed$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void name;
                void $this$mapTo$iv$iv2;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String it = (String)item$iv$iv;
                int bl2 = n;
                collection = destination$iv$iv3;
                boolean bl = false;
                Iterable $this$map$iv2 = data2;
                boolean $i$f$map2 = false;
                Iterable bl3 = $this$map$iv2;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void colIndex;
                    void row;
                    List list = (List)item$iv$iv2;
                    Collection collection2 = destination$iv$iv4;
                    boolean bl4 = false;
                    collection2.add(row.size() <= colIndex ? null : (Object)row.get((int)colIndex));
                }
                List values3 = (List)destination$iv$iv4;
                collection.add(ConstructorsKt.guessColumnType((String)name, values3));
            }
            dataFrame = ToDataFrameKt.toDataFrameAnyColumn((List)destination$iv$iv3);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame toDataFrame$default(List list, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return CommonKt.toDataFrame(list, bl);
    }

    public static final boolean isURL(@NotNull String path) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Object[] objectArray = new String[]{"http:", "https:", "ftp:"};
            Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)path, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isFile(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return Intrinsics.areEqual((Object)url.getProtocol(), (Object)"file");
    }

    @Nullable
    public static final File asFileOrNull(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return CommonKt.isFile(url) ? new File(url.getPath()) : null;
    }

    @NotNull
    public static final File urlAsFile(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new File(url.toURI());
    }

    public static final boolean isProtocolSupported(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object[] objectArray = new String[]{"http", "https", "ftp"};
        return SetsKt.setOf((Object[])objectArray).contains(url.getProtocol());
    }
}

