/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.python;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.api.BuildFileProvider;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.model.Dependency;
import com.intellij.packageChecker.model.SourcedDependency;
import com.intellij.packageChecker.model.impl.MutableModuleModel;
import com.intellij.packageChecker.model.impl.ProjectDependenciesModelBase;
import com.intellij.packageChecker.python.PythonBuildFileProvider;
import com.intellij.packageChecker.python.utils.UtilsKt;
import com.intellij.packageChecker.toolwindow.DependencyContext;
import com.intellij.psi.PsiElement;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.python.packaging.PyRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.Package;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000fH&J\b\u0010\u0013\u001a\u00020\u0014H&J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u001e\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0014J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/packageChecker/python/PyPIProjectDependenciesModel;", "Lcom/intellij/packageChecker/model/impl/ProjectDependenciesModelBase;", "Lcom/intellij/packageChecker/model/impl/MutableModuleModel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "buildFileName", "", "getBuildFileName", "()Ljava/lang/String;", "findBuildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "getBuildFileSpecificRequirements", "", "Lcom/jetbrains/python/packaging/PyRequirement;", "findCorrespondingBuildFileProvider", "Lcom/intellij/packageChecker/api/BuildFileProvider;", "supports", "", "copyModule", "newDependencies", "", "Lcom/intellij/packageChecker/model/Dependency;", "getAllModules", "intellij.packageChecker.python"})
@SourceDebugExtension(value={"SMAP\nPyPIProjectDependenciesModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPIProjectDependenciesModel.kt\ncom/intellij/packageChecker/python/PyPIProjectDependenciesModel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n11476#2,9:110\n13402#2:119\n13403#2:123\n11485#2:124\n216#3,2:120\n1#4:122\n1187#5,2:125\n1261#5,4:127\n*S KotlinDebug\n*F\n+ 1 PyPIProjectDependenciesModel.kt\ncom/intellij/packageChecker/python/PyPIProjectDependenciesModel\n*L\n54#1:110,9\n54#1:119\n54#1:123\n54#1:124\n76#1:120,2\n54#1:122\n67#1:125,2\n67#1:127,4\n*E\n"})
public abstract class PyPIProjectDependenciesModel
extends ProjectDependenciesModelBase<MutableModuleModel>
implements Disposable {
    @NotNull
    private final Project project;

    public PyPIProjectDependenciesModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CompletableJob completableJob = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        String string = PyPIProjectDependenciesModel.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        super(completableJob.plus((CoroutineContext)new CoroutineName(string)));
        this.project = project;
        this.init();
    }

    @NotNull
    public abstract String getBuildFileName();

    @Nullable
    public abstract VirtualFile findBuildFile(@NotNull Module var1);

    @NotNull
    public abstract List<PyRequirement> getBuildFileSpecificRequirements(@NotNull Module var1);

    @NotNull
    public abstract BuildFileProvider findCorrespondingBuildFileProvider();

    @Override
    public boolean supports(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ProjectDependenciesModelBase.Companion.isModelSupportedByProject(project, this.getBuildFileName());
    }

    @Override
    @NotNull
    protected MutableModuleModel copyModule(@NotNull MutableModuleModel module, @NotNull Iterable<? extends Dependency> newDependencies) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(newDependencies, (String)"newDependencies");
        return module.withDependencies(newDependencies);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<MutableModuleModel> getAllModules() {
        void $this$mapNotNullTo$iv$iv;
        Module[] $this$mapNotNull$iv = ModuleManager.Companion.getInstance(this.project).getModules();
        boolean $i$f$mapNotNull = false;
        Module[] moduleArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            MutableModuleModel mutableModuleModel;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void module = element$iv$iv;
            boolean bl2 = false;
            ProgressManager.checkCanceled();
            ThreadingAssertions.assertBackgroundThread();
            if (this.findBuildFile((Module)module) == null) {
                mutableModuleModel = null;
            } else {
                VirtualFile buildFile;
                Set set;
                ProgressManager.checkCanceled();
                List<PyRequirement> declaredPyRequirements = this.getBuildFileSpecificRequirements((Module)module);
                Map<PyRequirement, Package> requirementToImportedPackages = ((PythonBuildFileProvider)BuildFileProvider.Companion.getEP_NAME().findExtensionOrFail(PythonBuildFileProvider.class, (AreaInstance)this.project)).requirementToImportedPackage((Module)module, declaredPyRequirements);
                Map packageDeclarations = (Map)ReadAction.compute(() -> PyPIProjectDependenciesModel.getAllModules$lambda$5$lambda$1(this, (Module)module));
                List<VirtualFile> sourcesRootDirectory = UtilsKt.sourceRootDirectories((Module)module);
                Set $this$getAllModules_u24lambda_u245_u24lambda_u244 = set = SetsKt.createSetBuilder();
                boolean bl3 = false;
                Map<PyRequirement, Package> $this$forEach$iv = requirementToImportedPackages;
                boolean $i$f$forEach2 = false;
                Iterator<Map.Entry<PyRequirement, Package>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<PyRequirement, Package> element$iv;
                    Map.Entry<PyRequirement, Package> entry = element$iv = iterator.next();
                    boolean bl4 = false;
                    PyRequirement requirements = entry.getKey();
                    Package importedPackage = entry.getValue();
                    ProgressManager.checkCanceled();
                    Package package_ = importedPackage;
                    if (package_ == null) {
                        package_ = UtilsKt.toPackage(requirements);
                    }
                    Package modulePackage = package_;
                    DependencyContext dependencyContext = new DependencyContext(this.project, (Module)module, buildFile, null, (arg_0, arg_1, arg_2) -> PyPIProjectDependenciesModel.getAllModules$lambda$5$lambda$4$lambda$3$lambda$2(packageDeclarations, modulePackage, arg_0, arg_1, arg_2), 8, null);
                    if (!((Collection)sourcesRootDirectory).isEmpty() && importedPackage != null) {
                        List<VirtualFile> sourceDirectories = UtilsKt.sourceDirectories(sourcesRootDirectory, modulePackage);
                        if (!(!((Collection)sourceDirectories).isEmpty())) continue;
                        $this$getAllModules_u24lambda_u245_u24lambda_u244.add(new SourcedDependency(modulePackage, SetsKt.emptySet(), dependencyContext, sourceDirectories));
                        continue;
                    }
                    $this$getAllModules_u24lambda_u245_u24lambda_u244.add(new Dependency(modulePackage, SetsKt.emptySet(), dependencyContext));
                }
                Set dependencies = SetsKt.build((Set)set);
                String string = module.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                mutableModuleModel = new MutableModuleModel(string, (Module)module, buildFile, dependencies, this.project);
            }
            if (mutableModuleModel == null) continue;
            MutableModuleModel it$iv$iv = mutableModuleModel;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map getAllModules$lambda$5$lambda$1(PyPIProjectDependenciesModel this$0, Module $module) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = this$0.declaredDependencies($module);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            PackageDeclaration it = (PackageDeclaration)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getPkg(), (Object)it.getPsiElement());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private static final PsiElement getAllModules$lambda$5$lambda$4$lambda$3$lambda$2(Map $packageDeclarations, Package $modulePackage, VirtualFile virtualFile, Module module, Package package_) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)package_, (String)"<unused var>");
        return (PsiElement)$packageDeclarations.get($modulePackage);
    }
}

