/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.impl.JsonRecursiveElementVisitor;
import com.intellij.jsonpath.JsonPathBundle;
import com.intellij.jsonpath.JsonPathConstants;
import com.intellij.jsonpath.psi.JsonPathBinaryConditionalOperator;
import com.intellij.jsonpath.psi.JsonPathExpressionSegment;
import com.intellij.jsonpath.psi.JsonPathFile;
import com.intellij.jsonpath.psi.JsonPathId;
import com.intellij.jsonpath.psi.JsonPathIdSegment;
import com.intellij.jsonpath.psi.JsonPathObjectValue;
import com.intellij.jsonpath.psi.JsonPathQuotedPathsList;
import com.intellij.jsonpath.psi.JsonPathRecursiveElementVisitor;
import com.intellij.jsonpath.psi.JsonPathStringLiteral;
import com.intellij.jsonpath.psi.JsonPathTokenSets;
import com.intellij.jsonpath.psi.JsonPathTypes;
import com.intellij.jsonpath.ui.JsonPathEvaluateManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.util.ProcessingContext;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonPathCompletionContributor
extends CompletionContributor {
    public JsonPathCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(JsonPathStringLiteral.class)).inside((ElementPattern)PlatformPatterns.psiElement().withElementType(JsonPathTypes.QUOTED_PATHS_LIST)), new JsonKeysCompletionProvider(false));
        ElementPattern identifierPattern = StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withElementType(JsonPathTokenSets.JSONPATH_DOT_NAVIGATION_SET)), PlatformPatterns.psiElement().withElementType(JsonPathTypes.IDENTIFIER)});
        this.extend(CompletionType.BASIC, identifierPattern, new JsonKeysCompletionProvider(true));
        this.extend(CompletionType.BASIC, identifierPattern, new FunctionNamesCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(JsonPathBinaryConditionalOperator.class), new OperatorCompletionProvider());
        KeywordsCompletionProvider keywordsCompletionProvider = new KeywordsCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(JsonPathObjectValue.class)).afterLeaf((ElementPattern)PlatformPatterns.psiElement().withElementType(JsonPathTypes.COLON)), keywordsCompletionProvider);
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withElementType(JsonPathTokenSets.JSONPATH_EQUALITY_OPERATOR_SET))).andNot((ElementPattern)PlatformPatterns.psiElement().withParent(JsonPathStringLiteral.class)), keywordsCompletionProvider);
    }

    private static class JsonKeysCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private final boolean validIdentifiersOnly;
        private static final Pattern VALID_IDENTIFIER_PATTERN = Pattern.compile("[\\w_][\\w_0-9]*", 256);

        private JsonKeysCompletionProvider(boolean validIdentifiersOnly) {
            this.validIdentifiersOnly = validIdentifiersOnly;
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, final @NotNull CompletionResultSet result) {
            Supplier targetFileGetter;
            PsiFile hostFile;
            PsiFile file;
            InjectedLanguageManager injectedLanguageManager;
            PsiLanguageInjectionHost injectionHost;
            if (parameters == null) {
                JsonKeysCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                JsonKeysCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                JsonKeysCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((injectionHost = (injectedLanguageManager = InjectedLanguageManager.getInstance((Project)(file = parameters.getOriginalFile()).getProject())).getInjectionHost((PsiElement)file)) != null && (hostFile = injectionHost.getContainingFile()) != null) {
                this.visitJsonPathLiteralsInFile(injectedLanguageManager, hostFile, injectionHost, propertyName -> this.addCompletionElement(result, (String)propertyName));
            }
            if ((targetFileGetter = (Supplier)file.getUserData(JsonPathEvaluateManager.JSON_PATH_EVALUATE_SOURCE_KEY)) != null) {
                JsonFile targetFile = (JsonFile)targetFileGetter.get();
                if (targetFile == null) {
                    return;
                }
                targetFile.accept((PsiElementVisitor)new JsonRecursiveElementVisitor(){

                    public void visitProperty(@NotNull JsonProperty o) {
                        if (o == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        super.visitProperty(o);
                        String propertyName = o.getName();
                        if (!propertyName.isBlank()) {
                            this.addCompletionElement(result, propertyName);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jsonpath/JsonPathCompletionContributor$JsonKeysCompletionProvider$1", "visitProperty"));
                    }
                });
            }
        }

        private void addCompletionElement(@NotNull CompletionResultSet result, String propertyName) {
            if (result == null) {
                JsonKeysCompletionProvider.$$$reportNull$$$0(3);
            }
            if (!this.validIdentifiersOnly || VALID_IDENTIFIER_PATTERN.matcher(propertyName).matches()) {
                result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)propertyName).withIcon(AllIcons.Nodes.Field).withTypeText(JsonPathBundle.message("jsonpath.completion.key", new Object[0])), (double)100.0));
            }
        }

        private void visitJsonPathLiteralsInFile(final @NotNull InjectedLanguageManager injectedLanguageManager, @NotNull PsiFile hostFile, final @Nullable PsiLanguageInjectionHost fromHost, final @NotNull Consumer<String> pathNameConsumer) {
            if (injectedLanguageManager == null) {
                JsonKeysCompletionProvider.$$$reportNull$$$0(4);
            }
            if (hostFile == null) {
                JsonKeysCompletionProvider.$$$reportNull$$$0(5);
            }
            if (pathNameConsumer == null) {
                JsonKeysCompletionProvider.$$$reportNull$$$0(6);
            }
            final PsiManager psiManager = hostFile.getManager();
            hostFile.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    super.visitElement(element);
                    if (element instanceof PsiLanguageInjectionHost && !psiManager.areElementsEquivalent(element, (PsiElement)fromHost)) {
                        List files = injectedLanguageManager.getInjectedPsiFiles(element);
                        if (files == null) {
                            return;
                        }
                        for (Pair rangePair : files) {
                            Object object = rangePair.getFirst();
                            if (!(object instanceof JsonPathFile)) continue;
                            JsonPathFile jsonPathFile = (JsonPathFile)((Object)object);
                            this.visitJsonPathLiterals(jsonPathFile);
                        }
                    }
                }

                private void visitJsonPathLiterals(JsonPathFile jsonPathFile) {
                    jsonPathFile.accept(new JsonPathRecursiveElementVisitor(){

                        @Override
                        public void visitIdSegment(@NotNull JsonPathIdSegment o) {
                            String literalText;
                            if (o == null) {
                                JsonKeysCompletionProvider.1.$$$reportNull$$$0(0);
                            }
                            super.visitIdSegment(o);
                            JsonPathId id = o.getId();
                            if (!id.getTextRange().isEmpty() && !StringUtil.isEmptyOrSpaces((String)(literalText = this.getElementTextWithoutHostEscaping(id)))) {
                                pathNameConsumer.accept(literalText);
                            }
                        }

                        @Override
                        public void visitExpressionSegment(@NotNull JsonPathExpressionSegment o) {
                            if (o == null) {
                                JsonKeysCompletionProvider.1.$$$reportNull$$$0(1);
                            }
                            super.visitExpressionSegment(o);
                            JsonPathQuotedPathsList quotedPathsList = o.getQuotedPathsList();
                            if (quotedPathsList == null) {
                                return;
                            }
                            for (JsonPathStringLiteral stringLiteral : quotedPathsList.getStringLiteralList()) {
                                String literalValue;
                                String literalText = this.getElementTextWithoutHostEscaping(stringLiteral);
                                if (literalText == null || StringUtil.isEmptyOrSpaces((String)(literalValue = StringUtil.unquoteString((String)literalText)))) continue;
                                pathNameConsumer.accept(literalValue);
                            }
                        }

                        private String getElementTextWithoutHostEscaping(@NotNull PsiElement element) {
                            if (element == null) {
                                JsonKeysCompletionProvider.1.$$$reportNull$$$0(2);
                            }
                            if (injectedLanguageManager.isInjectedFragment(element.getContainingFile())) {
                                return injectedLanguageManager.getUnescapedText(element);
                            }
                            return element.getText();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "o";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "element";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/jsonpath/JsonPathCompletionContributor$JsonKeysCompletionProvider$2$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitIdSegment";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitExpressionSegment";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "getElementTextWithoutHostEscaping";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsonpath/JsonPathCompletionContributor$JsonKeysCompletionProvider$2", "visitElement"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "injectedLanguageManager";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hostFile";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathNameConsumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/jsonpath/JsonPathCompletionContributor$JsonKeysCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletionElement";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJsonPathLiteralsInFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FunctionNamesCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private FunctionNamesCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                FunctionNamesCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                FunctionNamesCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                FunctionNamesCompletionProvider.$$$reportNull$$$0(2);
            }
            result.addElement((LookupElement)LookupElementBuilder.create((String)"*").bold());
            for (Map.Entry<String, String> function : JsonPathConstants.STANDARD_FUNCTIONS.entrySet()) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)(function.getKey() + "()")).withPresentableText(function.getKey()).withIcon(AllIcons.Nodes.Method).withTailText("()").withTypeText(function.getValue()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jsonpath/JsonPathCompletionContributor$FunctionNamesCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class OperatorCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private OperatorCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                OperatorCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                OperatorCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                OperatorCompletionProvider.$$$reportNull$$$0(2);
            }
            for (String keyword : JsonPathConstants.STANDARD_NAMED_OPERATORS) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)keyword).bold());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jsonpath/JsonPathCompletionContributor$OperatorCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class KeywordsCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private static final String[] KEYWORDS = new String[]{"null", "true", "false"};

        private KeywordsCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                KeywordsCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                KeywordsCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                KeywordsCompletionProvider.$$$reportNull$$$0(2);
            }
            for (String keyword : KEYWORDS) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)keyword).bold());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jsonpath/JsonPathCompletionContributor$KeywordsCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

