/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.local;

import com.google.common.collect.ImmutableList;
import com.intellij.application.Topics;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.local.NodeLocalInterpreterRefResolveResult;
import com.intellij.javascript.nodejs.interpreter.local.VirtualFileCache;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@State(name="NodeJsLocalInterpreterManager", category=SettingsCategory.TOOLS, exportable=true, presentableName=PresentableNameGetter.class, storages={@Storage(value="nodejs.xml", roamingType=RoamingType.DISABLED)})
public class NodeJsLocalInterpreterManager
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(NodeJsLocalInterpreterManager.class);
    private static final String LOCAL_INTERPRETERS_TAG_NAME = "local-interpreters";
    private static final String LOCAL_INTERPRETER_TAG_NAME = "local-interpreter";
    private static final String PATH_ATTR_NAME = "path";
    public static final String VERSION_CACHE_TAG_NAME = "version-cache";
    private static final String VERSION_ATTR_NAME = "version";
    private static final String VERSION_LAST_MODIFIED_ATTR_NAME = "last-modified";
    private static final String EXCLUDED_ATTR_NAME = "excluded";
    private final ExecutorService myExecutorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"NodeJsLocalInterpreter Pool");
    private final ConcurrentMap<String, TimestampedSemVer> myVersionCache = new ConcurrentHashMap<String, TimestampedSemVer>();
    private final ConcurrentMap<String, Future<SemVer>> myRunningFetches = new ConcurrentHashMap<String, Future<SemVer>>();
    private Set<String> myDetectedInterpreterPaths;
    private volatile List<NodeJsLocalInterpreter> myInterpreters;
    private volatile @Unmodifiable Map<String, NodeJsLocalInterpreter> myInterpreterByRefNameMap = Collections.emptyMap();
    private final Map<String, NodeJsLocalInterpreter> myOtherInterpreterByRefNameMap = new FixedHashMap(10);
    private Set<String> myExcludedInterpreterPaths = Collections.emptySet();
    private volatile Ref<NodeJsLocalInterpreter> myInterpreterFromPathRef;
    private final AtomicInteger mySwitchesOutside = new AtomicInteger(0);
    private final VirtualFileCache<Pair<NodeJsLocalInterpreter, String>> myNvmRcResolverCache = new VirtualFileCache<Pair<NodeJsLocalInterpreter, String>>(".nvmrc resolve"){

        @Override
        protected Pair<NodeJsLocalInterpreter, String> produceValue(@NotNull VirtualFile file, @NotNull String fileContent) {
            if (file == null) {
                1.$$$reportNull$$$0(0);
            }
            if (fileContent == null) {
                1.$$$reportNull$$$0(1);
            }
            return Pair.create((Object)NodeJsLocalInterpreterManager.resolveNvmRcInterpreter(fileContent, 0), (Object)fileContent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileContent";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager$1";
            objectArray[2] = "produceValue";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public NodeJsLocalInterpreterManager() {
        Topics.subscribe((Topic)ApplicationActivationListener.TOPIC, (Disposable)this, (Object)new ApplicationActivationListener(){

            public void applicationActivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    2.$$$reportNull$$$0(0);
                }
                NodeJsLocalInterpreterManager.this.myInterpreterFromPathRef = null;
                NodeJsLocalInterpreterManager.this.mySwitchesOutside.incrementAndGet();
                NodeJsLocalInterpreterManager.this.myNvmRcResolverCache.cleanCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager$2", "applicationActivated"));
            }
        });
    }

    public void dispose() {
    }

    @NotNull
    public static NodeJsLocalInterpreterManager getInstance() {
        NodeJsLocalInterpreterManager nodeJsLocalInterpreterManager = (NodeJsLocalInterpreterManager)ApplicationManager.getApplication().getService(NodeJsLocalInterpreterManager.class);
        if (nodeJsLocalInterpreterManager == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(0);
        }
        return nodeJsLocalInterpreterManager;
    }

    public int getSwitchesOutside() {
        return this.mySwitchesOutside.get();
    }

    @Nullable
    public Ref<SemVer> getCachedVersion(@NotNull NodeJsLocalInterpreter interpreter2) {
        String interpreterPath;
        TimestampedSemVer tsv;
        if (interpreter2 == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(1);
        }
        if ((tsv = (TimestampedSemVer)this.myVersionCache.get(interpreterPath = interpreter2.getInterpreterSystemIndependentPath())) != null) {
            File file = new File(interpreterPath);
            if (!(file.lastModified() != tsv.myLastModified || tsv.mySwitchesOutside != this.mySwitchesOutside.get() && interpreter2.isWrapperSwitchingVersionsInside())) {
                if (tsv.myVersion == null && tsv.myLoadedFromXml) {
                    this.fetchVersion(interpreter2, null);
                }
                return Ref.create((Object)tsv.myVersion);
            }
            this.myVersionCache.remove(interpreterPath);
        }
        return null;
    }

    public void fetchVersion(@NotNull NodeJsLocalInterpreter interpreter2, @Nullable NullableConsumer<? super SemVer> consumer) {
        if (interpreter2 == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(2);
        }
        Future<SemVer> future = this.getOrCreateFetch(interpreter2);
        if (consumer != null) {
            this.myExecutorService.execute(() -> {
                SemVer version2 = null;
                try {
                    version2 = (SemVer)future.get();
                }
                catch (InterruptedException e) {
                    LOG.warn("Fetch interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LOG.warn("Fetch failed", (Throwable)e);
                }
                consumer.consume((Object)version2);
            });
        }
    }

    @NotNull
    private Future<SemVer> getOrCreateFetch(@NotNull NodeJsLocalInterpreter interpreter2) {
        if (interpreter2 == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(3);
        }
        FutureTask<SemVer> newFetch = new FutureTask<SemVer>(() -> {
            SemVer version2 = null;
            File file = new File(interpreter2.getInterpreterSystemDependentPath());
            try {
                if (!NodeJsLocalInterpreterManager.isElectronApp(interpreter2.getInterpreterSystemIndependentPath(), file)) {
                    version2 = NodeJsLocalInterpreterManager.doFetchVersion(file);
                }
            }
            catch (Throwable t) {
                LOG.warn("Failed to fetch version for " + interpreter2.getInterpreterSystemDependentPath(), t);
            }
            finally {
                TimestampedSemVer result2 = new TimestampedSemVer(version2, file.lastModified(), false, this.mySwitchesOutside.get());
                this.myVersionCache.put(interpreter2.getInterpreterSystemIndependentPath(), result2);
                this.myRunningFetches.remove(interpreter2.getInterpreterSystemIndependentPath());
            }
            return version2;
        });
        Future running = this.myRunningFetches.putIfAbsent(interpreter2.getInterpreterSystemIndependentPath(), newFetch);
        if (running != null) {
            Future future = running;
            if (future == null) {
                NodeJsLocalInterpreterManager.$$$reportNull$$$0(4);
            }
            return future;
        }
        this.myExecutorService.execute(newFetch);
        FutureTask<SemVer> futureTask = newFetch;
        if (futureTask == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(5);
        }
        return futureTask;
    }

    private static boolean isElectronApp(@NotNull String interpreterSystemIndependentPath, @NotNull File interpreter2) {
        String osxSuffix;
        int osxInd;
        if (interpreterSystemIndependentPath == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(6);
        }
        if (interpreter2 == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(7);
        }
        if ((osxInd = interpreterSystemIndependentPath.lastIndexOf(osxSuffix = "/Contents/MacOS/")) >= 0 && interpreterSystemIndependentPath.indexOf(47, osxInd + osxSuffix.length()) == -1) {
            return true;
        }
        File parentDir = interpreter2.getParentFile();
        if (parentDir == null) {
            return false;
        }
        File resourcesDir = new File(parentDir, "resources");
        if (!resourcesDir.isDirectory()) {
            return false;
        }
        return new File(resourcesDir, "electron.asar").isFile() || new File(resourcesDir, "app.asar").isFile();
    }

    @Nullable
    private static SemVer doFetchVersion(@NotNull File interpreter2) {
        ProcessOutput output;
        if (interpreter2 == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(8);
        }
        if (!interpreter2.exists()) {
            LOG.warn("No version for non-existent file " + interpreter2.getAbsolutePath());
            return null;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setWorkDirectory(NodeJsLocalInterpreterManager.getWorkingDirectory());
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.withCharset(StandardCharsets.UTF_8);
        commandLine.setExePath(interpreter2.getAbsolutePath());
        commandLine.addParameter("--version");
        try {
            output = NodeCommandLineUtil.execute(commandLine, 5000L);
        }
        catch (com.intellij.execution.ExecutionException e) {
            LOG.warn("Cannot fetch version (" + commandLine.getCommandLineString() + ")", (Throwable)e);
            return null;
        }
        if (output.isTimeout()) {
            LOG.warn("Cannot fetch version: timed out (" + commandLine.getCommandLineString() + ")");
            return null;
        }
        if (output.getExitCode() != 0) {
            LOG.warn("Cannot fetch version: non-zero exit code " + output.getExitCode() + " (" + commandLine.getCommandLineString() + "), stdout: " + output.getStdout() + ", stderr: " + output.getStderr());
            return null;
        }
        List stdout = output.getStdoutLines(true);
        if (stdout.size() != 1) {
            LOG.warn("Cannot parse version: expected single line, actual lines " + String.valueOf(stdout) + " (" + commandLine.getCommandLineString() + ")");
            return null;
        }
        SemVer version2 = NodeJsLocalInterpreterManager.parseSemVer((String)stdout.get(0));
        if (version2 == null) {
            LOG.warn("Cannot parse version from '" + (String)stdout.get(0) + "' (" + commandLine.getCommandLineString() + ")");
        }
        return version2;
    }

    @Nullable
    public static File getWorkingDirectory() {
        VirtualFile workingDir = null;
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            VirtualFile root = ProjectUtil.guessProjectDir((Project)project);
            if (workingDir == null) {
                workingDir = root;
            }
            if (PackageJsonUtil.findChildPackageJsonFile(root) == null) continue;
            workingDir = root;
            break;
        }
        return workingDir != null ? VfsUtilCore.virtualToIoFile(workingDir) : null;
    }

    @Nullable
    private static SemVer parseSemVer(@NotNull String str) {
        if (str == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(9);
        }
        return SemVer.parseFromText((String)StringUtil.trimStart((String)str, (String)"v"));
    }

    @Nullable
    public Element getState() {
        List<NodeJsLocalInterpreter> interpreters = this.myInterpreters;
        if (interpreters == null) {
            return null;
        }
        Element parent = new Element(LOCAL_INTERPRETERS_TAG_NAME);
        for (NodeJsLocalInterpreter interpreter2 : interpreters) {
            Element interpreterElement = new Element(LOCAL_INTERPRETER_TAG_NAME);
            interpreterElement.setAttribute(PATH_ATTR_NAME, interpreter2.getInterpreterSystemIndependentPath());
            this.addVersionCacheElementIfNeeded(interpreterElement, interpreter2.getInterpreterSystemIndependentPath());
            parent.addContent(interpreterElement);
        }
        Set<String> excludedInterpreterPaths = this.updateExcludedInterpreterPaths(this.myInterpreters);
        for (String excludedInterpreterPath : excludedInterpreterPaths) {
            Element interpreterElement = new Element(LOCAL_INTERPRETER_TAG_NAME);
            interpreterElement.setAttribute(PATH_ATTR_NAME, excludedInterpreterPath);
            interpreterElement.setAttribute(EXCLUDED_ATTR_NAME, Boolean.toString(true));
            parent.addContent(interpreterElement);
        }
        return parent;
    }

    private void addVersionCacheElementIfNeeded(@NotNull Element parent, @NotNull String interpreterSystemIndependentPath) {
        TimestampedSemVer tsv;
        if (parent == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(10);
        }
        if (interpreterSystemIndependentPath == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(11);
        }
        if ((tsv = (TimestampedSemVer)this.myVersionCache.get(interpreterSystemIndependentPath)) != null) {
            SemVer version2 = tsv.myVersion;
            Element versionElement = new Element(VERSION_CACHE_TAG_NAME);
            if (version2 != null) {
                versionElement.setAttribute(VERSION_ATTR_NAME, version2.getRawVersion());
            }
            versionElement.setAttribute(VERSION_LAST_MODIFIED_ATTR_NAME, String.valueOf(tsv.myLastModified));
            parent.addContent(versionElement);
        }
    }

    @NotNull
    private Set<String> getDetectedInterpreterPaths() {
        List<File> interpreters = NodeJsLocalInterpreterUtil.detectAllLocalInterpreters();
        HashSet<String> interpreterPaths = new HashSet<String>(interpreters.size());
        for (File interpreter2 : interpreters) {
            interpreterPaths.add(FileUtil.toSystemIndependentName((String)interpreter2.getAbsolutePath()));
        }
        this.myDetectedInterpreterPaths = interpreterPaths;
        HashSet<String> hashSet = interpreterPaths;
        if (hashSet == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(13);
        }
        List children = state.getChildren(LOCAL_INTERPRETER_TAG_NAME);
        HashSet<String> excludedInterpreterPaths = new HashSet<String>();
        ArrayList<NodeJsLocalInterpreter> interpreters = new ArrayList<NodeJsLocalInterpreter>();
        for (Element interpreterElement : children) {
            String interpreterPath = interpreterElement.getAttributeValue(PATH_ATTR_NAME);
            if (interpreterPath == null) continue;
            interpreterPath = FileUtil.toSystemIndependentName((String)interpreterPath);
            boolean excluded = Boolean.parseBoolean(interpreterElement.getAttributeValue(EXCLUDED_ATTR_NAME));
            if (excluded) {
                excludedInterpreterPaths.add(interpreterPath);
                continue;
            }
            TimestampedSemVer version2 = NodeJsLocalInterpreterManager.parseVersionCache(interpreterElement);
            if (version2 != null) {
                this.myVersionCache.putIfAbsent(interpreterPath, version2);
            }
            interpreters.add(new NodeJsLocalInterpreter(interpreterPath));
        }
        this.doSetInterpreter(interpreters);
        this.myExcludedInterpreterPaths = excludedInterpreterPaths;
    }

    public void noStateLoaded() {
        NodeJsLocalInterpreterManager oldManager = (NodeJsLocalInterpreterManager)ApplicationManager.getApplication().getService(OldNodeJsLocalInterpreterManager.class);
        List<NodeJsLocalInterpreter> interpreters = oldManager.myInterpreters;
        if (interpreters != null) {
            LOG.info("Imported from previous settings: " + String.valueOf(interpreters));
            this.doSetInterpreter(interpreters);
            oldManager.myInterpreters = null;
        }
        this.myExcludedInterpreterPaths = oldManager.myExcludedInterpreterPaths;
    }

    @Nullable
    private static TimestampedSemVer parseVersionCache(@NotNull Element interpreterElement) {
        Element versionCacheElement;
        if (interpreterElement == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(14);
        }
        if ((versionCacheElement = interpreterElement.getChild(VERSION_CACHE_TAG_NAME)) == null) {
            return null;
        }
        long lastModified = StringUtil.parseLong((String)versionCacheElement.getAttributeValue(VERSION_LAST_MODIFIED_ATTR_NAME), (long)-1L);
        if (lastModified >= 0L) {
            String versionStr = versionCacheElement.getAttributeValue(VERSION_ATTR_NAME);
            SemVer version2 = SemVer.parseFromText((String)StringUtil.notNullize((String)versionStr));
            return new TimestampedSemVer(version2, lastModified, true, 0);
        }
        return null;
    }

    @NotNull
    private List<NodeJsLocalInterpreter> sortInterpreters(@NotNull List<? extends NodeJsLocalInterpreter> interpreters) {
        if (interpreters == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(15);
        }
        ArrayList<InterpreterWithVersion> pairs = new ArrayList<InterpreterWithVersion>(interpreters.size());
        for (NodeJsLocalInterpreter nodeJsLocalInterpreter : interpreters) {
            SemVer version2 = (SemVer)Ref.deref(this.getCachedVersion(nodeJsLocalInterpreter));
            if (version2 == null) {
                version2 = NodeJsLocalInterpreterManager.guessVersionByPath(nodeJsLocalInterpreter);
            }
            pairs.add(new InterpreterWithVersion(nodeJsLocalInterpreter, version2));
        }
        Collections.sort(pairs);
        ArrayList<NodeJsLocalInterpreter> result2 = new ArrayList<NodeJsLocalInterpreter>(interpreters.size());
        for (InterpreterWithVersion pair : pairs) {
            result2.add(pair.myInterpreter);
        }
        ArrayList<NodeJsLocalInterpreter> arrayList = result2;
        if (arrayList == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @Nullable
    private static SemVer guessVersionByPath(@NotNull NodeJsLocalInterpreter interpreter2) {
        int sepInd2;
        String path2;
        int sepInd1;
        if (interpreter2 == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(17);
        }
        if ((sepInd1 = (path2 = interpreter2.getInterpreterSystemIndependentPath()).lastIndexOf(47)) > 0 && (sepInd1 = path2.lastIndexOf(47, sepInd1 - 1)) > 0 && (sepInd2 = path2.lastIndexOf(47, sepInd1 - 1)) > 0) {
            String str = path2.substring(sepInd2 + 1, sepInd1);
            return NodeJsLocalInterpreterManager.parseSemVer(str);
        }
        return null;
    }

    public void setInterpreters(@NotNull List<NodeJsLocalInterpreter> interpreters) {
        if (interpreters == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(18);
        }
        this.doSetInterpreter(interpreters);
        this.myExcludedInterpreterPaths = this.updateExcludedInterpreterPaths(interpreters);
    }

    private void doSetInterpreter(@NotNull List<NodeJsLocalInterpreter> interpreters) {
        if (interpreters == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(19);
        }
        this.myInterpreters = ImmutableList.copyOf(interpreters);
        this.myInterpreterByRefNameMap = NodeJsLocalInterpreterManager.calcInterpreterByRefNameMap(interpreters);
    }

    @NotNull
    private Set<String> updateExcludedInterpreterPaths(@NotNull List<? extends NodeJsLocalInterpreter> interpreters) {
        Set<String> detectedInterpreterPaths;
        if (interpreters == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(20);
        }
        if ((detectedInterpreterPaths = this.myDetectedInterpreterPaths) == null) {
            Set<String> set = this.myExcludedInterpreterPaths;
            if (set == null) {
                NodeJsLocalInterpreterManager.$$$reportNull$$$0(21);
            }
            return set;
        }
        HashSet<String> result2 = new HashSet<String>(detectedInterpreterPaths);
        for (NodeJsLocalInterpreter nodeJsLocalInterpreter : interpreters) {
            result2.remove(nodeJsLocalInterpreter.getInterpreterSystemIndependentPath());
        }
        this.myExcludedInterpreterPaths = result2;
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(22);
        }
        return hashSet;
    }

    public boolean hasValidInterpreters() {
        List interpreters = ContainerUtil.notNullize(this.myInterpreters);
        for (NodeJsLocalInterpreter interpreter2 : interpreters) {
            String interpreterPath = interpreter2.getInterpreterSystemIndependentPath();
            if (this.myExcludedInterpreterPaths.contains(interpreterPath) || !interpreter2.isValid()) continue;
            return true;
        }
        HashSet<String> detectedInterpreterPaths = new HashSet<String>(this.getDetectedInterpreterPaths());
        detectedInterpreterPaths.removeAll(this.myExcludedInterpreterPaths);
        return !detectedInterpreterPaths.isEmpty();
    }

    @NotNull
    public List<NodeJsLocalInterpreter> getInterpreters() {
        HashSet<String> detectedPaths = new HashSet<String>(this.getDetectedInterpreterPaths());
        ArrayList<NodeJsLocalInterpreter> result2 = new ArrayList(ContainerUtil.notNullize(this.myInterpreters));
        for (NodeJsLocalInterpreter interpreter2 : result2) {
            detectedPaths.remove(interpreter2.getInterpreterSystemIndependentPath());
        }
        detectedPaths.removeAll(this.myExcludedInterpreterPaths);
        for (String detectedPath : detectedPaths) {
            result2.add(new NodeJsLocalInterpreter(detectedPath));
        }
        result2 = this.sortInterpreters(result2);
        this.doSetInterpreter(result2);
        ArrayList<NodeJsLocalInterpreter> arrayList = result2;
        if (arrayList == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    private static @Unmodifiable @NotNull Map<String, NodeJsLocalInterpreter> calcInterpreterByRefNameMap(@NotNull List<NodeJsLocalInterpreter> interpreters) {
        if (interpreters == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(24);
        }
        Map map2 = ContainerUtil.newMapFromValues(interpreters.iterator(), interpreter2 -> interpreter2.getPresentableName());
        if (map2 == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(25);
        }
        return map2;
    }

    @Nullable
    private NodeJsLocalInterpreter findByReferenceName(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(26);
        }
        if (NodeJsLocalInterpreterType.isNodeFromPathRef(referenceName)) {
            Ref cached = this.myInterpreterFromPathRef;
            if (cached == null) {
                this.myInterpreterFromPathRef = cached = Ref.create((Object)this.detectMostRelevant());
            }
            return (NodeJsLocalInterpreter)cached.get();
        }
        if (StringUtil.isEmptyOrSpaces((String)referenceName) || !OSAgnosticPathUtil.isAbsolute((String)referenceName)) {
            return null;
        }
        return this.findByReferenceNameOrCreate(referenceName);
    }

    @Nullable
    NodeLocalInterpreterRefResolveResult resolveReference(@Nullable Project project, @NotNull String referenceName) {
        NodeLocalInterpreterRefResolveResult result2;
        if (referenceName == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(27);
        }
        if (NodeJsLocalInterpreterType.isNodeFromPathRef(referenceName) && (result2 = this.resolveFromNodeVersionFile(project)) != null && result2.getInterpreter() != null) {
            return result2;
        }
        return new NodeLocalInterpreterRefResolveResult(this.findByReferenceName(referenceName), null, null);
    }

    @Nullable
    private NodeLocalInterpreterRefResolveResult resolveFromNodeVersionFile(@Nullable Project project) {
        Pair<NodeJsLocalInterpreter, String> interpreterAndContent;
        if (SystemInfo.isWindows) {
            return null;
        }
        VirtualFile child = NodeJsLocalInterpreterManager.findNodeVersionFile(project);
        if (child != null && child.isValid() && !child.isDirectory() && (interpreterAndContent = this.myNvmRcResolverCache.getValue(child)) != null) {
            return new NodeLocalInterpreterRefResolveResult((NodeJsLocalInterpreter)interpreterAndContent.first, child.getName(), (String)interpreterAndContent.second);
        }
        return null;
    }

    @Nullable
    private static VirtualFile findNodeVersionFile(@Nullable Project project) {
        VirtualFile dir = project != null && !project.isDefault() ? ProjectUtil.guessProjectDir((Project)project) : null;
        try {
            VirtualFile child;
            VirtualFile virtualFile = child = dir != null ? dir.findChild(".nvmrc") : null;
            if (child == null || !child.isValid() || child.isDirectory()) {
                child = dir != null ? dir.findChild(".node-version") : null;
            }
            return child;
        }
        catch (InvalidVirtualFileAccessException e) {
            return null;
        }
    }

    @Nullable
    public static NodeVersionFileInfo findNodeVersionFileInfo(@Nullable Project project) {
        CharSequence content;
        VirtualFile child = NodeJsLocalInterpreterManager.findNodeVersionFile(project);
        if (child != null && child.isValid() && !child.isDirectory() && (content = VirtualFileCache.loadText(child)) != null) {
            return new NodeVersionFileInfo(content.toString());
        }
        return null;
    }

    @Nullable
    public static NodeJsLocalInterpreter resolveNvmRcInterpreter(@NotNull CharSequence nvmRcText, int depth) {
        if (nvmRcText == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(28);
        }
        if (depth > 3) {
            return null;
        }
        String trimmedText = nvmRcText.toString().trim();
        String versionStr = StringUtil.trimStart((String)trimmedText, (String)"v");
        SemVer version2 = SemVer.parseFromText((String)versionStr);
        File nvmVersionsNodeDir = NodeJsLocalInterpreterUtil.findNvmVersionsNodeDir();
        if (nvmVersionsNodeDir == null) {
            return null;
        }
        if (version2 != null) {
            File node = new File(nvmVersionsNodeDir, "v" + version2.getRawVersion() + File.separatorChar + "bin" + File.separatorChar + "node");
            if (node.isFile()) {
                return new NodeJsLocalInterpreter(node.getAbsolutePath());
            }
            return null;
        }
        NodeJsLocalInterpreter latest = NodeJsLocalInterpreterManager.findLatestByBaseVersion(nvmVersionsNodeDir, versionStr);
        if (latest != null) {
            return latest;
        }
        NodeJsLocalInterpreter alias = NodeJsLocalInterpreterManager.findInterpreterByNvmAlias(nvmVersionsNodeDir, trimmedText, depth);
        if (alias != null) {
            return alias;
        }
        if ("node".equals(trimmedText) || "stable".equals(trimmedText)) {
            return NodeJsLocalInterpreterManager.findLatestByBaseVersion(nvmVersionsNodeDir, null);
        }
        return null;
    }

    @Nullable
    private static NodeJsLocalInterpreter findInterpreterByNvmAlias(@NotNull File nvmVersionsNodeDir, @NotNull String alias, int depth) {
        File nvmDir;
        if (nvmVersionsNodeDir == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(29);
        }
        if (alias == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(30);
        }
        File file = nvmDir = (nvmDir = nvmVersionsNodeDir.getParentFile()) == null ? null : nvmDir.getParentFile();
        if (nvmDir == null) {
            return null;
        }
        File nvmAliasDir = new File(nvmDir, "alias");
        File file2 = new File(nvmAliasDir, alias);
        if (file2.isFile()) {
            try {
                return NodeJsLocalInterpreterManager.resolveNvmRcInterpreter(FileUtil.loadFile((File)file2), depth + 1);
            }
            catch (IOException e) {
                LOG.info("Cannot load " + file2.getAbsolutePath());
            }
        }
        return null;
    }

    @Nullable
    private static NodeJsLocalInterpreter findLatestByBaseVersion(@NotNull File interpretersDir, @Nullable String baseVersionStr) {
        File node;
        File[] children;
        if (interpretersDir == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(31);
        }
        if (baseVersionStr != null && SemVer.parseFromText((String)baseVersionStr) == null && SemVer.parseFromText((String)(baseVersionStr + ".0")) == null && SemVer.parseFromText((String)(baseVersionStr + ".0.0")) == null) {
            return null;
        }
        SemVer latestMatchedVersion = null;
        File latestMatchedDir = null;
        for (File child : children = (File[])ObjectUtils.notNull((Object)interpretersDir.listFiles(), (Object)ArrayUtil.EMPTY_FILE_ARRAY)) {
            SemVer version2 = SemVer.parseFromText((String)StringUtil.trimStart((String)child.getName(), (String)"v"));
            if (version2 == null || baseVersionStr != null && !(version2.getRawVersion() + ".").startsWith(baseVersionStr + ".") || latestMatchedVersion != null && version2.compareTo(latestMatchedVersion) <= 0) continue;
            latestMatchedVersion = version2;
            latestMatchedDir = child;
        }
        if (latestMatchedDir != null && (node = new File(latestMatchedDir, "bin" + File.separatorChar + "node")).isFile()) {
            return new NodeJsLocalInterpreter(node.getAbsolutePath());
        }
        return null;
    }

    @NotNull
    private static String resolveInterpreterPath(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(32);
        }
        if (SystemInfo.isWindows) {
            String fileWithExePath = referenceName + ".exe";
            File fileWithExe = new File(fileWithExePath);
            if (fileWithExe.isFile()) {
                String string = fileWithExePath;
                if (string == null) {
                    NodeJsLocalInterpreterManager.$$$reportNull$$$0(33);
                }
                return string;
            }
            File file = new File(referenceName);
            if (file.isFile()) {
                String string = referenceName;
                if (string == null) {
                    NodeJsLocalInterpreterManager.$$$reportNull$$$0(34);
                }
                return string;
            }
            String string = fileWithExePath;
            if (string == null) {
                NodeJsLocalInterpreterManager.$$$reportNull$$$0(35);
            }
            return string;
        }
        String string = referenceName;
        if (string == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(36);
        }
        return string;
    }

    @Nullable
    public NodeJsLocalInterpreter detectMostRelevant() {
        File interpreterFile = NodeJsLocalInterpreterUtil.findInterpreterInPath();
        if (interpreterFile == null) {
            return null;
        }
        NodeJsLocalInterpreter interpreter2 = new NodeJsLocalInterpreter(interpreterFile.getAbsolutePath());
        return this.findByReferenceNameOrCreate(interpreter2.getReferenceName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private NodeJsLocalInterpreter findByReferenceNameOrCreate(@NotNull String referenceName) {
        NodeJsLocalInterpreter interpreter2;
        if (referenceName == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(37);
        }
        if (this.myInterpreters == null) {
            this.getInterpreters();
        }
        if ((interpreter2 = this.myInterpreterByRefNameMap.get(referenceName)) == null) {
            Map<String, NodeJsLocalInterpreter> map2 = this.myOtherInterpreterByRefNameMap;
            synchronized (map2) {
                interpreter2 = this.myOtherInterpreterByRefNameMap.get(referenceName);
                if (interpreter2 == null) {
                    String interpreterPath = NodeJsLocalInterpreterManager.resolveInterpreterPath(referenceName);
                    interpreter2 = new NodeJsLocalInterpreter(interpreterPath);
                    this.myOtherInterpreterByRefNameMap.put(referenceName, interpreter2);
                }
            }
        }
        NodeJsLocalInterpreter nodeJsLocalInterpreter = interpreter2;
        if (nodeJsLocalInterpreter == null) {
            NodeJsLocalInterpreterManager.$$$reportNull$$$0(38);
        }
        return nodeJsLocalInterpreter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 6, 7, 8, 9, 10, 11, 13, 14, 15, 17, 18, 19, 20, 24, 26, 27, 28, 29, 30, 31, 32, 37 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterSystemIndependentPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterElement";
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreters";
                break;
            }
            case 26: 
            case 27: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nvmRcText";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nvmVersionsNodeDir";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpretersDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateFetch";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectedInterpreterPaths";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sortInterpreters";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "updateExcludedInterpreterPaths";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreters";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInterpreterByRefNameMap";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInterpreterPath";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "findByReferenceNameOrCreate";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCachedVersion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fetchVersion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateFetch";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isElectronApp";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doFetchVersion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseSemVer";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addVersionCacheElementIfNeeded";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseVersionCache";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sortInterpreters";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "guessVersionByPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreters";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doSetInterpreter";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateExcludedInterpreterPaths";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "calcInterpreterByRefNameMap";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findByReferenceName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveNvmRcInterpreter";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findInterpreterByNvmAlias";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findLatestByBaseVersion";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resolveInterpreterPath";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findByReferenceNameOrCreate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 6, 7, 8, 9, 10, 11, 13, 14, 15, 17, 18, 19, 20, 24, 26, 27, 28, 29, 30, 31, 32, 37 -> new IllegalArgumentException(string);
        };
    }

    private static class TimestampedSemVer {
        private final SemVer myVersion;
        private final long myLastModified;
        private final boolean myLoadedFromXml;
        private final int mySwitchesOutside;

        TimestampedSemVer(@Nullable SemVer version2, long lastModified, boolean loadedFromXml, int switchesOutside) {
            this.myVersion = version2;
            this.myLastModified = lastModified;
            this.myLoadedFromXml = loadedFromXml;
            this.mySwitchesOutside = switchesOutside;
        }
    }

    @Deprecated(forRemoval=true)
    @State(name="NodeJsLocalInterpreters", storages={@Storage(value="other.xml", roamingType=RoamingType.DISABLED)})
    @Service(value={Service.Level.APP})
    public static final class OldNodeJsLocalInterpreterManager
    extends NodeJsLocalInterpreterManager {
        @Override
        public void noStateLoaded() {
        }
    }

    private static class InterpreterWithVersion
    implements Comparable<InterpreterWithVersion> {
        private final NodeJsLocalInterpreter myInterpreter;
        private final SemVer myVersion;

        InterpreterWithVersion(@NotNull NodeJsLocalInterpreter interpreter2, @Nullable SemVer version2) {
            if (interpreter2 == null) {
                InterpreterWithVersion.$$$reportNull$$$0(0);
            }
            this.myInterpreter = interpreter2;
            this.myVersion = version2;
        }

        @Override
        public int compareTo(InterpreterWithVersion other) {
            SemVer version1 = this.myVersion;
            SemVer version2 = other.myVersion;
            String path1 = this.myInterpreter.getInterpreterSystemIndependentPath();
            String path2 = other.myInterpreter.getInterpreterSystemIndependentPath();
            if (version1 != null && version2 != null) {
                int res2 = version2.compareTo(version1);
                if (res2 == 0) {
                    res2 = path1.compareTo(path2);
                }
                return res2;
            }
            if (version1 == null && version2 == null) {
                return path1.compareTo(path2);
            }
            return version1 == null ? -1 : 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager$InterpreterWithVersion", "<init>"));
        }
    }

    public static class NodeVersionFileInfo {
        private final String myFileContent;

        public NodeVersionFileInfo(@NotNull String fileContent) {
            if (fileContent == null) {
                NodeVersionFileInfo.$$$reportNull$$$0(0);
            }
            this.myFileContent = fileContent;
        }

        @NotNull
        public String getFileContent() {
            String string = this.myFileContent;
            if (string == null) {
                NodeVersionFileInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileContent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager$NodeVersionFileInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterManager$NodeVersionFileInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static final class PresentableNameGetter
    extends State.NameGetter {
        public String get() {
            return JavaScriptBundle.message("node.js.interpreters", new Object[0]);
        }
    }
}

