/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.settings;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.settings.NodeSettingsView;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    public static final String ID = "settings.nodejs";
    private final Project myProject;
    private VirtualFile myRequestor;
    private NodeSettingsView myView;

    public NodeSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            NodeSettingsConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @Nls
    public String getDisplayName() {
        return JavaScriptBundle.message("settings.nodejs.name", new Object[0]);
    }

    public String getHelpTopic() {
        return this.getId();
    }

    public JComponent createComponent() {
        NodeSettingsView view;
        this.myView = view = new NodeSettingsView(this.myProject, this.myRequestor);
        return view.getComponent();
    }

    public boolean isModified() {
        NodeSettingsView view = this.myView;
        if (view == null) {
            return false;
        }
        NodeJsInterpreterRef prevInterpreter = NodeJsInterpreterManager.getInstance(this.myProject).getInterpreterRef();
        NodeJsInterpreterRef nextInterpreter = view.getInterpreterRef();
        NodePackageRef prevPmPackageRef = NpmManager.getInstance(this.myProject).getPackageRef();
        NodePackageRef nextPmPackageRef = view.getPackageManagerPackageRef();
        return !prevInterpreter.equals(nextInterpreter) || !prevPmPackageRef.equals(nextPmPackageRef);
    }

    public void apply() {
        NodeSettingsView view = this.myView;
        if (view != null) {
            NodeJsInterpreterManager interpreterManager = NodeJsInterpreterManager.getInstance(this.myProject);
            NodeJsInterpreterRef oldInterpreterRef = interpreterManager.getInterpreterRef();
            NodeJsInterpreterRef newInterpreterRef = view.getInterpreterRef();
            interpreterManager.setInterpreterRef(newInterpreterRef);
            NpmManager npmManager = NpmManager.getInstance(this.myProject);
            NodePackageRef oldNpmRef = npmManager.getPackageRef();
            NodePackageRef newNpmRef = view.getPackageManagerPackageRef();
            npmManager.setPackageRef(newNpmRef);
            if (!oldInterpreterRef.equals(newInterpreterRef) || !oldNpmRef.equals(newNpmRef)) {
                DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
            }
        }
    }

    public void reset() {
        NodeSettingsView view = this.myView;
        if (view != null) {
            view.setInterpreterRef(NodeJsInterpreterManager.getInstance(this.myProject).getInterpreterRef());
            view.setPackageManagerPackageRef(NpmManager.getInstance(this.myProject).getPackageRef());
        }
    }

    private void setRequestor(VirtualFile requestor) {
        this.myRequestor = requestor;
    }

    public static void showSettingsDialog(@NotNull Project project) {
        if (project == null) {
            NodeSettingsConfigurable.$$$reportNull$$$0(1);
        }
        NodeSettingsConfigurable.showSettingsDialog(project, null);
    }

    public static void showSettingsDialog(@NotNull Project project, @Nullable VirtualFile requestor) {
        if (project == null) {
            NodeSettingsConfigurable.$$$reportNull$$$0(2);
        }
        ShowSettingsUtil.getInstance().showSettingsDialog(project, NodeSettingsConfigurable.class, configurable -> configurable.setRequestor(requestor));
    }

    @NotNull
    public static AnAction createConfigureInterpreterAction(@NotNull Project project, @Nullable Runnable onBeforeDialogShownRunnable) {
        if (project == null) {
            NodeSettingsConfigurable.$$$reportNull$$$0(3);
        }
        return NodeSettingsConfigurable.createShowSettingsDialogAction(project, JavaScriptBundle.message("node.js.configure.interpreter", "Node.js"), onBeforeDialogShownRunnable);
    }

    @NotNull
    public static AnAction createOpenSettingsAction(@NotNull Project project, @Nullable Runnable onBeforeDialogShownRunnable) {
        if (project == null) {
            NodeSettingsConfigurable.$$$reportNull$$$0(4);
        }
        return NodeSettingsConfigurable.createShowSettingsDialogAction(project, JavaScriptBundle.message("node.download.open.settings", new Object[0]), onBeforeDialogShownRunnable);
    }

    @NotNull
    private static AnAction createShowSettingsDialogAction(@NotNull Project project, @NotNull @NlsActions.ActionText String actionName, @Nullable Runnable onBeforeDialogShownRunnable) {
        if (project == null) {
            NodeSettingsConfigurable.$$$reportNull$$$0(5);
        }
        if (actionName == null) {
            NodeSettingsConfigurable.$$$reportNull$$$0(6);
        }
        DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)actionName, event -> {
            if (onBeforeDialogShownRunnable != null) {
                onBeforeDialogShownRunnable.run();
            }
            NodeSettingsConfigurable.showSettingsDialog(project);
        });
        if (dumbAwareAction == null) {
            NodeSettingsConfigurable.$$$reportNull$$$0(7);
        }
        return dumbAwareAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/settings/NodeSettingsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/settings/NodeSettingsConfigurable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createShowSettingsDialogAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showSettingsDialog";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createConfigureInterpreterAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createOpenSettingsAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createShowSettingsDialogAction";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

