/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.bundler;

import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfig;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfigCache;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfigEvaluationContext;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfiguration;
import com.intellij.lang.javascript.buildTools.bundler.WebBundlerConfigurationMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010&\u001a\u00020!2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(H\u0007J\u001c\u0010)\u001a\u0004\u0018\u00010\u00162\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010*\u001a\u00020+H\u0002J&\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010'\u001a\u00020(2\u0006\u0010-\u001a\u00020\u00142\u0006\u0010*\u001a\u00020+H$J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020!0/J\b\u00100\u001a\u00020\u0002H\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0002H\u0016J\u0018\u00104\u001a\u0002022\u0006\u00103\u001a\u00020\u00022\b\b\u0002\u00105\u001a\u00020+J\u0017\u00106\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b72\u0006\u00108\u001a\u00020\u001aH\u0004J\u0012\u00109\u001a\u0002022\b\u0010:\u001a\u0004\u0018\u00010!H\u0007J\u0006\u0010;\u001a\u00020\u001aJ\u0006\u0010<\u001a\u00020=J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u000202H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR&\u0010\u0011\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00020\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0012\u0010\u001d\u001a\u00020\u0002X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR \u0010 \u001a\u0004\u0018\u00010!8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006A"}, d2={"Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfiguration;", "Lcom/intellij/openapi/util/ModificationTracker;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "cache", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigCache;", "getCache", "()Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigCache;", "cache$delegate", "Lkotlin/Lazy;", "resolvedConfigsByDir", "Lcom/intellij/psi/util/CachedValue;", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/util/Optional;", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigEvaluationContext;", "modificationTracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "bundlerId", "", "getBundlerId", "()Ljava/lang/String;", "configuration", "getConfiguration", "()Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfiguration;", "forceConfig", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfig;", "getForceConfig", "()Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfig;", "setForceConfig", "(Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfig;)V", "resolveConfig", "element", "Lcom/intellij/psi/PsiElement;", "resolveConfigEvaluationContext", "preferGlobalConfig", "", "computeConfigEvaluationContext", "directory", "getEvaluatedConfigs", "", "getState", "loadState", "", "state", "applySettings", "invalidate", "findFile", "Lorg/jetbrains/annotations/Nullable;", "path", "setConfig", "config", "getGlobalConfigPath", "getConfigurationMode", "Lcom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigurationMode;", "getModificationCount", "", "dispose", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nWebBundlerConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebBundlerConfigManager.kt\ncom/intellij/lang/javascript/buildTools/bundler/WebBundlerConfigManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1#2:170\n*E\n"})
public abstract class WebBundlerConfigManager
implements PersistentStateComponent<WebBundlerConfiguration>,
ModificationTracker,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy cache$delegate;
    @NotNull
    private final CachedValue<ConcurrentHashMap<VirtualFile, Optional<WebBundlerConfigEvaluationContext>>> resolvedConfigsByDir;
    @NotNull
    private final SimpleModificationTracker modificationTracker;
    @TestOnly
    @Nullable
    private volatile WebBundlerConfig forceConfig;

    public WebBundlerConfigManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.cache$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> WebBundlerConfigManager.cache_delegate$lambda$0(this));
        CachedValue cachedValue = CachedValuesManager.getManager((Project)this.project).createCachedValue(() -> WebBundlerConfigManager.resolvedConfigsByDir$lambda$1(this));
        Intrinsics.checkNotNullExpressionValue((Object)cachedValue, (String)"createCachedValue(...)");
        this.resolvedConfigsByDir = cachedValue;
        this.modificationTracker = new SimpleModificationTracker();
        Registry.Companion.get("webpack.execution.timeout.ms").addListener(new RegistryValueListener(){

            public void afterValueChanged(RegistryValue value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.getCache().removeAll(this.getBundlerId());
                this.getCache().notifyCacheChanged(true);
            }
        }, (Disposable)this);
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final WebBundlerConfigCache getCache() {
        Lazy lazy = this.cache$delegate;
        return (WebBundlerConfigCache)lazy.getValue();
    }

    @NotNull
    public abstract String getBundlerId();

    @NotNull
    protected abstract WebBundlerConfiguration getConfiguration();

    @Nullable
    protected final WebBundlerConfig getForceConfig() {
        return this.forceConfig;
    }

    protected final void setForceConfig(@Nullable WebBundlerConfig webBundlerConfig) {
        this.forceConfig = webBundlerConfig;
    }

    @JvmOverloads
    @NotNull
    public final WebBundlerConfig resolveConfig(@Nullable PsiElement element) {
        WebBundlerConfigurationMode mode = this.getConfigurationMode();
        if (mode == WebBundlerConfigurationMode.DISABLED) {
            return WebBundlerConfigCache.Companion.getEMPTY_CONFIG();
        }
        WebBundlerConfig webPackConfig = this.forceConfig;
        if (webPackConfig != null) {
            return webPackConfig;
        }
        return this.getCache().getConfigForFile(this.resolveConfigEvaluationContext(element, mode == WebBundlerConfigurationMode.MANUAL));
    }

    public static /* synthetic */ WebBundlerConfig resolveConfig$default(WebBundlerConfigManager webBundlerConfigManager, PsiElement psiElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolveConfig");
        }
        if ((n & 1) != 0) {
            psiElement = null;
        }
        return webBundlerConfigManager.resolveConfig(psiElement);
    }

    private final WebBundlerConfigEvaluationContext resolveConfigEvaluationContext(PsiElement element, boolean preferGlobalConfig) {
        return (WebBundlerConfigEvaluationContext)ReadAction.compute(() -> WebBundlerConfigManager.resolveConfigEvaluationContext$lambda$6(element, this, preferGlobalConfig));
    }

    @NotNull
    protected abstract Optional<WebBundlerConfigEvaluationContext> computeConfigEvaluationContext(@NotNull PsiElement var1, @NotNull VirtualFile var2, boolean var3);

    @NotNull
    public final Collection<WebBundlerConfig> getEvaluatedConfigs() {
        return this.getCache().getCachedConfigs(this.getBundlerId());
    }

    @NotNull
    public WebBundlerConfiguration getState() {
        return this.getConfiguration();
    }

    public void loadState(@NotNull WebBundlerConfiguration state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.applySettings(state, false);
    }

    public final void applySettings(@NotNull WebBundlerConfiguration state, boolean invalidate) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        String oldPath = this.getConfiguration().getPath();
        String string = state.getPath();
        String path2 = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
        CharSequence charSequence2 = path2;
        this.getConfiguration().setPath(!(charSequence2 == null || charSequence2.length() == 0) ? FileUtil.toSystemIndependentName((String)path2) : null);
        WebBundlerConfigurationMode oldMode = this.getConfiguration().getMode();
        WebBundlerConfiguration webBundlerConfiguration = this.getConfiguration();
        WebBundlerConfigurationMode webBundlerConfigurationMode = state.getMode();
        if (webBundlerConfigurationMode == null) {
            webBundlerConfigurationMode = WebBundlerConfigurationMode.NONE;
        }
        webBundlerConfiguration.setMode(webBundlerConfigurationMode);
        if (this.getConfiguration().getMode() == WebBundlerConfigurationMode.NONE) {
            if (this.getConfiguration().getPath() != null) {
                this.getConfiguration().setMode(WebBundlerConfigurationMode.MANUAL);
            } else {
                this.getConfiguration().setMode(WebBundlerConfigurationMode.AUTO);
            }
        } else if (this.getConfiguration().getMode() == WebBundlerConfigurationMode.MANUAL && this.getConfiguration().getPath() == null) {
            this.getConfiguration().setMode(WebBundlerConfigurationMode.AUTO);
        }
        if (!Intrinsics.areEqual((Object)this.getConfiguration().getPath(), (Object)oldPath) && !((charSequence = (CharSequence)oldPath) == null || charSequence.length() == 0)) {
            ActionsKt.runReadAction(() -> WebBundlerConfigManager.applySettings$lambda$7(this, oldPath));
        }
        if (!Intrinsics.areEqual((Object)this.getConfiguration().getPath(), (Object)oldPath) || this.getConfiguration().getMode() != oldMode) {
            this.modificationTracker.incModificationCount();
            if (invalidate) {
                this.getCache().removeAll(this.getBundlerId());
            }
            this.getCache().notifyCacheChanged(true);
        }
    }

    public static /* synthetic */ void applySettings$default(WebBundlerConfigManager webBundlerConfigManager, WebBundlerConfiguration webBundlerConfiguration, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: applySettings");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        webBundlerConfigManager.applySettings(webBundlerConfiguration, bl);
    }

    @Nullable
    protected final VirtualFile findFile(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return VirtualFileManager.getInstance().findFileByUrl(VfsUtil.pathToUrl((String)path2));
    }

    @TestOnly
    public final void setConfig(@Nullable WebBundlerConfig config) {
        this.modificationTracker.incModificationCount();
        this.forceConfig = config;
    }

    @NotNull
    public final String getGlobalConfigPath() {
        String string = this.getConfiguration().getPath();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final WebBundlerConfigurationMode getConfigurationMode() {
        WebBundlerConfigurationMode webBundlerConfigurationMode = this.getConfiguration().getMode();
        if (webBundlerConfigurationMode == null) {
            webBundlerConfigurationMode = WebBundlerConfigurationMode.AUTO;
        }
        return webBundlerConfigurationMode;
    }

    public long getModificationCount() {
        return this.modificationTracker.getModificationCount();
    }

    public void dispose() {
    }

    @JvmOverloads
    @NotNull
    public final WebBundlerConfig resolveConfig() {
        return WebBundlerConfigManager.resolveConfig$default(this, null, 1, null);
    }

    private static final WebBundlerConfigCache cache_delegate$lambda$0(WebBundlerConfigManager this$0) {
        return WebBundlerConfigCache.Companion.getInstance(this$0.project);
    }

    private static final CachedValueProvider.Result resolvedConfigsByDir$lambda$1(WebBundlerConfigManager this$0) {
        Object[] objectArray = new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, this$0};
        return CachedValueProvider.Result.create(new ConcurrentHashMap(), (Object[])objectArray);
    }

    private static final Optional resolveConfigEvaluationContext$lambda$6$lambda$4(WebBundlerConfigManager this$0, PsiElement $element, VirtualFile $directory, boolean $preferGlobalConfig, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.computeConfigEvaluationContext($element, $directory, $preferGlobalConfig);
    }

    private static final Optional resolveConfigEvaluationContext$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        return (Optional)$tmp0.invoke(p0);
    }

    private static final WebBundlerConfigEvaluationContext resolveConfigEvaluationContext$lambda$6(PsiElement $element, WebBundlerConfigManager this$0, boolean $preferGlobalConfig) {
        Object object;
        block11: {
            block10: {
                VirtualFile virtualFile;
                Object object2;
                block9: {
                    block8: {
                        VirtualFile virtualFile2;
                        if ($element == null || !$element.isValid()) {
                            return null;
                        }
                        object2 = PsiUtilCore.getVirtualFile((PsiElement)$element);
                        if (object2 == null) break block8;
                        VirtualFile it = virtualFile2 = object2;
                        boolean bl = false;
                        object2 = it.isValid() ? virtualFile2 : null;
                        if (object2 != null) break block9;
                    }
                    return null;
                }
                VirtualFile file = object2;
                object = file.getParent();
                if (object == null) break block10;
                VirtualFile it = virtualFile = object;
                boolean bl = false;
                object = it.isValid() && it.isDirectory() ? virtualFile : null;
                if (object != null) break block11;
            }
            return null;
        }
        VirtualFile directory = object;
        ConcurrentHashMap configs = (ConcurrentHashMap)this$0.resolvedConfigsByDir.getValue();
        Optional config = (Optional)configs.get(directory);
        if (config == null) {
            config = configs.computeIfAbsent(directory, arg_0 -> WebBundlerConfigManager.resolveConfigEvaluationContext$lambda$6$lambda$5(arg_0 -> WebBundlerConfigManager.resolveConfigEvaluationContext$lambda$6$lambda$4(this$0, $element, directory, $preferGlobalConfig, arg_0), arg_0));
        }
        return config.orElse(null);
    }

    private static final Unit applySettings$lambda$7(WebBundlerConfigManager this$0, String $oldPath) {
        this$0.getCache().remove(this$0.findFile($oldPath));
        return Unit.INSTANCE;
    }
}

