/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.IndexedData;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeIndexerKt;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSSimpleTransformer;
import com.intellij.lang.javascript.psi.resolve.generic.JSTypeSubstitutorImpl;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.types.JSAliasTypeImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCacheableTypeTransformerBase;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContextualUnionType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSRestType;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSTemplateLiteralType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutionContextImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithGenericParameters;
import com.intellij.lang.javascript.psi.types.JSTypeWithWidening;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericDeclarationTypeImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.TreeItem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSGenericTypesEvaluatorBase
implements JSGenericTypesEvaluator {
    @NotNull
    public static JSTypeSubstitutor getTypeSubstitutorForExplicitThisParameterType(@NotNull Supplier<? extends JSType> qualifierType, @Nullable JSFunctionType functionType, @Nullable PsiElement context2, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext evaluationContext) {
        if (qualifierType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(0);
        }
        if (evaluationContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(1);
        }
        if (!(functionType instanceof TypeScriptJSFunctionTypeImpl)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(2);
            }
            return jSTypeSubstitutor;
        }
        JSType definedType = functionType.getThisType();
        if (JSTypeUtils.hasForeignGenericParameter(definedType)) {
            return JSGenericTypesEvaluatorBase.findAndIntersectGenericsTypeValues(qualifierType.get(), definedType, context2, evaluationContext);
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(3);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    protected Function.Mono<JSType> getJSQualifierGenericsRemapper(@Nullable JSExpression methodExpression) {
        JSExpression qualifier;
        if (methodExpression instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)methodExpression).getQualifier()) != null) {
            Function.Mono mono = type2 -> JSGenericTypesEvaluatorBase.evaluateJSGenericsFromQualifier(type2, qualifier);
            if (mono == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(4);
            }
            return mono;
        }
        Function.Mono mono = Functions.id();
        if (mono == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(5);
        }
        return mono;
    }

    @NotNull
    protected static JSTypeSubstitutor getDefaultTypeSubstitutor(@Nullable JSFunctionType functionType, @NotNull JSCallItem callItem) {
        if (callItem == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(6);
        }
        if (JSTypeUtils.hasTypeArguments(callItem)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(7);
            }
            return jSTypeSubstitutor;
        }
        return JSGenericTypesEvaluatorBase.getSubstitutorForDefaultParameters(functionType);
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForDefaultParameters(@NotNull PsiElement typeParametersOwner) {
        if (typeParametersOwner == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(8);
        }
        if (!(typeParametersOwner instanceof TypeScriptTypeParameterListOwner)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(9);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameter[] parameters2 = TypeScriptPsiUtil.getTypeParametersForOwner(typeParametersOwner);
        if (parameters2.length == 0) {
            JSClass jsClass;
            if (typeParametersOwner instanceof JSFunction && ((JSFunction)typeParametersOwner).isConstructor() && (jsClass = JSUtils.getMemberContainingClass(typeParametersOwner)) != null && !jsClass.isInterface()) {
                return JSGenericTypesEvaluatorBase.getSubstitutorForDefaultParameters(jsClass);
            }
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(10);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutorImpl substitutor = new JSTypeSubstitutorImpl();
        for (TypeScriptTypeParameter parameter : parameters2) {
            String name = parameter.getName();
            if (name == null) continue;
            JSTypeGenericId id = parameter.getGenericId();
            JSType type2 = JSGenericTypesEvaluatorBase.getTypeParameterDefaultType(parameter);
            substitutor.put(id, type2);
        }
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = substitutor;
        if (jSTypeSubstitutorImpl == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(11);
        }
        return jSTypeSubstitutorImpl;
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForDefaultParameters(@Nullable JSFunctionType typeParametersOwner) {
        if (!(typeParametersOwner instanceof TypeScriptJSFunctionTypeImpl)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(12);
            }
            return jSTypeSubstitutor;
        }
        List<TypeScriptGenericDeclarationTypeImpl> declarations = ((TypeScriptJSFunctionTypeImpl)typeParametersOwner).getGenericDeclarations();
        JSTypeSubstitutorImpl substitutor = new JSTypeSubstitutorImpl();
        for (TypeScriptGenericDeclarationTypeImpl parameter : declarations) {
            JSTypeGenericId id = parameter.getGenericId();
            JSType type2 = JSGenericTypesEvaluatorBase.getTypeParameterDefaultType(parameter);
            substitutor.put(id, type2);
        }
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = substitutor;
        if (jSTypeSubstitutorImpl == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(13);
        }
        return jSTypeSubstitutorImpl;
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForGenericConstraints(@Nullable JSFunctionType typeParametersOwner, @NotNull JSTypeSubstitutor substitutor) {
        if (substitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(14);
        }
        if (!(typeParametersOwner instanceof TypeScriptJSFunctionTypeImpl)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(15);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutorImpl result2 = new JSTypeSubstitutorImpl();
        for (TypeScriptGenericDeclarationTypeImpl parameter : ((TypeScriptJSFunctionTypeImpl)typeParametersOwner).getGenericDeclarations()) {
            JSTypeGenericId id = parameter.getGenericId();
            JSType constraintType2 = parameter.getConstraintType();
            if (constraintType2 == null) continue;
            result2.put(id, JSTypeUtils.applyGenericArguments(constraintType2, substitutor));
        }
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = result2;
        if (jSTypeSubstitutorImpl == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(16);
        }
        return jSTypeSubstitutorImpl;
    }

    protected static void addGenericDependencyFromType(final @NotNull Set<JSTypeGenericId> generics, final @NotNull MultiMap<Integer, JSTypeGenericId> results, final int ownName, @Nullable JSType type2) {
        if (generics == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(17);
        }
        if (results == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(18);
        }
        if (type2 == null) {
            return;
        }
        type2.accept(new JSRecursiveTypeVisitor(){

            @Override
            public void visitJSType(@NotNull JSType type2) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type2 instanceof JSGenericParameterImpl && generics.contains(((JSGenericParameterImpl)type2).getGenericId())) {
                    results.putValue((Object)ownName, (Object)((JSGenericParameterImpl)type2).getGenericId());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluatorBase$1", "visitJSType"));
            }
        });
    }

    protected static Integer @NotNull [] reorderByDependencies(int argumentsLength, @NotNull List<? extends JSType> parameterTypes, @NotNull Set<JSTypeGenericId> generics) {
        if (parameterTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(19);
        }
        if (generics == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(20);
        }
        Integer[] result2 = new Integer[argumentsLength];
        MultiMap results = new MultiMap();
        for (int i = 0; i < argumentsLength; ++i) {
            result2[i] = i;
            if (i >= parameterTypes.size()) continue;
            JSGenericTypesEvaluatorBase.addGenericDependencyFromType(generics, (MultiMap<Integer, JSTypeGenericId>)results, i, parameterTypes.get(i));
        }
        Arrays.sort(result2, (r1, r2) -> {
            Collection all2;
            Collection all1 = results.get(r1);
            if (all1.equals(all2 = results.get(r2))) {
                return 0;
            }
            return ContainerUtil.exists((Iterable)all1, i -> all2.contains(i)) ? -1 : 1;
        });
        if (result2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(21);
        }
        return result2;
    }

    @NotNull
    protected static JSType getTypeParameterDefaultType(@NotNull TypeScriptGenericDeclarationTypeImpl parameter) {
        JSType defaultType;
        if (parameter == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(22);
        }
        if ((defaultType = parameter.getDefaultType()) == null) {
            defaultType = parameter.getConstraintType();
        }
        JSType jSType = defaultType == null ? JSUnknownType.TS_INSTANCE : defaultType;
        if (jSType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(23);
        }
        return jSType;
    }

    @NotNull
    public static JSType getTypeParameterDefaultType(@NotNull TypeScriptTypeParameter parameter) {
        TypeScriptType defaultType;
        if (parameter == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(24);
        }
        if ((defaultType = parameter.getDefault()) == null) {
            defaultType = parameter.getTypeConstraint();
        }
        JSType jSType = defaultType == null ? JSUnknownType.TS_INSTANCE : defaultType.getJSType();
        if (jSType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(25);
        }
        return jSType;
    }

    @Contract(value="null->false")
    protected static boolean canHaveGenericParameters(@Nullable JSType type2) {
        return type2 != null && (!(type2 instanceof JSUtilType) || type2 instanceof JSArrayType || type2 instanceof JSFunctionType);
    }

    @NotNull
    protected JSTypeSubstitutor inferGenericTypesForCall(@Nullable JSFunctionType jsFunctionType, @NotNull JSCallItem callItem, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context2, @NotNull Collection<JSTypeGenericId> explicitArguments) {
        boolean isContextualWithOverloads;
        Set<JSTypeGenericId> names;
        if (callItem == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(26);
        }
        if (context2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(27);
        }
        if (explicitArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(28);
        }
        JSTypeSubstitutorImpl result2 = new JSTypeSubstitutorImpl();
        if (context2.paramToSkip == -1) {
            result2.putAll(JSGenericTypesEvaluatorBase.getDefaultTypeSubstitutor(jsFunctionType, callItem));
        }
        if (jsFunctionType instanceof JSTypeWithGenericParameters && !callItem.isNewExpression() && jsFunctionType.isTypeScript() && explicitArguments.containsAll(names = ((JSTypeWithGenericParameters)((Object)jsFunctionType)).getGenericIds())) {
            JSTypeSubstitutorImpl jSTypeSubstitutorImpl = result2;
            if (jSTypeSubstitutorImpl == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(29);
            }
            return jSTypeSubstitutorImpl;
        }
        boolean bl = isContextualWithOverloads = context2.paramToSkip != -1;
        if (jsFunctionType != null) {
            List<JSType> argumentTypes = callItem.getArgumentTypes(JSPsiBasedTypeOfType.getArgumentTypeFactory(isContextualWithOverloads));
            List<JSType> parameterTypes = JSGenericTypesEvaluatorBase.getParameterTypesForInference(jsFunctionType.getParameters(), argumentTypes.size());
            Predicate<JSType> condition = JSGenericTypesEvaluatorBase.getExcludeExplicitArgumentsCondition(explicitArguments);
            this.doInferParameters(jsFunctionType, callItem, new JSGenericTypesEvaluator.GenericEvaluationContext(context2, condition), result2, argumentTypes, parameterTypes);
        }
        for (JSTypeGenericId key : result2.keys()) {
            JSTypeSubstitutorImpl substitutor = new JSTypeSubstitutorImpl(result2);
            substitutor.put(key, null);
            result2.put(key, JSTypeUtils.applyGenericArguments(result2.get(key), substitutor));
        }
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = result2;
        if (jSTypeSubstitutorImpl == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(30);
        }
        return jSTypeSubstitutorImpl;
    }

    private void doInferParameters(@NotNull JSFunctionType jsFunctionType, @NotNull JSCallItem callItem, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext evaluationContext, @NotNull JSTypeSubstitutorImpl result2, @NotNull List<JSType> argumentTypes, @NotNull List<JSType> parameterTypes) {
        if (jsFunctionType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(31);
        }
        if (callItem == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(32);
        }
        if (evaluationContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(33);
        }
        if (result2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(34);
        }
        if (argumentTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(35);
        }
        if (parameterTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(36);
        }
        JSGenericMappings genericArguments = JSGenericTypesEvaluatorBase.inferGenericArgumentsFromCall(argumentTypes, parameterTypes, evaluationContext.paramToSkip, jsFunctionType, evaluationContext, evaluationContext.paramToSkip != -1, callItem, evaluationContext.expectedTypeKind.increaseInferenceDepth());
        MultiMap<JSTypeGenericId, JSType> mapping = genericArguments.getMapping();
        result2.putAll(this.getTypeSubstitutorForReturnType(jsFunctionType, callItem, evaluationContext.acceptableGenericArguments.and(type2 -> {
            if (type2 instanceof JSGenericParameterImpl) {
                return !mapping.containsKey((Object)((JSGenericParameterImpl)type2).getGenericId());
            }
            return true;
        }), evaluationContext.expectedTypeKind.increaseInferenceDepth()));
        ProcessingContext processingContext = JSTypeComparingContextService.createProcessingContextWithCache(callItem.getPsiContext());
        if (evaluationContext.paramToSkip == -1) {
            JSGenericTypesEvaluatorBase.widenInferredTypes(mapping, parameterTypes, jsFunctionType, callItem, processingContext);
        }
        result2.putAll(JSGenericTypesEvaluatorBase.intersectGenericsForCall(genericArguments, callItem.getPsiContext(), evaluationContext.reporter, processingContext));
    }

    @NotNull
    public static Predicate<JSType> getExcludeExplicitArgumentsCondition(@NotNull Collection<JSTypeGenericId> explicitArguments) {
        if (explicitArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(37);
        }
        Predicate<JSType> predicate = type2 -> type2 instanceof JSGenericParameterImpl && !explicitArguments.contains(((JSGenericParameterImpl)type2).getGenericId());
        if (predicate == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(38);
        }
        return predicate;
    }

    @NotNull
    protected JSTypeSubstitutor getTypeSubstitutorForReturnType(@NotNull JSFunctionType jsFunctionType, @NotNull JSCallItem callItem, @NotNull Predicate<? super JSType> condition, JSExpectedTypeKind expectedTypeKind) {
        JSType returnType2;
        if (jsFunctionType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(39);
        }
        if (callItem == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(40);
        }
        if (condition == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(41);
        }
        if ((returnType2 = jsFunctionType.getReturnType()) != null) {
            returnType2 = returnType2.substituteCompilerTypesInTypeHierarchy();
        }
        if (returnType2 instanceof JSCodeBasedType) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(42);
            }
            return jSTypeSubstitutor;
        }
        if (callItem.getTypeArguments().length == 0 && JSTypeUtils.hasTypes(returnType2, condition)) {
            PsiElement expression = callItem.getPsiContext();
            JSType expectedType = expression instanceof JSExpression ? JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)expression, expectedTypeKind.increaseInferenceDepth()) : null;
            return JSGenericTypesEvaluatorBase.findAndIntersectGenericsTypeValues(expectedType, returnType2, callItem.getPsiContext());
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(43);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static List<JSType> getParameterTypesForInference(@NotNull List<? extends JSParameterItem> parameters2, int argumentsLength) {
        if (parameters2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(44);
        }
        SmartList parameterTypes = new SmartList();
        JSType restParameterType = null;
        for (JSParameterItem jSParameterItem : parameters2) {
            JSType parameterType = jSParameterItem.getSimpleType();
            parameterTypes.add(parameterType);
            if (!jSParameterItem.isRest()) continue;
            restParameterType = parameterType;
        }
        if (restParameterType != null && argumentsLength > parameterTypes.size()) {
            for (int i = parameterTypes.size(); i < argumentsLength; ++i) {
                parameterTypes.add(restParameterType);
            }
        }
        SmartList smartList = parameterTypes;
        if (smartList == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(45);
        }
        return smartList;
    }

    private static JSTypeSubstitutor intersectGenericsForCall(@NotNull JSGenericMappings applyingContext, @Nullable PsiElement context2, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter, @NotNull ProcessingContext processingContext) {
        if (applyingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(46);
        }
        if (processingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(47);
        }
        MultiMap<JSTypeGenericId, JSType> mapping = applyingContext.getMapping();
        JSTypeSubstitutorImpl result2 = JSGenericTypesEvaluatorBase.intersectGenerics(mapping, processingContext, reporter, context2);
        for (Map.Entry entry : mapping.entrySet()) {
            Collection types;
            JSTypeGenericId key = (JSTypeGenericId)entry.getKey();
            if (!result2.containsId(key) || (types = (Collection)entry.getValue()) == null || !ContainerUtil.and((Iterable)types, t -> t instanceof JSLiteralType)) continue;
            result2.put(key, JSCompositeTypeFactory.createUnionType(JSTypeSourceFactory.createTypeSource(context2, true), new ArrayList(types)));
        }
        JSTypeSubstitutorImpl deepSubstitutor = JSGenericTypesEvaluatorBase.intersectGenerics(applyingContext.getDeepMapping(), processingContext, null, context2);
        for (JSTypeGenericId key : result2.keys()) {
            result2.put(key, JSTypeUtils.applyGenericArguments(result2.get(key), deepSubstitutor));
        }
        return result2;
    }

    @NotNull
    protected static JSTypeSubstitutorImpl intersectGenerics(@NotNull MultiMap<JSTypeGenericId, JSType> map2, @NotNull ProcessingContext processingContext, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter, @Nullable PsiElement context2) {
        if (map2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(48);
        }
        if (processingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(49);
        }
        JSTypeSubstitutorImpl result2 = new JSTypeSubstitutorImpl();
        for (Map.Entry entry : map2.entrySet()) {
            Collection rawTypes = (Collection)entry.getValue();
            assert (!rawTypes.isEmpty());
            JSTypeGenericId parameterName = (JSTypeGenericId)entry.getKey();
            JSGenericTypesEvaluatorBase.addTypesForParameter(rawTypes, parameterName, result2, processingContext, reporter, context2);
        }
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = result2;
        if (jSTypeSubstitutorImpl == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(50);
        }
        return jSTypeSubstitutorImpl;
    }

    private static void addTypesForParameter(@NotNull Collection<JSType> rawTypes, @NotNull JSTypeGenericId parameterId, @NotNull JSTypeSubstitutorImpl result2, @NotNull ProcessingContext processingContext, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter, @Nullable PsiElement context2) {
        if (rawTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(51);
        }
        if (parameterId == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(52);
        }
        if (result2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(53);
        }
        if (processingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(54);
        }
        if (rawTypes.isEmpty()) {
            return;
        }
        if (rawTypes.size() == 1) {
            result2.put(parameterId, (JSType)ContainerUtil.getFirstItem(rawTypes));
            return;
        }
        boolean hasImplicitly = JSGenericTypesEvaluatorBase.checkImplicitFlags(rawTypes);
        List<JSType> typesWithoutGenerics = ContainerUtil.mapNotNull(rawTypes, el -> {
            if (el instanceof JSGenericParameterImpl || el == null || JSTypeUtils.isNullOrUndefinedType(el)) {
                return null;
            }
            if (el instanceof JSUnionType) {
                JSUnionType unionType = (JSUnionType)el;
                if (!(el instanceof JSContextualUnionType)) {
                    JSType optimized = JSTypeUtils.removeNullableComponents(unionType);
                    if (optimized instanceof TypeScriptNeverType) {
                        return null;
                    }
                    return optimized;
                }
            }
            return el;
        });
        List nullOrUndefined = ContainerUtil.flatMap(rawTypes, el -> {
            if (JSTypeUtils.isNullOrUndefinedType(el)) {
                return Collections.singletonList(el);
            }
            if (el instanceof JSUnionType) {
                JSUnionType unionType = (JSUnionType)el;
                if (!(el instanceof JSContextualUnionType)) {
                    return ContainerUtil.filter(unionType.getTypes(), t -> JSTypeUtils.isNullOrUndefinedType(t));
                }
            }
            return Collections.emptyList();
        });
        List<JSType> typesToUnite = typesWithoutGenerics.isEmpty() ? new ArrayList<JSType>(rawTypes) : typesWithoutGenerics;
        JSType type2 = JSGenericTypesEvaluatorBase.uniteTypes((List<? extends JSType>)typesToUnite, processingContext);
        if (type2 != null) {
            result2.put(parameterId, JSCompositeTypeFactory.createUnionType(type2.getSource(), ContainerUtil.prepend((List)nullOrUndefined, (Object[])new JSType[]{type2})));
            return;
        }
        if (hasImplicitly) {
            return;
        }
        if (typesWithoutGenerics.isEmpty()) {
            if (!nullOrUndefined.isEmpty() && !ContainerUtil.exists(rawTypes, t -> t instanceof JSGenericParameterImpl)) {
                result2.put(parameterId, JSCompositeTypeFactory.createUnionType(((JSType)nullOrUndefined.get(0)).getSource(), nullOrUndefined));
            }
            return;
        }
        if (context2 != null && DialectDetector.isTypeScript(context2) && typesWithoutGenerics.size() > 1 && ContainerUtil.and((Iterable)typesWithoutGenerics, t -> (t instanceof JSArrayType || t instanceof JSTupleType || t instanceof JSRecordType) && t.getSourceElement() != null && PsiTreeUtil.isAncestor((PsiElement)context2, (PsiElement)t.getSourceElement(), (boolean)true))) {
            JSTypeSource typeSource = new JSTypeSource(context2, JSTypeSource.SourceLanguage.TS, true);
            result2.put(parameterId, JSCompositeTypeFactory.createUnionType(typeSource, ContainerUtil.concat((List)typesWithoutGenerics, (List)nullOrUndefined)));
        } else {
            result2.put(parameterId, JSCompositeTypeFactory.createUnionType(((JSType)typesWithoutGenerics.get(0)).getSource(), ContainerUtil.prepend((List)nullOrUndefined, (Object[])new JSType[]{(JSType)typesWithoutGenerics.get(0)})));
        }
        Set nonWideningLiterals = (Set)processingContext.get(JSGenericTypesEvaluator.nonWideningLiterals);
        if (nonWideningLiterals != null && nonWideningLiterals.contains(parameterId) && ContainerUtil.all((Collection)typesToUnite, t -> t instanceof JSLiteralType)) {
            return;
        }
        if (reporter != null && typesWithoutGenerics.size() > 1) {
            reporter.error(JavaScriptBundle.message("typescript.validation.cannot.find.best.common.type", new Object[0]));
        }
    }

    private static boolean checkImplicitFlags(@NotNull Collection<? extends JSType> types) {
        if (types == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(55);
        }
        boolean hasImplicitly = false;
        for (JSType jSType : types) {
            JSType valuableType = JSTypeUtils.getValuableType(jSType, null);
            if (valuableType != null && valuableType.isSourceStrict()) continue;
            hasImplicitly = true;
            break;
        }
        return hasImplicitly;
    }

    @Nullable
    private static JSType uniteTypes(@NotNull List<? extends JSType> types, @Nullable ProcessingContext context2) {
        int size;
        if (types == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(56);
        }
        if ((size = types.size()) == 1) {
            return types.get(0);
        }
        for (JSType jSType : types) {
            if (!(jSType instanceof JSAnyType)) continue;
            return jSType;
        }
        JSType unionCandidate = null;
        boolean bl = false;
        for (JSType jSType : types) {
            boolean isCandidateContainsCurrent;
            boolean bl2;
            if (jSType == null || !JSGenericTypesEvaluatorBase.isAcceptableBySourceStrictness(jSType)) continue;
            if (unionCandidate == null) {
                unionCandidate = jSType;
                bl2 = JSGenericTypesEvaluatorBase.isComingFromAnonymousFunction(unionCandidate);
                continue;
            }
            if (jSType == unionCandidate || (isCandidateContainsCurrent = unionCandidate.isDirectlyAssignableType(jSType, context2)) && !bl2) continue;
            boolean isCurrentContainsCandidate = jSType.isDirectlyAssignableType(unionCandidate, context2);
            if (!isCandidateContainsCurrent && !isCurrentContainsCandidate) {
                return null;
            }
            int candidateScore = (isCandidateContainsCurrent ? 1 : 0) + (bl2 ? 0 : 3);
            int currentScore = (isCurrentContainsCandidate ? 1 : 0) + (JSGenericTypesEvaluatorBase.isComingFromAnonymousFunction(jSType) ? 0 : 3);
            boolean isCurrentFromAnonymousFunction = JSGenericTypesEvaluatorBase.isComingFromAnonymousFunction(jSType);
            if (currentScore <= candidateScore) continue;
            unionCandidate = jSType;
            bl2 = isCurrentFromAnonymousFunction;
        }
        return unionCandidate;
    }

    private static boolean isComingFromAnonymousFunction(@NotNull JSType type2) {
        JSParameterList parameterList;
        if (type2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(57);
        }
        if ((parameterList = (JSParameterList)PsiTreeUtil.getContextOfType((PsiElement)type2.getSourceElement(), (Class[])new Class[]{JSParameterList.class})) == null) {
            return false;
        }
        return ContainerUtil.and((Object[])parameterList.getParameters(), p -> p.getTypeElement() == null);
    }

    private static boolean isAcceptableBySourceStrictness(@NotNull JSType type2) {
        if (type2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(58);
        }
        return !type2.getSource().isTypeScript() || JSTypeUtils.getValuableType(type2, null).isSourceStrict();
    }

    @NotNull
    protected static JSGenericMappings inferGenericArgumentsFromCall(@NotNull List<? extends JSType> argumentTypes, @NotNull List<? extends JSType> parameterTypes, int callArgumentToSkip, @NotNull JSFunctionType jsFunctionType, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext evaluationContext, boolean isContextualWithOverloads, @Nullable JSCallItem callItem, JSExpectedTypeKind expectedTypeKind) {
        if (argumentTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(59);
        }
        if (parameterTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(60);
        }
        if (jsFunctionType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(61);
        }
        if (evaluationContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(62);
        }
        List argumentProviders = ContainerUtil.map(argumentTypes, type2 -> () -> {
            if (expectedTypeKind.increaseInferenceDepth().isInferenceDepthExceeded()) {
                return type2;
            }
            JSType result2 = isContextualWithOverloads ? TypeScriptSignatureChooser.mapContextualTypeForOverload(type2, jsFunctionType, callItem, expectedTypeKind) : type2;
            JSTypeSubstitutionContextImpl context2 = new JSTypeSubstitutionContextImpl((PsiElement)ObjectUtils.doIfNotNull((Object)callItem, JSCallItem::getPsiContext));
            context2.putUserData(JSTypeBaseImpl.IS_CHECKING_ASSIGNABILITY, true);
            return result2 instanceof JSPsiBasedTypeOfType ? result2.substitute(context2) : result2;
        });
        return expectedTypeKind.isInferenceDepthExceeded() ? new JSGenericMappings() : JSGenericTypesEvaluatorBase.inferGenericArgumentsFromCall(parameterTypes, argumentProviders, callArgumentToSkip, jsFunctionType, callItem != null ? callItem.getPsiContext() : null, evaluationContext);
    }

    @NotNull
    public static MultiMap<JSTypeGenericId, JSType> widenInferredTypes(@NotNull MultiMap<JSTypeGenericId, JSType> inferred, @NotNull List<? extends JSType> actualParameters, @Nullable JSFunctionType resolvedFunction, @Nullable JSCallItem callItem, @NotNull ProcessingContext processingContext) {
        if (inferred == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(63);
        }
        if (actualParameters == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(64);
        }
        if (processingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(65);
        }
        if (inferred.isEmpty()) {
            MultiMap<JSTypeGenericId, JSType> multiMap = inferred;
            if (multiMap == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(66);
            }
            return multiMap;
        }
        JSType returnType2 = resolvedFunction != null ? resolvedFunction.getReturnType() : null;
        JSType returnTypeSubstitute = JSTypeUtils.unwrapType(TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(returnType2, callItem != null ? callItem.getPsiContext() : null));
        Set returnIds = ContainerUtil.map2Set(JSGenericTypesEvaluatorBase.getTopLevelGenerics(returnTypeSubstitute), JSGenericParameterImpl::getGenericId);
        Set parameterTypes = StreamEx.of(actualParameters).nonNull().map(el -> JSGenericTypesEvaluatorBase.extractGenericsForParameterType(el)).flatMap(Collection::stream).toSet();
        Set<JSTypeGenericId> excludedFromWideningByContextType = null;
        for (JSGenericParameterType parameterType : parameterTypes) {
            JSTypeGenericId id = parameterType.getGenericId();
            if (!inferred.containsKey((Object)id)) continue;
            Collection types = inferred.get((Object)id);
            JSType constraintType2 = parameterType.getConstraintType();
            if (constraintType2 instanceof JSEvaluableType) continue;
            if (JSTypeUtils.containsLiteralOrEnumOrPrimitiveTypes(constraintType2)) {
                HashSet<JSTypeGenericId> nonWideningLiterals = (HashSet<JSTypeGenericId>)processingContext.get(JSGenericTypesEvaluator.nonWideningLiterals);
                if (nonWideningLiterals == null) {
                    nonWideningLiterals = new HashSet<JSTypeGenericId>();
                    processingContext.put(JSGenericTypesEvaluator.nonWideningLiterals, nonWideningLiterals);
                }
                nonWideningLiterals.add(id);
                List newTypes = ContainerUtil.map((Collection)types, type2 -> {
                    if (type2 instanceof JSTypeWithWidening && ((JSTypeWithWidening)type2).allowWidening()) {
                        type2 = ((JSTypeWithWidening)type2).copyWithAllowWidening(false);
                    }
                    return type2;
                });
                inferred.put((Object)id, (Collection)newTypes);
                continue;
            }
            if (returnIds.contains(id)) continue;
            ArrayList<JSType> newTypes = new ArrayList<JSType>(types.size());
            boolean hasWiden = false;
            for (JSType type3 : types) {
                JSType widen;
                boolean isConst = parameterType instanceof TypeScriptGenericParameterImpl && ((TypeScriptGenericParameterImpl)parameterType).isConst();
                JSType jSType = widen = isConst ? type3 : JSTypeUtils.widenLiteralTypes(type3);
                if (type3 != widen) {
                    if (excludedFromWideningByContextType == null) {
                        excludedFromWideningByContextType = JSGenericTypesEvaluatorBase.calcExcludedFromWideningByContextType(callItem, returnType2);
                    }
                    if (!excludedFromWideningByContextType.contains(id)) {
                        hasWiden = true;
                        type3 = widen;
                    }
                }
                newTypes.add(type3);
            }
            if (!hasWiden) continue;
            inferred.put((Object)id, newTypes);
        }
        MultiMap<JSTypeGenericId, JSType> multiMap = inferred;
        if (multiMap == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(67);
        }
        return multiMap;
    }

    @NotNull
    private static List<JSGenericParameterType> extractGenericsForParameterType(@NotNull JSType type2) {
        if (type2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(68);
        }
        if (type2 instanceof JSRestType) {
            type2 = ((JSRestType)((Object)type2)).getInnerType();
        }
        if (type2 instanceof JSGenericParameterType) {
            List<JSGenericParameterType> list = Collections.singletonList((JSGenericParameterType)type2);
            if (list == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(69);
            }
            return list;
        }
        if (type2 instanceof JSUnionOrIntersectionType) {
            List list = ContainerUtil.filterIsInstance(((JSUnionOrIntersectionType)type2).getTypes(), JSGenericParameterType.class);
            if (list == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(70);
            }
            return list;
        }
        if (type2 instanceof JSTupleType) {
            List list = ContainerUtil.filterIsInstance(((JSTupleType)type2).getTypes(), JSGenericParameterType.class);
            if (list == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(71);
            }
            return list;
        }
        if (type2 instanceof JSTemplateLiteralType) {
            List list = ContainerUtil.filterIsInstance(((JSTemplateLiteralType)type2).getTypes(), JSGenericParameterType.class);
            if (list == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(72);
            }
            return list;
        }
        List<JSGenericParameterType> list = Collections.emptyList();
        if (list == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(73);
        }
        return list;
    }

    @NotNull
    private static Set<JSTypeGenericId> calcExcludedFromWideningByContextType(@Nullable JSCallItem callItem, @Nullable JSType returnType2) {
        if (returnType2 == null) {
            Set<JSTypeGenericId> set = Collections.emptySet();
            if (set == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(74);
            }
            return set;
        }
        JSCallExpression callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)callItem, JSCallExpression.class);
        if (callExpression == null) {
            Set<JSTypeGenericId> set = Collections.emptySet();
            if (set == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(75);
            }
            return set;
        }
        JSType jSType = returnType2 = returnType2 instanceof JSArrayType ? ((JSArrayType)returnType2).asGenericType() : returnType2;
        if (!(returnType2 instanceof JSGenericTypeImpl)) {
            Set<JSTypeGenericId> set = Collections.emptySet();
            if (set == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(76);
            }
            return set;
        }
        JSGenericTypeImpl genericReturnType = (JSGenericTypeImpl)returnType2;
        JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType(callExpression, JSExpectedTypeKind.WIDENING);
        if (expectedType instanceof JSAliasTypeImpl) {
            expectedType = ((JSAliasTypeImpl)expectedType).getAlias();
        }
        if (expectedType instanceof JSArrayType) {
            expectedType = ((JSArrayType)expectedType).asGenericType();
        }
        if (!(expectedType instanceof JSGenericTypeImpl)) {
            Set<JSTypeGenericId> set = Collections.emptySet();
            if (set == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(77);
            }
            return set;
        }
        if (!((JSGenericTypeImpl)expectedType).getType().isEquivalentTo(genericReturnType.getType(), null)) {
            Set<JSTypeGenericId> set = Collections.emptySet();
            if (set == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(78);
            }
            return set;
        }
        List<JSType> arguments = genericReturnType.getArguments();
        List<JSType> expectedArgs = ((JSGenericTypeImpl)expectedType).getArguments();
        HashSet<JSTypeGenericId> result2 = new HashSet<JSTypeGenericId>();
        for (int i = 0; i < Math.min(arguments.size(), expectedArgs.size()); ++i) {
            JSType argument = arguments.get(i);
            JSType expectedArgument = expectedArgs.get(i);
            if (!(argument instanceof JSGenericParameterType) || !JSTypeUtils.containsLiteralOrEnumOrPrimitiveTypes(expectedArgument)) continue;
            result2.add(((JSGenericParameterType)argument).getGenericId());
        }
        HashSet<JSTypeGenericId> hashSet = result2;
        if (hashSet == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(79);
        }
        return hashSet;
    }

    @NotNull
    public static JSGenericMappings inferGenericArgumentsFromCall(@NotNull List<? extends JSType> parameterTypes, @NotNull List<? extends Supplier<JSType>> arguments, int callArgumentToSkip, @Nullable JSFunctionType jsFunctionType, @Nullable PsiElement context2, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext evaluationContext) {
        if (parameterTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(80);
        }
        if (arguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(81);
        }
        if (evaluationContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(82);
        }
        Set<JSTypeGenericId> generics = jsFunctionType instanceof JSTypeWithGenericParameters ? ((JSTypeWithGenericParameters)((Object)jsFunctionType)).getGenericIds() : Collections.emptySet();
        Integer[] newIndices = JSGenericTypesEvaluatorBase.reorderByDependencies(arguments.size(), parameterTypes, generics);
        JSGenericMappings applyingContext = new JSGenericMappings();
        ProcessingContext processingContext = JSTypeComparingContextService.createProcessingContextWithCache(context2);
        processingContext.put(genericParametersProvider, evaluationContext.genericParametersProvider);
        for (int i = 0; i < arguments.size(); ++i) {
            int j = newIndices[i];
            if (j == callArgumentToSkip) continue;
            if (j >= parameterTypes.size()) break;
            JSType paramType = parameterTypes.get(j);
            if (paramType instanceof JSCodeBasedType) {
                paramType = paramType.substitute(context2);
            }
            if (paramType instanceof JSClassExpressionType) {
                paramType = paramType.asRecordType();
            }
            if (paramType != null) {
                paramType = paramType.substituteCompilerTypesInTypeHierarchy();
            }
            if (!JSTypeUtils.hasTypes(paramType, evaluationContext.acceptableGenericArguments)) continue;
            JSType exprType = JSGenericTypesEvaluatorBase.getArgType(arguments, j);
            boolean matchedTuples = false;
            if (paramType instanceof JSRestTypeImpl) {
                JSRestTypeImpl restParamType = (JSRestTypeImpl)paramType;
                JSType tempType = restParamType.getIterableType();
                if (tempType instanceof JSGenericParameterImpl) {
                    JSType constraintType2 = ((JSGenericParameterImpl)tempType).getConstraintType();
                    if (constraintType2 != null && JSTypeUtils.isIterableCollectionType(constraintType2)) {
                        WidenKind widenKind = restParamType.isConst() ? WidenKind.AS_CONST : WidenKind.WIDEN;
                        List types = JSGenericTypesEvaluatorBase.getArgTypesForRestTuple(arguments, newIndices, widenKind, i);
                        if (restParamType.isConst()) {
                            types = ContainerUtil.map(types, t -> JSWidenType.getTypeInConstContext(t, true, new JSEvaluateContext(null)));
                        }
                        tupleType = JSCompositeTypeFactory.createTupleType(paramType.getSource(), types, true, -1, restParamType.isConst());
                        JSGenericTypesEvaluatorBase.matchGenericTypes(applyingContext, processingContext, tupleType, tempType, evaluationContext);
                        matchedTuples = true;
                    }
                } else if (tempType instanceof JSTupleType) {
                    List<JSType> types = JSGenericTypesEvaluatorBase.getArgTypesForRestTuple(arguments, newIndices, WidenKind.NO_WIDENING, i);
                    int maxLength = ((JSTupleType)tempType).getMaxLength();
                    List<JSType> effectiveTypes = maxLength == Integer.MAX_VALUE ? types : types.subList(0, Math.min(maxLength, types.size()));
                    tupleType = JSCompositeTypeFactory.createTupleType(paramType.getSource(), effectiveTypes, true, -1, false);
                    JSGenericTypesEvaluatorBase.matchGenericTypes(applyingContext, processingContext, tupleType, tempType, evaluationContext);
                    matchedTuples = true;
                }
            }
            if (!matchedTuples) {
                JSGenericTypesEvaluatorBase.matchGenericTypes(applyingContext, processingContext, exprType, paramType, evaluationContext);
            }
            if (matchedTuples) break;
        }
        JSGenericMappings jSGenericMappings = applyingContext;
        if (jSGenericMappings == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(83);
        }
        return jSGenericMappings;
    }

    @NotNull
    private static List<JSType> getArgTypesForRestTuple(@NotNull List<? extends Supplier<JSType>> arguments, Integer @NotNull [] newIndices, @NotNull WidenKind widenKind, int i) {
        if (arguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(84);
        }
        if (widenKind == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(85);
        }
        if (newIndices == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(86);
        }
        ArrayList<JSType> types = new ArrayList<JSType>();
        for (int k = i; k < arguments.size(); ++k) {
            JSType widenedOrNarrowed;
            JSType argType = JSGenericTypesEvaluatorBase.getArgType(arguments, newIndices[k]);
            if (widenKind == WidenKind.WIDEN) {
                widenedOrNarrowed = JSTypeUtils.widenLiteralTypes(argType);
            } else if (widenKind == WidenKind.NO_WIDENING) {
                widenedOrNarrowed = argType;
            } else if (widenKind == WidenKind.AS_CONST) {
                widenedOrNarrowed = null == argType ? null : JSWidenType.getTypeInConstContext(argType, true, new JSEvaluateContext(null));
            } else {
                throw new IllegalArgumentException(String.valueOf((Object)widenKind));
            }
            types.add(widenedOrNarrowed);
        }
        ArrayList<JSType> arrayList = types;
        if (arrayList == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(87);
        }
        return arrayList;
    }

    @Nullable
    private static JSType getArgType(@NotNull List<? extends Supplier<JSType>> arguments, int index) {
        PsiElement sourceElement;
        JSType exprType;
        if (arguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(88);
        }
        if ((exprType = arguments.get(index).get()) != null && exprType.isTypeScript() && (sourceElement = exprType.getSource().getSourceElement()) != null) {
            return TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny(sourceElement, exprType);
        }
        return exprType;
    }

    @NotNull
    public static JSTypeSubstitutor findAndIntersectGenericsTypeValues(@Nullable JSType exprType, @Nullable JSType paramType, @Nullable PsiElement context2) {
        return JSGenericTypesEvaluatorBase.findAndIntersectGenericsTypeValues(exprType, paramType, context2, DEFAULT_CONTEXT);
    }

    @NotNull
    public static JSTypeSubstitutor findAndIntersectGenericsTypeValues(@Nullable JSType exprType, @Nullable JSType paramType, @Nullable PsiElement context2, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext evaluationContext) {
        if (evaluationContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(89);
        }
        if (exprType == null || paramType == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(90);
            }
            return jSTypeSubstitutor;
        }
        JSGenericMappings applyingContext = new JSGenericMappings();
        ProcessingContext contextForMatch = JSTypeComparingContextService.createProcessingContextWithCache(context2);
        JSGenericTypesEvaluatorBase.matchGenericTypes(applyingContext, contextForMatch, exprType, paramType, evaluationContext);
        MultiMap<JSTypeGenericId, JSType> generics = applyingContext.getMapping();
        if (!generics.isEmpty()) {
            ProcessingContext processingContext = JSTypeComparingContextService.createProcessingContextWithCache(context2);
            return JSGenericTypesEvaluatorBase.intersectGenerics(generics, processingContext, null, context2);
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(91);
        }
        return jSTypeSubstitutor;
    }

    protected static MultiMap<JSTypeGenericId, JSType> findGenericsTypeValues(@Nullable JSType exprType, @Nullable JSType paramType, @Nullable PsiElement context2) {
        if (exprType == null || paramType == null) {
            return MultiMap.empty();
        }
        JSGenericMappings applyingContext = new JSGenericMappings();
        JSGenericTypesEvaluatorBase.matchGenericTypes(applyingContext, JSTypeComparingContextService.createProcessingContextWithCache(context2), exprType, paramType);
        return applyingContext.getMapping();
    }

    public static void matchGenericTypes(@NotNull JSGenericMappings applyingContext, @NotNull ProcessingContext processingContext, @Nullable JSType exprType, @NotNull JSType paramType) {
        if (applyingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(92);
        }
        if (processingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(93);
        }
        if (paramType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(94);
        }
        JSGenericTypesEvaluatorBase.matchGenericTypes(applyingContext, processingContext, exprType, paramType, DEFAULT_CONTEXT);
    }

    public static void matchGenericTypes(@NotNull JSGenericMappings applyingContext, @NotNull ProcessingContext processingContext, @Nullable JSType exprType, @NotNull JSType paramType, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext evaluationContext) {
        PsiElement sourceElement;
        JSType toCheck;
        Pair<JSTypeGenericId, Integer> arity;
        if (applyingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(95);
        }
        if (processingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(96);
        }
        if (paramType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(97);
        }
        if (evaluationContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(98);
        }
        if ((arity = evaluationContext.impliedArity) != null) {
            processingContext.put(impliedArity, arity);
        }
        if (paramType == (toCheck = paramType.transformTypeHierarchy(new JSMatchGenericsTransformer(evaluationContext.acceptableGenericArguments)))) {
            return;
        }
        if (JSGenericTypesEvaluatorBase.isUntypedArrowFunction(exprType)) {
            return;
        }
        if (exprType instanceof JSFunctionType && exprType instanceof JSTypeWithGenericParameters && !((JSTypeWithGenericParameters)((Object)exprType)).getGenericIds().isEmpty() && (sourceElement = exprType.getSourceElement()) instanceof JSFunctionExpression && sourceElement.getContext() instanceof JSArgumentList) {
            return;
        }
        processingContext.put(ourGenericArgumentsMapKey, (Object)applyingContext);
        toCheck.isDirectlyAssignableType(exprType instanceof JSSpreadType ? ((JSSpreadType)((Object)exprType)).getComponentType() : exprType, processingContext);
        processingContext.put(ourGenericArgumentsMapKey, null);
    }

    private static boolean isUntypedArrowFunction(JSType type2) {
        return type2 instanceof JSFunctionType && ContainerUtil.and(((JSFunctionType)type2).getParameters(), p -> JSGenericTypesEvaluatorBase.isAnyOrNull(p.getInferredType())) && JSGenericTypesEvaluatorBase.isAnyOrNull(((JSFunctionType)type2).getReturnType());
    }

    private static boolean isAnyOrNull(JSType type1) {
        return type1 == null || !(type1 instanceof JSCodeBasedType) && JSTypeUtils.isAnyType(type1);
    }

    @NotNull
    private static List<JSGenericParameterImpl> getTopLevelGenerics(@Nullable JSType paramType) {
        SmartList topLevelGenerics = new SmartList();
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)arg_0 -> JSGenericTypesEvaluatorBase.lambda$getTopLevelGenerics$19((List)topLevelGenerics, arg_0)), paramType);
        SmartList smartList = topLevelGenerics;
        if (smartList == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(99);
        }
        return smartList;
    }

    @NotNull
    private static JSType evaluateJSGenericsFromQualifier(@NotNull JSType type2, @NotNull JSExpression qualifier) {
        if (type2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(100);
        }
        if (qualifier == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(101);
        }
        return JSGenericTypesEvaluatorBase.evaluateJSGenericsFromQualifier(type2, () -> JSResolveUtil.getElementJSType((PsiElement)qualifier));
    }

    @NotNull
    protected static JSType evaluateJSGenericsFromQualifier(@NotNull JSType type2, @NotNull Supplier<? extends JSType> qualifierTypeSupplier) {
        JSType qualifierType;
        if (type2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(102);
        }
        if (qualifierTypeSupplier == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(103);
        }
        if (type2.getSource().isTypeScript()) {
            JSType jSType = type2;
            if (jSType == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(104);
            }
            return jSType;
        }
        PsiElement sourceElement = type2.getSource().getSourceElement();
        List<String> javaScriptGenericParameters = null;
        JSQualifiedName qualifiedName = null;
        PsiElement namespaceElement = sourceElement;
        if (namespaceElement instanceof JSDocComment) {
            namespaceElement = JSStubBasedPsiTreeUtil.findAssociatedElement((JSDocComment)namespaceElement);
        }
        if (namespaceElement instanceof JSParameter) {
            namespaceElement = ((JSParameter)namespaceElement).getDeclaringFunction();
        }
        if (namespaceElement instanceof JSPsiElementBase && namespaceElement.isValid()) {
            PsiFile file = namespaceElement.getContainingFile();
            for (qualifiedName = ((JSPsiElementBase)namespaceElement).getNamespace(); qualifiedName != null && (javaScriptGenericParameters = JSGenericsIndex.findGenericParameters(qualifiedName.getQualifiedName(), file)) == null; qualifiedName = qualifiedName.getParent()) {
            }
            if (javaScriptGenericParameters != null) {
                type2 = JSGenericTypesEvaluatorBase.convertNamedTypesToGenericParameters(type2, javaScriptGenericParameters);
            }
        }
        if (JSTypeUtils.hasForeignGenericParameter(type2) && javaScriptGenericParameters != null && (qualifierType = qualifierTypeSupplier.get()) != null) {
            qualifierType = JSTypeUtils.unwrapDecorations(qualifierType);
            JSTypeSubstitutor typeArguments2 = JSGenericTypesEvaluatorBase.findTypeArgumentsForClassInHierarchy(qualifierType, qualifiedName, sourceElement);
            JSType jSType = JSTypeUtils.applyGenericArguments(type2, typeArguments2);
            if (jSType == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(105);
            }
            return jSType;
        }
        JSType jSType = type2;
        if (jSType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(106);
        }
        return jSType;
    }

    @NotNull
    private static JSType convertNamedTypesToGenericParameters(@NotNull JSType type2, @NotNull List<String> javaScriptGenericParameters) {
        if (type2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(107);
        }
        if (javaScriptGenericParameters == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(108);
        }
        List<String> genericParameters = javaScriptGenericParameters;
        JSType jSType = type2 = JSTypeUtils.applyCompositeMapping(type2, (Function<? super JSType, ? extends JSType>)((Function)type1 -> {
            String text;
            if (type1 instanceof JSTypeImpl && genericParameters.contains(text = type1.getTypeText())) {
                return new JSGenericParameterImpl(text, type1.getSource(), null);
            }
            return type1;
        }));
        if (jSType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(109);
        }
        return jSType;
    }

    @NotNull
    public static JSTypeSubstitutor findTypeArgumentsForClassInHierarchy(@NotNull JSType genericType, @NotNull JSQualifiedName parentClassNamespace, @NotNull PsiElement scopeElement) {
        String qName;
        if (genericType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(110);
        }
        if (parentClassNamespace == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(111);
        }
        if (scopeElement == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(112);
        }
        if ((qName = JSTypeUtils.getQualifiedNameMatchingType(genericType, true)) == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(113);
            }
            return jSTypeSubstitutor;
        }
        String parentClassName = parentClassNamespace.getQualifiedName();
        if (parentClassName.equals(qName)) {
            List<String> genericParameters = JSGenericsIndex.findGenericParameters(parentClassName, scopeElement.getContainingFile());
            if (genericParameters == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluatorBase.$$$reportNull$$$0(114);
                }
                return jSTypeSubstitutor;
            }
            List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
            if (arguments == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluatorBase.$$$reportNull$$$0(115);
                }
                return jSTypeSubstitutor;
            }
            JSTypeSubstitutorImpl typeArguments2 = new JSTypeSubstitutorImpl();
            for (int i = 0; i < genericParameters.size() && i < arguments.size(); ++i) {
                typeArguments2.putForJSGenerics(genericParameters.get(i), arguments.get(i));
            }
            JSTypeSubstitutorImpl jSTypeSubstitutorImpl = typeArguments2;
            if (jSTypeSubstitutorImpl == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(116);
            }
            return jSTypeSubstitutorImpl;
        }
        GlobalSearchScope scope2 = JSResolveUtil.getResolveScope(scopeElement);
        JSTypeSubstitutor typeArguments3 = JSGenericTypesEvaluatorBase.getTypeArgumentsMap(genericType, scope2);
        return JSGenericTypesEvaluatorBase.applyTypeSubstitutorUpToParentClass(qName, parentClassName, scopeElement, typeArguments3);
    }

    @NotNull
    public static JSTypeSubstitutor applyTypeSubstitutorUpToParentClass(@NotNull String qName, @NotNull String parentClassName, @NotNull PsiElement scopeElement, @NotNull JSTypeSubstitutor typeArguments2) {
        if (qName == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(117);
        }
        if (parentClassName == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(118);
        }
        if (scopeElement == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(119);
        }
        if (typeArguments2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(120);
        }
        TreeItem<String> root = JSTypeEvaluateManager.buildSuperClassesHierarchy(scopeElement, qName);
        ArrayList<String> pathToSuperClass = new ArrayList<String>();
        for (TreeItem parentClass = JSTypeEvaluateManager.findSuperClass(scopeElement, root, parentClassName); parentClass != null && parentClass != root; parentClass = parentClass.getParent()) {
            pathToSuperClass.add(0, (String)parentClass.getData());
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(scopeElement, true);
        GlobalSearchScope scope2 = JSResolveUtil.getResolveScope(scopeElement);
        for (String superClass : pathToSuperClass) {
            JSType type2 = JSTypeParser.createType(scopeElement.getProject(), superClass, typeSource);
            if (type2 == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluatorBase.$$$reportNull$$$0(121);
                }
                return jSTypeSubstitutor;
            }
            type2 = JSTypeUtils.applyGenericArguments(type2, typeArguments2);
            typeArguments2 = JSGenericTypesEvaluatorBase.getTypeArgumentsMap(type2, scope2);
        }
        JSTypeSubstitutor jSTypeSubstitutor = typeArguments2;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(122);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static JSTypeSubstitutor getTypeArgumentsMap(@NotNull JSType genericType, @NotNull GlobalSearchScope scope2) {
        if (genericType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(123);
        }
        if (scope2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(124);
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(genericType, true);
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
        if (qName == null || arguments == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(125);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutorImpl typeArguments2 = new JSTypeSubstitutorImpl();
        List<String> genericParameters = JSGenericsIndex.findGenericParameters(qName, scope2);
        if (genericParameters != null) {
            JSGenericTypesEvaluatorBase.addArgumentsToSubstitutor(genericParameters, arguments, typeArguments2);
        }
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = typeArguments2;
        if (jSTypeSubstitutorImpl == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(126);
        }
        return jSTypeSubstitutorImpl;
    }

    public static void addArgumentsToSubstitutor(@NotNull List<String> parameters2, @NotNull List<JSType> arguments, @NotNull JSTypeSubstitutorImpl typeArguments2) {
        if (parameters2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(127);
        }
        if (arguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(128);
        }
        if (typeArguments2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(129);
        }
        for (int i = 0; i < parameters2.size() && i < arguments.size(); ++i) {
            typeArguments2.putForJSGenerics(parameters2.get(i), arguments.get(i));
        }
    }

    private static /* synthetic */ boolean lambda$getTopLevelGenerics$19(List topLevelGenerics, JSType type2) {
        if (type2 instanceof JSUnionOrIntersectionType) {
            return true;
        }
        if (type2 instanceof JSGenericParameterImpl) {
            topLevelGenerics.add((JSGenericParameterImpl)type2);
        }
        if (type2 instanceof TypeScriptConditionalTypeJSTypeImpl) {
            JSType typeIfTrue;
            JSType typeIfFalse = ((TypeScriptConditionalTypeJSTypeImpl)type2).getTypeIfFalse();
            if (typeIfFalse instanceof JSGenericParameterImpl) {
                topLevelGenerics.add((JSGenericParameterImpl)typeIfFalse);
            }
            if ((typeIfTrue = ((TypeScriptConditionalTypeJSTypeImpl)type2).getTypeIfTrue()) instanceof JSGenericParameterImpl) {
                topLevelGenerics.add((JSGenericParameterImpl)typeIfTrue);
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 7, 9, 10, 11, 12, 13, 15, 16, 21, 23, 25, 29, 30, 38, 42, 43, 45, 50, 66, 67, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 83, 87, 90, 91, 99, 104, 105, 106, 109, 113, 114, 115, 116, 121, 122, 125, 126 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 1: 
            case 33: 
            case 62: 
            case 82: 
            case 89: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 21: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 38: 
            case 42: 
            case 43: 
            case 45: 
            case 50: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 83: 
            case 87: 
            case 90: 
            case 91: 
            case 99: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 121: 
            case 122: 
            case 125: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluatorBase";
                break;
            }
            case 6: 
            case 26: 
            case 32: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callItem";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParametersOwner";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generics";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 19: 
            case 36: 
            case 60: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 28: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitArguments";
                break;
            }
            case 31: 
            case 39: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFunctionType";
                break;
            }
            case 34: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 35: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypes";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 44: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 46: 
            case 92: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyingContext";
                break;
            }
            case 47: 
            case 49: 
            case 54: 
            case 65: 
            case 93: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawTypes";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterId";
                break;
            }
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 57: 
            case 58: 
            case 68: 
            case 100: 
            case 102: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferred";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualParameters";
                break;
            }
            case 81: 
            case 84: 
            case 88: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widenKind";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newIndices";
                break;
            }
            case 94: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramType";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierTypeSupplier";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaScriptGenericParameters";
                break;
            }
            case 110: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClassNamespace";
                break;
            }
            case 112: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClassName";
                break;
            }
            case 120: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluatorBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForExplicitThisParameterType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSQualifierGenericsRemapper";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTypeSubstitutor";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutorForDefaultParameters";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutorForGenericConstraints";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "reorderByDependencies";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameterDefaultType";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "inferGenericTypesForCall";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeExplicitArgumentsCondition";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForReturnType";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypesForInference";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectGenerics";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "widenInferredTypes";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "extractGenericsForParameterType";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "calcExcludedFromWideningByContextType";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "inferGenericArgumentsFromCall";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgTypesForRestTuple";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "findAndIntersectGenericsTypeValues";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelGenerics";
                break;
            }
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateJSGenericsFromQualifier";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "convertNamedTypesToGenericParameters";
                break;
            }
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "findTypeArgumentsForClassInHierarchy";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTypeSubstitutorUpToParentClass";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForExplicitThisParameterType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 21: 
            case 23: 
            case 25: 
            case 29: 
            case 30: 
            case 38: 
            case 42: 
            case 43: 
            case 45: 
            case 50: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 83: 
            case 87: 
            case 90: 
            case 91: 
            case 99: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 121: 
            case 122: 
            case 125: 
            case 126: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeSubstitutor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutorForDefaultParameters";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutorForGenericConstraints";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addGenericDependencyFromType";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "reorderByDependencies";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterDefaultType";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "inferGenericTypesForCall";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "doInferParameters";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getExcludeExplicitArgumentsCondition";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForReturnType";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypesForInference";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "intersectGenericsForCall";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "intersectGenerics";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "addTypesForParameter";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "checkImplicitFlags";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "uniteTypes";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isComingFromAnonymousFunction";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableBySourceStrictness";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "inferGenericArgumentsFromCall";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "widenInferredTypes";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "extractGenericsForParameterType";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getArgTypesForRestTuple";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getArgType";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "findAndIntersectGenericsTypeValues";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "matchGenericTypes";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "evaluateJSGenericsFromQualifier";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "convertNamedTypesToGenericParameters";
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "findTypeArgumentsForClassInHierarchy";
                break;
            }
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "applyTypeSubstitutorUpToParentClass";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgumentsMap";
                break;
            }
            case 127: 
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "addArgumentsToSubstitutor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 7, 9, 10, 11, 12, 13, 15, 16, 21, 23, 25, 29, 30, 38, 42, 43, 45, 50, 66, 67, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 83, 87, 90, 91, 99, 104, 105, 106, 109, 113, 114, 115, 116, 121, 122, 125, 126 -> new IllegalStateException(string);
        };
    }

    private static enum WidenKind {
        WIDEN,
        NO_WIDENING,
        AS_CONST;

    }

    private static final class JSMatchGenericsTransformer
    extends JSCacheableTypeTransformerBase
    implements JSSimpleTransformer {
        @NotNull
        private final Predicate<? super JSType> myAcceptableGenericArguments;

        private JSMatchGenericsTransformer(@NotNull Predicate<? super JSType> acceptableGenericArguments) {
            if (acceptableGenericArguments == null) {
                JSMatchGenericsTransformer.$$$reportNull$$$0(0);
            }
            this.myAcceptableGenericArguments = acceptableGenericArguments;
        }

        @Override
        protected boolean isCompletelyIgnored(@NotNull JSType type2) {
            IndexedData data;
            if (type2 == null) {
                JSMatchGenericsTransformer.$$$reportNull$$$0(1);
            }
            return (data = JSTypeIndexerKt.getTypeIndexedData(type2)).getGenerics().isEmpty() && data.getDeclaredGenerics().isEmpty();
        }

        @Override
        @NotNull
        public JSType fun(@NotNull JSType type2) {
            if (type2 == null) {
                JSMatchGenericsTransformer.$$$reportNull$$$0(2);
            }
            if (!(type2 instanceof JSGenericParameterImpl)) {
                JSType jSType = type2;
                if (jSType == null) {
                    JSMatchGenericsTransformer.$$$reportNull$$$0(3);
                }
                return jSType;
            }
            JSGenericParameterImpl genericParameter = (JSGenericParameterImpl)type2;
            if (!this.myAcceptableGenericArguments.test(genericParameter)) {
                JSGenericParameterImpl jSGenericParameterImpl = genericParameter;
                if (jSGenericParameterImpl == null) {
                    JSMatchGenericsTransformer.$$$reportNull$$$0(4);
                }
                return jSGenericParameterImpl;
            }
            JSGenericParameterImpl jSGenericParameterImpl = genericParameter.copyWithSourceAndApplying(genericParameter.getSource(), JSGenericParameterType.JSGenericState.APPLYING);
            if (jSGenericParameterImpl == null) {
                JSMatchGenericsTransformer.$$$reportNull$$$0(5);
            }
            return jSGenericParameterImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "acceptableGenericArguments";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluatorBase$JSMatchGenericsTransformer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluatorBase$JSMatchGenericsTransformer";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fun";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isCompletelyIgnored";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "fun";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

