/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.IndexedData;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeIndexerKt;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptStringLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTemplateLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeOperator;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptLiteralBasedPropertyElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.generic.JSTypeSubstitutorImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCacheableTypeTransformerResolvedIdBase;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSDistributedType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSKeyofType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTaggedLiteralKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutionContextImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithGenericParameters;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedTypeGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeMemberParser;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveReadonlyArrayType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.lang.javascript.psi.types.recordImpl.ComputedPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.IndexSignatureImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptMappedJSTypeImpl
extends JSTypeBaseImpl
implements JSTypeWithIncompleteSubstitution,
JSDistributedType,
JSEvaluableType,
JSTypeWithGenericParameters {
    private static final Key<Map<JSResolvedTypeId, Map<JSResolvedTypeId, Integer>>> CONVERT_TO_INDEX_ACCESS_KEY = Key.create((String)"convert.as.index.key");
    private static final String INFER_GENERIC_PREFIX = "_infer_";
    private final boolean myReadonly;
    private final boolean myMinusReadonly;
    private final boolean myOptional;
    private final boolean myMinusOptional;
    @NotNull
    private final JSTypeGenericId myParameterId;
    @NotNull
    private final JSType myParameterType;
    @NotNull
    private final JSType myResultType;
    @Nullable
    private final JSType myNameType;
    private final NotNullLazyValue<Boolean> myHasForeignParameters;
    private static final int MAX_SOURCE_DEPTH = 10;

    @ApiStatus.Internal
    public TypeScriptMappedJSTypeImpl(@NotNull JSTypeSource source, boolean isReadonly, boolean isOptional, boolean isMinusReadonly, boolean isMinusOptional, @NotNull JSTypeGenericId parameterId, @NotNull JSType parameterType, @NotNull JSType resultType, @Nullable JSType nameType) {
        if (source == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(0);
        }
        if (parameterId == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(1);
        }
        if (parameterType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(2);
        }
        if (resultType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(3);
        }
        super(source);
        this.myHasForeignParameters = NotNullLazyValue.atomicLazy(() -> JSTypeUtils.hasForeignGenericParameter(this.getParameterType(), new HashSet<JSTypeGenericId>(Collections.singletonList(this.getParameterId()))));
        this.myParameterId = parameterId;
        this.myReadonly = isReadonly;
        this.myMinusReadonly = isMinusReadonly;
        this.myOptional = isOptional;
        this.myMinusOptional = isMinusOptional;
        this.myParameterType = parameterType;
        this.myResultType = resultType;
        this.myNameType = nameType;
    }

    TypeScriptMappedJSTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(4);
        }
        if (inputStream == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(5);
        }
        super(source);
        this.myHasForeignParameters = NotNullLazyValue.atomicLazy(() -> JSTypeUtils.hasForeignGenericParameter(this.getParameterType(), new HashSet<JSTypeGenericId>(Collections.singletonList(this.getParameterId()))));
        this.myParameterId = JSTypeSerializer.readGenericId(inputStream);
        this.myReadonly = JSTypeSerializer.readBoolean(inputStream);
        this.myMinusReadonly = JSTypeSerializer.readBoolean(inputStream);
        this.myOptional = JSTypeSerializer.readBoolean(inputStream);
        this.myMinusOptional = JSTypeSerializer.readBoolean(inputStream);
        this.myParameterType = JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream);
        this.myResultType = JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream);
        this.myNameType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source, inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(6);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeGenericId(this.myParameterId, outputStream);
        JSTypeSerializer.writeBoolean(this.myReadonly, outputStream);
        JSTypeSerializer.writeBoolean(this.myMinusReadonly, outputStream);
        JSTypeSerializer.writeBoolean(this.myOptional, outputStream);
        JSTypeSerializer.writeBoolean(this.myMinusOptional, outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myParameterType, outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myResultType, outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.myNameType, outputStream);
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        if (format == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(7);
        }
        if (builder2 == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(8);
        }
        builder2.append("{");
        boolean readonly = this.isReadonly();
        boolean minusReadonly = this.isMinusReadonly();
        if (readonly || minusReadonly) {
            builder2.append(minusReadonly ? "-readonly " : "readonly ");
        }
        builder2.append("[");
        String name = this.getParameterName();
        builder2.append(name);
        builder2.append(" in ");
        this.getParameterType().buildTypeText(format, builder2);
        JSType nameType = this.getNameType();
        if (nameType != null) {
            builder2.append(" as ");
            nameType.buildTypeText(format, builder2);
        }
        builder2.append("]");
        boolean optional = this.isOptional();
        boolean minusOptional = this.isMinusOptional();
        if (optional || minusOptional) {
            builder2.append(optional ? "?" : "-?");
        }
        builder2.append(this.getTypeSeparator(format));
        this.getResultType().buildTypeText(format, builder2);
        builder2.append("}");
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.getParameterType(), this.getResultType());
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        if (childTransform == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(9);
        }
        if (newSource == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(10);
        }
        JSType newParameterType = JSTypeUtils.transformTypeHierarchySafe(this.getParameterType(), childTransform);
        JSType newResultType = JSTypeUtils.transformTypeHierarchySafe(this.getResultType(), childTransform);
        JSType newNamedType = JSTypeUtils.transformTypeHierarchySafe(this.getNameType(), childTransform);
        if (newParameterType == this.getParameterType() && newResultType == this.getResultType() && newNamedType == this.getNameType()) {
            TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = this;
            if (typeScriptMappedJSTypeImpl == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(11);
            }
            return typeScriptMappedJSTypeImpl;
        }
        JSType jSType = JSCompositeTypeFactory.createMappedType(newSource, this.isReadonly(), this.isOptional(), this.isMinusReadonly(), this.isMinusOptional(), this.myParameterId, newParameterType, newResultType, newNamedType);
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(12);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(13);
        }
        return new TypeScriptMappedJSTypeImpl(source, this.myReadonly, this.myOptional, this.myMinusReadonly, this.myMinusOptional, this.myParameterId, this.myParameterType, this.myResultType, this.myNameType);
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSType substitute;
        if (elementType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(14);
        }
        if (processingContext == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(15);
        }
        if ((substitute = this.substitute(processingContext)) != this) {
            return substitute.isDirectlyAssignableType(elementType, processingContext);
        }
        JSType paramType = this.getParameterType();
        if (JSTypeCastUtil.isTypeOperatorLikeType(paramType) && TypeScriptMappedJSTypeImpl.isDirectAssignableForMappedTypeWithTypeOperator(elementType, this, processingContext, false)) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public Set<JSTypeGenericId> getGenericIds() {
        return Collections.singleton(this.myParameterId);
    }

    public static boolean isDirectAssignableForMappedTypeWithTypeOperator(@NotNull JSType operand, @NotNull TypeScriptMappedJSTypeImpl mappedType, @NotNull ProcessingContext processingContext, boolean isDirectComparing) {
        if (operand == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(16);
        }
        if (mappedType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(17);
        }
        if (processingContext == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(18);
        }
        TypeScriptMappedTypeGenericParameterImpl nameAsType = new TypeScriptMappedTypeGenericParameterImpl(mappedType.myParameterId, mappedType.getSource());
        JSType typeForGuard = TypeScriptMappedJSTypeImpl.getSubstitutionTypeInIndexAccess(operand);
        Boolean referencedType2 = TypeScriptMappedJSTypeImpl.processHomomorphicType(operand, mappedType, processingContext);
        if (referencedType2 != null) {
            return referencedType2;
        }
        return JSRecursiveTypeUtil.computeWithRecursiveTypes(typeForGuard, nameAsType, CONVERT_TO_INDEX_ACCESS_KEY, nameAsType, processingContext, (type2, ctx) -> {
            JSType indexedType = JSCompositeTypeFactory.createIndexedAccessType(operand, type2, mappedType.getSource());
            JSType result2 = mappedType.getResultType();
            return TypeScriptMappedJSTypeImpl.isAssignableDirectOrInverseType(indexedType, result2, ctx, isDirectComparing);
        });
    }

    @Nullable
    private static Boolean processHomomorphicType(@NotNull JSType operand, @NotNull TypeScriptMappedJSTypeImpl mappedType, @NotNull ProcessingContext processingContext) {
        JSType parameterType;
        JSType paramType;
        if (operand == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(19);
        }
        if (mappedType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(20);
        }
        if (processingContext == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(21);
        }
        if (!((paramType = mappedType.getParameterType()) instanceof JSKeyofType)) {
            return null;
        }
        JSType referencedType2 = ((JSKeyofType)paramType).getReferencedType();
        JSType resultType = mappedType.getResultType();
        if (resultType instanceof TypeScriptIndexedAccessJSTypeImpl && (parameterType = ((TypeScriptIndexedAccessJSTypeImpl)resultType).getParameterType()) instanceof JSGenericParameterType && mappedType.getGenericIds().contains(((JSGenericParameterType)parameterType).getGenericId()) && referencedType2.isEquivalentTo(((TypeScriptIndexedAccessJSTypeImpl)resultType).getOwner(), processingContext)) {
            return referencedType2 instanceof JSGenericParameterType && operand.isJavaScript() || referencedType2.isDirectlyAssignableType(operand, processingContext);
        }
        if (JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext) && referencedType2 instanceof JSGenericParameterType) {
            HashMap<String, JSRecordType.MemberSource> sourceMap = new HashMap<String, JSRecordType.MemberSource>();
            Collection<JSRecordType.PropertySignature> allProperties = operand.asRecordType().getProperties();
            HashSet<String> optionalProps = new HashSet<String>();
            HashSet<String> readonlyProps = new HashSet<String>();
            for (JSRecordType.PropertySignature property : allProperties) {
                JSGenericParameterImpl temp_Generic = new JSGenericParameterImpl(new JSTypeSubstitutor.StringGenericId(INFER_GENERIC_PREFIX + property.getMemberName()), resultType.getSource(), JSGenericParameterType.JSGenericState.APPLYING, null);
                JSType type2 = resultType.transformTypeHierarchy((Function<? super JSType, ? extends JSType>)((Function)t -> t instanceof TypeScriptIndexedAccessJSTypeImpl && TypeScriptMappedJSTypeImpl.isIndexedByOwnKey((TypeScriptIndexedAccessJSTypeImpl)t, mappedType.getGenericIds()) ? temp_Generic : t));
                JSType propType = property.getJSType();
                if (propType == null) continue;
                RecursionManager.doPreventingRecursion((Object)"TypeScriptMappedJSTypeImpl.processHomomorphicType", (boolean)false, () -> {
                    JSRecursiveTypeUtil.computeWithRecursiveTypes(type2, propType, CONVERT_TO_INDEX_ACCESS_KEY, propType, processingContext, (t, ctx) -> type2.isDirectlyAssignableType(t, ctx));
                    return null;
                });
                sourceMap.put(property.getMemberName(), JSRecordMemberSourceFactory.createSource(property.getMemberSource().getAllSourceElements(), JSRecordType.MemberSourceKind.MappedNoStatus, false));
                if (property.isOptional()) {
                    optionalProps.add(property.getMemberName());
                }
                if (!property.isConst()) continue;
                readonlyProps.add(property.getMemberName());
            }
            JSGenericMappings mappings = (JSGenericMappings)processingContext.get(JSGenericTypesEvaluator.ourGenericArgumentsMapKey);
            ArrayList<JSRecordType.TypeMember> newTypeProps = new ArrayList<JSRecordType.TypeMember>();
            int inferredCount = 0;
            for (JSTypeGenericId id : new HashSet(mappings.getMapping().keySet())) {
                String name = id.getName();
                if (!name.startsWith(INFER_GENERIC_PREFIX)) continue;
                Collection types = mappings.getMapping().remove((Object)id);
                String propName = name.substring(INFER_GENERIC_PREFIX.length());
                if (types == null || !sourceMap.containsKey(propName)) continue;
                JSType type3 = JSCompositeTypeFactory.createUnionType(referencedType2.getSource(), types);
                newTypeProps.addAll(TypeScriptMappedJSTypeImpl.mapNameAndCreateProperty(mappedType, propName, type3, readonlyProps.contains(propName), optionalProps.contains(propName), (JSRecordType.MemberSource)sourceMap.get(propName), null));
                ++inferredCount;
            }
            if (inferredCount == allProperties.size()) {
                mappings.getMapping().put((Object)((JSGenericParameterType)referencedType2).getGenericId(), (Collection)new SmartList((Object)new JSRecordTypeImpl(referencedType2.getSource(), newTypeProps)));
            }
        }
        return null;
    }

    private static boolean isIndexedByOwnKey(TypeScriptIndexedAccessJSTypeImpl t, Set<JSTypeGenericId> ids) {
        JSType type2 = t.getParameterType();
        return type2 instanceof JSGenericParameterType && ids.contains(((JSGenericParameterType)type2).getGenericId());
    }

    private static boolean isAssignableDirectOrInverseType(@NotNull JSType thisType, @NotNull JSType rType, @NotNull ProcessingContext context2, boolean direct) {
        if (thisType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(22);
        }
        if (rType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(23);
        }
        if (context2 == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(24);
        }
        return direct ? thisType.isDirectlyAssignableType(rType, context2) : rType.isDirectlyAssignableType(thisType, context2);
    }

    @NotNull
    public static JSType getSubstitutionTypeInIndexAccess(@NotNull JSType elementType) {
        if (elementType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(25);
        }
        while (elementType instanceof TypeScriptIndexedAccessJSTypeImpl) {
            elementType = ((TypeScriptIndexedAccessJSTypeImpl)elementType).getOwner();
        }
        JSType jSType = elementType;
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(26);
        }
        return jSType;
    }

    @Override
    @Nullable
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context2) {
        if (context2 == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(27);
        }
        if (JSTypeUtils.hasSignificantGenericParameter(this.getParameterType(), Collections.singleton(this.getParameterId()))) {
            return this;
        }
        return this.substituteInternal(context2);
    }

    @Override
    @NotNull
    public JSType substituteCompletely() {
        if (JSTypeUtils.hasSignificantGenericParameter(this.getParameterType(), Collections.singleton(this.getParameterId()))) {
            JSType jSType = this.getResolveCachedType(() -> this.substituteInternal(new JSTypeSubstitutionContextImpl()), SUBSTITUTE_COMPLETE);
            if (jSType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(28);
            }
            return jSType;
        }
        JSType jSType = this.substitute();
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(29);
        }
        return jSType;
    }

    public boolean hasForeignGenericParameters() {
        return this.myHasForeignParameters.getValue() == Boolean.TRUE;
    }

    @Nullable
    private JSType substituteInternal(@NotNull JSTypeSubstitutionContext context2) {
        JSType distributeType;
        if (context2 == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(30);
        }
        if ((distributeType = this.distributeType()) != this) {
            return distributeType;
        }
        JSType parameterType = this.getParameterType();
        JSType originalResultType = this.getResultType();
        Map<String, LiteralStatus> sources = TypeScriptMappedJSTypeImpl.buildLiteralSourceElementsMap(parameterType, context2);
        JSType parType = context2.substituteNested(parameterType);
        if (parType == null) {
            return null;
        }
        if (sources.isEmpty()) {
            return this.substituteNoStrings(originalResultType, parType);
        }
        Ref canPropagateOptStatus = Ref.create((Object)TypeScriptMappedJSTypeImpl.canPropagateOptionalStatus(parameterType));
        JSRecordType originalType = TypeScriptMappedJSTypeImpl.getOriginalType(parameterType, this, (Ref<Boolean>)canPropagateOptStatus, context2);
        List<JSRecordType.TypeMember> result2 = this.substituteGeneral(parameterType, originalResultType, sources, originalType, (Boolean)canPropagateOptStatus.get(), context2);
        JSTypeSource typeSource = originalType != null && originalType.getSourceElement() != null ? originalType.getSource() : this.getSource();
        typeSource = TypeScriptMappedJSTypeImpl.updateIfFromJSDoc(typeSource, originalResultType);
        return new JSRecordTypeImpl(typeSource, result2);
    }

    private boolean isIndexedType(@NotNull JSType originalResultType) {
        if (originalResultType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(31);
        }
        return originalResultType instanceof TypeScriptIndexedAccessJSTypeImpl && TypeScriptMappedJSTypeImpl.isParameter(this.myParameterId, ((TypeScriptIndexedAccessJSTypeImpl)originalResultType).getParameterType());
    }

    @NotNull
    private List<JSRecordType.TypeMember> substituteGeneral(@NotNull JSType parameterType, @NotNull JSType originalResultType, @NotNull Map<String, LiteralStatus> sources, @Nullable JSRecordType originalType, boolean canPropagateOptStatus, @NotNull JSTypeSubstitutionContext context2) {
        if (parameterType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(32);
        }
        if (originalResultType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(33);
        }
        if (sources == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(34);
        }
        if (context2 == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(35);
        }
        boolean hasOptionalKeyword = this.isOptional();
        boolean hasMinusOptionalKeyword = this.isMinusOptional();
        List<JSRecordType> keyBases = TypeScriptMappedJSTypeImpl.getKeyBases(parameterType);
        SmartList result2 = new SmartList();
        JSRecordType mappedRecord = this.extractKeyOwnerType(originalResultType);
        for (Map.Entry<String, LiteralStatus> entry : sources.entrySet()) {
            String key = entry.getKey();
            LiteralStatus status = entry.getValue();
            JSRecordType.PropertySignature mappedProperty = mappedRecord != null ? mappedRecord.findPropertySignature(key) : null;
            JSType propertyType = this.getPropertyType(key, originalResultType, keyBases, mappedProperty);
            JSRecordType.MemberSource source = this.computeCommonMemberSource(status == null ? Collections.emptySet() : status.sources, originalType, mappedProperty, key);
            boolean originalOptional = TypeScriptMappedJSTypeImpl.calcOriginalOptional(originalType, key, status);
            boolean propIsOptional = hasOptionalKeyword || canPropagateOptStatus && !hasMinusOptionalKeyword && originalOptional;
            result2.addAll(TypeScriptMappedJSTypeImpl.mapNameAndCreateProperty(this, key, propertyType, propIsOptional, this.isReadonly(), source, context2));
        }
        SmartList smartList = result2;
        if (smartList == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(36);
        }
        return smartList;
    }

    @Nullable
    private JSRecordType extractKeyOwnerType(@NotNull JSType originalResultType) {
        if (originalResultType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(37);
        }
        if (!this.isIndexedType(originalResultType)) {
            return null;
        }
        JSType owner = ((TypeScriptIndexedAccessJSTypeImpl)originalResultType).getOwner();
        return owner.asRecordType();
    }

    @NotNull
    private JSType getPropertyType(@NotNull String name, @NotNull JSType originalResultType, @NotNull List<JSRecordType> keyBases, @Nullable JSRecordType.PropertySignature propertySignature) {
        JSType type2;
        if (name == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(38);
        }
        if (originalResultType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(39);
        }
        if (keyBases == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(40);
        }
        if (propertySignature != null && (type2 = propertySignature.getJSType()) != null) {
            JSType jSType = type2;
            if (jSType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(41);
            }
            return jSType;
        }
        JSStringLiteralTypeImpl toReplace = !keyBases.isEmpty() ? JSTypeKeyTypeImpl.createKeyType(name, keyBases, originalResultType.getSource()) : new JSStringLiteralTypeImpl(name, false, originalResultType.getSource());
        JSType jSType = originalResultType.transformTypeHierarchy(new ParameterRemapper(this, toReplace));
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(42);
        }
        return jSType;
    }

    @NotNull
    private JSTypeBaseImpl substituteNoStrings(JSType originalResultType, JSType type2) {
        JSRecordType.ComputedMember propertySignature;
        JSType resultType = this.applyStringGenericToMemberType(originalResultType);
        if (JSTypeUtils.isAnyType(type2)) {
            List<IndexSignatureImpl> indexSignatures = Arrays.asList(new IndexSignatureImpl((JSType)JSNamedTypeFactory.createStringPrimitiveType(this.getSource()), resultType, this.getSourceElement(), false), new IndexSignatureImpl((JSType)JSNamedTypeFactory.createNumberPrimitiveType(this.getSource()), resultType, this.getSourceElement(), false), new IndexSignatureImpl((JSType)JSNamedTypeFactory.createSymbolPrimitiveType(this.getSource()), resultType, this.getSourceElement(), false));
            return new JSRecordTypeImpl(this.getSource(), indexSignatures);
        }
        if (type2 instanceof JSGenericParameterType) {
            return new JSRecordTypeImpl(this.getSource(), Collections.singletonList(new IndexSignatureImpl((JSType)JSNamedTypeFactory.createStringPrimitiveType(this.getSource()), resultType, this.getSourceElement(), false)));
        }
        if (JSRecordTypeImpl.isValidIndexerParameterType(type2)) {
            return new JSRecordTypeImpl(this.getSource(), Collections.singletonList(new IndexSignatureImpl(type2, resultType, this.getSourceElement(), false)));
        }
        if (type2 instanceof JSUnionType) {
            List<JSRecordType.TypeMember> indexSignatures = this.createMembersForUnion((JSUnionType)type2, resultType);
            return new JSRecordTypeImpl(this.getSource(), indexSignatures);
        }
        if (type2 instanceof TypeScriptNeverType) {
            return new JSRecordTypeImpl(this.getSource(), Collections.emptyList());
        }
        if (type2 instanceof JSUniqueSymbolTypeImpl && (propertySignature = this.createSymbolComputedProperty(type2, resultType)) != null) {
            return new JSRecordTypeImpl(this.getSource(), Collections.singletonList(propertySignature));
        }
        JSAnyType jSAnyType = JSAnyType.getWithLanguage(this.getSource().getLanguage());
        if (jSAnyType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(43);
        }
        return jSAnyType;
    }

    @NotNull
    private JSType applyStringGenericToMemberType(@NotNull JSType originalResultType) {
        if (originalResultType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(44);
        }
        JSTypeSubstitutorImpl substitutor = new JSTypeSubstitutorImpl();
        substitutor.put(this.getParameterId(), JSNamedTypeFactory.createStringPrimitiveType(this.getSource()));
        JSType resultType = JSTypeUtils.applyGenericArguments(originalResultType, substitutor);
        if (this.myOptional) {
            resultType = JSTypeGuardUtil.wrapWithUndefined(resultType, this.getSource());
        }
        JSType jSType = resultType;
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(45);
        }
        return jSType;
    }

    @NotNull
    private List<JSRecordType.TypeMember> createMembersForUnion(@NotNull JSUnionType parameterType, @NotNull JSType memberType) {
        if (parameterType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(46);
        }
        if (memberType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(47);
        }
        List list = ContainerUtil.mapNotNull(parameterType.getTypes(), type2 -> {
            if (type2 instanceof JSUniqueSymbolTypeImpl) {
                return this.createSymbolComputedProperty((JSType)type2, memberType);
            }
            if (JSRecordTypeImpl.isValidIndexerParameterType(type2)) {
                return new IndexSignatureImpl((JSType)type2, memberType, this.getSourceElement(), false);
            }
            return null;
        });
        if (list == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(48);
        }
        return list;
    }

    @Nullable
    private JSRecordType.ComputedMember createSymbolComputedProperty(@NotNull JSType parameterType, @NotNull JSType memberType) {
        String nameRef;
        if (parameterType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(49);
        }
        if (memberType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(50);
        }
        if (StringUtil.isEmpty((String)(nameRef = TypeScriptTypeMemberParser.getComputedPropNameFromType(parameterType)))) {
            return null;
        }
        return new ComputedPropertySignatureImpl(nameRef, memberType, this.isOptional(), this.isReadonly(), JSRecordMemberSourceFactory.createSource(this.getSourceElement()));
    }

    @NotNull
    private static List<JSRecordType.TypeMember> mapNameAndCreateProperty(@NotNull TypeScriptMappedJSTypeImpl mappedType, @NotNull String memberName, @Nullable JSType type2, boolean propIsOptional, boolean readonly, @NotNull JSRecordType.MemberSource source, @Nullable JSTypeSubstitutionContext context2) {
        JSType nameType;
        if (mappedType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(51);
        }
        if (memberName == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(52);
        }
        if (source == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(53);
        }
        if (type2 != null && JSTypeUtils.hasForeignGenericParameter(type2)) {
            JSStringLiteralTypeImpl toReplace = new JSStringLiteralTypeImpl(memberName, false, type2.getSource());
            type2 = type2.transformTypeHierarchy(new ParameterRemapper(mappedType, toReplace));
        }
        if ((nameType = mappedType.getNameType()) != null) {
            JSStringLiteralTypeImpl toReplace = new JSStringLiteralTypeImpl(memberName, false, nameType.getSource());
            JSType newNamedType = nameType.transformTypeHierarchy(new ParameterRemapper(mappedType, toReplace));
            JSType substitute = context2 == null ? newNamedType.substitute() : context2.substituteNested(newNamedType);
            SmartList result2 = new SmartList();
            List<JSType> types = substitute instanceof JSUnionType ? ((JSUnionType)substitute).getTypes() : Collections.singletonList(substitute);
            for (JSType jsType : types) {
                if (!(jsType instanceof JSStringLiteralTypeImpl)) continue;
                String mappedName = ((JSStringLiteralTypeImpl)jsType).getLiteral();
                result2.add(new PropertySignatureImpl(mappedName, type2, propIsOptional, readonly, source));
            }
            SmartList smartList = result2;
            if (smartList == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(54);
            }
            return smartList;
        }
        List<JSRecordType.TypeMember> list = Collections.singletonList(new PropertySignatureImpl(memberName, type2, propIsOptional, readonly, source));
        if (list == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(55);
        }
        return list;
    }

    @NotNull
    private static JSTypeSource updateIfFromJSDoc(@NotNull JSTypeSource typeSource, @Nullable JSType resultType) {
        JSType owner;
        if (typeSource == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(56);
        }
        if (resultType instanceof TypeScriptIndexedAccessJSTypeImpl && (owner = ((TypeScriptIndexedAccessJSTypeImpl)resultType).getOwner()) instanceof JSRecordType && owner.isJavaScript() && owner.getSourceElement() instanceof JSDocComment) {
            JSTypeSource jSTypeSource = owner.getSource();
            if (jSTypeSource == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(57);
            }
            return jSTypeSource;
        }
        JSTypeSource jSTypeSource = typeSource;
        if (jSTypeSource == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(58);
        }
        return jSTypeSource;
    }

    private static boolean calcOriginalOptional(@Nullable JSRecordType originalType, @NotNull String memberName, @Nullable LiteralStatus status) {
        JSRecordType.PropertySignature originalSignature;
        if (memberName == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(59);
        }
        JSRecordType.PropertySignature propertySignature = originalSignature = originalType != null ? originalType.findPropertySignature(memberName) : null;
        if (originalSignature != null) {
            return originalSignature.isOptional();
        }
        return status != null && status.isOptional();
    }

    private static boolean canPropagateOptionalStatus(@Nullable JSType parameterType) {
        if (!(parameterType instanceof JSUnionOrIntersectionType)) {
            return true;
        }
        return parameterType.getSourceElement() instanceof TypeScriptTypeOperator;
    }

    @NotNull
    private static List<JSRecordType> getKeyBases(@Nullable JSType parameterType) {
        if (parameterType instanceof JSKeyofType) {
            List<JSRecordType> list = Collections.singletonList(((JSKeyofType)parameterType).getReferencedType().asRecordType());
            if (list == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(60);
            }
            return list;
        }
        if (parameterType instanceof JSUnionOrIntersectionType) {
            List<JSRecordType> list = ((JSUnionOrIntersectionType)parameterType).getTypes().stream().filter(t -> t instanceof JSKeyofType).map(t -> ((JSKeyofType)t).getReferencedType().asRecordType()).collect(Collectors.toList());
            if (list == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(61);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(62);
        }
        return list;
    }

    @NotNull
    private static List<JSType> collectReferencedTypes(@Nullable JSType type2, boolean expandTypeof) {
        JSResolvedTypeInfo info;
        JSType alias;
        if (type2 instanceof JSKeyofType) {
            List list = ContainerUtil.createMaybeSingletonList((Object)((JSKeyofType)type2).getReferencedType());
            if (list == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(63);
            }
            return list;
        }
        if (type2 instanceof JSUnionOrIntersectionType) {
            ArrayList<JSType> types = new ArrayList<JSType>();
            for (JSType part : ((JSUnionOrIntersectionType)type2).getTypes()) {
                types.addAll(TypeScriptMappedJSTypeImpl.collectReferencedTypes(part, false));
            }
            ArrayList<JSType> arrayList = types;
            if (arrayList == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(64);
            }
            return arrayList;
        }
        if (expandTypeof && type2 instanceof JSResolvableType && (alias = (info = ((JSResolvableType)type2).resolveType()).getAliasedType()) != null) {
            return TypeScriptMappedJSTypeImpl.collectReferencedTypes(alias, false);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(65);
        }
        return list;
    }

    @Nullable
    private static JSRecordType getOriginalType(@Nullable JSType type2, @NotNull TypeScriptMappedJSTypeImpl mappedJSType, @NotNull Ref<Boolean> canPropagateOptionalStatus, @NotNull JSTypeSubstitutionContext context2) {
        JSType genericParameterValue;
        JSType referencedType2;
        JSType constraintType2;
        JSType typeParameterType;
        TypeScriptType typeElement;
        TypeScriptMappedTypeParameter typeParameter;
        PsiElement sourceElement;
        if (mappedJSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(66);
        }
        if (canPropagateOptionalStatus == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(67);
        }
        if (context2 == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(68);
        }
        if (!(type2 instanceof JSKeyofType) && context2 instanceof JSTypeSubstitutionContextImpl && (sourceElement = mappedJSType.getSourceElement()) instanceof TypeScriptMappedType && (typeParameter = ((TypeScriptMappedType)sourceElement).getTypeParameter()) != null && (typeElement = typeParameter.getTypeElement()) instanceof TypeScriptSingleType && (typeParameterType = typeElement.getJSType()) instanceof JSGenericParameterType && (constraintType2 = ((JSGenericParameterType)typeParameterType).getConstraintType()) instanceof JSKeyofType && (referencedType2 = ((JSKeyofType)constraintType2).getReferencedType()) instanceof JSGenericParameterType && (genericParameterValue = ((JSTypeSubstitutionContextImpl)context2).getGenericParameterTypeFromHierarchyForMappedType((JSGenericParameterType)referencedType2)) != null) {
            canPropagateOptionalStatus.set((Object)true);
            return genericParameterValue.asRecordType();
        }
        List<JSType> types = TypeScriptMappedJSTypeImpl.collectReferencedTypes(type2, true);
        if (types.isEmpty()) {
            return null;
        }
        if (types.size() == 1) {
            return types.get(0).asRecordType();
        }
        assert (type2 != null);
        return JSCompositeTypeFactory.createUnionType(type2.getSource(), types).asRecordType();
    }

    @NotNull
    private JSRecordType.MemberSource computeCommonMemberSource(@NotNull Set<PsiElement> extraSourceElements, @Nullable JSRecordType originalType, @Nullable JSRecordType.TypeMember typeMember, @NotNull String memberName) {
        JSRecordType.MemberSource originalSignatureSource;
        JSRecordType.PropertySignature originalSignature;
        JSRecordType.MemberSource source;
        if (extraSourceElements == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(69);
        }
        if (memberName == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(70);
        }
        JSRecordType.MemberSource memberSource = source = typeMember == null ? JSRecordMemberSourceFactory.createEmptySource() : typeMember.getMemberSource().copyWithKind(this.getMemberSourceKind());
        if (originalType != null && (originalSignature = originalType.findPropertySignature(memberName)) != null && !(originalSignatureSource = originalSignature.getMemberSource()).isEmpty()) {
            source = source.isEmpty() ? originalSignatureSource.copyWithKind(this.getMemberSourceKind()) : JSRecordMemberSourceFactory.createSource(JSRecordMemberSourceFactory.mergeCollectionToUnique(source.getAllSourceElements(), originalSignatureSource.getAllSourceElements()), this.getMemberSourceKind(), false);
        }
        Collection<PsiElement> sourceElements = JSRecordMemberSourceFactory.mergeCollectionToUnique(extraSourceElements, source.getAllSourceElements());
        JSRecordType.MemberSource memberSource2 = JSRecordMemberSourceFactory.createSource(sourceElements, this.getMemberSourceKind(), false);
        if (memberSource2 == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(71);
        }
        return memberSource2;
    }

    @NotNull
    private JSRecordType.MemberSourceKind getMemberSourceKind() {
        JSRecordType.MemberSourceKind memberSourceKind = JSRecordType.MemberSourceKind.getMappedKind(this.isOptional(), this.isMinusOptional(), this.isReadonly(), this.isMinusReadonly());
        if (memberSourceKind == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(72);
        }
        return memberSourceKind;
    }

    @NotNull
    private static Map<String, LiteralStatus> buildLiteralSourceElementsMap(@Nullable JSType type2, @NotNull JSTypeSubstitutionContext context2) {
        if (context2 == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(73);
        }
        if (type2 == null) {
            Map<String, LiteralStatus> map2 = Collections.emptyMap();
            if (map2 == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(74);
            }
            return map2;
        }
        LinkedHashMap<String, LiteralStatus> map3 = new LinkedHashMap<String, LiteralStatus>();
        TypeScriptMappedJSTypeImpl.fillExtraLiteralSourceElements(type2, map3, context2, 0);
        LinkedHashMap<String, LiteralStatus> linkedHashMap = map3;
        if (linkedHashMap == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(75);
        }
        return linkedHashMap;
    }

    private static void fillExtraLiteralSourceElements(@Nullable JSType type2, @NotNull Map<String, LiteralStatus> sourceElements, @NotNull JSTypeSubstitutionContext context2, int depth) {
        JSType substitute;
        LiteralStatus status;
        String literal;
        PsiElement owner;
        String literal2;
        if (sourceElements == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(76);
        }
        if (context2 == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(77);
        }
        if (depth > 10 || type2 == null) {
            return;
        }
        if (type2 instanceof JSTypeImpl) {
            TypeScriptEnumField field;
            JSResolvedTypeInfo typeInfo = ((JSTypeImpl)type2).resolveType();
            if (typeInfo.isEnumWithLiteralValues()) {
                TypeScriptEnum tsEnum = typeInfo.getDeclarationOfType(TypeScriptEnum.class);
                if (tsEnum != null) {
                    for (JSField field2 : tsEnum.getFields()) {
                        TypeScriptMappedJSTypeImpl.putIfStringLiteral(sourceElements, (TypeScriptEnumField)field2);
                    }
                }
            } else if (typeInfo.isEnumLiteral() && (field = typeInfo.getDeclarationOfType(TypeScriptEnumField.class)) != null) {
                TypeScriptMappedJSTypeImpl.putIfStringLiteral(sourceElements, field);
            }
        }
        if ((type2 = context2.substituteNested(type2)) instanceof JSUnionOrIntersectionType) {
            for (JSType part : ((JSUnionOrIntersectionType)type2).getTypes()) {
                TypeScriptMappedJSTypeImpl.fillExtraLiteralSourceElements(part, sourceElements, context2, depth + 1);
            }
            return;
        }
        if (type2 instanceof JSTypeKeyTypeImpl) {
            literal2 = ((JSTypeKeyTypeImpl)type2).getLiteral();
            LiteralStatus status2 = TypeScriptMappedJSTypeImpl.getOrCreateStatus(sourceElements, literal2);
            status2.addKey((JSTypeKeyTypeImpl)type2);
            return;
        }
        if (type2 instanceof JSTaggedLiteralKeyTypeImpl) {
            owner = type2.getSource().getSourceElement();
            if (owner instanceof TypeScriptStringLiteralType) {
                literal = ((JSTaggedLiteralKeyTypeImpl)type2).getLiteral();
                status = TypeScriptMappedJSTypeImpl.getOrCreateStatus(sourceElements, literal);
                status.add((PsiElement)new TypeScriptLiteralBasedPropertyElementImpl(literal, owner));
            }
            return;
        }
        if (type2 instanceof JSStringLiteralTypeImpl) {
            owner = type2.getSource().getSourceElement();
            literal = ((JSStringLiteralTypeImpl)type2).getLiteral();
            status = TypeScriptMappedJSTypeImpl.getOrCreateStatus(sourceElements, literal);
            if (owner instanceof TypeScriptTemplateLiteralType || owner instanceof TypeScriptStringLiteralType || owner instanceof JSLiteralExpression) {
                status.add((PsiElement)new TypeScriptLiteralBasedPropertyElementImpl(literal, owner));
            }
            return;
        }
        if (type2 instanceof JSNumberLiteralTypeImpl) {
            literal2 = ((JSNumberLiteralTypeImpl)type2).getValueAsString();
            TypeScriptMappedJSTypeImpl.getOrCreateStatus(sourceElements, literal2);
            return;
        }
        if (type2 != null && (substitute = JSTypeWithIncompleteSubstitution.substituteCompletely(type2)) != type2) {
            TypeScriptMappedJSTypeImpl.fillExtraLiteralSourceElements(substitute, sourceElements, context2, depth + 1);
        }
    }

    private static void putIfStringLiteral(@NotNull Map<String, LiteralStatus> sourceElements, @NotNull TypeScriptEnumField field) {
        String stringValue;
        if (sourceElements == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(78);
        }
        if (field == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(79);
        }
        if (!StringUtil.isEmpty((String)(stringValue = field.getConstantValue().getAsString()))) {
            LiteralStatus status = TypeScriptMappedJSTypeImpl.getOrCreateStatus(sourceElements, stringValue);
            status.add((PsiElement)new TypeScriptLiteralBasedPropertyElementImpl(stringValue, (PsiElement)field));
        }
    }

    @NotNull
    private static LiteralStatus getOrCreateStatus(@NotNull Map<String, LiteralStatus> sourceElements, @NotNull String stringValue) {
        if (sourceElements == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(80);
        }
        if (stringValue == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(81);
        }
        LiteralStatus literalStatus = sourceElements.computeIfAbsent(stringValue, key -> new LiteralStatus());
        if (literalStatus == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(82);
        }
        return literalStatus;
    }

    private static boolean isParameter(@NotNull JSTypeGenericId id, @NotNull JSType el) {
        if (id == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(83);
        }
        if (el == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(84);
        }
        return el instanceof TypeScriptMappedTypeGenericParameterImpl && id.equals(((TypeScriptMappedTypeGenericParameterImpl)el).getGenericId());
    }

    public boolean isReadonly() {
        return this.myReadonly;
    }

    public boolean isMinusReadonly() {
        return this.myMinusReadonly;
    }

    public boolean isMinusOptional() {
        return this.myMinusOptional;
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type2, ProcessingContext context2, boolean allowResolve) {
        if (type2 == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(85);
        }
        TypeScriptMappedJSTypeImpl mappedType = (TypeScriptMappedJSTypeImpl)type2;
        return this.isReadonly() == mappedType.isReadonly() && this.isMinusReadonly() == mappedType.isMinusReadonly() && this.isOptional() == mappedType.isOptional() && this.isMinusOptional() == mappedType.isMinusOptional() && this.getParameterType().isEquivalentTo(mappedType.getParameterType(), context2, allowResolve) && this.getResultType().isEquivalentTo(mappedType.getResultType(), context2, allowResolve) && JSType.isEquivalentToSafe(this.getNameType(), mappedType.getNameType(), context2, allowResolve);
    }

    @Nullable
    private JSType getNameType() {
        return this.myNameType;
    }

    @NotNull
    public JSType getParameterType() {
        JSType jSType = this.myParameterType;
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(86);
        }
        return jSType;
    }

    @NotNull
    public JSType getResultType() {
        JSType jSType = this.myResultType;
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(87);
        }
        return jSType;
    }

    public boolean isOptional() {
        return this.myOptional;
    }

    @NotNull
    public String getParameterName() {
        String string = this.myParameterId.getName();
        if (string == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(88);
        }
        return string;
    }

    @NotNull
    public JSTypeGenericId getParameterId() {
        JSTypeGenericId jSTypeGenericId = this.myParameterId;
        if (jSTypeGenericId == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(89);
        }
        return jSTypeGenericId;
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(90);
        }
        this.myResultType.accept(visitor);
        this.myParameterType.accept(visitor);
    }

    @Override
    @NotNull
    public JSType distributeType() {
        JSType parameterType = this.getParameterType();
        if (parameterType instanceof JSKeyofType) {
            return this.distributeByKey(((JSKeyofType)parameterType).getReferencedType());
        }
        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = this;
        if (typeScriptMappedJSTypeImpl == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(91);
        }
        return typeScriptMappedJSTypeImpl;
    }

    @NotNull
    private JSType distributeByKey(JSType keyType2) {
        if (keyType2 instanceof JSPrimitiveType && !(keyType2 instanceof JSPrimitiveLiteralType)) {
            JSType jSType = keyType2;
            if (jSType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(92);
            }
            return jSType;
        }
        if (keyType2 instanceof JSUnionType) {
            List<JSType> types = ((JSUnionType)keyType2).getTypes();
            ArrayList<JSType> newTypes = new ArrayList<JSType>(types.size());
            JSType resultType = this.getResultType();
            for (JSType type2 : types) {
                newTypes.add(JSCompositeTypeFactory.createMappedType(this.getSource(), this.isReadonly(), this.isOptional(), this.isMinusReadonly(), this.isMinusOptional(), this.myParameterId, JSCompositeTypeFactory.createKeyOfType(type2, this.getSource()), TypeScriptMappedJSTypeImpl.transformForIndexer(keyType2, this.myParameterId, type2, resultType, true), this.getNameType()));
            }
            JSType jSType = JSCompositeTypeFactory.createUnionType(this.getSource(), newTypes);
            if (jSType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(93);
            }
            return jSType;
        }
        JSGenericTypeImpl genericArrayType = TypeScriptMappedJSTypeImpl.getGenericArrayType(keyType2);
        if (genericArrayType != null) {
            JSType arrayBase = genericArrayType.getType();
            JSType S = genericArrayType.getArguments().get(0);
            JSType X = this.getResultType();
            if (this.isReadonly() && TypeScriptMappedJSTypeImpl.isArrayKind(arrayBase, "Array")) {
                arrayBase = new JSPrimitiveReadonlyArrayType(arrayBase.getSource(), ((JSNamedType)arrayBase).getTypeContext());
            } else if (this.isMinusReadonly() && TypeScriptMappedJSTypeImpl.isArrayKind(arrayBase, "ReadonlyArray")) {
                arrayBase = new JSPrimitiveArrayType(arrayBase.getSource(), ((JSNamedType)arrayBase).getTypeContext());
            }
            return new JSGenericTypeImpl(this.getSource(), arrayBase, TypeScriptMappedJSTypeImpl.transformForIndexer(keyType2, this.myParameterId, S, X, false));
        }
        if (keyType2 instanceof JSTupleType) {
            List<JSType> types = ((JSTupleType)keyType2).getTypes();
            ArrayList<JSType> newTypes = new ArrayList<JSType>(types.size());
            JSType X = this.getResultType();
            for (JSType type3 : types) {
                newTypes.add(TypeScriptMappedJSTypeImpl.transformForIndexer(keyType2, this.myParameterId, type3, X, false));
            }
            JSType jSType = JSCompositeTypeFactory.createTupleType(this.getSource(), newTypes, keyType2.isSourceStrict(), ((JSTupleType)keyType2).getOptionalStart(), !this.isMinusReadonly() && (this.isReadonly() || ((JSTupleType)keyType2).isReadonly()));
            if (jSType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(94);
            }
            return jSType;
        }
        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = this;
        if (typeScriptMappedJSTypeImpl == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(95);
        }
        return typeScriptMappedJSTypeImpl;
    }

    private static boolean isArrayKind(JSType type2, String arrayClass) {
        return type2 instanceof JSNamedType && arrayClass.equals(((JSNamedType)type2).getQualifiedName().getQualifiedName());
    }

    private static JSType transformForIndexer(JSType keyType2, JSTypeGenericId parameterId, JSType type2, JSType x, boolean preserveIndexer) {
        return x.transformTypeHierarchy((Function<? super JSType, ? extends JSType>)((Function)t -> {
            if (t instanceof TypeScriptIndexedAccessJSTypeImpl) {
                JSType owner = ((TypeScriptIndexedAccessJSTypeImpl)t).getOwner();
                JSType parameterType = ((TypeScriptIndexedAccessJSTypeImpl)t).getParameterType();
                if (owner.isEquivalentTo(keyType2, null, true) && TypeScriptMappedJSTypeImpl.isParameter(parameterId, parameterType)) {
                    return preserveIndexer ? JSCompositeTypeFactory.createIndexedAccessType(type2, parameterType, t.getSource()).substitute() : type2;
                }
            }
            return t;
        }));
    }

    @Nullable
    private static JSGenericTypeImpl getGenericArrayType(@Nullable JSType keyType2) {
        JSType constraintType2;
        JSGenericTypeImpl genericArrayType = null;
        if (keyType2 instanceof JSArrayType) {
            genericArrayType = ((JSArrayType)keyType2).asGenericType();
        } else if (keyType2 instanceof JSGenericTypeImpl) {
            String typeText;
            JSType type2 = ((JSGenericTypeImpl)keyType2).getType();
            if (type2 instanceof JSNamedType && ("Array".equals(typeText = type2.getTypeText(JSType.TypeTextFormat.SIMPLE)) || "ReadonlyArray".equals(typeText))) {
                genericArrayType = (JSGenericTypeImpl)keyType2;
            }
        } else if (keyType2 instanceof JSGenericParameterType && (constraintType2 = ((JSGenericParameterType)keyType2).getConstraintType()) instanceof JSArrayType) {
            genericArrayType = ((JSArrayType)constraintType2).asGenericType();
        }
        return genericArrayType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 26, 28, 29, 36, 41, 42, 43, 45, 48, 54, 55, 57, 58, 60, 61, 62, 63, 64, 65, 71, 72, 74, 75, 82, 86, 87, 88, 89, 91, 92, 93, 94, 95 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterId";
                break;
            }
            case 2: 
            case 32: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 11: 
            case 12: 
            case 26: 
            case 28: 
            case 29: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 82: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl";
                break;
            }
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 17: 
            case 20: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappedType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 24: 
            case 27: 
            case 30: 
            case 35: 
            case 68: 
            case 73: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 31: 
            case 33: 
            case 37: 
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalResultType";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyBases";
                break;
            }
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberType";
                break;
            }
            case 52: 
            case 59: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappedJSType";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canPropagateOptionalStatus";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraSourceElements";
                break;
            }
            case 76: 
            case 78: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElements";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringValue";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutionTypeInIndexAccess";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteCompletely";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteGeneral";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyType";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteNoStrings";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "applyStringGenericToMemberType";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createMembersForUnion";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "mapNameAndCreateProperty";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "updateIfFromJSDoc";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyBases";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "collectReferencedTypes";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCommonMemberSource";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberSourceKind";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "buildLiteralSourceElementsMap";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateStatus";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultType";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterName";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterId";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "distributeType";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "distributeByKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 11: 
            case 12: 
            case 26: 
            case 28: 
            case 29: 
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 82: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isDirectAssignableForMappedTypeWithTypeOperator";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processHomomorphicType";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableDirectOrInverseType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutionTypeInIndexAccess";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "substituteInternal";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isIndexedType";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "substituteGeneral";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "extractKeyOwnerType";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyType";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "applyStringGenericToMemberType";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createMembersForUnion";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolComputedProperty";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "mapNameAndCreateProperty";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "updateIfFromJSDoc";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "calcOriginalOptional";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalType";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "computeCommonMemberSource";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "buildLiteralSourceElementsMap";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "fillExtraLiteralSourceElements";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "putIfStringLiteral";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateStatus";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "isParameter";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 26, 28, 29, 36, 41, 42, 43, 45, 48, 54, 55, 57, 58, 60, 61, 62, 63, 64, 65, 71, 72, 74, 75, 82, 86, 87, 88, 89, 91, 92, 93, 94, 95 -> new IllegalStateException(string);
        };
    }

    private static final class LiteralStatus {
        private final Set<PsiElement> sources = new HashSet<PsiElement>();
        private ThreeState optional = ThreeState.UNSURE;

        private LiteralStatus() {
        }

        void add(@NotNull PsiElement key) {
            if (key == null) {
                LiteralStatus.$$$reportNull$$$0(0);
            }
            this.optional = ThreeState.NO;
            this.sources.add(key);
        }

        void addKey(@NotNull JSTypeKeyTypeImpl key) {
            if (key == null) {
                LiteralStatus.$$$reportNull$$$0(1);
            }
            this.sources.addAll(key.getKeySourceElements());
            if (this.optional != ThreeState.NO) {
                this.optional = ThreeState.fromBoolean((boolean)key.isOptional());
            }
        }

        boolean isOptional() {
            return this.optional == ThreeState.YES;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "key";
            objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl$LiteralStatus";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addKey";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ParameterRemapper
    extends JSCacheableTypeTransformerResolvedIdBase {
        @NotNull
        private final JSTypeGenericId myParameterId;
        @NotNull
        private final JSType myToReplace;

        private ParameterRemapper(@NotNull TypeScriptMappedJSTypeImpl mappedType, @NotNull JSType toReplace) {
            if (mappedType == null) {
                ParameterRemapper.$$$reportNull$$$0(0);
            }
            if (toReplace == null) {
                ParameterRemapper.$$$reportNull$$$0(1);
            }
            this.myParameterId = mappedType.getParameterId();
            this.myToReplace = toReplace;
        }

        @Override
        protected boolean isCompletelyIgnored(@NotNull JSType appliedType) {
            if (appliedType == null) {
                ParameterRemapper.$$$reportNull$$$0(2);
            }
            if (JSTypeIndexerKt.isSimpleType(appliedType)) {
                return true;
            }
            IndexedData data = JSTypeIndexerKt.getTypeIndexedData(appliedType);
            return !data.getGenerics().contains(this.myParameterId);
        }

        @Override
        @NotNull
        public JSType fun(@NotNull JSType el) {
            if (el == null) {
                ParameterRemapper.$$$reportNull$$$0(3);
            }
            JSType jSType = TypeScriptMappedJSTypeImpl.isParameter(this.myParameterId, el) ? this.myToReplace : el;
            if (jSType == null) {
                ParameterRemapper.$$$reportNull$$$0(4);
            }
            return jSType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappedType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toReplace";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "appliedType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "el";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl$ParameterRemapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl$ParameterRemapper";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fun";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isCompletelyIgnored";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fun";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

