/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlighter;
import com.intellij.lang.javascript.psi.TypeScriptSatisfiesExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptAwaitedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInferType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTemplateLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeOperator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypePredicate;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.validation.ES6KeywordHighlighterVisitor;
import com.intellij.lang.javascript.validation.JSKeywordHighlighterVisitor;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TypeScriptKeywordHighlighterVisitor
extends ES6KeywordHighlighterVisitor {
    public static final Collection<IElementType> MODIFIERS_KEYWORDS = List.of(JSTokenTypes.DECLARE_KEYWORD, JSTokenTypes.ABSTRACT_KEYWORD, JSTokenTypes.OVERRIDE_KEYWORD, JSTokenTypes.READONLY_KEYWORD, JSTokenTypes.IN_KEYWORD, JSTokenTypes.OUT_KEYWORD);

    public TypeScriptKeywordHighlighterVisitor(@NotNull HighlightInfoHolder holder) {
        if (holder == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(0);
        }
        this(holder, (JSHighlighter)new TypeScriptHighlighter());
    }

    protected TypeScriptKeywordHighlighterVisitor(HighlightInfoHolder holder, JSHighlighter highlighter) {
        super(holder, highlighter);
    }

    @Override
    public void visitTypeScriptModule(@NotNull TypeScriptModule element) {
        if (element == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(1);
        }
        this.highlightChildKeywordOfTypes(element, JSKeywordSets.MODULES_AND_GLOBAL_KEYWORDS);
        super.visitTypeScriptModule(element);
    }

    @Override
    @NotNull
    protected TextAttributesKey annotatePrimitiveType(ASTNode keyword) {
        ASTNode identifier;
        if (keyword.getElementType() == JSTokenTypes.SYMBOL_KEYWORD && (identifier = TreeUtil.findSiblingBackward((ASTNode)keyword, (IElementType)JSTokenTypes.IDENTIFIER)) != null && "unique".equals(identifier.getText())) {
            this.myHolder.add(JSKeywordHighlighterVisitor.highlightKeyword(identifier, TypeScriptHighlighter.TS_PRIMITIVE_TYPES));
        }
        TextAttributesKey textAttributesKey = TypeScriptHighlighter.TS_PRIMITIVE_TYPES;
        if (textAttributesKey == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(2);
        }
        return textAttributesKey;
    }

    @Override
    public void visitTypeScriptTypeAlias(@NotNull TypeScriptTypeAlias element) {
        if (element == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(3);
        }
        this.highlightChildKeywordOfType(element, JSTokenTypes.TYPE_KEYWORD);
        super.visitTypeScriptTypeAlias(element);
    }

    @Override
    public void visitTypeScriptInferType(@NotNull TypeScriptInferType element) {
        if (element == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(4);
        }
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.INFER_KEYWORD);
        super.visitTypeScriptInferType(element);
    }

    @Override
    public void visitTypeScriptTypeOperator(@NotNull TypeScriptTypeOperator element) {
        if (element == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(5);
        }
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.KEYOF_KEYWORD);
        super.visitTypeScriptTypeOperator(element);
    }

    @Override
    public void visitTypeScriptAwaitedType(@NotNull TypeScriptAwaitedType typeOperator) {
        if (typeOperator == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(6);
        }
        this.highlightChildKeywordOfType((PsiElement)typeOperator, JSTokenTypes.AWAITED_KEYWORD);
        super.visitTypeScriptAwaitedType(typeOperator);
    }

    @Override
    public void visitJSAttributeList(@NotNull JSAttributeList element) {
        if (element == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(7);
        }
        this.highlightModifierKeywords(element);
        super.visitJSAttributeList(element);
    }

    @Override
    public void visitTypeScriptImportStatement(@NotNull TypeScriptImportStatement importStatement) {
        TypeScriptExternalModuleReference externalModuleReference;
        if (importStatement == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(8);
        }
        if ((externalModuleReference = importStatement.getExternalModuleReference()) != null) {
            this.highlightChildKeywordOfType((PsiElement)externalModuleReference, JSTokenTypes.REQUIRE_KEYWORD);
        }
        if (importStatement.isTypeImport()) {
            this.highlightChildKeywordOfType((PsiElement)importStatement, JSTokenTypes.TYPE_KEYWORD);
        }
        super.visitTypeScriptImportStatement(importStatement);
    }

    public void highlightModifierKeywords(JSAttributeList element) {
        for (IElementType modifier : this.getModifiers()) {
            this.highlightChildKeywordOfType((PsiElement)element, modifier);
        }
    }

    @Override
    public void visitTypeScriptTypePredicate(@NotNull TypeScriptTypePredicate predicate) {
        if (predicate == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(9);
        }
        this.highlightChildKeywordOfType((PsiElement)predicate, JSTokenTypes.ASSERTS_KEYWORD);
        this.highlightChildKeywordOfType((PsiElement)predicate, JSTokenTypes.IS_KEYWORD);
        super.visitTypeScriptTypePredicate(predicate);
    }

    @NotNull
    protected Collection<IElementType> getModifiers() {
        Collection<IElementType> collection = MODIFIERS_KEYWORDS;
        if (collection == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @Override
    public void visitTypeScriptCastExpression(@NotNull TypeScriptCastExpression node) {
        if (node == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(11);
        }
        this.highlightChildKeywordOfType((PsiElement)node, JSTokenTypes.AS_KEYWORD);
        super.visitTypeScriptCastExpression(node);
    }

    @Override
    public void visitTypeScriptSatisfiesExpression(@NotNull TypeScriptSatisfiesExpression node) {
        if (node == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(12);
        }
        this.highlightChildKeywordOfType((PsiElement)node, JSTokenTypes.SATISFIES_KEYWORD);
        super.visitTypeScriptSatisfiesExpression(node);
    }

    @Override
    public void visitES6ImportExportSpecifier(@NotNull ES6ImportExportSpecifier specifier) {
        ASTNode typeKeyword;
        if (specifier == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(13);
        }
        if ((typeKeyword = specifier.getNode().findChildByType(this.getSpecifierModifiers())) != null && specifier.getReferenceNameElement() != typeKeyword.getPsi()) {
            this.myHolder.add(TypeScriptKeywordHighlighterVisitor.highlightKeyword(typeKeyword, this.myHighlighter.getMappedKey(JSHighlighter.JS_KEYWORD)));
        }
        super.visitES6ImportExportSpecifier(specifier);
    }

    @NotNull
    protected TokenSet getSpecifierModifiers() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.TYPE_KEYWORD});
        if (tokenSet == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(14);
        }
        return tokenSet;
    }

    @Override
    public void visitTypeScriptMappedType(@NotNull TypeScriptMappedType mappedType) {
        if (mappedType == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(15);
        }
        this.highlightChildKeywordOfType((PsiElement)mappedType, JSTokenTypes.READONLY_KEYWORD);
        super.visitTypeScriptMappedType(mappedType);
    }

    @Override
    public void visitTypeScriptMappedTypeParameter(@NotNull TypeScriptMappedTypeParameter typeParameter) {
        if (typeParameter == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(16);
        }
        this.highlightChildKeywordOfType((PsiElement)typeParameter, JSTokenTypes.AS_KEYWORD);
        super.visitTypeScriptMappedTypeParameter(typeParameter);
    }

    @Override
    public void visitTypeScriptTemplateLiteralType(@NotNull TypeScriptTemplateLiteralType templateLiteralType) {
        if (templateLiteralType == null) {
            TypeScriptKeywordHighlighterVisitor.$$$reportNull$$$0(17);
        }
        for (ASTNode child : templateLiteralType.getNode().getChildren(TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS)) {
            this.myHolder.add(TypeScriptKeywordHighlighterVisitor.highlightKeyword(child, this.myHighlighter.getMappedKey(TypeScriptHighlighter.TS_TEMPLATE_LITERAL_PLACEHOLDER_DELIMITERS)));
        }
        super.visitTypeScriptTemplateLiteralType(templateLiteralType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 10, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/TypeScriptKeywordHighlighterVisitor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeOperator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappedType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateLiteralType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/TypeScriptKeywordHighlighterVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "annotatePrimitiveType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiers";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecifierModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptModule";
                break;
            }
            case 2: 
            case 10: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptTypeAlias";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptInferType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptTypeOperator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptAwaitedType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitJSAttributeList";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptImportStatement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptTypePredicate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptCastExpression";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptSatisfiesExpression";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitES6ImportExportSpecifier";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptMappedType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptMappedTypeParameter";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptTemplateLiteralType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 10, 14 -> new IllegalStateException(string);
        };
    }
}

