/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.intellij.lang.javascript.boilerplate.GithubDownloadUtil;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticTemplatesMemoryCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\b\u0007\u0018\u0000 )2\u00020\u0001:\u0006$%&'()B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\r\u001a\u00020\fH\u0002J\u001d\u0010\u0017\u001a\n \u0018*\u0004\u0018\u00010\u00160\u00162\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0019J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010\"\u001a\u00020 2\u0006\u0010\r\u001a\u00020\fH\u0007J\u0010\u0010#\u001a\u00020 2\u0006\u0010\r\u001a\u00020\fH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001a\u001a\n \u0018*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001c\u00a8\u0006*"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "myCache", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesMemoryCache;", "getTemplates", "", "", "version", "getCriteria", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesMemoryCache$GetCriteria;", "myCacheSubdir", "myDownloadRetryIntervalMs", "", "myDownloadedFile", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadedFile;", "getDownloadedPath", "Ljava/nio/file/Path;", "doGetFilePath", "kotlin.jvm.PlatformType", "(Ljava/lang/String;)Ljava/nio/file/Path;", "myDataUrlPattern", "Ljava/util/regex/Pattern;", "Ljava/util/regex/Pattern;", "parseDataURL", "url", "removeDownloadedFileAsFailed", "", "file", "cleanup", "assertDownloadFailed", "DownloadedFile", "DownloadStatus", "SuccessfullyDownloaded", "VersionNotFound", "DownloadFailed", "Companion", "intellij.javascript.impl"})
public final class DiagnosticTemplatesEnProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final DiagnosticTemplatesMemoryCache myCache;
    @NotNull
    private final String myCacheSubdir;
    private final int myDownloadRetryIntervalMs;
    @Nullable
    private volatile DownloadedFile myDownloadedFile;
    private final Pattern myDataUrlPattern;
    @NotNull
    private static final Logger myLogger;
    @NotNull
    private static final Function1<Exception, Unit> myDefaultErrorReporter;
    @NotNull
    private static Function1<? super Exception, Unit> myErrorReporter;

    public DiagnosticTemplatesEnProvider(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.myCache = new DiagnosticTemplatesMemoryCache((Function1<? super Path, ? extends Sequence<Pair<Integer, String>>>)((Function1)DiagnosticTemplatesEnProvider::myCache$lambda$0));
        this.myCacheSubdir = "typescript-diag-message-parser";
        this.myDownloadRetryIntervalMs = 20000;
        this.myDataUrlPattern = Pattern.compile("data:application/json;charset=utf-8,(.+)", 2);
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    @RequiresBackgroundThread
    @NotNull
    public final List<String> getTemplates(@NotNull String version2, @NotNull DiagnosticTemplatesMemoryCache.GetCriteria getCriteria) {
        List list;
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)getCriteria, (String)"getCriteria");
        Path file = this.getDownloadedPath(version2);
        if (file != null) {
            List list2;
            try {
                list2 = this.myCache.getTemplates(file, getCriteria);
            }
            catch (JsonParseException e) {
                myErrorReporter.invoke((Object)e);
                this.removeDownloadedFileAsFailed(file, version2);
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final Path getDownloadedPath(String version2) {
        DownloadedFile downloadedFile;
        DownloadedFile downloadedFile2 = downloadedFile = this.myDownloadedFile;
        if (Intrinsics.areEqual((Object)(downloadedFile2 != null ? downloadedFile2.getVersion() : null), (Object)version2)) {
            DownloadStatus downloadStatus = downloadedFile.getStatus();
            if (downloadStatus instanceof SuccessfullyDownloaded) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isRegularFile(((SuccessfullyDownloaded)downloadedFile.getStatus()).getFile(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    return ((SuccessfullyDownloaded)downloadedFile.getStatus()).getFile();
                }
            } else {
                if (downloadStatus instanceof VersionNotFound) {
                    return null;
                }
                if (downloadStatus instanceof DownloadFailed) {
                    long retryAt = ((DownloadFailed)downloadedFile.getStatus()).getWhenMs() + (long)this.myDownloadRetryIntervalMs;
                    if (retryAt > System.currentTimeMillis()) {
                        return null;
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        Path downloadedPath = this.doGetFilePath(version2);
        Intrinsics.checkNotNull((Object)downloadedPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isRegularFile(downloadedPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            this.myDownloadedFile = new DownloadedFile(version2, new SuccessfullyDownloaded(downloadedPath));
            return downloadedPath;
        }
        return (Path)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(this, version2, downloadedPath, null){
            int label;
            final /* synthetic */ DiagnosticTemplatesEnProvider this$0;
            final /* synthetic */ String $version;
            final /* synthetic */ Path $downloadedPath;
            {
                this.this$0 = $receiver;
                this.$version = $version;
                this.$downloadedPath = $downloadedPath;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BuildersKt.async$default((CoroutineScope)this.this$0.getCs(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(this.this$0, this.$version, this.$downloadedPath, null){
                            int label;
                            final /* synthetic */ DiagnosticTemplatesEnProvider this$0;
                            final /* synthetic */ String $version;
                            final /* synthetic */ Path $downloadedPath;
                            {
                                this.this$0 = $receiver;
                                this.$version = $version;
                                this.$downloadedPath = $downloadedPath;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        try {
                                            Object object2 = DiagnosticTemplatesEnProvider.Companion;
                                            Path path2 = this.$downloadedPath;
                                            String string = this.$version;
                                            DiagnosticTemplatesEnProvider diagnosticTemplatesEnProvider = this.this$0;
                                            Companion companion = object2;
                                            synchronized (companion) {
                                                boolean bl = false;
                                                Intrinsics.checkNotNull((Object)path2);
                                                LinkOption[] linkOptionArray = new LinkOption[]{};
                                                if (!Files.isRegularFile(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                                                    String url = StringsKt.replace$default((String)Registry.Companion.stringValue("ts.highlightCodeInErrorTooltips.diagnosticMessages.url"), (String)"${version}", (String)string, (boolean)false, (int)4, null);
                                                    String jsonFromDataUrl = DiagnosticTemplatesEnProvider.access$parseDataURL(diagnosticTemplatesEnProvider, url);
                                                    if (jsonFromDataUrl != null) {
                                                        FileUtil.writeToFile((File)path2.toFile(), (String)jsonFromDataUrl);
                                                    } else {
                                                        GithubDownloadUtil.downloadAtomically(null, (String)url, (File)path2.toFile(), (String)"microsoft", (String)"TypeScript");
                                                    }
                                                }
                                                Unit unit = Unit.INSTANCE;
                                            }
                                            object2 = this.$downloadedPath;
                                            Intrinsics.checkNotNull((Object)object2);
                                            DiagnosticTemplatesEnProvider.access$setMyDownloadedFile$p(this.this$0, new DownloadedFile(this.$version, new SuccessfullyDownloaded((Path)object2)));
                                            return this.$downloadedPath;
                                        }
                                        catch (IOException e) {
                                            DiagnosticTemplatesEnProvider.access$getMyErrorReporter$cp().invoke((Object)e);
                                            Throwable throwable = e.getCause();
                                            HttpRequests.HttpStatusException httpStatusException = throwable instanceof HttpRequests.HttpStatusException ? (HttpRequests.HttpStatusException)throwable : null;
                                            boolean bl = httpStatusException != null ? httpStatusException.getStatusCode() == 404 : false;
                                            if (bl) {
                                                DiagnosticTemplatesEnProvider.access$setMyDownloadedFile$p(this.this$0, new DownloadedFile(this.$version, VersionNotFound.INSTANCE));
                                            } else {
                                                DiagnosticTemplatesEnProvider.access$setMyDownloadedFile$p(this.this$0, new DownloadedFile(this.$version, new DownloadFailed(System.currentTimeMillis())));
                                            }
                                            return null;
                                        }
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null).await((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final Path doGetFilePath(String version2) {
        String[] stringArray = new String[]{this.myCacheSubdir, "diagnosticMessages-en-" + version2 + ".json"};
        return Paths.get(PathManager.getSystemPath(), stringArray);
    }

    private final String parseDataURL(String url) {
        Matcher m = this.myDataUrlPattern.matcher(url);
        return m.matches() ? URLDecoder.decode(m.group(1), "utf-8") : null;
    }

    private final void removeDownloadedFileAsFailed(Path file, String version2) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isRegularFile(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Files.delete(file);
        }
        this.myDownloadedFile = new DownloadedFile(version2, new DownloadFailed(System.currentTimeMillis()));
    }

    @TestOnly
    public final void cleanup(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        DownloadedFile downloadedFile = this.myDownloadedFile;
        if (Intrinsics.areEqual((Object)(downloadedFile != null ? downloadedFile.getVersion() : null), (Object)version2)) {
            DownloadStatus status;
            DownloadedFile downloadedFile2 = this.myDownloadedFile;
            DownloadStatus downloadStatus = status = downloadedFile2 != null ? downloadedFile2.getStatus() : null;
            if (status instanceof SuccessfullyDownloaded) {
                PathKt.delete$default((Path)((SuccessfullyDownloaded)status).getFile(), (boolean)false, (int)1, null);
            }
            this.myDownloadedFile = null;
        }
        this.myCache.cleanup$intellij_javascript_impl();
    }

    @TestOnly
    public final void assertDownloadFailed(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Path path2 = this.doGetFilePath(version2);
        Intrinsics.checkNotNull((Object)path2);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new AssertionError((Object)("Exists " + path2));
        }
        DownloadedFile downloadedFile = this.myDownloadedFile;
        if (!Intrinsics.areEqual((Object)(downloadedFile != null ? downloadedFile.getVersion() : null), (Object)version2)) {
            DownloadedFile downloadedFile2 = this.myDownloadedFile;
            throw new AssertionError((Object)("Unexpected version " + (downloadedFile2 != null ? downloadedFile2.getVersion() : null)));
        }
        DownloadedFile downloadedFile3 = this.myDownloadedFile;
        if (!((downloadedFile3 != null ? downloadedFile3.getStatus() : null) instanceof DownloadFailed)) {
            DownloadedFile downloadedFile4 = this.myDownloadedFile;
            throw new AssertionError((Object)("Not failed: " + (downloadedFile4 != null ? downloadedFile4.getStatus() : null)));
        }
    }

    private static final Sequence myCache$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Companion.getCodeToTemplate(it);
    }

    private static final Unit myDefaultErrorReporter$lambda$1(Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            myLogger.error((Throwable)e);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$setMyDownloadedFile$p(DiagnosticTemplatesEnProvider $this, DownloadedFile downloadedFile) {
        $this.myDownloadedFile = downloadedFile;
    }

    public static final /* synthetic */ Function1 access$getMyErrorReporter$cp() {
        return myErrorReporter;
    }

    public static final /* synthetic */ String access$parseDataURL(DiagnosticTemplatesEnProvider $this, String url) {
        return $this.parseDataURL(url);
    }

    static {
        Logger logger = Logger.getInstance(DiagnosticTemplatesEnProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        myLogger = logger;
        myDefaultErrorReporter = DiagnosticTemplatesEnProvider::myDefaultErrorReporter$lambda$1;
        myErrorReporter = myDefaultErrorReporter;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2%\u0010\u000f\u001a!\u0012\u0017\u0012\u00150\bj\u0002`\t\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\n0\u0007H\u0007J \u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00150\u00142\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\b\u0012\u00060\bj\u0002`\t\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$Companion;", "", "<init>", "()V", "myLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "myDefaultErrorReporter", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "", "myErrorReporter", "setErrorReporter", "disposable", "Lcom/intellij/openapi/Disposable;", "reporter", "Lkotlin/ParameterName;", "name", "e", "getCodeToTemplate", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "", "", "file", "Ljava/nio/file/Path;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        public final void setErrorReporter(@NotNull Disposable disposable, @NotNull Function1<? super Exception, Unit> reporter) {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            Intrinsics.checkNotNullParameter(reporter, (String)"reporter");
            myErrorReporter = reporter;
            Disposer.register((Disposable)disposable, Companion::setErrorReporter$lambda$0);
        }

        @NotNull
        public final Sequence<Pair<Integer, String>> getCodeToTemplate(@NotNull Path file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Pair<? extends Integer, ? extends String>>, Continuation<? super Unit>, Object>(file, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Path $file;
                {
                    this.$file = $file;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    block11: {
                        var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        block0 : switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$sequence = (SequenceScope)this.L$0;
                                root = JsonParser.parseReader((Reader)Files.newBufferedReader(this.$file));
                                if (!root.isJsonObject()) {
                                    throw new JsonParseException("Not json object: " + this.$file);
                                }
                                var4_5 = root.getAsJsonObject().entrySet().iterator();
lbl10:
                                // 3 sources

                                while (var4_5.hasNext()) {
                                    var5_6 = (Map.Entry)var4_5.next();
                                    Intrinsics.checkNotNull((Object)var5_6);
                                    jsonKey = (String)var5_6.getKey();
                                    jsonVal = (JsonElement)var5_6.getValue();
                                    if (!jsonVal.isJsonObject() || !jsonVal.getAsJsonObject().has("code") || !jsonVal.getAsJsonObject().get("code").isJsonPrimitive()) break block0;
                                    if (jsonVal.getAsJsonObject().get("code").getAsJsonPrimitive() == null) ** GOTO lbl30
                                    $i$a$-let-DiagnosticTemplatesEnProvider$Companion$getCodeToTemplate$1$1 = false;
                                    if (it.isNumber()) ** GOTO lbl-1000
                                    if (it.isString()) {
                                        v0 = it.getAsString();
                                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getAsString(...)");
                                        ** if (StringsKt.toIntOrNull((String)v0) == null) goto lbl-1000
                                    }
                                    ** GOTO lbl-1000
lbl-1000:
                                    // 2 sources

                                    {
                                        v1 = true;
                                        ** GOTO lbl28
                                    }
lbl-1000:
                                    // 2 sources

                                    {
                                        v1 = false;
                                    }
lbl28:
                                    // 2 sources

                                    v2 = v1;
                                    ** GOTO lbl31
lbl30:
                                    // 1 sources

                                    v2 = false;
lbl31:
                                    // 2 sources

                                    if (!v2) break block0;
                                    it = jsonVal.getAsJsonObject().get("code").getAsJsonPrimitive();
                                    var11_13 = $this$sequence;
                                    $i$a$-let-DiagnosticTemplatesEnProvider$Companion$getCodeToTemplate$1$2 = false;
                                    if (it.isNumber()) {
                                        v3 = it.getAsInt();
                                    } else {
                                        v4 = it.getAsString();
                                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getAsString(...)");
                                        v3 = Integer.parseInt(v4);
                                    }
                                    this.L$0 = $this$sequence;
                                    this.L$1 = var4_5;
                                    this.label = 1;
                                    v5 = var11_13.yield((Object)TuplesKt.to((Object)Boxing.boxInt((int)v3), (Object)jsonKey), (Continuation)this);
                                    if (v5 != var12_2) continue;
                                    return var12_2;
                                }
                                break block11;
                            }
                            case 1: {
                                var4_5 = (Iterator<E>)this.L$1;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v5 = $result;
                                ** GOTO lbl10
                            }
                        }
                        throw new JsonParseException("In " + this.$file + " unexpected json value=" + jsonVal + " with key=" + jsonKey);
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(SequenceScope<? super Pair<Integer, String>> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        private static final void setErrorReporter$lambda$0() {
            myErrorReporter = myDefaultErrorReporter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadFailed;", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadStatus;", "whenMs", "", "<init>", "(J)V", "getWhenMs", "()J", "intellij.javascript.impl"})
    private static final class DownloadFailed
    extends DownloadStatus {
        private final long whenMs;

        public DownloadFailed(long whenMs) {
            super(null);
            this.whenMs = whenMs;
        }

        public final long getWhenMs() {
            return this.whenMs;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0004\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadStatus;", "", "<init>", "()V", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadFailed;", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$SuccessfullyDownloaded;", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$VersionNotFound;", "intellij.javascript.impl"})
    private static abstract class DownloadStatus {
        private DownloadStatus() {
        }

        public /* synthetic */ DownloadStatus(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadedFile;", "", "version", "", "status", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadStatus;", "<init>", "(Ljava/lang/String;Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadStatus;)V", "getVersion", "()Ljava/lang/String;", "getStatus", "()Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadStatus;", "intellij.javascript.impl"})
    private static final class DownloadedFile {
        @NotNull
        private final String version;
        @NotNull
        private final DownloadStatus status;

        public DownloadedFile(@NotNull String version2, @NotNull DownloadStatus status) {
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            this.version = version2;
            this.status = status;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final DownloadStatus getStatus() {
            return this.status;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$SuccessfullyDownloaded;", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadStatus;", "file", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getFile", "()Ljava/nio/file/Path;", "intellij.javascript.impl"})
    private static final class SuccessfullyDownloaded
    extends DownloadStatus {
        @NotNull
        private final Path file;

        public SuccessfullyDownloaded(@NotNull Path file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(null);
            this.file = file;
        }

        @NotNull
        public final Path getFile() {
            return this.file;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$VersionNotFound;", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadStatus;", "<init>", "()V", "intellij.javascript.impl"})
    private static final class VersionNotFound
    extends DownloadStatus {
        @NotNull
        public static final VersionNotFound INSTANCE = new VersionNotFound();

        private VersionNotFound() {
            super(null);
        }
    }
}

