/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Sets;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.awt.AWT;
import org.assertj.swing.core.AWTEventPoster;
import org.assertj.swing.core.ActivateWindowTask;
import org.assertj.swing.core.BasicComponentFinder;
import org.assertj.swing.core.ComponentFinder;
import org.assertj.swing.core.ComponentIsFocusableQuery;
import org.assertj.swing.core.ComponentMatcher;
import org.assertj.swing.core.ComponentPrinter;
import org.assertj.swing.core.ComponentRequestFocusTask;
import org.assertj.swing.core.FocusMonitor;
import org.assertj.swing.core.FocusOwnerFinder;
import org.assertj.swing.core.InputEventGenerator;
import org.assertj.swing.core.InputModifiers;
import org.assertj.swing.core.MouseButton;
import org.assertj.swing.core.Robot;
import org.assertj.swing.core.RobotEventGenerator;
import org.assertj.swing.core.Scrolling;
import org.assertj.swing.core.Settings;
import org.assertj.swing.core.TypeMatcher;
import org.assertj.swing.core.UnexpectedJOptionPaneFinder;
import org.assertj.swing.core.WindowAncestorFinder;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.dependency.jsr305.concurrent.GuardedBy;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.exception.ComponentLookupException;
import org.assertj.swing.exception.UnexpectedException;
import org.assertj.swing.exception.WaitTimedOutError;
import org.assertj.swing.format.Formatting;
import org.assertj.swing.hierarchy.ComponentHierarchy;
import org.assertj.swing.hierarchy.ExistingHierarchy;
import org.assertj.swing.hierarchy.NewHierarchy;
import org.assertj.swing.input.InputState;
import org.assertj.swing.keystroke.KeyStrokeMap;
import org.assertj.swing.lock.ScreenLock;
import org.assertj.swing.monitor.WindowMonitor;
import org.assertj.swing.query.ComponentShowingQuery;
import org.assertj.swing.timing.Pause;
import org.assertj.swing.util.Modifiers;
import org.assertj.swing.util.Pair;
import org.assertj.swing.util.TimeoutWatch;
import org.assertj.swing.util.ToolkitProvider;

public class BasicRobot
implements Robot {
    private static final int POPUP_DELAY = 10000;
    private static final int POPUP_TIMEOUT = 5000;
    private static final int WINDOW_DELAY = 20000;
    private static final ComponentMatcher POPUP_MATCHER = new TypeMatcher(JPopupMenu.class, true);
    @GuardedBy(value="this")
    private volatile boolean active;
    private static final Runnable EMPTY_RUNNABLE = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final int BUTTON_MASK = 28;
    private static Toolkit toolkit = ToolkitProvider.instance().defaultToolkit();
    private static WindowMonitor windowMonitor = WindowMonitor.instance();
    private static InputState inputState = new InputState(toolkit);
    private final ComponentHierarchy hierarchy;
    private final Object screenLockOwner;
    private final ComponentFinder finder;
    private final Settings settings;
    private final AWTEventPoster eventPoster;
    private final InputEventGenerator eventGenerator;
    private final UnexpectedJOptionPaneFinder unexpectedJOptionPaneFinder;

    @Nonnull
    public static Robot robotWithNewAwtHierarchy() {
        Object screenLockOwner = BasicRobot.acquireScreenLock();
        return new BasicRobot(screenLockOwner, NewHierarchy.ignoreExistingComponents());
    }

    @Nonnull
    public static Robot robotWithNewAwtHierarchyWithoutScreenLock() {
        return new BasicRobot(null, NewHierarchy.ignoreExistingComponents());
    }

    @Nonnull
    public static Robot robotWithCurrentAwtHierarchy() {
        Object screenLockOwner = BasicRobot.acquireScreenLock();
        return new BasicRobot(screenLockOwner, new ExistingHierarchy());
    }

    @Nonnull
    public static Robot robotWithCurrentAwtHierarchyWithoutScreenLock() {
        return new BasicRobot(null, new ExistingHierarchy());
    }

    @Nonnull
    private static Object acquireScreenLock() {
        Object screenLockOwner = new Object();
        ScreenLock.instance().acquire(screenLockOwner);
        return screenLockOwner;
    }

    @VisibleForTesting
    BasicRobot(@Nullable Object screenLockOwner, @Nonnull ComponentHierarchy hierarchy) {
        this.screenLockOwner = screenLockOwner;
        this.hierarchy = hierarchy;
        this.settings = new Settings();
        this.eventGenerator = new RobotEventGenerator(this.settings);
        this.eventPoster = new AWTEventPoster(toolkit, inputState, windowMonitor, this.settings);
        this.finder = new BasicComponentFinder(hierarchy, this.settings);
        this.unexpectedJOptionPaneFinder = new UnexpectedJOptionPaneFinder(this.finder);
        this.active = true;
    }

    @Override
    @Nonnull
    public ComponentPrinter printer() {
        return this.finder().printer();
    }

    @Override
    @Nonnull
    public ComponentFinder finder() {
        return this.finder;
    }

    @Override
    @RunsInEDT
    public void showWindow(@Nonnull Window w) {
        this.showWindow(w, null, true);
    }

    @Override
    @RunsInEDT
    public void showWindow(@Nonnull Window w, @Nonnull Dimension size) {
        this.showWindow(w, size, true);
    }

    @Override
    @RunsInEDT
    public void showWindow(final @Nonnull Window w, final @Nullable Dimension size, final boolean pack) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (pack) {
                    BasicRobot.this.packAndEnsureSafePosition(w);
                }
                if (size != null) {
                    w.setSize(size);
                }
                w.setVisible(true);
            }
        });
        this.waitForWindow(w);
    }

    @RunsInCurrentThread
    private void packAndEnsureSafePosition(@Nonnull Window w) {
        w.pack();
        w.setLocation(100, 100);
    }

    @RunsInEDT
    private void waitForWindow(@Nonnull Window w) {
        long start = System.currentTimeMillis();
        while (!windowMonitor.isWindowReady(w) || !ComponentShowingQuery.isShowing(w)) {
            long elapsed = System.currentTimeMillis() - start;
            if (elapsed > 20000L) {
                throw new WaitTimedOutError(Strings.concat((Object[])new Object[]{"Timed out waiting for Window to open (", String.valueOf(elapsed), "ms)"}));
            }
            Pause.pause();
        }
    }

    @Override
    @RunsInEDT
    public void close(@Nonnull Window w) {
        WindowEvent event = new WindowEvent(w, 201);
        Applet applet = this.findAppletDescendent(w);
        EventQueue eventQueue = windowMonitor.eventQueueFor(applet != null ? applet : w);
        ((EventQueue)Preconditions.checkNotNull((Object)eventQueue)).postEvent(event);
        this.waitForIdle();
    }

    @Nullable
    @RunsInEDT
    private Applet findAppletDescendent(@Nonnull Container c) {
        ArrayList found = Lists.newArrayList(this.finder.findAll(c, new TypeMatcher(Applet.class)));
        if (found.size() == 1) {
            return (Applet)found.get(0);
        }
        return null;
    }

    @Override
    @RunsInEDT
    public void focusAndWaitForFocusGain(@Nonnull Component c) {
        this.focus(c, true);
    }

    @Override
    @RunsInEDT
    public void focus(@Nonnull Component c) {
        this.focus(c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RunsInEDT
    private void focus(@Nonnull Component target, boolean wait) {
        Component currentOwner = FocusOwnerFinder.inEdtFocusOwner();
        if (currentOwner == target) {
            return;
        }
        FocusMonitor focusMonitor = FocusMonitor.attachTo(target);
        Component newOwner = FocusOwnerFinder.inEdtFocusOwner();
        if (newOwner == target) {
            target.removeFocusListener(focusMonitor);
            return;
        }
        this.moveMouse(target);
        this.activateWindowOfFocusTarget(target, currentOwner);
        ComponentRequestFocusTask.giveFocusTo(target);
        try {
            if (wait) {
                TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(this.settings().timeoutToBeVisible());
                while (!focusMonitor.hasFocus()) {
                    if (watch.isTimeOut()) {
                        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Focus change to ", Formatting.format(target), " failed", " focus owner: ", Formatting.format(FocusOwnerFinder.focusOwner())}));
                    }
                    Pause.pause();
                }
            }
        }
        finally {
            target.removeFocusListener(focusMonitor);
        }
    }

    @RunsInEDT
    private void activateWindowOfFocusTarget(@Nullable Component target, @Nullable Component currentOwner) {
        Pair<Window, Window> windowAncestors = BasicRobot.windowAncestorsOf(currentOwner, target);
        Window currentOwnerAncestor = (Window)windowAncestors.first;
        Window targetAncestor = (Window)windowAncestors.second;
        if (currentOwnerAncestor == targetAncestor) {
            return;
        }
        this.activate((Window)Preconditions.checkNotNull((Object)targetAncestor));
        this.waitForIdle();
    }

    @RunsInEDT
    private static Pair<Window, Window> windowAncestorsOf(final @Nullable Component one, final @Nullable Component two) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Window, Window>>(){

            @Override
            protected Pair<Window, Window> executeInEDT() throws Throwable {
                return Pair.of(this.windowAncestor(one), this.windowAncestor(two));
            }

            @Nullable
            private Window windowAncestor(Component c) {
                return c != null ? WindowAncestorFinder.windowAncestorOf(c) : null;
            }
        });
    }

    @RunsInEDT
    private void activate(@Nonnull Window w) {
        ActivateWindowTask.activateWindow(w);
        this.moveMouse(w);
    }

    @Override
    @RunsInEDT
    public synchronized void cleanUp() {
        this.cleanUp(true);
    }

    @Override
    @RunsInEDT
    public synchronized void cleanUpWithoutDisposingWindows() {
        this.cleanUp(false);
    }

    @RunsInEDT
    private void cleanUp(boolean disposeWindows) {
        try {
            if (disposeWindows) {
                BasicRobot.disposeWindows(this.hierarchy);
            }
            this.releaseMouseButtons();
        }
        finally {
            this.active = false;
            this.releaseScreenLock();
        }
    }

    private void releaseScreenLock() {
        ScreenLock screenLock = ScreenLock.instance();
        if (screenLock.acquiredBy(this.screenLockOwner)) {
            screenLock.release(this.screenLockOwner);
        }
    }

    @RunsInEDT
    private static void disposeWindows(@Nonnull ComponentHierarchy hierarchy) {
        GuiActionRunner.execute(() -> {
            for (Container c : hierarchy.roots()) {
                if (!(c instanceof Window)) continue;
                BasicRobot.dispose(hierarchy, (Window)c);
            }
        });
    }

    @RunsInCurrentThread
    private static void dispose(@Nonnull ComponentHierarchy hierarchy, @Nonnull Window w) {
        hierarchy.dispose(w);
        w.setVisible(false);
        w.dispose();
    }

    @Override
    @RunsInEDT
    public void click(@Nonnull Component c) {
        this.click(c, MouseButton.LEFT_BUTTON);
    }

    @Override
    @RunsInEDT
    public void rightClick(@Nonnull Component c) {
        this.click(c, MouseButton.RIGHT_BUTTON);
    }

    @Override
    @RunsInEDT
    public void click(@Nonnull Component c, @Nonnull MouseButton button2) {
        this.click(c, button2, 1);
    }

    @Override
    @RunsInEDT
    public void doubleClick(@Nonnull Component c) {
        this.click(c, MouseButton.LEFT_BUTTON, 2);
    }

    @Override
    @RunsInEDT
    public void click(@Nonnull Component c, @Nonnull MouseButton button2, int times) {
        Point where = AWT.visibleCenterOf(c);
        if (c instanceof JComponent) {
            where = this.scrollIfNecessary((JComponent)c);
        }
        this.click(c, where, button2, times);
    }

    @Nonnull
    private Point scrollIfNecessary(@Nonnull JComponent c) {
        Scrolling.scrollToVisible(this, c);
        return AWT.visibleCenterOf(c);
    }

    @Override
    @RunsInEDT
    public void click(@Nonnull Component c, @Nonnull Point where) {
        this.click(c, where, MouseButton.LEFT_BUTTON, 1);
    }

    @Override
    @RunsInEDT
    public void click(@Nonnull Point where, @Nonnull MouseButton button2, int times) {
        this.doClick(null, where, button2, times);
    }

    @Override
    @RunsInEDT
    public void click(@Nonnull Component c, @Nonnull Point where, @Nonnull MouseButton button2, int times) {
        this.doClick(c, where, button2, times);
    }

    private void doClick(@Nullable Component c, @Nonnull Point where, @Nonnull MouseButton button2, int times) {
        int mask = button2.mask;
        int modifierMask = mask & 0xFFFFFFE3;
        int finalMask = mask &= 0x1C;
        this.pressModifiersWhileRunning(modifierMask, () -> this.doClickWhileModifiersPressed(c, where, times, finalMask));
        this.waitForIdle();
    }

    private void doClickWhileModifiersPressed(Component c, Point where, int times, int mask) {
        int delayBetweenEvents = this.settings.delayBetweenEvents();
        if (this.shouldSetDelayBetweenEventsToZeroWhenClicking(times)) {
            this.settings.delayBetweenEvents(0);
        }
        if (c == null) {
            this.eventGenerator.pressMouse(where, mask);
            for (int i = times; i > 1; --i) {
                this.eventGenerator.releaseMouse(mask);
                this.eventGenerator.pressMouse(mask);
            }
        } else {
            this.eventGenerator.pressMouse(c, where, mask);
            for (int i = times; i > 1; --i) {
                this.eventGenerator.releaseMouse(mask);
                this.eventGenerator.pressMouse(mask);
            }
        }
        this.settings.delayBetweenEvents(delayBetweenEvents);
        this.eventGenerator.releaseMouse(mask);
    }

    private boolean shouldSetDelayBetweenEventsToZeroWhenClicking(int times) {
        return times > 1;
    }

    @Override
    public void pressModifiers(int modifierMask) {
        for (int modifierKey : Modifiers.keysFor(modifierMask)) {
            this.pressKey(modifierKey);
        }
    }

    @Override
    public void pressModifiersWhileRunning(int modifierMask, Runnable runnable) {
        this.pressModifiers(modifierMask);
        try {
            runnable.run();
        }
        finally {
            this.releaseModifiers(modifierMask);
        }
    }

    @Override
    public void releaseModifiers(int modifierMask) {
        int[] modifierKeys = Modifiers.keysFor(modifierMask);
        for (int i = modifierKeys.length - 1; i >= 0; --i) {
            this.releaseKey(modifierKeys[i]);
        }
    }

    @Override
    @RunsInEDT
    public void moveMouse(@Nonnull Component c) {
        this.moveMouse(c, AWT.visibleCenterOf(c));
    }

    @Override
    @RunsInEDT
    public void moveMouse(@Nonnull Component c, @Nonnull Point p) {
        this.moveMouse(c, p.x, p.y);
    }

    @Override
    @RunsInEDT
    public void moveMouse(@Nonnull Component c, int x, int y) {
        if (!this.waitForComponentToBeReady(c, this.settings.timeoutToBeVisible())) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Could not obtain position of component ", Formatting.format(c)}));
        }
        this.eventGenerator.moveMouse(c, x, y);
        this.waitForIdle();
    }

    @Override
    public void moveMouse(@Nonnull Point p) {
        this.moveMouse(p.x, p.y);
    }

    @Override
    public void moveMouse(int x, int y) {
        this.eventGenerator.moveMouse(x, y);
    }

    @Override
    public void pressMouse(@Nonnull MouseButton button2) {
        this.eventGenerator.pressMouse(button2.mask);
    }

    @Override
    public void pressMouseWhileRunning(@Nonnull MouseButton button2, @Nonnull Runnable runnable) {
        this.pressMouse(button2);
        try {
            runnable.run();
        }
        finally {
            this.releaseMouse(button2);
        }
    }

    @Override
    public void pressMouse(@Nonnull Component c, @Nonnull Point where) {
        this.pressMouse(c, where, MouseButton.LEFT_BUTTON);
    }

    @Override
    public void pressMouseWhileRunning(@Nonnull Component c, @Nonnull Point where, @Nonnull Runnable runnable) {
        this.pressMouseWhileRunning(c, where, MouseButton.LEFT_BUTTON, runnable);
    }

    @Override
    public void pressMouse(@Nonnull Component c, @Nonnull Point where, @Nonnull MouseButton button2) {
        this.jitter(c, where);
        this.moveMouse(c, where.x, where.y);
        this.eventGenerator.pressMouse(c, where, button2.mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pressMouseWhileRunning(@Nonnull Component c, @Nonnull Point where, @Nonnull MouseButton button2, @Nonnull Runnable runnable) {
        this.pressMouse(c, where, button2);
        try {
            runnable.run();
        }
        finally {
            this.releaseMouse(button2);
        }
    }

    @Override
    public void pressMouse(@Nonnull Point where, @Nonnull MouseButton button2) {
        this.eventGenerator.pressMouse(where, button2.mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pressMouseWhileRunning(@Nonnull Point where, @Nonnull MouseButton button2, @Nonnull Runnable runnable) {
        this.pressMouse(where, button2);
        try {
            runnable.run();
        }
        finally {
            this.releaseMouse(button2);
        }
    }

    @Override
    @RunsInEDT
    public void releaseMouse(@Nonnull MouseButton button2) {
        this.mouseRelease(button2.mask);
    }

    @Override
    @RunsInEDT
    public void releaseMouseButtons() {
        int buttons = inputState.buttons();
        if (buttons == 0) {
            return;
        }
        this.mouseRelease(buttons);
    }

    @Override
    public void rotateMouseWheel(@Nonnull Component c, int amount) {
        this.moveMouse(c);
        this.rotateMouseWheel(amount);
    }

    @Override
    public void rotateMouseWheel(int amount) {
        this.eventGenerator.rotateMouseWheel(amount);
        this.waitForIdle();
    }

    @Override
    @RunsInEDT
    public void jitter(@Nonnull Component c) {
        this.jitter(c, AWT.visibleCenterOf(c));
    }

    @Override
    @RunsInEDT
    public void jitter(@Nonnull Component c, @Nonnull Point where) {
        int x = where.x;
        int y = where.y;
        this.moveMouse(c, x > 0 ? x - 1 : x + 1, y);
    }

    @RunsInEDT
    private boolean waitForComponentToBeReady(@Nonnull Component c, long timeout) {
        if (this.isReadyForInput(c)) {
            return true;
        }
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(timeout);
        while (!this.isReadyForInput(c)) {
            if (c instanceof JPopupMenu) {
                Pair<Component, Point> invokerAndCenterOfInvoker = BasicRobot.invokerAndCenterOfInvoker((JPopupMenu)c);
                Component invoker = (Component)invokerAndCenterOfInvoker.first;
                if (invoker instanceof JMenu) {
                    this.jitter(invoker, (Point)invokerAndCenterOfInvoker.second);
                }
            }
            if (watch.isTimeOut()) {
                return false;
            }
            Pause.pause();
        }
        return true;
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Component, Point> invokerAndCenterOfInvoker(final @Nonnull JPopupMenu popupMenu) {
        Pair<Component, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Component, Point>>(){

            @Override
            protected Pair<Component, Point> executeInEDT() {
                Component invoker = (Component)Preconditions.checkNotNull((Object)popupMenu.getInvoker());
                return Pair.of(invoker, AWT.centerOf(invoker));
            }
        });
        return (Pair)Preconditions.checkNotNull(result);
    }

    @Override
    @RunsInEDT
    public void enterText(@Nonnull String text) {
        Preconditions.checkNotNull((Object)text);
        if (text.isEmpty()) {
            return;
        }
        for (char character : text.toCharArray()) {
            this.type(character);
        }
        this.waitForIdle();
    }

    @Override
    @RunsInEDT
    public void type(char character) {
        KeyStroke keyStroke = KeyStrokeMap.keyStrokeFor(character);
        if (keyStroke == null) {
            Component focus = FocusOwnerFinder.focusOwner();
            if (focus == null) {
                return;
            }
            KeyEvent keyEvent = this.keyEventFor(focus, character);
            this.waitForIdle();
            this.eventPoster.postEvent(focus, keyEvent);
            return;
        }
        this.keyPressAndRelease(keyStroke.getKeyCode(), keyStroke.getModifiers());
    }

    private KeyEvent keyEventFor(Component c, char character) {
        return new KeyEvent(c, 400, System.currentTimeMillis(), 0, 0, character);
    }

    @Override
    @RunsInEDT
    public void pressAndReleaseKey(int keyCode, int ... modifiers) {
        this.keyPressAndRelease(keyCode, InputModifiers.unify(modifiers));
        this.waitForIdle();
    }

    @Override
    @RunsInEDT
    public void pressAndReleaseKeys(int ... keyCodes) {
        for (int keyCode : keyCodes) {
            this.keyPressAndRelease(keyCode, 0);
            this.waitForIdle();
            Pause.pause(50L);
        }
    }

    @RunsInEDT
    private void keyPressAndRelease(int keyCode, int modifiers) {
        int updatedModifiers = Modifiers.updateModifierWithKeyCode(keyCode, modifiers);
        if (updatedModifiers == modifiers) {
            this.pressModifiersWhileRunning(updatedModifiers, () -> {
                this.doPressKey(keyCode);
                this.eventGenerator.releaseKey(keyCode);
            });
        }
    }

    @Override
    @RunsInEDT
    public void pressKey(int keyCode) {
        this.doPressKey(keyCode);
        this.waitForIdle();
    }

    @Override
    public void pressKeyWhileRunning(int keyCode, Runnable runnable) {
        this.pressKey(keyCode);
        try {
            runnable.run();
        }
        finally {
            this.releaseKey(keyCode);
        }
    }

    @RunsInEDT
    private void doPressKey(int keyCode) {
        this.eventGenerator.pressKey(keyCode, '\uffff');
    }

    @Override
    @RunsInEDT
    public void releaseKey(int keyCode) {
        this.eventGenerator.releaseKey(keyCode);
        this.waitForIdle();
    }

    @RunsInEDT
    private void mouseRelease(int buttons) {
        this.eventGenerator.releaseMouse(buttons);
    }

    @Override
    @RunsInEDT
    public void waitForIdle() {
        this.waitIfNecessary();
        if (this.settings.simpleWaitForIdle()) {
            this.simpleWaitForIdle();
        } else {
            Collection<EventQueue> queues = windowMonitor.allEventQueues();
            if (queues.size() == 1) {
                this.waitForIdle((EventQueue)Preconditions.checkNotNull((Object)toolkit.getSystemEventQueue()));
                return;
            }
            for (EventQueue queue : queues) {
                this.waitForIdle((EventQueue)Preconditions.checkNotNull((Object)queue));
            }
        }
    }

    private void waitIfNecessary() {
        int delayBetweenEvents = this.settings.delayBetweenEvents();
        int eventPostingDelay = this.settings.eventPostingDelay();
        if (eventPostingDelay > delayBetweenEvents) {
            Pause.pause(eventPostingDelay - delayBetweenEvents);
        }
    }

    private void simpleWaitForIdle() {
        if (EventQueue.isDispatchThread()) {
            throw new IllegalThreadStateException("Cannot call method from the event dispatcher thread");
        }
        try {
            EventQueue.invokeAndWait(EMPTY_RUNNABLE);
        }
        catch (Exception e) {
            throw new UnexpectedException("could not invokeAndWait", e);
        }
    }

    private void waitForIdle(@Nonnull EventQueue eventQueue) {
        int idleTimeout;
        if (EventQueue.isDispatchThread()) {
            throw new IllegalThreadStateException("Cannot call method from the event dispatcher thread");
        }
        long start = System.currentTimeMillis();
        while (!this.postInvocationEvent(eventQueue, idleTimeout = this.settings.idleTimeout()) && System.currentTimeMillis() - start <= (long)idleTimeout) {
            Pause.pause();
            if (eventQueue.peekEvent() != null) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RunsInEDT
    private boolean postInvocationEvent(@Nonnull EventQueue eventQueue, long timeout) {
        RobotIdleLock lock;
        RobotIdleLock robotIdleLock = lock = new RobotIdleLock();
        synchronized (robotIdleLock) {
            InvocationEvent event = new InvocationEvent((Object)toolkit, EMPTY_RUNNABLE, lock, true);
            eventQueue.postEvent(event);
            long start = System.currentTimeMillis();
            try {
                while (!event.isDispatched() && System.currentTimeMillis() - start < timeout) {
                    lock.wait(timeout);
                }
                return System.currentTimeMillis() - start >= (long)this.settings.idleTimeout();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
    }

    @Override
    public boolean isDragging() {
        return inputState.dragInProgress();
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull Component invoker) {
        return this.showPopupMenu(invoker, AWT.visibleCenterOf(invoker));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull Component invoker, @Nonnull Point location) {
        if (ComponentIsFocusableQuery.isFocusable(invoker)) {
            this.focusAndWaitForFocusGain(invoker);
        }
        this.click(invoker, location, MouseButton.RIGHT_BUTTON, 1);
        JPopupMenu popup = this.findActivePopupMenu();
        if (popup == null) {
            throw new ComponentLookupException(Strings.concat((Object[])new Object[]{"Unable to show popup at ", location, " on ", Formatting.inEdtFormat(invoker)}));
        }
        long start = System.currentTimeMillis();
        while (!this.isWindowAncestorReadyForInput(popup) && System.currentTimeMillis() - start > 10000L) {
            Pause.pause();
        }
        return popup;
    }

    @RunsInEDT
    private boolean isWindowAncestorReadyForInput(JPopupMenu popup) {
        return (Boolean)Preconditions.checkNotNull((Object)GuiActionRunner.execute(() -> this.isReadyForInput((Component)Preconditions.checkNotNull((Object)SwingUtilities.getWindowAncestor(popup)))));
    }

    @Override
    @RunsInCurrentThread
    public boolean isReadyForInput(@Nonnull Component c) {
        Window w = WindowAncestorFinder.windowAncestorOf(c);
        if (w == null) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Component ", Formatting.format(c), " does not have a Window ancestor"}));
        }
        return c.isShowing() && windowMonitor.isWindowReady(w);
    }

    @Override
    @Nullable
    @RunsInEDT
    public JPopupMenu findActivePopupMenu() {
        JPopupMenu popup = this.activePopupMenu();
        if (popup != null || SwingUtilities.isEventDispatchThread()) {
            return popup;
        }
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(5000L);
        while ((popup = this.activePopupMenu()) == null && !watch.isTimeOut()) {
            Pause.pause(100L);
        }
        return popup;
    }

    @Nullable
    @RunsInEDT
    private JPopupMenu activePopupMenu() {
        ArrayList found = Lists.newArrayList(this.finder().findAll(POPUP_MATCHER));
        if (found.size() == 1) {
            return (JPopupMenu)found.get(0);
        }
        if (found.size() > 1) {
            return this.findOuterPopupMenu(found);
        }
        return null;
    }

    @RunsInEDT
    private JPopupMenu findOuterPopupMenu(List<Component> found) {
        ArrayList innerMenus = Lists.newArrayList();
        innerMenus.addAll(this.determineInnerPopupsToRemove(found));
        found.removeAll(innerMenus);
        if (found.size() == 1) {
            return (JPopupMenu)found.get(0);
        }
        throw BasicRobot.multiplePopupMenusFound(found);
    }

    @Nonnull
    @RunsInEDT
    private static ComponentLookupException multiplePopupMenusFound(@Nonnull Collection<Component> found) {
        StringBuilder message = new StringBuilder();
        String format = "Found more than one popup menu.%n%nFound:";
        message.append(String.format(format, new Object[0]));
        BasicRobot.appendComponents(message, found);
        if (!found.isEmpty()) {
            message.append(System.lineSeparator());
        }
        throw new ComponentLookupException(message.toString(), found);
    }

    @RunsInEDT
    private static void appendComponents(@Nonnull StringBuilder message, @Nonnull Collection<Component> found) {
        GuiActionRunner.execute(() -> {
            for (Component c : found) {
                message.append(String.format("%n%s", Formatting.format(c)));
            }
        });
    }

    @RunsInEDT
    private Collection<? extends JPopupMenu> popupMenus(Component[] components) {
        HashSet menus = Sets.newHashSet();
        for (Component component2 : components) {
            if (!(component2 instanceof JPopupMenu)) continue;
            menus.add((JPopupMenu)component2);
        }
        return menus;
    }

    @RunsInEDT
    private Collection<? extends JPopupMenu> determineInnerPopupsToRemove(List<Component> found) {
        HashSet menusSetToRemoveData = Sets.newHashSet();
        for (Component fndComp : found) {
            Component[] compArr;
            for (Component component2 : compArr = ((JPopupMenu)fndComp).getComponents()) {
                if (component2 instanceof JPopupMenu) {
                    menusSetToRemoveData.add((JPopupMenu)component2);
                    continue;
                }
                if (!(component2 instanceof JMenuItem)) continue;
                JMenuItem jmiComp = (JMenuItem)component2;
                JPopupMenu jpNextLevelComp = jmiComp.getComponentPopupMenu();
                if (jpNextLevelComp == null && component2 instanceof JMenu) {
                    JMenu jmComp = (JMenu)component2;
                    jpNextLevelComp = jmComp.getPopupMenu();
                }
                if (jpNextLevelComp == null || !found.contains(jpNextLevelComp)) continue;
                menusSetToRemoveData.add((JPopupMenu)component2.getParent());
            }
        }
        return menusSetToRemoveData;
    }

    @Override
    @RunsInEDT
    public void requireNoJOptionPaneIsShowing() {
        this.unexpectedJOptionPaneFinder.requireNoJOptionPaneIsShowing();
    }

    @Override
    @Nonnull
    public Settings settings() {
        return this.settings;
    }

    @Override
    @Nonnull
    public ComponentHierarchy hierarchy() {
        return this.hierarchy;
    }

    @Override
    public synchronized boolean isActive() {
        return this.active;
    }

    @Nullable
    @VisibleForTesting
    final Object screenLockOwner() {
        return this.screenLockOwner;
    }

    private static class RobotIdleLock {
        RobotIdleLock() {
        }
    }
}

