/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.ui.visualization.markerRenderers.NotebookMarkdownCellLeftBorderRenderer;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.ui.EditorCellView;
import com.intellij.notebooks.visualization.ui.EditorLayerController;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\b\u0010\u001b\u001a\u00020\u0014H\u0002J\u0012\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0014H\u0002J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J\u0012\u0010$\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\b\u0010%\u001a\u00020\u0014H\u0002J\b\u0010&\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorCellFrameManager;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "view", "Lcom/intellij/notebooks/visualization/ui/EditorCellView;", "cellType", "Lcom/intellij/notebooks/visualization/NotebookCellLines$CellType;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/notebooks/visualization/ui/EditorCellView;Lcom/intellij/notebooks/visualization/NotebookCellLines$CellType;)V", "leftBorderHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "rightBorderLine", "Ljava/awt/geom/Line2D;", "currentColor", "Ljava/awt/Color;", "isSelected", "", "isHovered", "redrawBorders", "", "updateCellFrameShow", "selected", "hovered", "updateCellFrameShowMarkdown", "updateCellFrameShowCode", "color", "redrawLeftBorder", "redrawRightBorder", "layerController", "Lcom/intellij/notebooks/visualization/ui/EditorLayerController;", "clearFrame", "addLeftBorderHighlighter", "startOffset", "", "endOffset", "removeRightBorder", "removeLeftBorder", "dispose", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nEditorCellFrameManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorCellFrameManager.kt\ncom/intellij/notebooks/visualization/ui/EditorCellFrameManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n295#2,2:149\n543#2,6:151\n1#3:157\n*S KotlinDebug\n*F\n+ 1 EditorCellFrameManager.kt\ncom/intellij/notebooks/visualization/ui/EditorCellFrameManager\n*L\n90#1:149,2\n94#1:151,6\n*E\n"})
public final class EditorCellFrameManager
implements Disposable {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final EditorCellView view;
    @NotNull
    private final NotebookCellLines.CellType cellType;
    @Nullable
    private RangeHighlighter leftBorderHighlighter;
    @Nullable
    private Line2D rightBorderLine;
    @NotNull
    private Color currentColor;
    private boolean isSelected;
    private boolean isHovered;

    public EditorCellFrameManager(@NotNull EditorImpl editor, @NotNull EditorCellView view, @NotNull NotebookCellLines.CellType cellType) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)((Object)cellType), (String)"cellType");
        this.editor = editor;
        this.view = view;
        this.cellType = cellType;
        this.currentColor = (Color)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getCellFrameHoveredColor().get();
        if (this.cellType == NotebookCellLines.CellType.CODE) {
            this.redrawBorders((Color)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getCellFrameHoveredColor().get());
        }
    }

    public final void redrawBorders() {
        this.redrawBorders(this.currentColor);
    }

    public final void updateCellFrameShow(boolean selected, boolean hovered) {
        this.isSelected = selected;
        this.isHovered = hovered;
        switch (WhenMappings.$EnumSwitchMapping$0[this.cellType.ordinal()]) {
            case 1: {
                this.updateCellFrameShowMarkdown();
                break;
            }
            case 2: {
                this.updateCellFrameShowCode();
            }
        }
    }

    private final void updateCellFrameShowMarkdown() {
        if (this.view.isUnderDiff()) {
            this.updateCellFrameShowCode();
            return;
        }
        if (this.isSelected) {
            this.redrawBorders((Color)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getCellFrameSelectedColor().get());
        } else if (this.isHovered) {
            this.redrawBorders((Color)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getCellFrameHoveredColor().get());
        } else {
            this.clearFrame();
        }
    }

    private final void updateCellFrameShowCode() {
        if (this.isSelected) {
            this.redrawBorders((Color)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getCellFrameSelectedColor().get());
        } else {
            this.redrawBorders((Color)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getCellFrameHoveredColor().get());
        }
    }

    private final void redrawBorders(Color color) {
        this.currentColor = color;
        EditorLayerController layerController = EditorLayerController.Companion.getLayerController(this.editor);
        this.view.updateFrameVisibility(true, this.currentColor);
        this.redrawLeftBorder();
        this.redrawRightBorder(layerController);
    }

    private final void redrawLeftBorder() {
        this.removeLeftBorder();
        int startOffset = this.editor.getDocument().getLineStartOffset(this.view.getCell().getInterval().getLines().getFirst());
        int endOffset = this.editor.getDocument().getLineEndOffset(this.view.getCell().getInterval().getLines().getLast());
        this.addLeftBorderHighlighter(startOffset, endOffset);
    }

    /*
     * WARNING - void declaration
     */
    private final void redrawRightBorder(EditorLayerController layerController) {
        void it;
        Line2D.Double double_;
        Rectangle rectangle;
        Inlay<?> inlay;
        Object upperInlayBounds;
        Object $this$firstOrNull$iv;
        block6: {
            Object v0;
            List<Inlay<?>> inlays;
            block5: {
                if (layerController == null) {
                    return;
                }
                this.removeRightBorder(layerController);
                inlays = this.view.getInput().getBlockElementsInRange();
                $this$firstOrNull$iv = inlays;
                boolean $i$f$firstOrNull = false;
                Iterator iterator = $this$firstOrNull$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    Inlay it2 = (Inlay)element$iv;
                    boolean bl = false;
                    if (!(it2.getProperties().getPriority() == NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getJUPYTER_CELL_SPACERS_INLAY_PRIORITY() && it2.getProperties().isShownAbove())) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            Inlay inlay2 = v0;
            if (inlay2 == null || ($this$firstOrNull$iv = inlay2.getBounds()) == null) {
                return;
            }
            upperInlayBounds = $this$firstOrNull$iv;
            List<Inlay<?>> $this$lastOrNull$iv = inlays;
            boolean $i$f$lastOrNull = false;
            ListIterator<Inlay<?>> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Inlay<?> element$iv;
                Inlay<?> it3 = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!(it3.getProperties().getPriority() == NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getJUPYTER_CELL_SPACERS_INLAY_PRIORITY() && !it3.getProperties().isShownAbove())) continue;
                inlay = element$iv;
                break block6;
            }
            inlay = null;
        }
        $this$firstOrNull$iv = (Inlay)inlay;
        if ($this$firstOrNull$iv == null || (rectangle = $this$firstOrNull$iv.getBounds()) == null) {
            return;
        }
        Rectangle lowerInlayBounds = rectangle;
        double lineX = (double)(((Rectangle)upperInlayBounds).x + ((Rectangle)upperInlayBounds).width) - 0.5;
        double lineStartY = ((Rectangle)upperInlayBounds).y + ((Rectangle)upperInlayBounds).height;
        double lineEndY = lowerInlayBounds.y;
        Line2D.Double double_2 = double_ = new Line2D.Double(lineX, lineStartY, lineX, lineEndY);
        EditorCellFrameManager editorCellFrameManager = this;
        boolean bl = false;
        layerController.addOverlayLine((Line2D)it, this.currentColor);
        editorCellFrameManager.rightBorderLine = double_;
    }

    private final void clearFrame() {
        this.view.updateFrameVisibility(false, this.currentColor);
        this.removeLeftBorder();
        this.removeRightBorder(EditorLayerController.Companion.getLayerController(this.editor));
    }

    private final void addLeftBorderHighlighter(int startOffset, int endOffset) {
        if (this.leftBorderHighlighter == null) {
            this.leftBorderHighlighter = (RangeHighlighter)this.editor.getMarkupModel().addRangeHighlighterAndChangeAttributes(null, startOffset, endOffset, 900, HighlighterTargetArea.LINES_IN_RANGE, false, arg_0 -> EditorCellFrameManager.addLeftBorderHighlighter$lambda$6(arg_0 -> EditorCellFrameManager.addLeftBorderHighlighter$lambda$5(this, arg_0), arg_0));
        }
    }

    private final void removeRightBorder(EditorLayerController layerController) {
        block1: {
            Line2D line2D = this.rightBorderLine;
            if (line2D == null) break block1;
            Line2D it = line2D;
            boolean bl = false;
            EditorLayerController editorLayerController = layerController;
            if (editorLayerController != null) {
                editorLayerController.removeOverlayLine(it);
            }
            this.rightBorderLine = null;
        }
    }

    private final void removeLeftBorder() {
        block0: {
            RangeHighlighter rangeHighlighter = this.leftBorderHighlighter;
            if (rangeHighlighter == null) break block0;
            RangeHighlighter it = rangeHighlighter;
            boolean bl = false;
            this.editor.getMarkupModel().removeHighlighter(it);
            this.leftBorderHighlighter = null;
        }
    }

    public void dispose() {
        this.removeLeftBorder();
        this.removeRightBorder(EditorLayerController.Companion.getLayerController(this.editor));
    }

    private static final Pair addLeftBorderHighlighter$lambda$5$lambda$4(EditorCellFrameManager this$0, Editor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Rectangle it2 = this$0.view.getInput().getComponent().calculateBounds();
        boolean bl = false;
        return TuplesKt.to((Object)it2.y, (Object)it2.height);
    }

    private static final Unit addLeftBorderHighlighter$lambda$5(EditorCellFrameManager this$0, RangeHighlighterEx o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        o.setLineMarkerRenderer((LineMarkerRenderer)new NotebookMarkdownCellLeftBorderRenderer((RangeHighlighter)o, this$0.currentColor, (Function1<? super Editor, Pair<Integer, Integer>>)((Function1)arg_0 -> EditorCellFrameManager.addLeftBorderHighlighter$lambda$5$lambda$4(this$0, arg_0))));
        return Unit.INSTANCE;
    }

    private static final void addLeftBorderHighlighter$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotebookCellLines.CellType.values().length];
            try {
                nArray[NotebookCellLines.CellType.MARKDOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookCellLines.CellType.CODE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

