%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4.2
%% Purpose: Encoding and decoding of the types in SecureMimeMessageV3dot1-2009.

-module('SecureMimeMessageV3dot1-2009').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("SecureMimeMessageV3dot1-2009.hrl").
-asn1_info([{vsn,'5.4.2'},
            {module,'SecureMimeMessageV3dot1-2009'},
            {options,[{i,"/var/tmp/portage/dev-lang/erlang-28.1/work/otp-OTP-28.1/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/var/tmp/portage/dev-lang/erlang-28.1/work/otp-OTP-28.1/lib/public_key/asn1"},
 {outdir,"/var/tmp/portage/dev-lang/erlang-28.1/work/otp-OTP-28.1/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/var/tmp/portage/dev-lang/erlang-28.1/work/otp-OTP-28.1/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_SMIMEEncryptionKeyPreference/2,
enc_SMIMECapabilitiesParametersForRC2CBC/2,
'enc_aa-smimeCapabilities_SMIMECapabilities'/2
]).

-export([
dec_SMIMEEncryptionKeyPreference/2,
dec_SMIMECapabilitiesParametersForRC2CBC/2,
'dec_aa-smimeCapabilities_SMIMECapabilities'/2
]).

-export([
'enc_aa-smimeCapabilities'/3,
'enc_aa-encrypKeyPref'/3,
'enc_cap-preferBinaryInside'/3,
'enc_cap-RC2CBC'/3,
enc_SMimeCapsSet_smimeCaps/3,
'enc_aa-smimeCapabilities_smimeCaps'/3
]).

-export([
'dec_aa-smimeCapabilities'/3,
'dec_aa-encrypKeyPref'/3,
'dec_cap-preferBinaryInside'/3,
'dec_cap-RC2CBC'/3,
dec_SMimeCapsSet_smimeCaps/3,
'dec_aa-smimeCapabilities_smimeCaps'/3
]).

-export([
getenc_SMimeAttributeSet/1,
getenc_SMimeCapsSet/1,
getenc_internal_object_set_argument_3/1,
getenc_internal_object_set_argument_2/1
]).

-export([
getdec_SMimeAttributeSet/1,
getdec_SMimeCapsSet/1,
getdec_internal_object_set_argument_3/1,
getdec_internal_object_set_argument_2/1
]).

-export([
'id-aa'/0,
smimeCapabilities/0,
'id-aa-encrypKeyPref'/0,
'id-smime'/0,
'id-cap'/0,
'id-cap-preferBinaryInside'/0
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('SMIMEEncryptionKeyPreference', Data) -> enc_SMIMEEncryptionKeyPreference(Data);
encode_disp('SMIMECapabilitiesParametersForRC2CBC', Data) -> enc_SMIMECapabilitiesParametersForRC2CBC(Data);
encode_disp('aa-smimeCapabilities_SMIMECapabilities', Data) -> 'enc_aa-smimeCapabilities_SMIMECapabilities'(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('SMIMEEncryptionKeyPreference', Data) -> dec_SMIMEEncryptionKeyPreference(Data);
decode_disp('SMIMECapabilitiesParametersForRC2CBC', Data) -> dec_SMIMECapabilitiesParametersForRC2CBC(Data);
decode_disp('aa-smimeCapabilities_SMIMECapabilities', Data) -> 'dec_aa-smimeCapabilities_SMIMECapabilities'(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  SMIMEEncryptionKeyPreference
%%================================
enc_SMIMEEncryptionKeyPreference(Val) ->
    enc_SMIMEEncryptionKeyPreference(Val, []).

enc_SMIMEEncryptionKeyPreference(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      issuerAndSerialNumber ->
         'CryptographicMessageSyntax-2009':'enc_IssuerAndSerialNumber'(element(2,Val), [<<160>>]);
      receipentKeyId ->
         'CryptographicMessageSyntax-2009':'enc_RecipientKeyIdentifier'(element(2,Val), [<<161>>]);
      subjectAltKeyIdentifier ->
         encode_restricted_string(element(2,Val), [<<130>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_SMIMEEncryptionKeyPreference(Tlv) ->
   dec_SMIMEEncryptionKeyPreference(Tlv, []).

dec_SMIMEEncryptionKeyPreference(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'issuerAndSerialNumber'
    {131072, V1} -> 
        {issuerAndSerialNumber, 'CryptographicMessageSyntax-2009':'dec_IssuerAndSerialNumber'(V1, [])};


%% 'receipentKeyId'
    {131073, V1} -> 
        {receipentKeyId, 'CryptographicMessageSyntax-2009':'dec_RecipientKeyIdentifier'(V1, [])};


%% 'subjectAltKeyIdentifier'
    {131074, V1} -> 
        {subjectAltKeyIdentifier, decode_octet_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  SMIMECapabilitiesParametersForRC2CBC
%%================================
enc_SMIMECapabilitiesParametersForRC2CBC(Val) ->
    enc_SMIMECapabilitiesParametersForRC2CBC(Val, [<<2>>]).

enc_SMIMECapabilitiesParametersForRC2CBC(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_SMIMECapabilitiesParametersForRC2CBC(Tlv) ->
   dec_SMIMECapabilitiesParametersForRC2CBC(Tlv, [2]).

dec_SMIMECapabilitiesParametersForRC2CBC(Tlv, TagIn) ->
decode_integer(Tlv, TagIn).



%%================================
%%  aa-smimeCapabilities_SMIMECapabilities
%%================================
'enc_aa-smimeCapabilities_SMIMECapabilities'(Val) ->
    'enc_aa-smimeCapabilities_SMIMECapabilities'(Val, [<<48>>]).

'enc_aa-smimeCapabilities_SMIMECapabilities'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_aa-smimeCapabilities_SMIMECapabilities_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_aa-smimeCapabilities_SMIMECapabilities_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_aa-smimeCapabilities_SMIMECapabilities_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_aa-smimeCapabilities_SMIMECapabilities_SMIMECapability'(H, [<<48>>]),
   'enc_aa-smimeCapabilities_SMIMECapabilities_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  aa-smimeCapabilities_SMIMECapabilities_SMIMECapability
%%================================
'enc_aa-smimeCapabilities_SMIMECapabilities_SMIMECapability'(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
ObjcapabilityID = 
   'SecureMimeMessageV3dot1-2009':'getenc_internal_object_set_argument_3'(                                   Cindex1),

%%-------------------------------------------------
%% attribute capabilityID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = ObjcapabilityID('Type', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_aa-smimeCapabilities_SMIMECapabilities'(Tlv) ->
   'dec_aa-smimeCapabilities_SMIMECapabilities'(Tlv, [16]).

'dec_aa-smimeCapabilities_SMIMECapabilities'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_aa-smimeCapabilities_SMIMECapabilities_SMIMECapability'(V1, [16]) || V1 <- Tlv1].


'dec_aa-smimeCapabilities_SMIMECapabilities_SMIMECapability'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute capabilityID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldType OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjcapabilityIDTerm1 =
   'SecureMimeMessageV3dot1-2009':'getdec_internal_object_set_argument_3'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjcapabilityIDTerm1('Type', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'SMIMECapability',Term1,Term2},
Res1.
'id-aa'() ->
{1,2,840,113549,1,9,16,2}.

smimeCapabilities() ->
{1,2,840,113549,1,9,15}.

'id-aa-encrypKeyPref'() ->
{1,2,840,113549,1,9,16,2,11}.

'id-smime'() ->
{1,2,840,113549,1,9,16}.

'id-cap'() ->
{1,2,840,113549,1,9,16,11}.

'id-cap-preferBinaryInside'() ->
{1,2,840,113549,1,9,16,11,1}.




%%================================
%%  aa-smimeCapabilities
%%================================
'enc_aa-smimeCapabilities'('Type', Val, _RestPrimFieldName) ->
   'enc_aa-smimeCapabilities_SMIMECapabilities'(Val,[<<48>>]);
'enc_aa-smimeCapabilities'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_aa-smimeCapabilities'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_aa-smimeCapabilities_SMIMECapabilities'(Tlv,[16]);
'dec_aa-smimeCapabilities'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).

tlv_format(Bytes) when is_binary(Bytes) ->
  {Tlv,_} = ber_decode_nif(Bytes),
  Tlv;
tlv_format(Bytes) ->
  Bytes.



%%================================
%%  aa-encrypKeyPref
%%================================
'enc_aa-encrypKeyPref'('Type', Val, _RestPrimFieldName) ->
   enc_SMIMEEncryptionKeyPreference(Val, []);
'enc_aa-encrypKeyPref'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_aa-encrypKeyPref'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_SMIMEEncryptionKeyPreference(Tlv, []);
'dec_aa-encrypKeyPref'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  cap-preferBinaryInside
%%================================
'enc_cap-preferBinaryInside'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_cap-preferBinaryInside'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  cap-RC2CBC
%%================================
'enc_cap-RC2CBC'('Type', Val, _RestPrimFieldName) ->
   enc_SMIMECapabilitiesParametersForRC2CBC(Val, [<<2>>]).


'dec_cap-RC2CBC'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_SMIMECapabilitiesParametersForRC2CBC(Tlv, [2]).




%%================================
%%  SMimeCapsSet_smimeCaps
%%================================
enc_SMimeCapsSet_smimeCaps('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


dec_SMimeCapsSet_smimeCaps('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  aa-smimeCapabilities_smimeCaps
%%================================
'enc_aa-smimeCapabilities_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_aa-smimeCapabilities_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  SMimeAttributeSet
%%================================
getenc_SMimeAttributeSet(Id) when Id =:= {1,2,840,113549,1,9,15} ->
    fun 'enc_aa-smimeCapabilities'/3;
getenc_SMimeAttributeSet(Id) when Id =:= {1,2,840,113549,1,9,16,2,11} ->
    fun 'enc_aa-encrypKeyPref'/3;
getenc_SMimeAttributeSet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_SMimeAttributeSet(Id) when Id =:= {1,2,840,113549,1,9,15} ->
    fun 'dec_aa-smimeCapabilities'/3;
getdec_SMimeAttributeSet(Id) when Id =:= {1,2,840,113549,1,9,16,2,11} ->
    fun 'dec_aa-encrypKeyPref'/3;
getdec_SMimeAttributeSet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SMimeCapsSet
%%================================
getenc_SMimeCapsSet({1,2,840,10040,4,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCapsSet({1,2,840,10045,4,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCapsSet(Id) when Id =:= {1,2,840,113549,3,2} ->
    fun 'enc_cap-RC2CBC'/3;
getenc_SMimeCapsSet({1,2,840,113549,3,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCapsSet({1,2,840,10045,4,3,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCapsSet({1,2,840,10045,4,3,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCapsSet({1,2,840,10045,4,3,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCapsSet({1,2,840,10045,4,3,4}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCapsSet({1,2,840,113549,1,1,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCapsSet({1,2,840,113549,1,1,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCapsSet({1,2,840,113549,1,1,4}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCapsSet({1,2,840,113549,1,1,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCapsSet({1,2,840,113549,1,1,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'PKIX1-PSS-OAEP-Algorithms-2009':'enc_RSAES-OAEP-params'(Val, [<<48>>])
      end
   end;
getenc_SMimeCapsSet({1,2,840,113549,1,1,10}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCapsSet({1,2,840,113549,1,9,16,3,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'CryptographicMessageSyntaxAlgorithms-2009':'enc_KeyWrapAlgorithm'(Val, [<<48>>])
      end
   end;
getenc_SMimeCapsSet({1,2,840,113549,1,9,16,3,6}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCapsSet({1,2,840,113549,1,9,16,3,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCapsSet({1,2,840,113549,1,9,16,3,10}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'CryptographicMessageSyntaxAlgorithms-2009':'enc_KeyWrapAlgorithm'(Val, [<<48>>])
      end
   end;
getenc_SMimeCapsSet(Id) when Id =:= {1,2,840,113549,1,9,16,11,1} ->
    fun 'enc_cap-preferBinaryInside'/3;
getenc_SMimeCapsSet({1,3,6,1,5,5,8,1,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCapsSet({2,16,840,1,101,3,4,3,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCapsSet({2,16,840,1,101,3,4,3,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCapsSet(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_SMimeCapsSet'({1,2,840,10040,4,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCapsSet'({1,2,840,10045,4,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
getdec_SMimeCapsSet(Id) when Id =:= {1,2,840,113549,3,2} ->
    fun 'dec_cap-RC2CBC'/3;
'getdec_SMimeCapsSet'({1,2,840,113549,3,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCapsSet'({1,2,840,10045,4,3,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCapsSet'({1,2,840,10045,4,3,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCapsSet'({1,2,840,10045,4,3,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCapsSet'({1,2,840,10045,4,3,4}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCapsSet'({1,2,840,113549,1,1,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCapsSet'({1,2,840,113549,1,1,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCapsSet'({1,2,840,113549,1,1,4}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCapsSet'({1,2,840,113549,1,1,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCapsSet'({1,2,840,113549,1,1,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'PKIX1-PSS-OAEP-Algorithms-2009':'dec_RSAES-OAEP-params'(Bytes, [16])
      end
   end;
'getdec_SMimeCapsSet'({1,2,840,113549,1,1,10}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCapsSet'({1,2,840,113549,1,9,16,3,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'CryptographicMessageSyntaxAlgorithms-2009':'dec_KeyWrapAlgorithm'(Bytes, [16])
      end
   end;
'getdec_SMimeCapsSet'({1,2,840,113549,1,9,16,3,6}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCapsSet'({1,2,840,113549,1,9,16,3,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCapsSet'({1,2,840,113549,1,9,16,3,10}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'CryptographicMessageSyntaxAlgorithms-2009':'dec_KeyWrapAlgorithm'(Bytes, [16])
      end
   end;
getdec_SMimeCapsSet(Id) when Id =:= {1,2,840,113549,1,9,16,11,1} ->
    fun 'dec_cap-preferBinaryInside'/3;
'getdec_SMimeCapsSet'({1,3,6,1,5,5,8,1,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCapsSet'({2,16,840,1,101,3,4,3,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCapsSet'({2,16,840,1,101,3,4,3,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
getdec_SMimeCapsSet(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_3
%%================================
getenc_internal_object_set_argument_3({1,2,840,10040,4,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_3({1,2,840,10045,4,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_3(Id) when Id =:= {1,2,840,113549,3,2} ->
    fun 'enc_cap-RC2CBC'/3;
getenc_internal_object_set_argument_3({1,2,840,113549,3,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_3({1,2,840,10045,4,3,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_3({1,2,840,10045,4,3,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_3({1,2,840,10045,4,3,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_3({1,2,840,10045,4,3,4}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_3({1,2,840,113549,1,1,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_3({1,2,840,113549,1,1,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_3({1,2,840,113549,1,1,4}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_3({1,2,840,113549,1,1,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_3({1,2,840,113549,1,1,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'PKIX1-PSS-OAEP-Algorithms-2009':'enc_RSAES-OAEP-params'(Val, [<<48>>])
      end
   end;
getenc_internal_object_set_argument_3({1,2,840,113549,1,1,10}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_3({1,2,840,113549,1,9,16,3,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'CryptographicMessageSyntaxAlgorithms-2009':'enc_KeyWrapAlgorithm'(Val, [<<48>>])
      end
   end;
getenc_internal_object_set_argument_3({1,2,840,113549,1,9,16,3,6}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_3({1,2,840,113549,1,9,16,3,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_3({1,2,840,113549,1,9,16,3,10}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'CryptographicMessageSyntaxAlgorithms-2009':'enc_KeyWrapAlgorithm'(Val, [<<48>>])
      end
   end;
getenc_internal_object_set_argument_3(Id) when Id =:= {1,2,840,113549,1,9,16,11,1} ->
    fun 'enc_cap-preferBinaryInside'/3;
getenc_internal_object_set_argument_3({1,3,6,1,5,5,8,1,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_3({2,16,840,1,101,3,4,3,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_3({2,16,840,1,101,3,4,3,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_3(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_internal_object_set_argument_3'({1,2,840,10040,4,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_3'({1,2,840,10045,4,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
getdec_internal_object_set_argument_3(Id) when Id =:= {1,2,840,113549,3,2} ->
    fun 'dec_cap-RC2CBC'/3;
'getdec_internal_object_set_argument_3'({1,2,840,113549,3,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_3'({1,2,840,10045,4,3,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_3'({1,2,840,10045,4,3,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_3'({1,2,840,10045,4,3,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_3'({1,2,840,10045,4,3,4}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_3'({1,2,840,113549,1,1,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_3'({1,2,840,113549,1,1,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_3'({1,2,840,113549,1,1,4}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_3'({1,2,840,113549,1,1,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_3'({1,2,840,113549,1,1,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'PKIX1-PSS-OAEP-Algorithms-2009':'dec_RSAES-OAEP-params'(Bytes, [16])
      end
   end;
'getdec_internal_object_set_argument_3'({1,2,840,113549,1,1,10}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_3'({1,2,840,113549,1,9,16,3,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'CryptographicMessageSyntaxAlgorithms-2009':'dec_KeyWrapAlgorithm'(Bytes, [16])
      end
   end;
'getdec_internal_object_set_argument_3'({1,2,840,113549,1,9,16,3,6}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_3'({1,2,840,113549,1,9,16,3,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_3'({1,2,840,113549,1,9,16,3,10}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'CryptographicMessageSyntaxAlgorithms-2009':'dec_KeyWrapAlgorithm'(Bytes, [16])
      end
   end;
getdec_internal_object_set_argument_3(Id) when Id =:= {1,2,840,113549,1,9,16,11,1} ->
    fun 'dec_cap-preferBinaryInside'/3;
'getdec_internal_object_set_argument_3'({1,3,6,1,5,5,8,1,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_3'({2,16,840,1,101,3,4,3,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_3'({2,16,840,1,101,3,4,3,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
getdec_internal_object_set_argument_3(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_2
%%================================
getenc_internal_object_set_argument_2({1,2,840,10040,4,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,10045,4,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,3,2} ->
    fun 'enc_cap-RC2CBC'/3;
getenc_internal_object_set_argument_2({1,2,840,113549,3,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,10045,4,3,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,10045,4,3,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,10045,4,3,3}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,10045,4,3,4}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,113549,1,1,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,113549,1,1,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,113549,1,1,4}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,113549,1,1,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,113549,1,1,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'PKIX1-PSS-OAEP-Algorithms-2009':'enc_RSAES-OAEP-params'(Val, [<<48>>])
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,113549,1,1,10}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,113549,1,9,16,3,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'CryptographicMessageSyntaxAlgorithms-2009':'enc_KeyWrapAlgorithm'(Val, [<<48>>])
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,113549,1,9,16,3,6}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,113549,1,9,16,3,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_2({1,2,840,113549,1,9,16,3,10}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'CryptographicMessageSyntaxAlgorithms-2009':'enc_KeyWrapAlgorithm'(Val, [<<48>>])
      end
   end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,9,16,11,1} ->
    fun 'enc_cap-preferBinaryInside'/3;
getenc_internal_object_set_argument_2({1,3,6,1,5,5,8,1,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_2({2,16,840,1,101,3,4,3,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_2({2,16,840,1,101,3,4,3,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_internal_object_set_argument_2(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_internal_object_set_argument_2'({1,2,840,10040,4,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,10045,4,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,3,2} ->
    fun 'dec_cap-RC2CBC'/3;
'getdec_internal_object_set_argument_2'({1,2,840,113549,3,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,10045,4,3,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,10045,4,3,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,10045,4,3,3}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,10045,4,3,4}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,113549,1,1,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,113549,1,1,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,113549,1,1,4}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,113549,1,1,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,113549,1,1,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'PKIX1-PSS-OAEP-Algorithms-2009':'dec_RSAES-OAEP-params'(Bytes, [16])
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,113549,1,1,10}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,113549,1,9,16,3,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'CryptographicMessageSyntaxAlgorithms-2009':'dec_KeyWrapAlgorithm'(Bytes, [16])
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,113549,1,9,16,3,6}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,113549,1,9,16,3,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_2'({1,2,840,113549,1,9,16,3,10}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'CryptographicMessageSyntaxAlgorithms-2009':'dec_KeyWrapAlgorithm'(Bytes, [16])
      end
   end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,9,16,11,1} ->
    fun 'dec_cap-preferBinaryInside'/3;
'getdec_internal_object_set_argument_2'({1,3,6,1,5,5,8,1,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_2'({2,16,840,1,101,3,4,3,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_internal_object_set_argument_2'({2,16,840,1,101,3,4,3,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
getdec_internal_object_set_argument_2(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.



%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

dec_subidentifiers(<<>>, _Av, Al) ->
    lists:reverse(Al);
dec_subidentifiers(<<1:1,H:7,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, Av bsl 7 + H, Al);
dec_subidentifiers(<<H,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 + H | Al]).

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_object_identifier(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    [AddedObjVal | ObjVals] = dec_subidentifiers(Val, 0, []),
    {Val1, Val2} =
        if
            AddedObjVal < 40 ->
                {0, AddedObjVal};
            AddedObjVal < 80 ->
                {1, AddedObjVal - 40};
            true ->
                {2, AddedObjVal - 80}
        end,
    list_to_tuple([Val1, Val2 | ObjVals]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

decode_open_type(Tlv, TagIn) ->
    case match_tags(Tlv, TagIn) of
        Bin when is_binary(Bin) ->
            {InnerTlv, _} = ber_decode_nif(Bin),
            InnerTlv;
        TlvBytes ->
            TlvBytes
    end.

e_object_identifier({'OBJECT IDENTIFIER', V}) ->
    e_object_identifier(V);
e_object_identifier(V) when is_tuple(V) ->
    e_object_identifier(tuple_to_list(V));
e_object_identifier([E1, E2 | Tail]) ->
    Head = 40 * E1 + E2,
    {H, Lh} = mk_object_val(Head),
    {R, Lr} = lists:mapfoldl(fun enc_obj_id_tail/2, 0, Tail),
    {[H | R], Lh + Lr}.

enc_obj_id_tail(H, Len) ->
    {B, L} = mk_object_val(H),
    {B, Len + L}.

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes, length(Bytes)}.

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error, {asn1, {encode_integer, Val}}}).

encode_integer_neg(-1, [B1 | _T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255 | Acc]).

encode_integer_pos(0, [B | _Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255 | Acc]).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_object_identifier(Val, TagIn) ->
    encode_tags(TagIn, e_object_identifier(Val)).

encode_open_type(Val, T) when is_list(Val) ->
    encode_open_type(list_to_binary(Val), T);
encode_open_type(Val, Tag) ->
    encode_tags(Tag, Val, byte_size(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar, LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

mk_object_val(0, Ack, Len) ->
    {Ack, Len};
mk_object_val(Val, Ack, Len) ->
    mk_object_val(Val bsr 7, [Val band 127 bor 128 | Ack], Len + 1).

mk_object_val(Val) when Val =< 127 ->
    {[255 band Val], 1};
mk_object_val(Val) ->
    mk_object_val(Val bsr 7, [Val band 127], 1).
