/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.instruct.GeneralVariable;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public abstract class XSLVariableDeclaration
extends XSLGeneralVariable
implements VariableDeclaration,
StylesheetProcedure {
    private int slotNumber = -9876;
    protected List references = new ArrayList(10);

    public boolean isDeclaration() {
        return true;
    }

    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(int slot) {
        this.slotNumber = slot;
    }

    public abstract SequenceType getRequiredType();

    public void registerReference(BindingReference ref) {
        this.references.add(ref);
    }

    public boolean isInstruction() {
        return true;
    }

    public void fixupReferences() throws XPathException {
        SequenceType type = this.getRequiredType();
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        Iterator iter = this.references.iterator();
        while (iter.hasNext()) {
            Value constantValue = null;
            int properties = 0;
            if (this instanceof XSLVariable && !this.isAssignable()) {
                int relation;
                if (this.select instanceof Literal && ((relation = th.relationship(this.select.getItemType(th), type.getPrimaryType())) == 0 || relation == 2)) {
                    constantValue = ((Literal)this.select).getValue();
                }
                if (this.select != null) {
                    properties = this.select.getSpecialProperties();
                }
            }
            ((BindingReference)iter.next()).setStaticType(type, constantValue, properties);
        }
        super.fixupReferences();
    }

    public void validate(Declaration decl) throws XPathException {
        super.validate(decl);
        if (this.global && !this.redundant) {
            this.slotNumber = this.getExecutable().getGlobalVariableMap().allocateSlotNumber(this.getVariableQName());
        }
    }

    protected void fixupBinding(Binding binding) {
        Iterator iter = this.references.iterator();
        while (iter.hasNext()) {
            ((BindingReference)iter.next()).fixup(binding);
        }
    }

    protected void setReferenceCount(GeneralVariable var) {
        var.setReferenceCount(10);
    }

    protected void index(Declaration decl, PrincipalStylesheetModule top) throws XPathException {
        top.indexVariableDeclaration(decl);
    }

    public void optimize(Declaration declaration) throws XPathException {
        if (this.global && !this.redundant && this.select != null) {
            Expression exp2 = this.select;
            ExpressionVisitor visitor = this.makeExpressionVisitor();
            Optimizer opt = this.getConfiguration().getOptimizer();
            try {
                if (opt.getOptimizationLevel() != 0) {
                    exp2 = exp2.optimize(visitor, AnyNodeTest.getInstance());
                }
            }
            catch (XPathException err) {
                err.maybeSetLocation(this);
                this.compileError(err);
            }
            this.allocateSlots(exp2);
            if (this.slotManager != null && this.slotManager.getNumberOfVariables() > 0) {
                ((GlobalVariable)this.compiledVariable).setContainsLocals(this.slotManager);
            }
            if (exp2 != this.select) {
                this.select = exp2;
                this.compiledVariable.setSelectExpression(this.select);
            }
        }
    }

    public GeneralVariable getCompiledVariable() {
        return this.compiledVariable;
    }
}

