/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import net.sf.saxon.s9api.QName;

public class XProcNamespaceContext {
    Hashtable<String, String> nshash = new Hashtable();

    public XProcNamespaceContext(Hashtable<String, String> hashtable) {
        for (String string : hashtable.keySet()) {
            this.nshash.put(string, hashtable.get(string));
        }
    }

    public String getNamespaceURI(String string) {
        if (this.nshash.containsKey(string)) {
            return this.nshash.get(string);
        }
        if ("xml".equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(string)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return "";
    }

    public String getPrefix(String string) {
        for (String string2 : this.nshash.keySet()) {
            if (!string.equals(this.nshash.get(string2))) continue;
            return string2;
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(string)) {
            return "xmlns";
        }
        return null;
    }

    public Set<String> getAllPrefixes() {
        return this.nshash.keySet();
    }

    public Hashtable<String, String> bindings() {
        return this.nshash;
    }

    public Iterator getPrefixes(String string) {
        Vector<String> vector = new Vector<String>();
        for (String string2 : this.nshash.keySet()) {
            if (!string.equals(this.nshash.get(string2))) continue;
            vector.add(string2);
        }
        return vector.iterator();
    }

    public Iterator getPrefixes() {
        return null;
    }

    public void addBinding(String string, String string2) {
        this.nshash.put(string, string2);
    }

    public void delBinding(String string) {
        this.nshash.remove(string);
    }

    public QName parseQName(String string) {
        QName qName = null;
        if (string.contains(":")) {
            int n = string.indexOf(":");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            String string4 = this.nshash.get(string2);
            if ("xml".equals(string2)) {
                string4 = "http://www.w3.org/XML/1998/namespace";
            }
            if (string4 == null) {
                throw new IllegalArgumentException("No binding for prefix in name: " + string);
            }
            qName = new QName(string4, string3, string2);
        } else {
            qName = new QName(this.getNamespaceURI(""), string, "");
        }
        return qName;
    }

    public void dump() {
        System.err.println("Namespace context: " + this.hashCode());
        for (String string : this.nshash.keySet()) {
            System.err.println("\t" + string + "=" + this.nshash.get(string));
        }
    }
}

