/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.SpanFilter;
import org.apache.lucene.search.SpanFilterResult;

public class CachingSpanFilter
extends SpanFilter {
    private SpanFilter filter;
    private transient Map<IndexReader, SpanFilterResult> cache;
    private final ReentrantLock lock = new ReentrantLock();

    public CachingSpanFilter(SpanFilter filter) {
        this.filter = filter;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        SpanFilterResult result = this.getCachedResult(reader);
        return result != null ? result.getDocIdSet() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpanFilterResult getCachedResult(IndexReader reader) throws IOException {
        block6: {
            this.lock.lock();
            try {
                SpanFilterResult cached;
                if (this.cache == null) {
                    this.cache = new WeakHashMap<IndexReader, SpanFilterResult>();
                }
                if ((cached = this.cache.get(reader)) == null) break block6;
                SpanFilterResult spanFilterResult = cached;
                Object var5_4 = null;
                this.lock.unlock();
                return spanFilterResult;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.lock.unlock();
                throw throwable;
            }
        }
        Object var5_5 = null;
        this.lock.unlock();
        SpanFilterResult result = this.filter.bitSpans(reader);
        this.lock.lock();
        try {
            this.cache.put(reader, result);
            Object var7_8 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.lock.unlock();
            throw throwable;
        }
        return result;
    }

    public SpanFilterResult bitSpans(IndexReader reader) throws IOException {
        return this.getCachedResult(reader);
    }

    public String toString() {
        return "CachingSpanFilter(" + this.filter + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof CachingSpanFilter)) {
            return false;
        }
        return this.filter.equals(((CachingSpanFilter)o).filter);
    }

    public int hashCode() {
        return this.filter.hashCode() ^ 0x1117BF25;
    }
}

