/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.store.Directory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndexCommit {
    public abstract String getSegmentsFileName();

    public abstract Collection<String> getFileNames() throws IOException;

    public abstract Directory getDirectory();

    public void delete() {
        throw new UnsupportedOperationException("This IndexCommit does not support this method.");
    }

    public boolean isDeleted() {
        throw new UnsupportedOperationException("This IndexCommit does not support this method.");
    }

    public boolean isOptimized() {
        throw new UnsupportedOperationException("This IndexCommit does not support this method.");
    }

    public boolean equals(Object other) {
        if (other instanceof IndexCommit) {
            IndexCommit otherCommit = (IndexCommit)other;
            return otherCommit.getDirectory().equals(this.getDirectory()) && otherCommit.getVersion() == this.getVersion();
        }
        return false;
    }

    public int hashCode() {
        return this.getDirectory().hashCode() + this.getSegmentsFileName().hashCode();
    }

    public long getVersion() {
        throw new UnsupportedOperationException("This IndexCommit does not support this method.");
    }

    public long getGeneration() {
        throw new UnsupportedOperationException("This IndexCommit does not support this method.");
    }

    public long getTimestamp() throws IOException {
        return this.getDirectory().fileModified(this.getSegmentsFileName());
    }

    public Map<String, String> getUserData() throws IOException {
        throw new UnsupportedOperationException("This IndexCommit does not support this method.");
    }
}

