/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.PriorityQueue;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.FuzzyTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.ToStringUtils;

public class FuzzyQuery
extends MultiTermQuery {
    public static final float defaultMinSimilarity = 0.5f;
    public static final int defaultPrefixLength = 0;
    private float minimumSimilarity;
    private int prefixLength;
    private boolean termLongEnough = false;
    protected Term term;

    public FuzzyQuery(Term term, float minimumSimilarity, int prefixLength) throws IllegalArgumentException {
        this.term = term;
        if (minimumSimilarity >= 1.0f) {
            throw new IllegalArgumentException("minimumSimilarity >= 1");
        }
        if (minimumSimilarity < 0.0f) {
            throw new IllegalArgumentException("minimumSimilarity < 0");
        }
        if (prefixLength < 0) {
            throw new IllegalArgumentException("prefixLength < 0");
        }
        if ((float)term.text().length() > 1.0f / (1.0f - minimumSimilarity)) {
            this.termLongEnough = true;
        }
        this.minimumSimilarity = minimumSimilarity;
        this.prefixLength = prefixLength;
        this.rewriteMethod = SCORING_BOOLEAN_QUERY_REWRITE;
    }

    public FuzzyQuery(Term term, float minimumSimilarity) throws IllegalArgumentException {
        this(term, minimumSimilarity, 0);
    }

    public FuzzyQuery(Term term) {
        this(term, 0.5f, 0);
    }

    public float getMinSimilarity() {
        return this.minimumSimilarity;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        return new FuzzyTermEnum(reader, this.getTerm(), this.minimumSimilarity, this.prefixLength);
    }

    public Term getTerm() {
        return this.term;
    }

    public void setRewriteMethod(MultiTermQuery.RewriteMethod method) {
        throw new UnsupportedOperationException("FuzzyQuery cannot change rewrite method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query rewrite(IndexReader reader) throws IOException {
        if (!this.termLongEnough) {
            return new TermQuery(this.term);
        }
        int maxSize = BooleanQuery.getMaxClauseCount();
        PriorityQueue<ScoreTerm> stQueue = new PriorityQueue<ScoreTerm>(1024);
        FilteredTermEnum enumerator = this.getEnum(reader);
        try {
            Term t;
            ScoreTerm bottomSt = null;
            while ((t = enumerator.term()) != null) {
                ScoreTerm st = new ScoreTerm(t, enumerator.difference());
                if (stQueue.size() < maxSize) {
                    if (bottomSt == null || st.compareTo(bottomSt) > 0) {
                        bottomSt = st;
                    }
                    stQueue.offer(st);
                } else {
                    assert (bottomSt != null);
                    if (st.compareTo(bottomSt) < 0) {
                        stQueue.offer(st);
                    }
                }
                if (enumerator.next()) continue;
                break;
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            enumerator.close();
            throw throwable;
        }
        enumerator.close();
        BooleanQuery query = new BooleanQuery(true);
        int size = Math.min(stQueue.size(), maxSize);
        for (int i = 0; i < size; ++i) {
            ScoreTerm st = (ScoreTerm)stQueue.poll();
            TermQuery tq = new TermQuery(st.term);
            tq.setBoost(this.getBoost() * st.score);
            query.add(tq, BooleanClause.Occur.SHOULD);
        }
        return query;
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        buffer.append('~');
        buffer.append(Float.toString(this.minimumSimilarity));
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Float.floatToIntBits(this.minimumSimilarity);
        result = 31 * result + this.prefixLength;
        result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FuzzyQuery other = (FuzzyQuery)obj;
        if (Float.floatToIntBits(this.minimumSimilarity) != Float.floatToIntBits(other.minimumSimilarity)) {
            return false;
        }
        if (this.prefixLength != other.prefixLength) {
            return false;
        }
        return !(this.term == null ? other.term != null : !this.term.equals(other.term));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ScoreTerm
    implements Comparable<ScoreTerm> {
        public Term term;
        public float score;

        public ScoreTerm(Term term, float score) {
            this.term = term;
            this.score = score;
        }

        @Override
        public int compareTo(ScoreTerm other) {
            if (this.score == other.score) {
                return this.term.compareTo(other.term);
            }
            return Float.compare(other.score, this.score);
        }
    }
}

