/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.TypeCheckerEnvironment;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionVisitor
implements TypeCheckerEnvironment {
    private Stack<Expression> stack = new Stack();
    private Executable executable;
    private StaticContext staticContext;
    private Configuration configuration;
    private boolean optimizeForStreaming = false;

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    @Override
    public CollationMap getCollationMap() {
        return this.executable.getCollationTable();
    }

    public Stack<Expression> getStack() {
        return this.stack;
    }

    public void setStack(Stack<Expression> stack) {
        this.stack = stack;
    }

    public StaticContext getStaticContext() {
        return this.staticContext;
    }

    public void setStaticContext(StaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public Expression getCurrentExpression() {
        return this.stack.peek();
    }

    public static ExpressionVisitor make(StaticContext env, Executable exec) {
        ExpressionVisitor visitor = new ExpressionVisitor();
        visitor.setStaticContext(env);
        visitor.setExecutable(exec);
        visitor.setConfiguration(env.getConfiguration());
        return visitor;
    }

    @Override
    public void issueWarning(String message, SourceLocator locator) {
        this.staticContext.issueWarning(message, locator);
    }

    @Override
    public XPathContext makeDynamicContext() {
        return this.staticContext.makeEarlyEvaluationContext();
    }

    @Override
    public Expression simplify(Expression exp) throws XPathException {
        if (exp != null) {
            this.stack.push(exp);
            Expression exp2 = exp.simplify(this);
            if (exp2 != exp) {
                ExpressionTool.copyLocationInfo(exp, exp2);
            }
            this.stack.pop();
            return exp2;
        }
        return null;
    }

    @Override
    public Expression typeCheck(Expression exp, ItemType contextItemType) throws XPathException {
        if (exp != null) {
            this.stack.push(exp);
            Expression exp2 = exp.typeCheck(this, contextItemType);
            if (exp2 != exp) {
                ExpressionTool.copyLocationInfo(exp, exp2);
            }
            this.stack.pop();
            return exp2;
        }
        return null;
    }

    public void setOptimizeForStreaming(boolean option) {
        this.optimizeForStreaming = option;
    }

    public boolean isOptimizeForStreaming() {
        return this.optimizeForStreaming;
    }

    public Expression optimize(Expression exp, ItemType contextItemType) throws XPathException {
        if (exp != null) {
            this.stack.push(exp);
            Expression exp2 = exp.optimize(this, contextItemType);
            if (exp2 != exp) {
                ExpressionTool.copyLocationInfo(exp, exp2);
            }
            this.stack.pop();
            return exp2;
        }
        return null;
    }

    public Expression getParentExpression() {
        int pos = this.stack.size() - 2;
        if (pos > 0) {
            return (Expression)this.stack.get(pos);
        }
        return null;
    }

    public boolean isLoopingSubexpression(Expression ancestor) {
        int top = this.stack.size() - 1;
        while (top > 0) {
            Expression parent = (Expression)this.stack.get(top - 1);
            if (parent.hasLoopingSubexpression((Expression)this.stack.get(top))) {
                return true;
            }
            if (parent == ancestor) {
                return false;
            }
            --top;
        }
        return false;
    }

    public final void resetStaticProperties() {
        for (Expression exp : this.stack) {
            exp.resetLocalStaticProperties();
        }
    }
}

