/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import net.sf.saxon.om.NamespaceResolver;

public class NamespaceContextImpl
implements NamespaceContext,
NamespaceResolver {
    NamespaceResolver resolver;

    public NamespaceContextImpl(NamespaceResolver resolver) {
        this.resolver = resolver;
    }

    public String getURIForPrefix(String prefix, boolean useDefault) {
        return this.resolver.getURIForPrefix(prefix, useDefault);
    }

    public Iterator iteratePrefixes() {
        return this.resolver.iteratePrefixes();
    }

    public String getNamespaceURI(String prefix) {
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return this.resolver.getURIForPrefix(prefix, true);
    }

    public String getPrefix(String uri) {
        Iterator prefixes = this.iteratePrefixes();
        while (prefixes.hasNext()) {
            String p = (String)prefixes.next();
            String u = this.resolver.getURIForPrefix(p, true);
            if (!u.equals(uri)) continue;
            return p;
        }
        return null;
    }

    public Iterator getPrefixes(String uri) {
        ArrayList<String> list = new ArrayList<String>(4);
        Iterator prefixes = this.iteratePrefixes();
        while (prefixes.hasNext()) {
            String p = (String)prefixes.next();
            String u = this.resolver.getURIForPrefix(p, true);
            if (!u.equals(uri)) continue;
            list.add(p);
        }
        return list.iterator();
    }
}

