/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tinytree;

import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.tinytree.TinyDocumentImpl;
import com.icl.saxon.tinytree.TinyNodeImpl;

final class AncestorEnumeration
implements AxisEnumeration {
    private int nextNodeNr;
    private TinyDocumentImpl document;
    private TinyNodeImpl node;
    private NodeTest test;
    private TinyNodeImpl first = null;
    private boolean includeSelf;
    private int last = -1;

    public AncestorEnumeration(TinyDocumentImpl tinyDocumentImpl, TinyNodeImpl tinyNodeImpl, NodeTest nodeTest, boolean bl) {
        this.document = tinyDocumentImpl;
        this.test = nodeTest;
        this.node = tinyNodeImpl;
        this.includeSelf = bl;
        if (bl && nodeTest.matches(tinyNodeImpl)) {
            this.first = tinyNodeImpl;
        }
        TinyNodeImpl tinyNodeImpl2 = (TinyNodeImpl)tinyNodeImpl.getParent();
        this.nextNodeNr = tinyNodeImpl2.nodeNr;
        if (!nodeTest.matches(tinyNodeImpl2)) {
            this.advance();
        }
    }

    public boolean hasMoreElements() {
        return this.first != null || this.nextNodeNr >= 0;
    }

    public NodeInfo nextElement() {
        if (this.first != null) {
            TinyNodeImpl tinyNodeImpl = this.first;
            this.first = null;
            return tinyNodeImpl;
        }
        TinyNodeImpl tinyNodeImpl = this.document.getNode(this.nextNodeNr);
        this.advance();
        return tinyNodeImpl;
    }

    private void advance() {
        int n = this.document.depth[this.nextNodeNr] - 1;
        while (true) {
            --this.nextNodeNr;
            if (this.nextNodeNr < 0) {
                return;
            }
            if (this.document.depth[this.nextNodeNr] > n) continue;
            if (this.test.matches(this.document.nodeType[this.nextNodeNr], this.document.nameCode[this.nextNodeNr])) {
                return;
            }
            --n;
            if (this.nextNodeNr < 0) break;
        }
    }

    public boolean isSorted() {
        return false;
    }

    public boolean isReverseSorted() {
        return true;
    }

    public boolean isPeer() {
        return false;
    }

    public int getLastPosition() {
        if (this.last >= 0) {
            return this.last;
        }
        AncestorEnumeration ancestorEnumeration = new AncestorEnumeration(this.document, this.node, this.test, this.includeSelf);
        this.last = 0;
        while (ancestorEnumeration.hasMoreElements()) {
            ancestorEnumeration.nextElement();
            ++this.last;
        }
        return this.last;
    }
}

