/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.DataExceptPattern;
import com.thaiopensource.relaxng.pattern.DataPattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.ValuePattern;
import com.thaiopensource.xml.util.Name;
import java.util.List;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DataDerivFailure {
    private final Datatype datatype;
    private final Name datatypeName;
    private final List<String> datatypeParams;
    private final String message;
    private final String stringValue;
    private final Object value;
    private Pattern except;
    private int index;
    private int tokenIndex = -1;
    private int tokenStart = -1;
    private int tokenEnd = -1;

    DataDerivFailure(DataPattern dataPattern, DatatypeException datatypeException) {
        this(dataPattern.getDatatype(), dataPattern.getDatatypeName(), dataPattern.getParams(), datatypeException.getMessage(), datatypeException.getIndex());
    }

    DataDerivFailure(Datatype datatype, Name name, DatatypeException datatypeException) {
        this(datatype, name, null, datatypeException.getMessage(), datatypeException.getIndex());
    }

    DataDerivFailure(DataExceptPattern dataExceptPattern) {
        this(dataExceptPattern.getDatatype(), dataExceptPattern.getDatatypeName(), dataExceptPattern.getParams(), dataExceptPattern.getExcept());
    }

    DataDerivFailure(ValuePattern valuePattern) {
        this(valuePattern.getDatatype(), valuePattern.getDatatypeName(), valuePattern.getValue(), valuePattern.getStringValue());
    }

    private DataDerivFailure(Datatype datatype, Name name, List<String> list, String string, int n) {
        this.datatype = datatype;
        this.datatypeName = name;
        this.datatypeParams = list;
        this.message = string;
        this.except = null;
        this.index = n == -1 ? -1 : n;
        this.stringValue = null;
        this.value = null;
    }

    private DataDerivFailure(Datatype datatype, Name name, List<String> list, Pattern pattern) {
        this.datatype = datatype;
        this.datatypeName = name;
        this.datatypeParams = list;
        this.message = null;
        this.except = pattern;
        this.index = -1;
        this.stringValue = null;
        this.value = null;
    }

    private DataDerivFailure(Datatype datatype, Name name, Object object, String string) {
        this.datatype = datatype;
        this.datatypeName = name;
        this.datatypeParams = null;
        this.message = null;
        this.except = null;
        this.index = -1;
        this.stringValue = string;
        this.value = object;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataDerivFailure)) {
            return false;
        }
        DataDerivFailure dataDerivFailure = (DataDerivFailure)object;
        return this.datatype == dataDerivFailure.datatype && DataDerivFailure.equal(this.message, dataDerivFailure.message) && DataDerivFailure.equal(this.stringValue, dataDerivFailure.stringValue) && this.except == dataDerivFailure.except && this.tokenIndex == dataDerivFailure.tokenIndex && this.index == dataDerivFailure.index;
    }

    public int hashCode() {
        int n = this.datatype.hashCode();
        if (this.message != null) {
            n ^= this.message.hashCode();
        }
        if (this.stringValue != null) {
            n ^= this.stringValue.hashCode();
        }
        if (this.except != null) {
            n ^= this.except.hashCode();
        }
        return n;
    }

    private static boolean equal(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    Datatype getDatatype() {
        return this.datatype;
    }

    Name getDatatypeName() {
        return this.datatypeName;
    }

    List<String> getDatatypeParams() {
        return this.datatypeParams;
    }

    String getMessage() {
        return this.message;
    }

    String getStringValue() {
        return this.stringValue;
    }

    Object getValue() {
        return this.value;
    }

    Pattern getExcept() {
        return this.except;
    }

    int getIndex() {
        return this.index;
    }

    int getTokenIndex() {
        return this.tokenIndex;
    }

    int getTokenStart() {
        return this.tokenStart;
    }

    int getTokenEnd() {
        return this.tokenEnd;
    }

    void setToken(int n, int n2, int n3) {
        this.tokenIndex = n;
        this.tokenStart = n2;
        this.tokenEnd = n3;
        if (this.index < 0) {
            this.index += n2;
        }
    }
}

