# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit autotools

if [[ ${PV} == *9999* ]]; then
	EGIT_REPO_URI="https://git.code.sf.net/p/libmwaw/libmwaw"
	inherit git-r3
else
	SRC_URI="https://downloads.sourceforge.net/${PN}/${P}.tar.xz"
	KEYWORDS="~amd64 ~arm ~arm64 ~loong ~ppc64 ~riscv ~x86"
fi

DESCRIPTION="Library parsing many pre-OSX MAC text formats"
HOMEPAGE="https://sourceforge.net/p/libmwaw/wiki/Home/"

LICENSE="LGPL-2.1"
SLOT="0"
IUSE="doc tools"

DEPEND="
	dev-libs/librevenge
	sys-libs/zlib
"
RDEPEND="${DEPEND}"
BDEPEND="
	dev-build/libtool
	virtual/pkgconfig
	doc? ( app-text/doxygen )
"

src_prepare() {
	default

	# Refresh stale libtool, bug #814512
	eautoreconf
}

src_configure() {
	# zip is hard enabled as the zlib is dep on the rdeps anyway
	local myeconfargs=(
		--enable-zip
		--disable-werror
		$(use_with doc docs)
		$(use_enable tools)
	)
	econf "${myeconfargs[@]}"
}

src_install() {
	default
	find "${D}" -name '*.la' -type f -delete || die
}
