# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.7.1.1.9999
#hackport: flags: -dev

CABAL_FEATURES="lib profile haddock hoogle hscolour"
inherit haskell-cabal

TEST_PN="${PN}-tests"
TEST_P="${TEST_PN}-${PV}"

DESCRIPTION="Lightweight package providing commonly useful parser combinators"
HOMEPAGE="https://github.com/mrkkrp/parser-combinators"
SRC_URI+=" test? ( https://hackage.haskell.org/package/${TEST_P}/${TEST_P}.tar.gz )"

LICENSE="BSD"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"
IUSE="test"
RESTRICT+=" !test? ( test )"

RDEPEND=">=dev-lang/ghc-8.6.3:=
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-2.4.0.1
	test? (
		>=dev-haskell/hspec-2.0 <dev-haskell/hspec-3.0
		>=dev-haskell/hspec-expectations-0.8 <dev-haskell/hspec-expectations-0.9
		>=dev-haskell/hspec-megaparsec-2.0 <dev-haskell/hspec-megaparsec-3.0
		>=dev-haskell/megaparsec-8.0 <dev-haskell/megaparsec-10.0
		>=dev-haskell/megaparsec-tests-8.0 <dev-haskell/megaparsec-tests-10.0
		>=dev-haskell/quickcheck-2.7 <dev-haskell/quickcheck-2.15
	)
"

pkg_pretend() {
	if use test; then
		ewarn "The \"test\" USE flag for this package creates cycles within the"
		ewarn "dependency graph. This may give you problems during 'haskell-updater' runs."
		ewarn "It is recommended to leave it disabled unless explicitly testing the package."
	fi
}

src_configure() {
	haskell-cabal_src_configure \
		--flag=-dev
}

src_test() {
	if use test; then
		cabal-register-inplace || die
		local pkg_db="${S}/dist/package.conf.inplace"

		local old_S="${S}"
		export S="${WORKDIR}/${TEST_P}"
		pushd "${S}" > /dev/null || die

		export CABAL_TEST_SUITE=yes
		export CABAL_USE_HADDOCK=''
		haskell-cabal_src_configure \
			--package-db="${pkg_db}" \
			--flag=-dev

		haskell-cabal_src_compile

		SKIP_REGISTER_INPLACE=yes haskell-cabal_src_test

		popd > /dev/null || die
		export S="${old_S}"
	fi
}
