# Copyright 2022-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Auto-Generated by cargo-ebuild 0.5.4-r1

EAPI=8

CRATES="
	adler@1.0.2
	anstream@0.6.13
	anstyle@1.0.6
	anstyle-parse@0.2.3
	anstyle-query@1.0.2
	anstyle-wincon@3.0.2
	autocfg@1.2.0
	bitflags@1.3.2
	bitflags@2.5.0
	bitvec@1.0.1
	bytemuck@1.16.1
	byteorder@1.5.0
	cc@1.0.92
	cfg-if@1.0.0
	clap@4.5.4
	clap_builder@4.5.2
	clap_lex@0.7.0
	clap_mangen@0.2.20
	colorchoice@1.0.0
	crc32fast@1.4.0
	crossbeam-channel@0.5.12
	crossbeam-deque@0.8.5
	crossbeam-epoch@0.9.18
	crossbeam-utils@0.8.19
	either@1.10.0
	env_filter@0.1.0
	env_logger@0.11.3
	equivalent@1.0.1
	errno@0.3.8
	fdeflate@0.3.4
	filetime@0.2.23
	flate2@1.0.28
	funty@2.0.0
	glob@0.3.1
	hashbrown@0.14.3
	image@0.25.1
	indexmap@2.2.6
	libc@0.2.153
	libdeflate-sys@1.20.0
	libdeflater@1.20.0
	linux-raw-sys@0.4.13
	log@0.4.21
	miniz_oxide@0.7.2
	num-traits@0.2.18
	pkg-config@0.3.31
	png@0.17.13
	radium@0.7.0
	rayon@1.10.0
	rayon-core@1.12.1
	redox_syscall@0.4.1
	rgb@0.8.44
	roff@0.2.1
	rustc-hash@1.1.0
	rustc_version@0.4.0
	rustix@0.38.32
	semver@1.0.22
	simd-adler32@0.3.7
	strsim@0.11.1
	tap@1.0.1
	terminal_size@0.3.0
	typed-arena@2.0.2
	utf8parse@0.2.1
	windows-sys@0.48.0
	windows-sys@0.52.0
	windows-targets@0.48.5
	windows-targets@0.52.5
	windows_aarch64_gnullvm@0.48.5
	windows_aarch64_gnullvm@0.52.5
	windows_aarch64_msvc@0.48.5
	windows_aarch64_msvc@0.52.5
	windows_i686_gnu@0.48.5
	windows_i686_gnu@0.52.5
	windows_i686_gnullvm@0.52.5
	windows_i686_msvc@0.48.5
	windows_i686_msvc@0.52.5
	windows_x86_64_gnu@0.48.5
	windows_x86_64_gnu@0.52.5
	windows_x86_64_gnullvm@0.48.5
	windows_x86_64_gnullvm@0.52.5
	windows_x86_64_msvc@0.48.5
	windows_x86_64_msvc@0.52.5
	wyz@0.5.1
	zopfli@0.8.0
"

RUST_MIN_VER="1.74.0"

inherit cargo

DESCRIPTION="Multithreaded lossless PNG compression optimizer written in Rust"
HOMEPAGE="https://github.com/shssoichiro/oxipng"
SRC_URI="https://github.com/shssoichiro/oxipng/archive/v${PV}.tar.gz -> ${P}.tar.gz"
SRC_URI+=" ${CARGO_CRATE_URIS}"

LICENSE="
	Apache-2.0
	|| ( Apache-2.0 MIT )
	|| ( Apache-2.0 MIT ZLIB )
	MIT
"
SLOT="0"
KEYWORDS="~amd64 ~arm64 ~riscv ~x86"
PATCHES=( "${FILESDIR}/oxipng-9.1.2-use-system-libdeflate.patch" )

BDEPEND="virtual/pkgconfig"
DEPEND=">=app-arch/libdeflate-1.20:="
RDEPEND="${DEPEND}"

# rust does not use *FLAGS from make.conf, silence portage warning
# update with proper path to binaries this crate installs, omit leading /
QA_FLAGS_IGNORED="usr/bin/${PN}"
QA_PRESTRIPPED="usr/bin/${PN}"

src_prepare() {
	# Relax the version restriction of libdeflate.
	# https://bugs.gentoo.org/944285
	#
	# Any API/ABI-compatible versions would be ok for app-arch/libdeflate, but
	# in such case the build script of libdeflate_sys should be patched to pick
	# even if the system library is newer.
	# See <https://github.com/adamkewley/libdeflater/pull/32#issuecomment-1971198374>.
	#
	# Also, don't forget updating `DEPNED` and `RDEPEND` in sync, or libdeflater
	# crate will fail to pick system library and silently use the bundled
	# version of libdeflate.
	( cd "${WORKDIR}"/cargo_home/gentoo/libdeflate-sys-1.20.0 && \
		eapply "${FILESDIR}"/libdeflater-1.20.0-relax-libdeflate-sys-version.patch )

	# Remove the linker configs (in `.cargo/config.toml`) specific to GitHub CI.
	# https://bugs.gentoo.org/924946
	rm -rv "${S}/.cargo/config.toml" || die

	default_src_prepare
}

src_configure() {
	export PKG_CONFIG_ALLOW_CROSS=1

	cargo_src_configure
}

src_install() {
	cargo_src_install

	dodoc CHANGELOG.md README.md
}
